/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ObjectUtils;

abstract class TransactionAttributeSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    TransactionAttributeSourcePointcut() {
    }

    public boolean matches(Method method, Class targetClass) {
        TransactionAttributeSource tas = this.getTransactionAttributeSource();
        return tas == null || tas.getTransactionAttribute(method, targetClass) != null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransactionAttributeSourcePointcut)) {
            return false;
        }
        TransactionAttributeSourcePointcut otherPc = (TransactionAttributeSourcePointcut)other;
        return ObjectUtils.nullSafeEquals((Object)this.getTransactionAttributeSource(), (Object)otherPc.getTransactionAttributeSource());
    }

    public int hashCode() {
        return TransactionAttributeSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getTransactionAttributeSource();
    }

    protected abstract TransactionAttributeSource getTransactionAttributeSource();
}

