/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.persistence.CriteriaQueryHelper;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class SiteDAO {
    @Autowired
    protected SessionFactory sessionFactory;
    private static String fullGroupByString = "ONLY_FULL_GROUP_BY";

    public void createEntity(BaseEntity entity) {
        Session session = this.session();
        session.save((Object)entity);
        session.flush();
    }

    public void updateEntity(BaseEntity entity) {
        Session session = this.session();
        session.update((Object)entity);
        session.flush();
    }

    public void deleteEntity(BaseEntity entity) {
        Session session = this.session();
        session.delete((Object)entity);
        session.flush();
    }

    public void refreshEntity(BaseEntity entity) {
        Session session = this.session();
        session.refresh((Object)entity);
    }

    public <T extends BaseEntity> T findById(Class<T> entityClass, Integer id) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), entityClass);
        criteriaHelper.whereEquals("id", id);
        Query query = criteriaHelper.getQuery();
        return (T)((BaseEntity)query.uniqueResult());
    }

    protected <T extends BaseEntity> List<T> findAll(Class<T> entityClass) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), entityClass);
        Query query = criteriaHelper.getQuery();
        return query.list();
    }

    public String findNameById(String tableName, Integer id, boolean first) {
        return first ? this.findFieldById(tableName, id, "firstName") : this.findFieldById(tableName, id, "name");
    }

    public String findNameById(String tableName, Integer id) {
        return this.findFieldById(tableName, id, "name");
    }

    public String findFieldById(String tableName, Integer id, String fieldName) {
        String findName = "SELECT table." + fieldName + " FROM " + tableName + " table  WHERE table.id = :id ";
        Query query = this.newQuery(findName);
        query.setParameter("id", (Object)id);
        query.setCacheable(true);
        String result = (String)query.uniqueResult();
        return result;
    }

    public BaseEntity findEntityByFieldString(String tableName, String fieldName, String value) {
        BaseEntity result = null;
        String queryString = "SELECT t FROM " + tableName + " t  WHERE UPPER(t." + fieldName + ") = UPPER('" + value + "')";
        Query query = this.newQuery(queryString);
        query.setCacheable(true);
        List results = query.list();
        if (results.size() == 0) {
            SchedulerRuntimeException.logDontThrow("No results for " + tableName + ":" + fieldName + ":" + value);
        } else {
            result = (BaseEntity)results.get(0);
            if (results.size() > 1) {
                SchedulerRuntimeException.logDontThrow("Choosing first from multiple results for " + tableName + ":" + fieldName + ":" + value);
            }
        }
        return result;
    }

    public int findTotalByQuery(String sqlQuery) {
        BigInteger bi = (BigInteger)this.newNativeQuery(sqlQuery).uniqueResult();
        return bi.intValue();
    }

    Session session() {
        Session session = this.sessionFactory.getCurrentSession();
        return session;
    }

    public Query newQuery(String hql) {
        Session session = this.session();
        return session.createQuery(hql);
    }

    protected NativeQuery newNativeQuery(String sql) {
        Session session = this.session();
        return session.createNativeQuery(sql);
    }

    String getMode(Session session) {
        String queryString = "SELECT @@sql_mode";
        NativeQuery query = session.createSQLQuery("SELECT @@sql_mode");
        String mode = (String)query.getSingleResult();
        return mode.toUpperCase();
    }
}

