/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class UserReportDTO
implements CsvAbleDTO {
    private String firstName;
    private String middleName;
    private String lastName;
    private String role;
    private String institutionRole;
    private String department;
    private String division;
    private String institution;
    private String credential;
    private String facultyRank;
    private String primaryPhone;
    private String secondaryPhone;
    private String email;
    private String active;

    public UserReportDTO(User u) {
        this.firstName = u.getFirstName();
        this.middleName = u.getMiddleName();
        this.lastName = u.getLastName();
        this.active = String.valueOf(u.getActive());
        this.primaryPhone = u.getPrimaryPhone();
        this.secondaryPhone = u.getSecondaryPhone();
        this.email = u.getEmail();
        if (u.getRole() != null) {
            this.role = u.getRole().getName();
        }
        if (u.getInstitutionRole() != null) {
            this.institutionRole = u.getInstitutionRole().getName();
        }
        if (u.getDepartment() != null) {
            this.department = u.getDepartment().getName();
        }
        if (u.getDivision() != null) {
            this.division = u.getDivision().getName();
        }
        if (u.getInstitution() != null) {
            this.institution = u.getInstitution().getName();
        }
        if (u.getCredential() != null) {
            this.credential = u.getCredential().getName();
        }
        if (u.getFacultyRank() != null) {
            this.facultyRank = u.getFacultyRank().getName();
        }
    }

    @Override
    public String toCsvHeaders() {
        return "Full Name,User Title,Role,Department,Division,Institution,Status,Credential,Faculty Rank,Primary Phone,Secondary Phone,Email";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            UserReportDTO u = (UserReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(MiscUtil.fullName(u.firstName, u.middleName, u.lastName)));
            columns.add(MiscUtil.q(u.role));
            columns.add(MiscUtil.q(u.institutionRole));
            columns.add(MiscUtil.q(u.department));
            columns.add(MiscUtil.q(u.division));
            columns.add(MiscUtil.q(u.institution));
            columns.add(MiscUtil.q(MiscUtil.booleanToStatusValue(u.active)));
            columns.add(MiscUtil.q(u.credential));
            columns.add(MiscUtil.q(u.facultyRank));
            columns.add(MiscUtil.q(u.primaryPhone));
            columns.add(MiscUtil.q(u.secondaryPhone));
            columns.add(MiscUtil.q(u.email));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

