/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BillingReportDTO
implements CsvAbleDTO {
    private Integer studyId;
    private String studyName;
    private String catalystId;
    private String localId;
    private String irb;
    private Boolean industryInitiated;
    private Boolean crcFunded;
    private Date checkInTime;
    private Date checkOutTime;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private Date visitCheckInTime;
    private Date visitCheckOutTime;
    private String sublocation;
    private String resourceName;
    private Boolean billable;
    private String visitName;
    private String visitType;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String birthdate;
    private String investigatorFirstName;
    private String investigatorMiddleName;
    private String investigatorLastName;
    private String bookedVisitComment;
    private String resourceActivities;
    private String resourceActivitiesComment;
    private String resourceActivitiesQuantity;

    @Override
    public String toCsvHeaders() {
        return "Study Name,Catalyst ID,Local ID,IRB #,Industry Initiated,PI Name,CRC Approved Study,Resource Start Time,Resource End Time,Resource Duration,Resource Duration In Mins,Check In,Check Out,Visit Duration,Visit Duration Total Mins,Visit Over Midnight?,Sublocation,Resource Name, Resource Activities, Resource Activities Comment, Resource Activities Quantity, Billable,Visit Name,Visit Type,Study Subject, MRN,Birth Date,Booked Visit Comment";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            BillingReportDTO d = (BillingReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.industryInitiated)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.investigatorFirstName, d.investigatorMiddleName, d.investigatorLastName)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.crcFunded)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkInTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.checkOutTime)));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.checkInTime, d.checkOutTime)));
            columns.add(MiscUtil.q(MiscUtil.endMinusStartInMinutes(d.checkInTime, d.checkOutTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.visitCheckInTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.visitCheckOutTime)));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.visitCheckInTime, d.visitCheckOutTime)));
            columns.add(MiscUtil.q(MiscUtil.endMinusStartInMinutes(d.visitCheckInTime, d.visitCheckOutTime)));
            columns.add(MiscUtil.q(MiscUtil.localDate2LaterThanDate1YesNo(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.sublocation));
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(d.resourceActivities));
            columns.add(MiscUtil.q(d.resourceActivitiesComment));
            columns.add(MiscUtil.q(d.resourceActivitiesQuantity));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(d.billable)));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.visitType));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            columns.add(MiscUtil.q(d.birthdate));
            columns.add(MiscUtil.q(d.bookedVisitComment));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }

    public Integer getStudyId() {
        return this.studyId;
    }

    public void setStudyId(Integer studyId) {
        this.studyId = studyId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public Boolean getIndustryInitiated() {
        return this.industryInitiated;
    }

    public void setIndustryInitiated(Boolean industryInitiated) {
        this.industryInitiated = industryInitiated;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public Date getVisitCheckInTime() {
        return this.visitCheckInTime;
    }

    public void setVisitCheckInTime(Date visitCheckInTime) {
        this.visitCheckInTime = visitCheckInTime;
    }

    public Date getVisitCheckOutTime() {
        return this.visitCheckOutTime;
    }

    public void setVisitCheckOutTime(Date visitCheckOutTime) {
        this.visitCheckOutTime = visitCheckOutTime;
    }

    public String getSublocation() {
        return this.sublocation;
    }

    public void setSublocation(String sublocation) {
        this.sublocation = sublocation;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Boolean getBillable() {
        return this.billable;
    }

    public void setBillable(Boolean billable) {
        this.billable = billable;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(String birthdate) {
        this.birthdate = birthdate;
    }

    public String getInvestigatorFirstName() {
        return this.investigatorFirstName;
    }

    public void setInvestigatorFirstName(String investigatorFirstName) {
        this.investigatorFirstName = investigatorFirstName;
    }

    public String getInvestigatorMiddleName() {
        return this.investigatorMiddleName;
    }

    public void setInvestigatorMiddleName(String investigatorMiddleName) {
        this.investigatorMiddleName = investigatorMiddleName;
    }

    public String getInvestigatorLastName() {
        return this.investigatorLastName;
    }

    public void setInvestigatorLastName(String investigatorLastName) {
        this.investigatorLastName = investigatorLastName;
    }

    public String getBookedVisitComment() {
        return this.bookedVisitComment;
    }

    public void setBookedVisitComment(String bookedVisitComment) {
        this.bookedVisitComment = bookedVisitComment;
    }

    public Boolean getCrcFunded() {
        return this.crcFunded;
    }

    public void setCrcFunded(Boolean crcFunded) {
        this.crcFunded = crcFunded;
    }

    public String getResourceActivities() {
        return this.resourceActivities;
    }

    public void setResourceActivities(String resourceActivities) {
        this.resourceActivities = resourceActivities;
    }

    public String getResourceActivitiesComment() {
        return this.resourceActivitiesComment;
    }

    public void setResourceActivitiesComment(String resourceActivitiesComment) {
        this.resourceActivitiesComment = resourceActivitiesComment;
    }

    public String getResourceActivitiesQuantity() {
        return this.resourceActivitiesQuantity;
    }

    public void setResourceActivitiesQuantity(String resourceActivitiesQuantity) {
        this.resourceActivitiesQuantity = resourceActivitiesQuantity;
    }
}

