/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OffUnitReportDTO
implements CsvAbleDTO {
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private Date resourceStartTime;
    private Date resourceEndTime;
    private String localId;
    private String irb;
    private String visitName;
    private String visitType;
    private String visitStatus;
    private String firstName;
    private String middleName;
    private String lastName;
    private String mrn;
    private String comment;
    private String genderName;
    private Date birthdate;
    private String resourceName;
    private Integer bookedVisitId;

    public Integer getBookedVisitId() {
        return this.bookedVisitId;
    }

    public void setBookedVisitId(Integer bookedVisitId) {
        this.bookedVisitId = bookedVisitId;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public void setGenderName(String genderName) {
        this.genderName = genderName;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Date getResourceStartTime() {
        return this.resourceStartTime;
    }

    public void setResourceStartTime(Date resourceStartTime) {
        this.resourceStartTime = resourceStartTime;
    }

    public Date getResourceEndTime() {
        return this.resourceEndTime;
    }

    public void setResourceEndTime(Date resourceEndTime) {
        this.resourceEndTime = resourceEndTime;
    }

    public String getVisitType() {
        return this.visitType;
    }

    public void setVisitType(String visitType) {
        this.visitType = visitType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getVisitStatus() {
        return this.visitStatus;
    }

    public void setVisitStatus(String visitStatus) {
        this.visitStatus = visitStatus;
    }

    @Override
    public String toCsvHeaders() {
        return "Visit Name-Visit Type,Subject Name,MRN,Gender,Birth Date,Local ID,IRB #,Visit Start Time,Visit End Time,Comment,Resource Name,Start Time,End Time";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousVisit = -1;
        boolean firstTime = true;
        for (Object object : dtoList) {
            OffUnitReportDTO d = (OffUnitReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentVisit = d.bookedVisitId;
            if (currentVisit != previousVisit) {
                if (!firstTime) {
                    result.add(" \n");
                }
                firstTime = false;
                result.add(this.toCsvHeaders() + "\n");
                columns.add(MiscUtil.q(d.visitName + " - " + d.visitType));
                columns.add(MiscUtil.q(MiscUtil.fullName(d.firstName, d.middleName, d.lastName)));
                columns.add(MiscUtil.q(d.mrn));
                columns.add(MiscUtil.q(d.genderName));
                columns.add(MiscUtil.q(MiscUtil.showDateTime(d.birthdate)));
                columns.add(MiscUtil.q(d.localId));
                columns.add(MiscUtil.q(d.irb));
                columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
                columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
                columns.add(MiscUtil.q(d.comment));
            } else {
                for (int i = 0; i < 10; ++i) {
                    columns.add("");
                }
            }
            previousVisit = currentVisit;
            columns.add(MiscUtil.q(d.resourceName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.resourceStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.resourceEndTime)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

