/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SubjectAuditStaffViewsReportDTO
implements CsvAbleDTO {
    private User userId;
    private String userFirstName;
    private String userMiddleName;
    private String userLastName;
    private String userRoleName;
    private String userDepartmentName;
    private String userInstitutionName;
    private String actionPerformed;
    private Date date;
    private String ipAddress;
    private String subjectName;
    private Integer subjectId;

    public User getUserId() {
        return this.userId;
    }

    public void setUserId(User userId) {
        this.userId = userId;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public void setUserRoleName(String userRoleName) {
        this.userRoleName = userRoleName;
    }

    public String getUserDepartmentName() {
        return this.userDepartmentName;
    }

    public void setUserDepartmentName(String userDepartmentName) {
        this.userDepartmentName = userDepartmentName;
    }

    public String getUserInstitutionName() {
        return this.userInstitutionName;
    }

    public void setUserInstitutionName(String userInstitutionName) {
        this.userInstitutionName = userInstitutionName;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public void setActionPerformed(String actionPerformed) {
        this.actionPerformed = actionPerformed;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public String getUserMiddleName() {
        return this.userMiddleName;
    }

    public void setUserMiddleName(String userMiddleName) {
        this.userMiddleName = userMiddleName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Integer getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Integer subjectId) {
        this.subjectId = subjectId;
    }

    @Override
    public String toCsvHeaders() {
        return "Subject Name,User,Title,Department,Institution,Action Performed,Date,IP Address";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousSubjectId = -1;
        for (Object object : dtoList) {
            SubjectAuditStaffViewsReportDTO d = (SubjectAuditStaffViewsReportDTO)object;
            int currentSubjectId = d.subjectId;
            if (currentSubjectId != previousSubjectId) {
                result.add(this.toCsvHeaders() + "\n");
                previousSubjectId = currentSubjectId;
            }
            ArrayList columns = Lists.newArrayList();
            String roleName = d.userId.getRole() == null ? "" : d.userId.getRole().getName();
            String deptName = d.userId.getDepartment() == null ? "" : d.userId.getDepartment().getName();
            String instName = d.userId.getInstitution() == null ? "" : d.userId.getInstitution().getName();
            columns.add(MiscUtil.q(d.subjectName));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.userId.getFirstName(), d.userId.getMiddleName(), d.userId.getLastName())));
            columns.add(MiscUtil.q(roleName));
            columns.add(MiscUtil.q(deptName));
            columns.add(MiscUtil.q(instName));
            columns.add(MiscUtil.q(d.actionPerformed));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.date)));
            columns.add(MiscUtil.q(d.ipAddress));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

