/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="subject_mrn")
public class SubjectMrn
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Subject subject;
    private String mrn;
    private String site;
    private String status;

    public SubjectMrn() {
        super(null);
    }

    public SubjectMrn(Subject subject, String mrn, String site, String status) {
        this(subject, mrn, site, status, null);
    }

    public SubjectMrn(Subject subject, String mrn, String site, String status, Integer id) {
        super(id);
        this.subject = subject;
        this.mrn = mrn;
        this.site = site;
        this.status = status;
    }

    public static SubjectMrn defensiveCopy(SubjectMrn original) {
        Subject origSubject = original.getSubject();
        SubjectMrn result = new SubjectMrn(Subject.defensiveCopy(origSubject), original.getMrn(), original.getSite(), original.getStatus(), original.getId());
        return result;
    }

    @JoinColumn(name="subject", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @Column(name="mrn")
    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    @Column(name="site")
    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    @Column(name="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public int hashCode() {
        int result = this.getId() == null ? 0 : this.getId();
        result += this.subject == null ? 0 : this.subject.hashCode();
        result += this.mrn == null ? 0 : this.mrn.hashCode();
        result += this.site == null ? 0 : this.site.hashCode();
        return result += this.status == null ? 0 : this.status.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubjectMrn other = (SubjectMrn)obj;
        boolean siteEquals = this.doSitesEqual(this.site, other.site);
        return siteEquals && this.subject.equals(other.subject) && this.mrn.equalsIgnoreCase(other.mrn) && this.status != null && this.status.equalsIgnoreCase(other.status);
    }

    public String toString() {
        return "Code: " + this.mrn + " Site: " + this.site + " Status: " + this.status;
    }

    private boolean doSitesEqual(String site1, String site2) {
        return site1 == null ? site2 == null : site1.equalsIgnoreCase(site2);
    }
}

