/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import edu.harvard.catalyst.scheduler.dto.SubjectMrnDTO;
import edu.harvard.catalyst.scheduler.dto.SubjectsDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponseDTO;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.SubjectService;
import edu.harvard.catalyst.scheduler.service.SubjectServiceClassic;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.Date;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/subject")
@Singleton
@Component
public class SubjectResource
extends SecuredResource {
    private final SubjectServiceClassic service;
    private final SubjectService subjectService;
    private final boolean isEpicMode;

    @Autowired
    public SubjectResource(SubjectServiceClassic service, @Qualifier(value="subjectSSOTConfigured") SubjectService subjectService, @Qualifier(value="subjectMode") String subjectMode) {
        this.service = service;
        this.subjectService = subjectService;
        this.isEpicMode = subjectMode != null ? subjectMode.equalsIgnoreCase("epic") : false;
    }

    SubjectResource() {
        this(null, null, null);
    }

    @POST
    @Path(value="/createSubject")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String createSubject(@FormParam(value="data") String data, @HeaderParam(value="User-Agent") String header) {
        SubjectsDTO subjectsDTO = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        subjectsDTO.nullifyBlanks();
        Date birthdate = this.getFormattedBirthDate(subjectsDTO.getBirthday());
        subjectsDTO.setBirthdate(birthdate);
        this.service.createSubjectForDto(subjectsDTO, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)subjectsDTO);
    }

    @POST
    @Path(value="/updateSubject")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String updateSubject(@FormParam(value="data") String data, @HeaderParam(value="User-Agent") String header) {
        SubjectsDTO subjectsDTO = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        subjectsDTO.nullifyBlanks();
        Date birthdate = this.getFormattedBirthDate(subjectsDTO.getBirthday());
        subjectsDTO.setBirthdate(birthdate);
        boolean allowOnlyOneMrn = !this.isEpicMode;
        subjectsDTO = this.service.updateSubject(subjectsDTO, this.getUser(), this.getRemoteHost(), allowOnlyOneMrn);
        return this.gson.toJson((Object)subjectsDTO);
    }

    public Date getFormattedBirthDate(String date) {
        return DateUtility.parse(DateUtility.subjectDate(), date);
    }

    @POST
    @Path(value="/ssot/getSearchSubjects")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSearchSubjects(@FormParam(value="data") String data) {
        SubjectsDTO subjectsDTO = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        String lastName = subjectsDTO.getLastName();
        String firstName = subjectsDTO.getFirstName();
        String mrn = subjectsDTO.getMrn();
        String dob = subjectsDTO.getBirthday();
        List<String> genderList = subjectsDTO.getGenderList();
        SubjectsResponseDTO subjectsResponseDTO = this.subjectService.getSearchedSubjects(lastName, firstName, mrn, dob, genderList);
        return this.gson.toJson((Object)subjectsResponseDTO);
    }

    @GET
    @Path(value="/getSubjectData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getSubjectData(@QueryParam(value="isPuid") Boolean isPuid, @QueryParam(value="data") String data) {
        SubjectsDTO subjectsDTO = (SubjectsDTO)this.gson.fromJson(data, SubjectsDTO.class);
        SubjectDetailResponse subject = this.subjectService.getSubjectData(isPuid, subjectsDTO.getId(), this.getRemoteHost(), this.getUser());
        return this.gson.toJson((Object)subject);
    }

    @POST
    @Path(value="/getExternalSubjectDataUsingMrn")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getExternalSubjectDataUsingMrnInfo(@FormParam(value="data") String data) {
        SubjectMrnDTO subjectMrnDTO = (SubjectMrnDTO)this.gson.fromJson(data, SubjectMrnDTO.class);
        SubjectDetailResponse subject = this.subjectService.getExternalSubjectDataUsingMrn(subjectMrnDTO.getMrnInfo());
        return this.gson.toJson((Object)subject);
    }

    @GET
    @Path(value="/findInternalSubjectByMrn")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String findInternalSubjectByMrn(@QueryParam(value="mrnInfo") String mrnInfoStr) {
        SubjectMrnDTO subjectsDTO = (SubjectMrnDTO)this.gson.fromJson(mrnInfoStr, SubjectMrnDTO.class);
        SubjectDetailResponse result = this.subjectService.findInternalSubjectByMrn(subjectsDTO.getMrnInfoList());
        return this.gson.toJson((Object)result);
    }
}

