/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.SubjectsDTO;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ServiceHelpers;
import edu.harvard.catalyst.scheduler.service.StudyService;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.lang.invoke.CallSite;
import java.security.Key;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SubjectServiceClassic
implements ServiceHelpers {
    private static final Logger LOGGER = LogManager.getLogger(SubjectServiceClassic.class);
    static final Function<String, String> CRYPT = SubjectDataEncryptor::encrypt;
    private static final Function<String, String> TO_UPPER = String::toUpperCase;
    static final Function<String, String> CRYPT_UPPER = TO_UPPER.andThen(CRYPT);
    private final SubjectDAO subjectDAO;
    private final StudyDAO studyDAO;
    private final AuditService auditService;
    private final StudyService studyService;
    private final AppointmentDAO appointmentDAO;

    @Autowired
    public SubjectServiceClassic(AuditService auditService, SubjectDAO subjectDAO, StudyDAO studyDAO, StudyService studyService, AppointmentDAO appointmentDAO, @Qualifier(value="encryptionKey") Key encryptionKey) {
        this.auditService = auditService;
        this.studyService = studyService;
        this.subjectDAO = subjectDAO;
        this.studyDAO = studyDAO;
        this.appointmentDAO = appointmentDAO;
        SubjectDataEncryptor.setEncryptionKey(encryptionKey);
    }

    SubjectServiceClassic() {
        this(null, null, null, null, null, null);
    }

    public void createSubjectForDto(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = this.createSubject(subjectDTO, user, ipAddress);
        if (subject == null) {
            return;
        }
        subjectDTO.setResult(true);
        subjectDTO.setId(subject.getId());
    }

    private boolean validateSubjectMerge(SubjectsDTO subjectDTO, MrnInfoDTO similarMrnInfoDTO, User user) {
        boolean isValid = true;
        if (!subjectDTO.mergeSimilarMrn() && similarMrnInfoDTO != null && user != null) {
            LOGGER.info("Similar MRN already exists -- cancelling creation of subject");
            subjectDTO.setResult(false);
            subjectDTO.setErrorMsg("Similar mrn exists");
            subjectDTO.setSimilarMrnAlreadyExistsError(true);
            subjectDTO.setSimilarMrnInfo(similarMrnInfoDTO);
            isValid = false;
        }
        return isValid;
    }

    public boolean mrnHasLeadingZeros(MrnInfoDTO mrnInfoDTO) {
        String mrnMinusLeadingZeros;
        boolean mrnWithLeadingZeros = false;
        if (mrnInfoDTO != null && !(mrnMinusLeadingZeros = mrnInfoDTO.getValue().replaceAll("^0*", "")).equals(mrnInfoDTO.getValue())) {
            mrnWithLeadingZeros = true;
        }
        return mrnWithLeadingZeros;
    }

    public void remapBookedVisits(List<BookedVisit> bookedVisits, SubjectMrn primarySubjectMrn, List<String> changeDetails) {
        bookedVisits.stream().forEach(bookedVisit -> {
            changeDetails.add("BookedVisit#" + bookedVisit.getId() + ".subjectMrn:from#" + bookedVisit.getSubjectMrn().getMrn() + ":to#" + primarySubjectMrn.getMrn());
            bookedVisit.setSubjectMrn(primarySubjectMrn);
            this.appointmentDAO.updateEntity((BaseEntity)bookedVisit);
        });
    }

    private void performMergeSimilarSubject(SubjectMrn mergeSubjectMrn, SubjectMrn newSubjectMrn, User user, String ipAddress, int studyId) {
        ArrayList<CallSite> changeDetailsList = new ArrayList<CallSite>();
        Subject mergeSubject = mergeSubjectMrn.getSubject();
        Subject newSubject = newSubjectMrn.getSubject();
        Study newStudy = new Study();
        List<StudySubject> mergeStudySubjects = this.studyDAO.findStudySubjectBySubjectMrn(mergeSubjectMrn);
        mergeStudySubjects.stream().forEach(mergeStudySubject -> {
            Study mergeStudy = mergeStudySubject.getStudy();
            if (studyId == mergeStudy.getId()) {
                newStudy.setId(mergeStudy.getId());
            }
            changeDetailsList.add((CallSite)((Object)("StudySubject#" + mergeStudySubject.getId() + ".subject:from#" + mergeStudySubject.getSubject().getId() + ":to#" + newSubject.getId())));
            mergeStudySubject.setSubjectMrn(newSubjectMrn);
            this.studyDAO.updateEntity((BaseEntity)mergeStudySubject);
            List<BookedVisit> bookedVisits = this.appointmentDAO.getAllBookedVisitByStudyAndSubjectMrn(mergeStudy, mergeSubjectMrn);
            this.remapBookedVisits(bookedVisits, newSubjectMrn, changeDetailsList);
        });
        mergeSubject.getSubjectMrnSet().forEach(subjectMrn -> {
            if (!subjectMrn.getMrn().equals(mergeSubjectMrn.getMrn()) || !subjectMrn.getSite().equals(mergeSubjectMrn.getSite())) {
                subjectMrn.setSubject(newSubject);
                this.subjectDAO.updateEntity((BaseEntity)subjectMrn);
            }
        });
        if (studyId != 0 && newStudy.getId() == null) {
            this.addSubjectToStudy(studyId, user, ipAddress, newSubjectMrn);
        }
        String newSubjectDescription = "subject with ID " + newSubject.getId() + " and MRN " + mergeSubjectMrn.getMrn() + " and Site " + newSubjectMrn.getSite();
        String mergeSubjectDescription = "subject with ID " + mergeSubject.getId() + " and MRN " + mergeSubjectMrn.getMrn() + " and Site " + mergeSubjectMrn.getSite();
        String actionPerformed = "Merge requested by user " + user.getEcommonsId() + " to resolve similar mrns ";
        changeDetailsList.add((CallSite)((Object)(mergeSubjectDescription + " merged into " + newSubjectDescription)));
        String changeDetails = String.join((CharSequence)",", changeDetailsList);
        mergeSubject.setArchivalStatus(ArchivalStatus.MERGED);
        this.subjectDAO.updateEntity(mergeSubject);
        ActivityLog al = new ActivityLog();
        al.setPerformingUser(user);
        al.setActionPerformed(actionPerformed);
        al.setDate(new Date());
        al.setIpAddress(ipAddress);
        al.setAffectedUser(null);
        al.setAffectedResource(null);
        al.setAffectedSublocation(null);
        al.setAffectedSubject(mergeSubject);
        al.setAffectedStudy(null);
        al.setAffectedVisit(null);
        al.setChangesDetailRequiredField(null);
        al.setChangesDetail(changeDetails);
        al.setAppointmentOverrideReason(null);
        al.setBookedVisit(null);
        this.subjectDAO.createEntity(al);
    }

    public Subject createSubject(SubjectsDTO subjectDTO, User user, String ipAddress) {
        Subject subject = null;
        if (this.mrnAlreadyExists(subjectDTO)) {
            LOGGER.info("MRN already exists -- cancelling creation of subject");
            subjectDTO.setResult(false);
            subjectDTO.setMrnAlreadyExistsError(true);
        } else {
            subject = new Subject();
            MrnInfoDTO mrnInfoDTO = subjectDTO.getMrnInfo();
            subject.setActive(Boolean.TRUE);
            subject.setCreatedDate(new Date());
            this.setSomeEntityValuesViaDto(subject, subjectDTO);
            this.subjectDAO.createSubject(subject);
            SubjectMrn newSubjectMrn = new SubjectMrn(subject, mrnInfoDTO.getValue(), mrnInfoDTO.getInstitution(), mrnInfoDTO.getStatus(), null);
            subject.getSubjectMrnSet().add(newSubjectMrn);
            this.subjectDAO.saveSubjectMrn(newSubjectMrn);
            this.auditService.logSubjectActivity(ipAddress, subject, user, "CREATE SUBJECT", null, null);
            this.addSubjectToStudy(subjectDTO.getStudyId(), user, ipAddress, newSubjectMrn);
        }
        return subject;
    }

    private void addSubjectToStudy(int studyId, User user, String ipAddress, SubjectMrn subjectMrn) {
        if (studyId > 0) {
            Study study = this.studyDAO.findStudyById(studyId);
            this.addSubjectToStudy(user, ipAddress, subjectMrn, study);
        }
    }

    private SubjectMrn mergeSimilarSubjects(SubjectsDTO subjectDTO, SubjectMrn similarSubjectMrn, User user, String ipAddress) {
        SubjectMrn newSubjectMrn;
        boolean createSubjectWithNewPuid = false;
        Subject internalSubjectByPuid = this.subjectDAO.findInternalSubjectByPuid(subjectDTO.getPartnersUid());
        MrnInfoDTO mrnInfoDTO = subjectDTO.getMrnInfo();
        if (internalSubjectByPuid == null || internalSubjectByPuid.getId().intValue() == similarSubjectMrn.getSubject().getId().intValue()) {
            createSubjectWithNewPuid = true;
        }
        int studyId = subjectDTO.getStudyId();
        subjectDTO.setStudyId(0);
        if (createSubjectWithNewPuid) {
            internalSubjectByPuid = this.createSubject(subjectDTO, user, ipAddress);
            newSubjectMrn = internalSubjectByPuid.getSubjectMrnSet().stream().filter(sm -> {
                String smDecrypted = SubjectDataEncryptor.decrypt(sm.getMrn());
                return smDecrypted.equals(mrnInfoDTO.getValue()) && sm.getSite().equals(mrnInfoDTO.getInstitution());
            }).findFirst().orElse(null);
        } else {
            newSubjectMrn = new SubjectMrn(internalSubjectByPuid, mrnInfoDTO.getValue(), mrnInfoDTO.getInstitution(), mrnInfoDTO.getStatus(), null);
            this.subjectDAO.saveSubjectMrn(newSubjectMrn);
        }
        this.performMergeSimilarSubject(similarSubjectMrn, newSubjectMrn, user, ipAddress, studyId);
        return newSubjectMrn;
    }

    public SubjectsDTO updateSubject(SubjectsDTO subjectDTO, User user, String ipAddress, boolean allowOnlyOneMrn) {
        Subject subject = this.subjectDAO.findBySubjectId(subjectDTO.getId());
        SubjectMrn subjectMrn = null;
        boolean mrnHasLeadingZeros = this.mrnHasLeadingZeros(subjectDTO.getMrnInfo());
        boolean doUpdate = true;
        if (!allowOnlyOneMrn) {
            Subject newPuidSubject;
            SubjectMrn similarSubjectMrn;
            if (mrnHasLeadingZeros && (similarSubjectMrn = this.findSimilarMrn(subjectDTO)) != null) {
                String decryptedMrn = SubjectDataEncryptor.decrypt(similarSubjectMrn.getMrn());
                MrnInfoDTO similarMrnInfoDTO = new MrnInfoDTO(decryptedMrn);
                similarMrnInfoDTO.setInstitution(similarSubjectMrn.getSite());
                similarMrnInfoDTO.setStatus(similarSubjectMrn.getStatus());
                if (this.validateSubjectMerge(subjectDTO, similarMrnInfoDTO, user)) {
                    subjectMrn = this.mergeSimilarSubjects(subjectDTO, similarSubjectMrn, user, ipAddress);
                    if (subject.getId().intValue() != subjectMrn.getSubject().getId().intValue()) {
                        doUpdate = false;
                        subjectDTO.setResult(true);
                    }
                    subject = subjectMrn.getSubject();
                    SubjectDataEncryptor.decryptSubjectInPlace(subject);
                    subjectDTO.setId(subject.getId());
                } else {
                    doUpdate = false;
                }
            }
            SubjectMrn differingPuidSubjectMrn = this.subjectExistsWithSameMrnAndDiffPuid(subjectDTO);
            if (doUpdate && differingPuidSubjectMrn != null && (newPuidSubject = this.subjectDAO.findInternalSubjectByPuid(subjectDTO.getPartnersUid())) != null) {
                subject = this.mergeSubjectWithSamePuid(differingPuidSubjectMrn, newPuidSubject, user, ipAddress);
                SubjectDataEncryptor.decryptSubjectInPlace(subject);
                subjectDTO.setId(subject.getId());
            }
        }
        if (doUpdate) {
            MrnInfoDTO mrnInfoDTO = subjectDTO.getMrnInfo();
            SubjectMrn newSubjectMrn = new SubjectMrn(subject, mrnInfoDTO.getValue(), mrnInfoDTO.getInstitution(), mrnInfoDTO.getStatus(), null);
            if (subjectMrn == null) {
                subjectMrn = this.subjectDAO.getSubjectMrnForSubject(newSubjectMrn);
            }
            if (subjectMrn == null) {
                if (this.mrnAlreadyExists(subjectDTO)) {
                    LOGGER.info("MRN already exists -- cancelling update of subject");
                    subjectDTO.setMrnAlreadyExistsError(true);
                    subjectDTO.setResult(false);
                    return subjectDTO;
                }
                try {
                    subjectMrn = this.createSubjectMrnIfNeeded(allowOnlyOneMrn, subject, newSubjectMrn);
                }
                catch (NoMrnFoundException e) {
                    subjectDTO.setErrorMsg(e.getMessage());
                    subjectDTO.setResult(false);
                    return subjectDTO;
                }
            }
            if (subjectDTO.getStudyId() > 0) {
                Study study = this.studyDAO.findStudyById(subjectDTO.getStudyId());
                if (this.isSubjectAlreadyInThisStudy(user, subject, study)) {
                    subjectDTO.setErrorMsg("This subject is already enrolled in this study.");
                    subjectDTO.setResult(false);
                    return subjectDTO;
                }
                this.addSubjectToStudy(user, ipAddress, subjectMrn, study);
            }
            this.updateSubjectFieldsIfNeeded(subjectDTO, user, ipAddress, subject);
            subjectDTO.setResult(true);
        }
        return subjectDTO;
    }

    private Subject mergeSubjectWithSamePuid(SubjectMrn mergeSubjectMrn, Subject activeSubject, User user, String ipAddress) {
        Subject mergeSubject = mergeSubjectMrn.getSubject();
        ArrayList<CallSite> changeDetailsList = new ArrayList<CallSite>();
        changeDetailsList.add((CallSite)((Object)("SubjectMrn#" + mergeSubjectMrn.getId() + ".subject:from#" + mergeSubjectMrn.getSubject().getId() + ":to#" + activeSubject.getId())));
        mergeSubjectMrn.setSubject(activeSubject);
        this.subjectDAO.updateEntity(mergeSubjectMrn);
        long mergeSubjectMrnCount = this.subjectDAO.getSubjectMrnCountBySubjectId(mergeSubject.getId());
        if (mergeSubjectMrnCount == 0L) {
            String activeSubjectDescription = "subject with ID " + activeSubject.getId();
            String mergeSubjectDescription = "subject with ID " + mergeSubject.getId();
            changeDetailsList.add((CallSite)((Object)(mergeSubjectDescription + " merged into " + activeSubjectDescription)));
            mergeSubject.setArchivalStatus(ArchivalStatus.MERGED);
            this.subjectDAO.updateEntity(mergeSubject);
        }
        String changeDetails = String.join((CharSequence)",", changeDetailsList);
        String actionPerformed = "Changed subject of subject mrn because puid changed";
        ActivityLog al = new ActivityLog();
        al.setPerformingUser(user);
        al.setActionPerformed(actionPerformed);
        al.setDate(new Date());
        al.setIpAddress(ipAddress);
        al.setAffectedUser(null);
        al.setAffectedResource(null);
        al.setAffectedSublocation(null);
        al.setAffectedSubject(mergeSubject);
        al.setAffectedStudy(null);
        al.setAffectedVisit(null);
        al.setChangesDetailRequiredField(null);
        al.setChangesDetail(changeDetails);
        al.setAppointmentOverrideReason(null);
        al.setBookedVisit(null);
        this.subjectDAO.createEntity(al);
        return activeSubject;
    }

    private SubjectMrn subjectExistsWithSameMrnAndDiffPuid(SubjectsDTO subjectDTO) {
        SubjectMrn subjectMrnDiffPuid = null;
        SubjectMrn subjectMrn = this.subjectDAO.getSubjectMrnByMrnAndSite(subjectDTO.getMrnInfo().getValue(), subjectDTO.getMrnInfo().getInstitution());
        if (subjectMrn != null) {
            String decryptedPuid = SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getPuid());
            if (subjectDTO.getPartnersUid() != null && !subjectDTO.getPartnersUid().equals(decryptedPuid)) {
                subjectMrnDiffPuid = subjectMrn;
            }
        }
        return subjectMrnDiffPuid;
    }

    boolean isSubjectAlreadyInThisStudy(User user, Subject subject, Study study) {
        List<StudySubject> studySubjectList = this.getStudySubjects(user, subject, study);
        if (ListUtils.nullOrEmpty(studySubjectList)) {
            return false;
        }
        return ListUtils.enrich(studySubjectList).exists(s -> s.getStudy().getId().equals(study.getId()));
    }

    private void updateSubjectFieldsIfNeeded(SubjectsDTO subjectDTO, User user, String ipAddress, Subject subject) {
        List<Optional<String>> previousDataComponents = this.gatherPreviousData(subjectDTO, subject);
        List<Optional<String>> otherPreviousDataComponents = this.gatherOtherPreviousData(subjectDTO, subject);
        Joiner joiner = Joiner.on((String)"");
        String previousData = joiner.join((Iterable)ListUtils.flatten(previousDataComponents));
        String otherPreviousData = joiner.join((Iterable)ListUtils.flatten(otherPreviousDataComponents));
        subject.setId(subjectDTO.getId());
        this.setSomeEntityValuesViaDto(subject, subjectDTO);
        this.subjectDAO.encryptAndSave(subject);
        this.auditService.logSubjectActivity(ipAddress, subject, user, "UPDATE SUBJECT", previousData, otherPreviousData);
    }

    private List<Optional<String>> gatherOtherPreviousData(SubjectsDTO subjectDTO, Subject subject) {
        int stateId = 0;
        if (subject.getState() != null) {
            stateId = subject.getState().getId();
        }
        return Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("State", subjectDTO.getState(), stateId), this.makeFieldString("Middle Name", subjectDTO.getMiddleName(), subject.getMiddleName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Secondary Phone", subjectDTO.getSecondaryContactNumber(), subject.getSecondaryContactNumber(), CRYPT, CRYPT_UPPER)});
    }

    private List<Optional<String>> gatherPreviousData(SubjectsDTO subjectDTO, Subject subject) {
        String ethnicity = this.lookupFieldById(subjectDTO.getEthnicity(), this.subjectDAO::findByEthnicityId);
        String gender = this.lookupFieldById(subjectDTO.getGender(), this.subjectDAO::findByGenderId);
        String race = this.lookupFieldById(subjectDTO.getRace(), this.subjectDAO::findByRaceId);
        String country = this.lookupFieldById(subjectDTO.getCountry(), this.subjectDAO::findCountryById);
        return Lists.newArrayList((Object[])new Optional[]{this.makeFieldString("Birth Date", subjectDTO.getBirthdate(), subject.getBirthdate()), this.makeFieldString("City", subjectDTO.getCity(), subject.getCity(), CRYPT_UPPER, CRYPT_UPPER), this.makeFieldString("Ethnicity", ethnicity.toUpperCase(), subject.getEthnicity(), subjectDTO.getEthnicity(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Gender", gender, subject.getGender(), subjectDTO.getGender(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("First Name", subjectDTO.getFirstName(), subject.getFirstName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Last Name", subjectDTO.getLastName(), subject.getLastName(), CRYPT, CRYPT_UPPER), this.makeFieldString("Primary Phone", subjectDTO.getPrimaryContactNumber(), subject.getPrimaryContactNumber(), CRYPT, CRYPT_UPPER), this.makeFieldString("Race", race, subject.getRace(), subjectDTO.getRace(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Street Address 1", subjectDTO.getStreetAddress1(), subject.getStreetAddress1(), CRYPT, CRYPT_UPPER), this.makeFieldString("Street Address 2", subjectDTO.getStreetAddress2(), subject.getStreetAddress2(), CRYPT, CRYPT_UPPER), this.makeFieldString("Zip", subjectDTO.getZip(), subject.getZip(), CRYPT, CRYPT_UPPER), this.makeFieldString("Country", country, subject.getCountry(), subjectDTO.getCountry(), BaseEntity::getId, CRYPT, CRYPT_UPPER), this.makeFieldString("Active", subjectDTO.getActive(), subject.getActive()), this.makeFieldString("Puid", subjectDTO.getPartnersUid(), subject.getPuid(), CRYPT, CRYPT_UPPER)});
    }

    SubjectMrn findSimilarMrn(SubjectsDTO subjectDTO) {
        SubjectMrn subjectMrn = new SubjectMrn();
        if (subjectDTO.getMrnInfo() != null) {
            String mrn = subjectDTO.getMrnInfo().getValue();
            String mrnMinusLeadingZeros = mrn.replaceAll("^0*", "");
            subjectMrn = this.subjectDAO.getSubjectMrnByMrnAndSite(mrnMinusLeadingZeros, subjectDTO.getMrnInfo().getInstitution());
        }
        return subjectMrn;
    }

    boolean mrnAlreadyExists(SubjectsDTO subjectDTO) {
        return subjectDTO.getMrnInfo() != null && this.subjectDAO.mrnInfoExists(subjectDTO.getMrnInfo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SubjectMrn createSubjectMrnIfNeeded(boolean allowOnlyOneMrn, Subject subject, SubjectMrn newSubjectMrn) throws NoMrnFoundException {
        SubjectMrn subjectMrnResult = null;
        if (allowOnlyOneMrn) {
            Optional result = subject.getSubjectMrnSet().stream().findFirst();
            if (!result.isPresent()) throw new NoMrnFoundException("Updating Subject Failed, the Subject's previous MRN was not found");
            subjectMrnResult = (SubjectMrn)result.get();
            subjectMrnResult = this.subjectDAO.getSubjectMrnForSubject(subjectMrnResult);
            subjectMrnResult.setMrn(newSubjectMrn.getMrn());
        } else {
            subjectMrnResult = newSubjectMrn;
        }
        this.subjectDAO.saveSubjectMrn(subjectMrnResult);
        return subjectMrnResult;
    }

    private void addSubjectToStudy(User user, String ipAddress, SubjectMrn subjectMrn, Study study) {
        StudySubject studySubject = new StudySubject(study, subjectMrn, Boolean.TRUE);
        try {
            this.studyDAO.createEntity(studySubject);
        }
        catch (ConstraintViolationException ex) {
            this.logDontThrow("updateSubject() constraint violation", (Exception)((Object)ex));
        }
        this.studyService.stampStudyAndLogStudySubjectMrnActivity(ipAddress, study, subjectMrn, user, "ADD STUDY SUBJECT", null, null);
    }

    void logDontThrow(String message, Exception cause) {
        SchedulerRuntimeException.logDontThrow(message, cause);
    }

    private List<StudySubject> getStudySubjects(User user, Subject subject, Study study) {
        if (user.isStudyStaff()) {
            return this.appointmentDAO.findStudySubjectBySubject(subject);
        }
        return this.appointmentDAO.findStudySubjectBySubjectAndStudy(subject, study);
    }

    void setSomeEntityValuesViaDto(Subject subject, SubjectsDTO subjectDTO) {
        subject.setBirthdate(subjectDTO.getBirthdate());
        subject.setCity(subjectDTO.getCity());
        subject.setEthnicity(this.subjectDAO.findByEthnicityId(subjectDTO.getEthnicity()));
        subject.setFirstName(subjectDTO.getFirstName());
        subject.setLastName(subjectDTO.getLastName());
        Gender genderEntity = this.subjectDAO.findByGenderId(subjectDTO.getGender());
        subject.setGender(genderEntity);
        subject.setGenderEmpi(subjectDTO.getGenderEmpi());
        String genderCode = genderEntity.getCode();
        if (genderCode == null) {
            SchedulerRuntimeException.logAndThrow("Cannot set subject.genderType because of null gender code on gender entity");
        } else {
            subject.setGenderType(GenderType.valueOf(genderCode));
        }
        subject.setDerivedFullName();
        subject.setMiddleName(subjectDTO.getMiddleName());
        subject.setPrimaryContactNumber(subjectDTO.getPrimaryContactNumber());
        subject.setRace(this.subjectDAO.findByRaceId(subjectDTO.getRace()));
        subject.setSecure(Boolean.FALSE);
        subject.setSecondaryContactNumber(subjectDTO.getSecondaryContactNumber());
        subject.setStreetAddress1(subjectDTO.getStreetAddress1());
        subject.setStreetAddress2(subjectDTO.getStreetAddress2());
        subject.setState(subjectDTO.getState() != 0 ? this.subjectDAO.findByStateId(subjectDTO.getState()) : null);
        subject.setCountry(this.subjectDAO.findCountryById(subjectDTO.getCountry()));
        subject.setZip(subjectDTO.getZip());
        subject.setComment(subjectDTO.getComment());
        subject.setActive(subjectDTO.getActive());
        subject.setComment(subjectDTO.getComment());
        subject.setPuid(subjectDTO.getPartnersUid());
    }

    class NoMrnFoundException
    extends Exception {
        NoMrnFoundException(String message) {
            super(message);
        }
    }
}

