/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.decrypter;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.util.BaseEnum;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SubjectDecrypter {
    private final SubjectDAO subjectDAO;
    private final DataSource dataSource;

    @Autowired
    public SubjectDecrypter(SubjectDAO subjectDAO, DataSource dataSource, @Qualifier(value="encryptionKeySubjectDecrypter") Key key) {
        this.subjectDAO = subjectDAO;
        this.dataSource = dataSource;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        System.out.println("Running with subjectDAO " + this.subjectDAO);
        Connection connection = null;
        PreparedStatement statement = null;
        int numDecryptedSubjects = 0;
        int numDecryptedSubjectMrns = 0;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("truncate table decrypted_subject");
            statement.execute();
            String createDecryptedSubjectString = "insert into decrypted_subject ( id, active, city, created_date, ethnicity, first_name, full_name, gender, gender_empi, last_name, middle_name, primary_contact_number, race, secondary_contact_number, secure, state, street_address1, street_address2, zip, birthdate, country, comment, archival_status, latest_ssot_refresh, puid, gender_enum ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            statement = connection.prepareStatement(createDecryptedSubjectString);
            List subjects = this.subjectDAO.findAllSubjectsHql();
            int numSubjects = subjects.size();
            System.out.println("There are " + numSubjects + " subjects to deal with");
            for (Subject subject : subjects) {
                Subject decryptedSubject = SubjectDataEncryptor.decryptSubject((Subject)subject);
                this.insertSubjectQuery(decryptedSubject, statement);
                ++numDecryptedSubjects;
            }
            statement = connection.prepareStatement("truncate table decrypted_subject_mrn");
            statement.execute();
            String createDecryptedSubjectMrnString = "insert into decrypted_subject_mrn ( id, subject, mrn, site, status) values ( ?,?,?,?,?)";
            statement = connection.prepareStatement(createDecryptedSubjectMrnString);
            List subjectMrns = this.subjectDAO.findAllSubjectMrns();
            int numSubjectMrns = subjectMrns.size();
            System.out.println("There are " + numSubjectMrns + " subjectMrns to deal with");
            for (SubjectMrn subjectMrn : subjectMrns) {
                this.insertSubjectMrnQuery(subjectMrn, statement);
                ++numDecryptedSubjectMrns;
            }
        }
        catch (SQLException se) {
            System.out.println("SQL Failure! " + se.getMessage());
        }
        finally {
            System.out.println("Succeeded to decrypt and store " + numDecryptedSubjects + " subjects");
            System.out.println("Succeeded to decrypt and store " + numDecryptedSubjectMrns + " subjectMrns");
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                System.out.println("SQL Failure while trying to close up shop! " + se.getMessage());
            }
        }
    }

    void setPrimitiveIntOrNull(int position, Integer value, PreparedStatement statement) throws SQLException {
        if (value != null) {
            statement.setInt(position, value);
        } else {
            statement.setNull(position, 4);
        }
    }

    void setPrimitiveBoolOrNull(int position, Boolean value, PreparedStatement statement) throws SQLException {
        if (value != null) {
            statement.setBoolean(position, value);
        } else {
            statement.setNull(position, 16);
        }
    }

    Integer idOrNull(BaseEntity entity) {
        return entity == null ? null : entity.getId();
    }

    Timestamp timestampOrNull(Date date) {
        Timestamp result = date == null ? null : new Timestamp(date.getTime());
        return result;
    }

    String nameOrNull(BaseEnum input) {
        return input == null ? null : input.name();
    }

    void insertSubjectQuery(Subject entity, PreparedStatement statement) throws SQLException {
        Timestamp birthStamp = this.timestampOrNull(entity.getBirthdate());
        Timestamp createStamp = this.timestampOrNull(entity.getCreatedDate());
        Timestamp latest_refresh = this.timestampOrNull(entity.getLatestSsotRefresh());
        Integer ethnicity = this.idOrNull((BaseEntity)entity.getEthnicity());
        Integer race = this.idOrNull((BaseEntity)entity.getRace());
        Integer gender = this.idOrNull((BaseEntity)entity.getGender());
        Integer state = this.idOrNull((BaseEntity)entity.getState());
        Integer country = this.idOrNull((BaseEntity)entity.getCountry());
        String archivalStatus = this.nameOrNull((BaseEnum)entity.getArchivalStatus());
        String genderType = this.nameOrNull((BaseEnum)entity.getGenderType());
        int index = 0;
        this.setPrimitiveIntOrNull(++index, entity.getId(), statement);
        this.setPrimitiveBoolOrNull(++index, entity.getActive(), statement);
        statement.setString(++index, entity.getCity());
        statement.setTimestamp(++index, createStamp);
        this.setPrimitiveIntOrNull(++index, ethnicity, statement);
        statement.setString(++index, entity.getFirstName());
        statement.setString(++index, entity.getFullName());
        this.setPrimitiveIntOrNull(++index, gender, statement);
        statement.setString(++index, entity.getGenderEmpi());
        statement.setString(++index, entity.getLastName());
        statement.setString(++index, entity.getMiddleName());
        statement.setString(++index, entity.getPrimaryContactNumber());
        this.setPrimitiveIntOrNull(++index, race, statement);
        statement.setString(++index, entity.getSecondaryContactNumber());
        this.setPrimitiveBoolOrNull(++index, entity.getSecure(), statement);
        this.setPrimitiveIntOrNull(++index, state, statement);
        statement.setString(++index, entity.getStreetAddress1());
        statement.setString(++index, entity.getStreetAddress2());
        statement.setString(++index, entity.getZip());
        statement.setTimestamp(++index, birthStamp);
        this.setPrimitiveIntOrNull(++index, country, statement);
        statement.setString(++index, entity.getComment());
        statement.setString(++index, archivalStatus);
        statement.setTimestamp(++index, latest_refresh);
        statement.setString(++index, entity.getPuid());
        statement.setString(++index, genderType);
        statement.executeUpdate();
    }

    void insertSubjectMrnQuery(SubjectMrn entity, PreparedStatement statement) throws SQLException {
        int index = 0;
        this.setPrimitiveIntOrNull(++index, entity.getId(), statement);
        this.setPrimitiveIntOrNull(++index, entity.getSubject().getId(), statement);
        statement.setString(++index, SubjectDataEncryptor.decrypt((String)entity.getMrn()));
        statement.setString(++index, entity.getSite());
        statement.setString(++index, entity.getStatus());
        statement.executeUpdate();
    }

    private static Options constructOptions() {
        Options options = new Options();
        options.addOption("help", false, "display this message");
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("decrypter", options);
    }

    public static void main(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        Options options = SubjectDecrypter.constructOptions();
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("help")) {
            SubjectDecrypter.printHelp(options);
            System.exit(1);
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-subject-decrypter.xml");
        SubjectDecrypter decrypter = (SubjectDecrypter)context.getBean("subjectDecrypter");
        decrypter.run();
    }
}

