/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.IRBInstitution;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.StudyFundingSource;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.StudyUser;
import edu.harvard.catalyst.scheduler.entity.User;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="study")
public class Study
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String catalystId;
    private String localId;
    private String spid;
    private String protocolNumber;
    private String name;
    private String shortTitle;
    private Institution institution;
    private StudyStatus studyStatus;
    private Date expectedStartDate;
    private Date expectedEndDate;
    private String irb;
    private Date irbExpiration;
    private Date irbRenewalDate;
    private Date irbApprovalDate;
    private Integer totalSubjects;
    private Integer totalOutpatientVisits;
    private Integer totalInpatientVisits;
    private Boolean industryInitiated;
    private String studyAbstract;
    private String clinicalTrial;
    private String newDrug;
    private String deviceExemption;
    private User investigator;
    private String investigatorName;
    private User physician;
    private User physician2;
    private User scheduler;
    private User secondaryScheduler;
    private User scheduler3;
    private User protocolNurse;
    private User associateNurse;
    private User protocolNutritionist;
    private User associateProtocolNutritionist;
    private String protocolNurseString;
    private String protocolNutritionistString;
    private Boolean crcFunded;
    private List<StudySubject> studySubjectList;
    private List<StudyUser> studyUserRoleList;
    private IRBInstitution irbInstitution;
    private String pediatric;
    private String crcCategory;
    private Date statusChange;
    private Date firstVisitDate;
    private Date lastScheduledVisitDate;
    private Set<StudyFundingSource> studyFundingSources = new HashSet<StudyFundingSource>();

    public Study() {
        super(null);
    }

    @Column(name="catalyst_id")
    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    @Column(name="local_id")
    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    @Column(name="spid")
    public String getSpid() {
        return this.spid;
    }

    public void setSpid(String spid) {
        this.spid = spid;
    }

    @Column(name="protocol_number")
    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    @Column(name="irb")
    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    @Column(name="irb_expiration")
    public Date getIrbExpiration() {
        return this.irbExpiration;
    }

    public void setIrbExpiration(Date irbExpiration) {
        this.irbExpiration = irbExpiration;
    }

    @Column(name="irb_renewal_date")
    public Date getIrbRenewalDate() {
        return this.irbRenewalDate;
    }

    public void setIrbRenewalDate(Date irbRenewalDate) {
        this.irbRenewalDate = irbRenewalDate;
    }

    @Column(name="irb_approval_date")
    public Date getIrbApprovalDate() {
        return this.irbApprovalDate;
    }

    public void setIrbApprovalDate(Date irbApprovalDate) {
        this.irbApprovalDate = irbApprovalDate;
    }

    @JoinColumn(name="institution", referencedColumnName="id")
    @ManyToOne
    public Institution getInstitution() {
        return this.institution;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="short_title")
    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @JoinColumn(name="study_status", referencedColumnName="id")
    @ManyToOne
    public StudyStatus getStudyStatus() {
        return this.studyStatus;
    }

    public void setStudyStatus(StudyStatus studyStatus) {
        this.studyStatus = studyStatus;
    }

    @Column(name="industry_initiated")
    public Boolean getIndustryInitiated() {
        return this.industryInitiated;
    }

    public void setIndustryInitiated(Boolean industryInitiated) {
        this.industryInitiated = industryInitiated;
    }

    @Column(name="total_subjects")
    public Integer getTotalSubjects() {
        return this.totalSubjects;
    }

    public void setTotalSubjects(Integer totalSubjects) {
        this.totalSubjects = totalSubjects;
    }

    @Column(name="total_outpatient_visits")
    public Integer getTotalOutpatientVisits() {
        return this.totalOutpatientVisits;
    }

    public void setTotalOutpatientVisits(Integer totalOutpatientVisits) {
        this.totalOutpatientVisits = totalOutpatientVisits;
    }

    @JoinColumn(name="principal_investigator", referencedColumnName="id")
    @ManyToOne
    public User getInvestigator() {
        return this.investigator;
    }

    public void setInvestigator(User investigator) {
        this.investigator = investigator;
    }

    @Transient
    public String getInvestigatorLastNameOrNA() {
        String lastName;
        if (this.investigator != null && (lastName = this.investigator.getLastName()) != null) {
            return lastName;
        }
        return "N/A";
    }

    @JoinColumn(name="responsible_physician", referencedColumnName="id")
    @ManyToOne
    public User getPhysician() {
        return this.physician;
    }

    public void setPhysician(User physician) {
        this.physician = physician;
    }

    @JoinColumn(name="responsible_physician2", referencedColumnName="id")
    @ManyToOne
    public User getPhysician2() {
        return this.physician2;
    }

    public void setPhysician2(User physician2) {
        this.physician2 = physician2;
    }

    @JoinColumn(name="primary_scheduling_contact", referencedColumnName="id")
    @ManyToOne
    public User getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(User scheduler) {
        this.scheduler = scheduler;
    }

    @JoinColumn(name="secondary_scheduling_contact", referencedColumnName="id")
    @ManyToOne
    public User getSecondaryScheduler() {
        return this.secondaryScheduler;
    }

    public void setSecondaryScheduler(User secondaryScheduler) {
        this.secondaryScheduler = secondaryScheduler;
    }

    @JoinColumn(name="protocol_nurse", referencedColumnName="id")
    @ManyToOne
    public User getProtocolNurse() {
        return this.protocolNurse;
    }

    public void setProtocolNurse(User protocolNurse) {
        this.protocolNurse = protocolNurse;
    }

    @Column(name="protocol_nurse_string")
    public String getProtocolNurseString() {
        return this.protocolNurseString;
    }

    public void setProtocolNurseString(String protocolNurseString) {
        this.protocolNurseString = protocolNurseString;
    }

    @Column(name="protocol_nutritionist_string")
    public String getProtocolNutritionistString() {
        return this.protocolNutritionistString;
    }

    public void setProtocolNutritionistString(String protocolNutritionistString) {
        this.protocolNutritionistString = protocolNutritionistString;
    }

    @JoinColumn(name="associate_nurse", referencedColumnName="id")
    @ManyToOne
    public User getAssociateNurse() {
        return this.associateNurse;
    }

    public void setAssociateNurse(User associateNurse) {
        this.associateNurse = associateNurse;
    }

    @JoinColumn(name="protocol_nutritionist", referencedColumnName="id")
    @ManyToOne
    public User getProtocolNutritionist() {
        return this.protocolNutritionist;
    }

    public void setProtocolNutritionist(User protocolNutritionist) {
        this.protocolNutritionist = protocolNutritionist;
    }

    @JoinColumn(name="associate_protocol_nutritionist", referencedColumnName="id")
    @ManyToOne
    public User getAssociateProtocolNutritionist() {
        return this.associateProtocolNutritionist;
    }

    public void setAssociateProtocolNutritionist(User associateProtocolNutritionist) {
        this.associateProtocolNutritionist = associateProtocolNutritionist;
    }

    @JoinColumn(name="irb_institution", referencedColumnName="id")
    @ManyToOne
    public IRBInstitution getIrbInstitution() {
        return this.irbInstitution;
    }

    public void setIrbInstitution(IRBInstitution irbInstitution) {
        this.irbInstitution = irbInstitution;
    }

    @Column(name="pediatric")
    public String getPediatric() {
        return this.pediatric;
    }

    public void setPediatric(String pediatric) {
        this.pediatric = pediatric;
    }

    @Column(name="expected_start_date")
    public Date getExpectedStartDate() {
        return this.expectedStartDate;
    }

    public void setExpectedStartDate(Date expectedStartDate) {
        this.expectedStartDate = expectedStartDate;
    }

    @Column(name="expected_end_date")
    public Date getExpectedEndDate() {
        return this.expectedEndDate;
    }

    public void setExpectedEndDate(Date expectedEndDate) {
        this.expectedEndDate = expectedEndDate;
    }

    @Column(name="total_inpatient_visits")
    public Integer getTotalInpatientVisits() {
        return this.totalInpatientVisits;
    }

    public void setTotalInpatientVisits(Integer totalInpatientVisits) {
        this.totalInpatientVisits = totalInpatientVisits;
    }

    @Column(name="crc_category")
    public String getCrcCategory() {
        return this.crcCategory;
    }

    public void setCrcCategory(String crcCategory) {
        this.crcCategory = crcCategory;
    }

    @Column(name="crc_funded")
    public Boolean getCrcFunded() {
        return this.crcFunded;
    }

    public void setCrcFunded(Boolean crcFunded) {
        this.crcFunded = crcFunded;
    }

    @JoinColumn(name="scheduler3", referencedColumnName="id")
    @ManyToOne
    public User getScheduler3() {
        return this.scheduler3;
    }

    public void setScheduler3(User scheduler3) {
        this.scheduler3 = scheduler3;
    }

    @Column(name="study_abstract")
    public String getStudyAbstract() {
        return this.studyAbstract;
    }

    public void setStudyAbstract(String studyAbstract) {
        this.studyAbstract = studyAbstract;
    }

    @Column(name="clinical_trial")
    public String getClinicalTrial() {
        return this.clinicalTrial;
    }

    public void setClinicalTrial(String clinicalTrial) {
        this.clinicalTrial = clinicalTrial;
    }

    @Column(name="new_drug")
    public String getNewDrug() {
        return this.newDrug;
    }

    public void setNewDrug(String newDrug) {
        this.newDrug = newDrug;
    }

    @Column(name="device_exemption")
    public String getDeviceExemption() {
        return this.deviceExemption;
    }

    public void setDeviceExemption(String deviceExemption) {
        this.deviceExemption = deviceExemption;
    }

    @Column(name="status_change")
    public Date getStatusChange() {
        return this.statusChange;
    }

    public void setStatusChange(Date statusChange) {
        this.statusChange = statusChange;
    }

    @Transient
    public String getInvestigatorName() {
        return this.investigatorName;
    }

    public void setInvestigatorName(String investigatorName) {
        this.investigatorName = investigatorName;
    }

    @Transient
    public List<StudySubject> getStudySubjectList() {
        return this.studySubjectList;
    }

    public void setStudySubjectList(List<StudySubject> studySubjectList) {
        this.studySubjectList = studySubjectList;
    }

    @Transient
    public List<StudyUser> getStudyUserRoleList() {
        return this.studyUserRoleList;
    }

    public void setStudyUserRoleList(List<StudyUser> studyUserRoleList) {
        this.studyUserRoleList = studyUserRoleList;
    }

    @Transient
    public Date getFirstVisitDate() {
        return this.firstVisitDate;
    }

    public void setFirstVisitDate(Date firstVisitDate) {
        this.firstVisitDate = firstVisitDate;
    }

    @Transient
    public Date getLastScheduledVisitDate() {
        return this.lastScheduledVisitDate;
    }

    public void setLastScheduledVisitDate(Date lastScheduledVisitDate) {
        this.lastScheduledVisitDate = lastScheduledVisitDate;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="studyId")
    public Set<StudyFundingSource> getStudyFundingSources() {
        return this.studyFundingSources;
    }

    public void setStudyFundingSources(Set<StudyFundingSource> studyFundingSources) {
        this.studyFundingSources = studyFundingSources;
    }

    public String toString() {
        return "Study [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

