/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class BASE64Decoder {
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;
    byte[] decode_buffer = new byte[4];

    public byte[] decodeBuffer(String var1) throws IOException {
        byte[] var2 = var1.getBytes();
        ByteArrayInputStream var3 = new ByteArrayInputStream(var2);
        ByteArrayOutputStream var4 = new ByteArrayOutputStream();
        this.decodeBuffer(var3, var4);
        return var4.toByteArray();
    }

    public void decodeBuffer(InputStream var1, OutputStream var2) throws IOException {
        PushbackInputStream var5 = new PushbackInputStream(var1);
        try {
            while (true) {
                int var6 = this.decodeLinePrefix(var5, var2);
                int var3 = 0;
                while (var3 + this.bytesPerAtom() < var6) {
                    this.decodeAtom(var5, var2, this.bytesPerAtom());
                    var3 += this.bytesPerAtom();
                }
                if (var3 + this.bytesPerAtom() == var6) {
                    this.decodeAtom(var5, var2, this.bytesPerAtom());
                } else {
                    this.decodeAtom(var5, var2, var6 - var3);
                }
                this.decodeLineSuffix(var5, var2);
            }
        }
        catch (CEStreamExhausted var8) {
            return;
        }
    }

    protected int decodeLinePrefix(PushbackInputStream var1, OutputStream var2) throws IOException {
        return this.bytesPerLine();
    }

    protected void decodeLineSuffix(PushbackInputStream var1, OutputStream var2) throws IOException {
    }

    protected int bytesPerAtom() {
        return 4;
    }

    protected int bytesPerLine() {
        return 72;
    }

    protected int readFully(InputStream var1, byte[] var2, int var3, int var4) throws IOException {
        for (int var5 = 0; var5 < var4; ++var5) {
            int var6 = var1.read();
            if (var6 == -1) {
                return var5 == 0 ? -1 : var5;
            }
            var2[var5 + var3] = (byte)var6;
        }
        return var4;
    }

    protected void decodeAtom(PushbackInputStream var1, OutputStream var2, int var3) throws IOException {
        int var5 = -1;
        int var6 = -1;
        int var7 = -1;
        int var8 = -1;
        if (var3 < 2) {
            SchedulerRuntimeException.logAndThrow("BASE64Decoder: Not enough bytes for an atom.");
        } else {
            int var4;
            do {
                if ((var4 = var1.read()) != -1) continue;
                throw new CEStreamExhausted();
            } while (var4 == 10 || var4 == 13);
            this.decode_buffer[0] = (byte)var4;
            var4 = this.readFully(var1, this.decode_buffer, 1, var3 - 1);
            if (var4 == -1) {
                throw new CEStreamExhausted();
            }
            if (var3 > 3 && this.decode_buffer[3] == 61) {
                var3 = 3;
            }
            if (var3 > 2 && this.decode_buffer[2] == 61) {
                var3 = 2;
            }
            switch (var3) {
                case 4: {
                    var8 = pem_convert_array[this.decode_buffer[3] & 0xFF];
                }
                case 3: {
                    var7 = pem_convert_array[this.decode_buffer[2] & 0xFF];
                }
                case 2: {
                    var6 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                    var5 = pem_convert_array[this.decode_buffer[0] & 0xFF];
                }
            }
            switch (var3) {
                case 2: {
                    var2.write((byte)(var5 << 2 & 0xFC | var6 >>> 4 & 3));
                    break;
                }
                case 3: {
                    var2.write((byte)(var5 << 2 & 0xFC | var6 >>> 4 & 3));
                    var2.write((byte)(var6 << 4 & 0xF0 | var7 >>> 2 & 0xF));
                    break;
                }
                case 4: {
                    var2.write((byte)(var5 << 2 & 0xFC | var6 >>> 4 & 3));
                    var2.write((byte)(var6 << 4 & 0xF0 | var7 >>> 2 & 0xF));
                    var2.write((byte)(var7 << 6 & 0xC0 | var8 & 0x3F));
                }
            }
        }
    }

    public static byte[] base64DecodeOld(String encryptedValue) {
        try {
            return new BASE64Decoder().decodeBuffer(encryptedValue);
        }
        catch (IOException e) {
            throw new RuntimeException("Base64 decoding failed", e);
        }
    }

    static {
        int var0;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (var0 = 0; var0 < 255; ++var0) {
            BASE64Decoder.pem_convert_array[var0] = -1;
        }
        for (var0 = 0; var0 < pem_array.length; ++var0) {
            BASE64Decoder.pem_convert_array[BASE64Decoder.pem_array[var0]] = (byte)var0;
        }
    }

    class CEStreamExhausted
    extends RuntimeException {
        CEStreamExhausted() {
        }
    }
}

