/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.request.ReportTemplateCreateUsersDTO;
import edu.harvard.catalyst.scheduler.dto.request.ReportTemplateRequestDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateMetadataDTO;
import edu.harvard.catalyst.scheduler.dto.response.ReportTemplateUsersDTO;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Field;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.ReportTemplateService;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/reports")
@Singleton
@Component
public class ReportTemplateResource
extends SecuredResource {
    private static final Logger LOGGER = Logger.getLogger(ReportTemplateResource.class);
    private final ReportTemplateService reportTemplateService;
    protected final Gson gson;

    @Autowired
    public ReportTemplateResource(ReportTemplateService reportTemplateService) {
        this.reportTemplateService = reportTemplateService;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                return new Date(json.getAsJsonPrimitive().getAsLong());
            }
        });
        this.gson = builder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes f) {
                return false;
            }
        }}).create();
    }

    @Deprecated
    ReportTemplateResource() {
        this(null);
    }

    @POST
    @Path(value="/templates/{id}/{type}/{templateUserId}/results")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public Response runReportTemplate(@FormParam(value="data") String data, @PathParam(value="id") Integer id, @PathParam(value="type") String type, @PathParam(value="templateUserId") Integer templateUserId) {
        ReportTemplateRequestDTO reportTemplateRequestDTO = (ReportTemplateRequestDTO)this.gson.fromJson(data, ReportTemplateRequestDTO.class);
        StreamingOutput streamingOutput = output -> this.reportTemplateService.runReportTemplate(this.getUser(), this.getRemoteHost(), id, reportTemplateRequestDTO, output, null);
        String reportName = this.reportTemplateService.getTemplateName(id, type, templateUserId).replaceAll("\\s", "_").toLowerCase();
        String fileName = reportName + ".csv";
        Response response = Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        String headerFilename = ((String)((List)response.getMetadata().get((Object)"Content-Disposition")).get(0)).replaceAll("attachment;", "");
        LOGGER.info((Object)("\n--> csv download filename is <" + headerFilename + ">"));
        return response;
    }

    @POST
    @Path(value="/templates/{id}/create-users-report")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String createUsersReport(@FormParam(value="data") String data, @PathParam(value="id") Integer id) {
        ReportTemplateCreateUsersDTO reportTemplateCreateUsersDTO = (ReportTemplateCreateUsersDTO)this.gson.fromJson(data, ReportTemplateCreateUsersDTO.class);
        ReportTemplateMetadataDTO result = this.reportTemplateService.createUserReport(this.getUser(), reportTemplateCreateUsersDTO, id);
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/templates/{id}/update-users-report")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String updateUsersReport(@FormParam(value="data") String data, @PathParam(value="id") Integer id) {
        ReportTemplateCreateUsersDTO reportTemplateCreateUsersDTO = (ReportTemplateCreateUsersDTO)this.gson.fromJson(data, ReportTemplateCreateUsersDTO.class);
        ReportTemplateMetadataDTO result = this.reportTemplateService.updateUserReport(this.getUser(), reportTemplateCreateUsersDTO, id);
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/templates")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getReportTemplateList() {
        List<ReportTemplateMetadataDTO> reportMetadataDTOs = this.reportTemplateService.getReportTemplateList(this.getUser());
        return this.gson.toJson(reportMetadataDTOs);
    }

    @GET
    @Path(value="/templates/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getReportTemplate(@PathParam(value="id") Integer id) {
        ReportTemplateDTO reportTemplateDTO = this.reportTemplateService.getReportTemplate(id);
        return this.gson.toJson((Object)reportTemplateDTO);
    }

    @GET
    @Path(value="/templates/users/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getUsersReport(@PathParam(value="id") Integer id) {
        ReportTemplateUsersDTO reportTemplateDTO = this.reportTemplateService.getUsersReport(id);
        return this.gson.toJson((Object)reportTemplateDTO);
    }

    @POST
    @Path(value="/templates/users/delete/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String deleteUsersReport(@PathParam(value="id") Integer id) {
        BooleanResultDTO result = this.reportTemplateService.deleteUsersReport(id);
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/sortSavedTemplates/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String sortSavedTemplates(@PathParam(value="id") Integer id) {
        List<ReportTemplateMetadataDTO> reportMetadataDTOs = this.reportTemplateService.sortSavedReportTemplateList(this.getUser(), id);
        return this.gson.toJson(reportMetadataDTOs);
    }

    @GET
    @Path(value="/getStaticLists/{id}/{columnName}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getStaticLists(@PathParam(value="id") Integer id, @PathParam(value="columnName") String columnName) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("staticList", this.reportTemplateService.getStaticListByTcf(id, columnName));
        return this.gson.toJson(map);
    }

    @GET
    @Path(value="/getListsByEnumField/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getListsByEnumField(@PathParam(value="id") Integer id) {
        HashMap<String, List<Field.HasReportFiltersNameAndIdPair>> map = new HashMap<String, List<Field.HasReportFiltersNameAndIdPair>>();
        map.put("staticList", this.reportTemplateService.getEnumListByTcf(id));
        return this.gson.toJson(map);
    }

    @GET
    @Path(value="/getListsByField/{id}")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String getListsByField(@PathParam(value="id") Integer id, @QueryParam(value="term") String filterBy, @QueryParam(value="selectedTerms") String selectedTerms) {
        List<Object> result = this.reportTemplateService.getListsByField(id, filterBy, selectedTerms);
        return this.gson.toJson(result);
    }
}

