/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.List;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

class UsernamePasswordAuthenticationTokenDeserializer
extends JsonDeserializer<UsernamePasswordAuthenticationToken> {
    UsernamePasswordAuthenticationTokenDeserializer() {
    }

    public UsernamePasswordAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        UsernamePasswordAuthenticationToken token = null;
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Boolean authenticated = this.readJsonNode(jsonNode, "authenticated").asBoolean();
        JsonNode principalNode = this.readJsonNode(jsonNode, "principal");
        Object principal = null;
        principal = principalNode.isObject() ? mapper.readValue(principalNode.traverse((ObjectCodec)mapper), Object.class) : principalNode.asText();
        JsonNode credentialsNode = this.readJsonNode(jsonNode, "credentials");
        String credentials = credentialsNode.isNull() || credentialsNode.isMissingNode() ? null : credentialsNode.asText();
        List authorities = (List)mapper.readValue(this.readJsonNode(jsonNode, "authorities").traverse((ObjectCodec)mapper), (TypeReference)new TypeReference<List<GrantedAuthority>>(){});
        token = authenticated != false ? new UsernamePasswordAuthenticationToken(principal, credentials, authorities) : new UsernamePasswordAuthenticationToken(principal, credentials);
        JsonNode detailsNode = this.readJsonNode(jsonNode, "details");
        if (detailsNode.isNull() || detailsNode.isMissingNode()) {
            token.setDetails(null);
        } else {
            token.setDetails(detailsNode);
        }
        return token;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

