/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class TypeConfigurationRegistry {
    private static final Logger LOG = Logger.getLogger(TypeConfigurationRegistry.class);
    public static final TypeConfigurationRegistry INSTANCE = new TypeConfigurationRegistry();
    private ConcurrentHashMap<String, TypeConfiguration> configurationMap;

    private TypeConfigurationRegistry() {
    }

    public void registerTypeConfiguration(TypeConfiguration typeConfiguration) {
        if (this.configurationMap == null) {
            this.configurationMap = new ConcurrentHashMap();
        }
        this.configurationMap.put(typeConfiguration.getUuid(), typeConfiguration);
    }

    public TypeConfiguration findTypeConfiguration(String uuid) {
        if (this.configurationMap == null) {
            return null;
        }
        return this.configurationMap.get(uuid);
    }

    public void deregisterTypeConfiguration(TypeConfiguration typeConfiguration) {
        TypeConfiguration existing = this.configurationMap.remove(typeConfiguration.getUuid());
        if (existing != typeConfiguration) {
            LOG.debugf("Different TypeConfiguration [%s] passed to #deregisterTypeConfiguration than previously registered [%s] under that UUID [%s]", (Object)typeConfiguration, (Object)existing, (Object)typeConfiguration.getUuid());
        }
    }
}

