/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.updateUserSalt;

import edu.harvard.catalyst.scheduler.util.BASE64Decoder;
import edu.harvard.catalyst.scheduler.util.OneWayPasswordEncoder;
import java.security.Key;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class UpdateUserSalt {
    private static final Logger log = LogManager.getLogger(UpdateUserSalt.class);
    private final DataSource dataSource;
    static long startTime;
    static long endTime;

    @Autowired
    public UpdateUserSalt(DataSource dataSource, @Qualifier(value="encryptionKeyUpdateUserSalt") Key key) {
        this.dataSource = dataSource;
    }

    public static void main(String[] args) throws SQLException {
        Date startDate = new Date();
        startTime = startDate.getTime();
        System.out.println("START UpdateUserSalt at " + startDate.toString());
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-populate-update-user-salt.xml");
        UpdateUserSalt updateUserSalt = (UpdateUserSalt)context.getBean("updateUserSalt");
        updateUserSalt.update();
        Date endDate = new Date();
        endTime = endDate.getTime();
        long elapsedTime = endTime - startTime;
        System.out.println("Elapsed time: " + elapsedTime / 1000L + " seconds");
        System.out.println("END UpdateUserSalt at " + endDate.toString());
    }

    void update() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            Statement queryStatement = connection.createStatement();
            Statement updateStatement = connection.createStatement();
            queryStatement.executeQuery("SET AUTOCOMMIT = 0");
            updateStatement.executeQuery("SET AUTOCOMMIT = 1");
            ResultSet resultSet = queryStatement.executeQuery("select id, salt from user");
            while (resultSet != null && resultSet.next()) {
                int rowId = resultSet.getInt(1);
                String oldSalt = resultSet.getString(2);
                byte[] oldBytes = BASE64Decoder.base64DecodeOld((String)oldSalt);
                String convertedSalt = OneWayPasswordEncoder.getInstance().byteToBase64(oldBytes);
                assert (!oldSalt.equals(convertedSalt));
                String updateString = "update user set salt = '" + convertedSalt + "' where id=" + rowId;
                updateStatement.executeUpdate(updateString);
            }
        }
    }
}

