/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.jdbc.cursor.internal.StandardRefCursorSupport;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.SQLStateType;
import org.hibernate.engine.jdbc.spi.TypeInfo;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;

public class ExtractedDatabaseMetaDataImpl
implements ExtractedDatabaseMetaData {
    private final JdbcEnvironment jdbcEnvironment;
    private final String connectionCatalogName;
    private final String connectionSchemaName;
    private final boolean supportsRefCursors;
    private final boolean supportsNamedParameters;
    private final boolean supportsScrollableResults;
    private final boolean supportsGetGeneratedKeys;
    private final boolean supportsBatchUpdates;
    private final boolean supportsDataDefinitionInTransaction;
    private final boolean doesDataDefinitionCauseTransactionCommit;
    private final SQLStateType sqlStateType;
    private final boolean lobLocatorUpdateCopy;
    private final Set<String> extraKeywords;
    private final LinkedHashSet<TypeInfo> typeInfoSet;
    private final List<SequenceInformation> sequenceInformationList;

    private ExtractedDatabaseMetaDataImpl(JdbcEnvironment jdbcEnvironment, String connectionCatalogName, String connectionSchemaName, Set<String> extraKeywords, LinkedHashSet<TypeInfo> typeInfoSet, boolean supportsRefCursors, boolean supportsNamedParameters, boolean supportsScrollableResults, boolean supportsGetGeneratedKeys, boolean supportsBatchUpdates, boolean supportsDataDefinitionInTransaction, boolean doesDataDefinitionCauseTransactionCommit, SQLStateType sqlStateType, boolean lobLocatorUpdateCopy, List<SequenceInformation> sequenceInformationList) {
        this.jdbcEnvironment = jdbcEnvironment;
        this.connectionCatalogName = connectionCatalogName;
        this.connectionSchemaName = connectionSchemaName;
        this.extraKeywords = extraKeywords != null ? extraKeywords : Collections.emptySet();
        this.typeInfoSet = typeInfoSet != null ? typeInfoSet : new LinkedHashSet();
        this.supportsRefCursors = supportsRefCursors;
        this.supportsNamedParameters = supportsNamedParameters;
        this.supportsScrollableResults = supportsScrollableResults;
        this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
        this.supportsBatchUpdates = supportsBatchUpdates;
        this.supportsDataDefinitionInTransaction = supportsDataDefinitionInTransaction;
        this.doesDataDefinitionCauseTransactionCommit = doesDataDefinitionCauseTransactionCommit;
        this.sqlStateType = sqlStateType;
        this.lobLocatorUpdateCopy = lobLocatorUpdateCopy;
        this.sequenceInformationList = sequenceInformationList;
    }

    @Override
    public boolean supportsRefCursors() {
        return this.supportsRefCursors;
    }

    @Override
    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    @Override
    public boolean supportsNamedParameters() {
        return this.supportsNamedParameters;
    }

    @Override
    public boolean supportsScrollableResults() {
        return this.supportsScrollableResults;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return this.supportsGetGeneratedKeys;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return this.supportsBatchUpdates;
    }

    @Override
    public boolean supportsDataDefinitionInTransaction() {
        return this.supportsDataDefinitionInTransaction;
    }

    @Override
    public boolean doesDataDefinitionCauseTransactionCommit() {
        return this.doesDataDefinitionCauseTransactionCommit;
    }

    @Override
    public Set<String> getExtraKeywords() {
        return this.extraKeywords;
    }

    @Override
    public SQLStateType getSqlStateType() {
        return this.sqlStateType;
    }

    @Override
    public boolean doesLobLocatorUpdateCopy() {
        return this.lobLocatorUpdateCopy;
    }

    @Override
    public String getConnectionCatalogName() {
        return this.connectionCatalogName;
    }

    @Override
    public String getConnectionSchemaName() {
        return this.connectionSchemaName;
    }

    @Override
    public LinkedHashSet<TypeInfo> getTypeInfoSet() {
        return this.typeInfoSet;
    }

    @Override
    public List<SequenceInformation> getSequenceInformationList() {
        return this.sequenceInformationList;
    }

    public static class Builder {
        private final JdbcEnvironment jdbcEnvironment;
        private String connectionSchemaName;
        private String connectionCatalogName;
        private Set<String> extraKeywords;
        private LinkedHashSet<TypeInfo> typeInfoSet;
        private boolean supportsRefCursors;
        private boolean supportsNamedParameters;
        private boolean supportsScrollableResults;
        private boolean supportsGetGeneratedKeys;
        private boolean supportsBatchUpdates;
        private boolean supportsDataDefinitionInTransaction;
        private boolean doesDataDefinitionCauseTransactionCommit;
        private SQLStateType sqlStateType;
        private boolean lobLocatorUpdateCopy;
        private List<SequenceInformation> sequenceInformationList = Collections.emptyList();

        public Builder(JdbcEnvironment jdbcEnvironment) {
            this.jdbcEnvironment = jdbcEnvironment;
        }

        public Builder apply(DatabaseMetaData databaseMetaData) throws SQLException {
            this.connectionCatalogName = databaseMetaData.getConnection().getCatalog();
            this.supportsRefCursors = StandardRefCursorSupport.supportsRefCursors(databaseMetaData);
            this.supportsNamedParameters = databaseMetaData.supportsNamedParameters();
            this.supportsScrollableResults = databaseMetaData.supportsResultSetType(1004);
            this.supportsGetGeneratedKeys = databaseMetaData.supportsGetGeneratedKeys();
            this.supportsBatchUpdates = databaseMetaData.supportsBatchUpdates();
            this.supportsDataDefinitionInTransaction = !databaseMetaData.dataDefinitionIgnoredInTransactions();
            this.doesDataDefinitionCauseTransactionCommit = databaseMetaData.dataDefinitionCausesTransactionCommit();
            this.extraKeywords = this.parseKeywords(databaseMetaData.getSQLKeywords());
            this.sqlStateType = SQLStateType.interpretReportedSQLStateType(databaseMetaData.getSQLStateType());
            this.lobLocatorUpdateCopy = databaseMetaData.locatorsUpdateCopy();
            this.typeInfoSet = new LinkedHashSet();
            this.typeInfoSet.addAll(TypeInfo.extractTypeInfo(databaseMetaData));
            return this;
        }

        private Set<String> parseKeywords(String extraKeywordsString) {
            if (StringHelper.isEmpty(extraKeywordsString)) {
                return Collections.emptySet();
            }
            HashSet<String> keywordSet = new HashSet<String>();
            keywordSet.addAll(Arrays.asList(extraKeywordsString.split("\\s*,\\s*")));
            return keywordSet;
        }

        public Builder setConnectionSchemaName(String connectionSchemaName) {
            this.connectionSchemaName = connectionSchemaName;
            return this;
        }

        public Builder setConnectionCatalogName(String connectionCatalogName) {
            this.connectionCatalogName = connectionCatalogName;
            return this;
        }

        public Builder setExtraKeywords(Set<String> extraKeywords) {
            if (this.extraKeywords == null) {
                this.extraKeywords = extraKeywords;
            } else {
                this.extraKeywords.addAll(extraKeywords);
            }
            return this;
        }

        public Builder addExtraKeyword(String keyword) {
            if (this.extraKeywords == null) {
                this.extraKeywords = new HashSet<String>();
            }
            this.extraKeywords.add(keyword);
            return this;
        }

        public Builder setTypeInfoSet(LinkedHashSet<TypeInfo> typeInfoSet) {
            if (this.typeInfoSet == null) {
                this.typeInfoSet = typeInfoSet;
            } else {
                this.typeInfoSet.addAll(typeInfoSet);
            }
            return this;
        }

        public Builder addTypeInfo(TypeInfo typeInfo) {
            if (this.typeInfoSet == null) {
                this.typeInfoSet = new LinkedHashSet();
            }
            this.typeInfoSet.add(typeInfo);
            return this;
        }

        public Builder setSupportsRefCursors(boolean supportsRefCursors) {
            this.supportsRefCursors = supportsRefCursors;
            return this;
        }

        public Builder setSupportsNamedParameters(boolean supportsNamedParameters) {
            this.supportsNamedParameters = supportsNamedParameters;
            return this;
        }

        public Builder setSupportsScrollableResults(boolean supportsScrollableResults) {
            this.supportsScrollableResults = supportsScrollableResults;
            return this;
        }

        public Builder setSupportsGetGeneratedKeys(boolean supportsGetGeneratedKeys) {
            this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
            return this;
        }

        public Builder setSupportsBatchUpdates(boolean supportsBatchUpdates) {
            this.supportsBatchUpdates = supportsBatchUpdates;
            return this;
        }

        public Builder setSupportsDataDefinitionInTransaction(boolean supportsDataDefinitionInTransaction) {
            this.supportsDataDefinitionInTransaction = supportsDataDefinitionInTransaction;
            return this;
        }

        public Builder setDoesDataDefinitionCauseTransactionCommit(boolean doesDataDefinitionCauseTransactionCommit) {
            this.doesDataDefinitionCauseTransactionCommit = doesDataDefinitionCauseTransactionCommit;
            return this;
        }

        public Builder setSqlStateType(SQLStateType sqlStateType) {
            this.sqlStateType = sqlStateType;
            return this;
        }

        public Builder setLobLocatorUpdateCopy(boolean lobLocatorUpdateCopy) {
            this.lobLocatorUpdateCopy = lobLocatorUpdateCopy;
            return this;
        }

        public Builder setSequenceInformationList(List<SequenceInformation> sequenceInformationList) {
            this.sequenceInformationList = sequenceInformationList;
            return this;
        }

        public ExtractedDatabaseMetaDataImpl build() {
            return new ExtractedDatabaseMetaDataImpl(this.jdbcEnvironment, this.connectionCatalogName, this.connectionSchemaName, this.extraKeywords, this.typeInfoSet, this.supportsRefCursors, this.supportsNamedParameters, this.supportsScrollableResults, this.supportsGetGeneratedKeys, this.supportsBatchUpdates, this.supportsDataDefinitionInTransaction, this.doesDataDefinitionCauseTransactionCommit, this.sqlStateType, this.lobLocatorUpdateCopy, this.sequenceInformationList);
        }
    }
}

