/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

public class CRCAvailabilityReportDTO
implements CsvAbleDTO {
    private String studyName;
    private String visitName;
    private String scheduled;
    private String overbook;

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(String scheduled) {
        this.scheduled = scheduled;
    }

    public String getOverbook() {
        return this.overbook;
    }

    public void setOverbook(String overbook) {
        this.overbook = overbook;
    }

    @Override
    public String toCsvHeaders() {
        return "Study Name,Visit Name,# visits booked normally,# visits overbooked";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            CRCAvailabilityReportDTO d = (CRCAvailabilityReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(d.visitName));
            columns.add(MiscUtil.q(d.scheduled));
            columns.add(MiscUtil.q(d.overbook));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

