/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class GanttGroupablesResponseDTO
extends GanttResponseDTO {
    private final List<GanttResourceDetail> acceptableGroupies;

    public GanttGroupablesResponseDTO(List<TemplateResource> allTemplateResourcesFromVisit, Predicate<? super TemplateResource> relevancePredicate, Integer groupAspirantId, Function<List<TemplateResource>, String> groupValidityCheck) {
        List<TemplateResource> acceptableGroupieTRs;
        List<TemplateResource> groupableTemplateResourcesFromVisit = this.getRelevantTemplateResources(allTemplateResourcesFromVisit, relevancePredicate);
        TemplateResource aspirant = this.findTrByIdFromList(groupAspirantId, groupableTemplateResourcesFromVisit);
        if (aspirant.getFloatable().booleanValue()) {
            groupableTemplateResourcesFromVisit.remove(aspirant);
            acceptableGroupieTRs = groupableTemplateResourcesFromVisit.stream().filter(tr -> ((String)groupValidityCheck.apply(Lists.newArrayList((Object[])new TemplateResource[]{tr, aspirant}))).equals("OK")).collect(Collectors.toList());
        } else {
            acceptableGroupieTRs = TemplateResource.getValidFlexGroup(groupableTemplateResourcesFromVisit, aspirant);
        }
        this.acceptableGroupies = acceptableGroupieTRs.stream().map(tr -> new GanttResourceDetail((TemplateResource)tr)).collect(Collectors.toList());
        this.acceptableGroupies.sort((o1, o2) -> {
            int timeCompare = o1.resourceStartMinutes.compareTo(o2.resourceStartMinutes);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return o1.resourceName.compareTo(o2.resourceName);
        });
    }

    @Override
    public String jsonify(Gson gson) {
        return gson.toJson((Object)this);
    }

    public static final class GanttResourceDetail {
        private final Integer resourceStartMinutes;
        private final Integer resourceEndMinutes;
        private final String resourceName;
        private final String resourceType;
        private final int id;

        GanttResourceDetail(TemplateResource templateResource) {
            if (templateResource == null || templateResource.getResource() == null) {
                SchedulerRuntimeException.logAndThrow("TemplateResource and Resource should be non-null");
            }
            Resource itsResource = templateResource.getResource();
            this.id = templateResource.getId();
            this.resourceName = itsResource.getName();
            this.resourceType = itsResource.getResourceType().getName();
            this.resourceStartMinutes = templateResource.getStartMinutes();
            this.resourceEndMinutes = templateResource.getEndMinutes();
        }
    }
}

