/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.core.BookedVisitActivityLogStatics;
import edu.harvard.catalyst.scheduler.dto.ScheduledVisitHistoryDTO;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.BookedVisitActivityLog;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.AuditDAO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditService {
    private AuditDAO auditDAO;
    private AppointmentDAO appointmentDAO;

    @Autowired
    public AuditService(AuditDAO auditDAO, AppointmentDAO appointmentDAO) {
        this.auditDAO = auditDAO;
        this.appointmentDAO = appointmentDAO;
    }

    AuditService() {
    }

    void logSubjectActivity(String ipAddress, final Subject subject, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedSubject(subject);
            }
        });
    }

    void logAppointmentActivity(String ipAddress, BookedVisit bookedVisit, User user, BookedVisitActivityLogStatics action) {
        this.logAppointmentActivity(ipAddress, bookedVisit, user, action.getLogString(), null);
    }

    void logAppointmentActivity(String ipAddress, BookedVisit bookedVisit, User user, String action) {
        this.logAppointmentActivity(ipAddress, bookedVisit, user, action, null);
    }

    void logAppointmentActivity(String ipAddress, BookedVisit bookedVisit, User user, BookedVisitActivityLogStatics action, AppointmentOverrideReason overrideReason) {
        this.logAppointmentActivity(ipAddress, bookedVisit, user, action.getLogString(), overrideReason);
    }

    void logAppointmentActivity(String ipAddress, BookedVisit bookedVisit, User user, String action, AppointmentOverrideReason overrideReason) {
        BookedVisitActivityLog log = new BookedVisitActivityLog();
        log.setPerformingUser(user);
        log.setActionPerformed(action);
        log.setDate(new Date());
        log.setIpAddress(ipAddress);
        log.setBookedVisit(bookedVisit);
        log.setAppointmentOverrideReason(overrideReason);
        this.auditDAO.createEntity(log);
    }

    public ScheduledVisitHistoryDTO getActivityLogForBookedVisit(int visitId) {
        BookedVisit visit = this.appointmentDAO.findBookedVisitById(visitId);
        List<BookedVisitActivityLog> bookedVisitActivityList = this.getActivityLogForBookedVisit(visit);
        return new ScheduledVisitHistoryDTO(bookedVisitActivityList);
    }

    public List<BookedVisitActivityLog> getActivityLogForBookedVisit(BookedVisit bookedVisit) {
        return this.auditDAO.getActivityLogForBookedVisit(bookedVisit);
    }

    void logAppointmentOverrideActivity(String ipAddress, final BookedVisit bv, final Resource r, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setBookedVisit(bv);
                log.setAffectedResource(r);
            }
        });
    }

    void logUserActivity(String ipAddress, final User createdUser, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedUser(createdUser);
            }
        });
    }

    void logStudyActivity(String ipAddress, final Study study, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedStudy(study);
            }
        });
    }

    void logTemplateResourceActivity(String host, User user, final VisitTemplate visitTemplate, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(host, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedVisit(visitTemplate);
            }
        });
    }

    void logStudySubjectActivity(String ipAddress, final Study study, final Subject subject, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedStudy(study);
                log.setAffectedSubject(subject);
            }
        });
    }

    void logStudyAndSubjectMrnActivity(String ipAddress, final Study study, final SubjectMrn subjectMrn, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedStudy(study);
                log.setAffectedSubject(subjectMrn.getSubject());
                log.setAffectedSubjectMrn(subjectMrn);
            }
        });
    }

    void logStudyMemberActivity(String ipAddress, final Study study, final User u, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedUser(u);
                log.setAffectedStudy(study);
            }
        });
    }

    void logVisitActivity(String ipAddress, final VisitTemplate visit, final User user, final String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setActionPerformed(action + " : " + visit.getName() + " by " + user.getFirstName() + " " + user.getLastName());
                log.setAffectedVisit(visit);
            }
        });
    }

    void logDeleteVisitActivity(String ipAddress, final String visit, final User user, final String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setActionPerformed(action + " : " + visit + " by " + user.getFirstName() + " " + user.getLastName());
            }
        });
    }

    void logViewActivity(String ipAddress, User user, String action) {
        this.doLog(ipAddress, user, action, null, null, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
            }
        });
    }

    void logVisitApprovalActivity(String ipAddress, final VisitTemplate visit, User user, final User affectedUser, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedUser(affectedUser);
                log.setAffectedVisit(visit);
            }
        });
    }

    void logResourceActivity(String ipAddress, final Resource resource, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedResource(resource);
            }
        });
    }

    void logResourceSublocationClosureActivity(String ipAddress, final Sublocation sublocation, User user, String action, String requiredFieldPreviousData, String previousData) {
        this.doLog(ipAddress, user, action, requiredFieldPreviousData, previousData, new LogOperation(){

            @Override
            public void modifyActivityLog(ActivityLog log) {
                log.setAffectedSublocation(sublocation);
            }
        });
    }

    ActivityLog generateActivityLog(String ipAddress, User user, String action, String requiredFieldPreviousData, String previousData) {
        ActivityLog log = new ActivityLog();
        log.setActionPerformed(action);
        log.setDate(new Date());
        log.setIpAddress(ipAddress);
        log.setPerformingUser(user);
        log.setChangesDetail(previousData);
        log.setChangesDetailRequiredField(requiredFieldPreviousData);
        return log;
    }

    void doLog(String ipAddress, User user, String action, String requiredFieldPreviousData, String previousData, LogOperation op) {
        ActivityLog log = this.generateActivityLog(ipAddress, user, action, requiredFieldPreviousData, previousData);
        op.modifyActivityLog(log);
        this.auditDAO.createEntity(log);
    }

    private static interface LogOperation {
        public void modifyActivityLog(ActivityLog var1);
    }
}

