/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var sublocationFilterName;
var app_selectedUser;
var app_selectedResource;
var app_selectedResourceSchedule;
var app_selectedTempAdj;
var app_selectedSubject;
var app_selectedStudy;
var app_selectedVisit;
var MINS_PER_DAY = 1440;
var MINS_PER_HOUR = 60;
var app_selectedBookedVisit;
var app_selectedBookedResource;
var resourcesSelectOptions;
var app_selectedTemplateResource;
var home;
var roles;
var visitTypes;
var sublocations;
var institutionRoles;
var studyStatuses;
var resourceNames;
var overrideReasons;
var institutions;
var checkOutReasons;
var cancellationReasons;
var states;
var races;
var ethnicities;
var countries;
var genders;
var credentials;
var departments;
var divisions;
var facultyRanks;
var yesNo = ["Yes", "No"];
var adultPediatric = ["Adult", "Pediatric", "Adult/Pediatric"];
var crcCategories = ["A", "B", "C", "D"];
var rooms;
var roomSelectOptions;
var roleSelectOptions;
var visitTypeSelectOptions;
var sublocationSelectOptions;
var institutionRoleSelectOptions;
var resourceNameSelectOptions;
var overrideReasonSelectOptions;
var institutionSelectOptions;
var checkOutReasonSelectOptions;
var cancellationReasonSelectOptions;
var stateSelectOptions;
var raceSelectOptions;
var ethnicitySelectOptions;
var genderSelectOptions;
var countrySelectOptions;
var credentialSelectOptions;
var departmentSelectOptions;
var divisionSelectOptions;
var facultyRankSelectOptions;
var studyStatusSelectOptions;
var studyMembersSelectOptions;
var yesNoSelectOptions;
var adultPediatricSelectOptions;
var crcCategorySelectOptions;
var app_idleInterval;
var user;
var calendar_rendered = false;
var USER_STATUS_AUTHORIZED = 1;
var USER_STATUS_NOT_FOUND = 0;
var USER_STATUS_INVALID_PASSWORD = -1;
var USER_STATUS_INACTIVE = -2;
var PREVIOUS_ACCESS_SHOWN = false;
var NEW_RESOURCE_LINK_ENABLED = false;
var idleTime = 0;
var ONE_MINUTE = 60000;
var minDate;
var SUPER_ADMIN = 1;
var RESOURCE_MANAGER = 2;
var SCHEDULER = 3;
var STUDY_STAFF = 4;
var FRONT_DESK = 5;
var GENERAL_VIEW = 6;
var demographic_check = false;
var nAgt = navigator.userAgent;
var fullVersion = '' + parseFloat(navigator.appVersion);
var majorVersion = parseInt(navigator.appVersion, 10);
var verOffset, ix;
var view = null;
var initial_load = true;
var currentPage;
var max_results;
var totalData = 0;
var totalPages;
var selectedPage = 1;
var apptInitialDisplay = false;
var enteredPage;
var dayOfWeekString = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
var monthString = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];

function subjectModule() {
    if (user.institutionRole.id == STUDY_STAFF) {
        window.location.href = "search_subject.html";
    } else {
        sessionStorage.setItem("userData", JSON.stringify(user));
        window.location.href = "subject_screen.html";
    }
}

function mgmtModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    if (PREVIOUS_ACCESS_SHOWN == false && user.previousLoginTime == "") {
        window.location.href = "password_reset.html";
    } else if (user.institutionRole.id == SUPER_ADMIN) {
        window.location.href = "mgmt_screen.html";
    } else {
        window.location.href = "password_reset.html";
    }
}

function appointmentModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    sessionStorage.setItem("is_navigated", false);
    sessionStorage.setItem("eventid", "");
    window.location.href = "appt_calendar.html";
}

function appointmentListModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "appt_list.html";
}

function appointmentBatchModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "appt_batch.html";
}

function homeModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    sessionStorage.setItem("eventid", "");
    window.location.href = "home.html";
}

function studyModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "study_screen.html";
}

function resourceModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "resource_screen.html";
}

function reportModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "report.html";
}

function reportsModule() {
    sessionStorage.setItem("userData", JSON.stringify(user));
    window.location.href = "reports.html";
}

function logoutUser() {
    util_logout();
}

function restrictAccess() {
    $(document)
        .ajaxError(function(e, xhr, options) {
            if (xhr.status === 403) {
                window.location.href = "access_denied.html";
            }
        });
}

function commonData() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user != null) {
        $('#home_userFullName')
            .text(util_buildFullName(user.firstName, user.middleName, user.lastName));
        restrictAccess();
        if (user.previousLoginTime != "") {
            linkRender();
        } else {
            $('.headerNav')
                .css({
                    visibility: "hidden"
                });
            $('#welcomeMessage')
                .css({
                    display: "block"
                });
            $('#index_helpLinks')
                .css({
                    visibility: "visible"
                });
            $('.homelink')
                .css({
                    visibility: "hidden"
                });
            $('.resourcelink')
                .css({
                    visibility: "hidden"
                });
            $('.studieslink')
                .css({
                    visibility: "hidden"
                });
            $('.subjectslink')
                .css({
                    visibility: "hidden"
                });
            $('.appointmentslink')
                .css({
                    visibility: "hidden"
                });
            $('.managementlink')
                .css({
                    visibility: "visible"
                });
            $('.reportlink')
                .css({
                    visibility: "hidden"
                });
            $('.reportslink')
                .css({
                    visibility: "hidden"
                });
        }
    }
}

function linkRender() {
    $('.headerNav')
        .css({
            visibility: "visible"
        });
    $('#welcomeMessage')
        .css({
            display: "block"
        });
    $('#index_helpLinks')
        .css({
            visibility: "visible"
        });
    moduleRoles();
}

function app_handleMouseMove() {
    idleTime = 0;
}

function app_runIdleTimer() {
    //Increment the idle time counter every minute.
    app_idleInterval = setInterval(app_timerIncrement, ONE_MINUTE);
    //Zero the idle timer on mouse movement.
    $(this)
        .mousemove(function(e) {
            idleTime = 0;
        });
    //Zero the idle timer on data entry.
    $(this)
        .keypress(function(e) {
            idleTime = 0;
        });
    $('.numbersOnly')
        .keyup(function() {
            if (this.value != this.value.replace(/[^0-9\.]/g, '')) {
                this.value = this.value.replace(/[^0-9\.]/g, '');
            }
        });
    $('.alphanumericOnly')
        .keyup(function() {
            if (this.value != this.value.replace(/[^a-zA-Z0-9\.]/g, '')) {
                this.value = this.value.replace(/[^a-zA-Z0-9\.]/g, '');
            }
        });
}

function app_timerIncrement() {
    idleTime++;
    if (idleTime == 25) {
        $('#main_dialog_text')
            .html('You will be automatically logged out soon unless you do something!');
        $('#main_dialog_wrapper')
            .css({
                opacity: 0.0,
                visibility: "visible"
            })
            .animate({
                opacity: 1.0
            });
    } else if (idleTime == 30) {
        sessionStorage.removeItem("userData");
        sessionStorage.removeItem("eventid");
        window.location.href = "login.html?session_timed_out=true";
    }
}

function removeLogoutWindow() {
    app_timerDismiss();
}

function app_timerDismiss() {
    $('#main_dialog_wrapper')
        .css({
            opacity: 1.0,
            visibility: "hidden"
        })
        .animate({
            opacity: 0.0
        });
    var jsonData = JSON.stringify({
        user: user
    });
    $.post("rest/auth/updateSession", {
        data: jsonData
    }, function(data) {});
    idleTime = 0;
}

function resourceModuleRoles() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user.institutionRole.id == SUPER_ADMIN) {
        $('.resource_addNewResource')
            .css({
                visibility: "visible"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "visible"
            });
        $('.resource_editResource')
            .css({
                visibility: "visible"
            });
        $('.resource_addDefault')
            .css({
                visibility: "visible"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "visible"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == RESOURCE_MANAGER) {
        $('.resource_addNewResource')
            .css({
                visibility: "visible"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "visible"
            });
        $('.resource_editResource')
            .css({
                visibility: "visible"
            });
        $('.resource_addDefault')
            .css({
                visibility: "visible"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "visible"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == SCHEDULER) {
        $('.resource_addNewResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "visible"
            });
        $('.resource_editResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_addDefault')
            .css({
                visibility: "hidden"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "hidden"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == STUDY_STAFF) {
        $('.resource_addNewResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "hidden"
            });
        $('.resource_editResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_addDefault')
            .css({
                visibility: "hidden"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "hidden"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == FRONT_DESK) {
        $('.resource_addNewResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "hidden"
            });
        $('.resource_editResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_addDefault')
            .css({
                visibility: "hidden"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "hidden"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == GENERAL_VIEW) {
        $('.resource_addNewResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_sublocationClosure')
            .css({
                visibility: "hidden"
            });
        $('.resource_editResource')
            .css({
                visibility: "hidden"
            });
        $('.resource_addDefault')
            .css({
                visibility: "hidden"
            });
        $('.resource_addAlternate')
            .css({
                visibility: "hidden"
            });
        $('.resource_addTemporary')
            .css({
                visibility: "hidden"
            });
    }
}

function studyModuleRoles() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user.institutionRole.id == SUPER_ADMIN) {
        $('.study_newStudy')
            .css({
                visibility: "visible"
            });
        $('.study_editStudy')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == RESOURCE_MANAGER) {
        $('.study_newStudy')
            .css({
                visibility: "hidden"
            });
        $('.study_editStudy')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == SCHEDULER) {
        $('.study_newStudy')
            .css({
                visibility: "hidden"
            });
        $('.study_editStudy')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == STUDY_STAFF) {
        $('.study_newStudy')
            .css({
                visibility: "hidden"
            });
        $('.study_editStudy')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == FRONT_DESK) {
        $('.study_newStudy')
            .css({
                visibility: "hidden"
            });
        $('.study_editStudy')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == GENERAL_VIEW) {
        $('.study_newStudy')
            .css({
                visibility: "hidden"
            });
        $('.study_editStudy')
            .css({
                visibility: "hidden"
            });
    }
}

function appointmentModuleRoles() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user.institutionRole.id == SUPER_ADMIN) {
        $('.appt_schedule')
            .css({
                visibility: "visible"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "visible"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == RESOURCE_MANAGER) {
        $('.appt_schedule')
            .css({
                visibility: "visible"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "visible"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == SCHEDULER) {
        $('.appt_schedule')
            .css({
                visibility: "visible"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "visible"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "visible"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "visible"
            });
    } else if (user.institutionRole.id == STUDY_STAFF) {
        $('.appt_schedule')
            .css({
                visibility: "visible"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "visible"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == FRONT_DESK) {
        $('.appt_schedule')
            .css({
                visibility: "visible"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "visible"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "visible"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "hidden"
            });
    } else if (user.institutionRole.id == GENERAL_VIEW) {
        $('.appt_schedule')
            .css({
                visibility: "hidden"
            });
        $('.appt_schedule_list')
            .css({
                visibility: "hidden"
            });
        $('.appt_checkoutnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_checkoutVisitnewResource')
            .css({
                visibility: "hidden"
            });
        $('.appt_newStudySubjectButton')
            .css({
                visibility: "hidden"
            });
        $('.newOverrideItemButton')
            .css({
                visibility: "hidden"
            });
    }
}

function homeModuleRoles() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user.institutionRole.id == SUPER_ADMIN) {
        $("#hp-tab2")
            .css({
                visibility: 'visible'
            });
        $("#tab2")
            .css({
                visibility: 'visible'
            });
    } else if (user.institutionRole.id == RESOURCE_MANAGER) {
        $("#hp-tab2")
            .css({
                visibility: 'visible'
            });
        $("#tab2")
            .css({
                visibility: 'visible'
            });
    } else if (user.institutionRole.id == SCHEDULER) {
        $("#hp-tab2")
            .css({
                visibility: 'visible'
            });
        $("#tab2")
            .css({
                visibility: 'visible'
            });
    } else if (user.institutionRole.id == STUDY_STAFF) {
        $("#hp-tab2")
            .css({
                visibility: 'hidden'
            });
        $("#tab2")
            .css({
                visibility: 'hidden'
            });
    } else if (user.institutionRole.id == FRONT_DESK) {
        $("#hp-tab2")
            .css({
                visibility: 'hidden'
            });
        $("#tab2")
            .css({
                visibility: 'hidden'
            });
    } else if (user.institutionRole.id == GENERAL_VIEW) {
        $("#hp-tab2")
            .css({
                visibility: 'hidden'
            });
        $("#tab2")
            .css({
                visibility: 'hidden'
            });
    }
}

function moduleRoles() {
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (user.institutionRole.id == SUPER_ADMIN) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "inline-block"
            });
        $('.subjectslink')
            .css({
                display: "inline-block"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "inline-block"
            });
        $('.reportslink')
            .css({
                display: "inline-block"
            });
    } else if (user.institutionRole.id == RESOURCE_MANAGER) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "inline-block"
            });
        $('.subjectslink')
            .css({
                display: "inline-block"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "inline-block"
            });
        $('.reportslink')
            .css({
                display: "none"
            });
    } else if (user.institutionRole.id == SCHEDULER) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "inline-block"
            });
        $('.subjectslink')
            .css({
                display: "inline-block"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "inline-block"
            });
        $('.reportslink')
            .css({
                display: "none"
            });
    } else if (user.institutionRole.id == STUDY_STAFF) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "inline-block"
            });
        $('.subjectslink')
            .css({
                display: "inline-block"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "none"
            });
        $('.reportslink')
            .css({
                display: "none"
            });
    } else if (user.institutionRole.id == FRONT_DESK) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "inline-block"
            });
        $('.subjectslink')
            .css({
                display: "inline-block"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "inline-block"
            });
        $('.reportslink')
            .css({
                display: "none"
            });
    } else if (user.institutionRole.id == GENERAL_VIEW) {
        $('.homelink')
            .css({
                display: "inline-block"
            });
        $('.resourcelink')
            .css({
                display: "inline-block"
            });
        $('.studieslink')
            .css({
                display: "none"
            });
        $('.subjectslink')
            .css({
                display: "none"
            });
        $('.appointmentslink')
            .css({
                display: "inline-block"
            });
        $('.managementlink')
            .css({
                display: "inline-block"
            });
        $('.reportlink')
            .css({
                display: "inline-block"
            });
        $('.reportslink')
            .css({
                display: "none"
            });
    }
}

function getBrowserVersion() {
    if ((verOffset = nAgt.indexOf("MSIE")) != -1) {
        fullVersion = nAgt.substring(verOffset + 5);
    }
    // trim the fullVersion string at semicolon/space if present
    if ((ix = fullVersion.indexOf(";")) != -1) fullVersion = fullVersion.substring(0, ix);
    if ((ix = fullVersion.indexOf(" ")) != -1) fullVersion = fullVersion.substring(0, ix);
    majorVersion = parseInt('' + fullVersion, 10);
    if (isNaN(majorVersion)) {
        fullVersion = '' + parseFloat(navigator.appVersion);
        majorVersion = parseInt(navigator.appVersion, 10);
    }
}

function showDate(value) {
    if (value != null && value != undefined && value != '') {
        return dateFormat(value, 'mm/dd/yyyy');
    } else {
        return "";
    }
}

function showClockDateTime(value) {
    if (value != null && value !== undefined) {
        return dateFormat(value, 'mm/dd/yyyy hh:MM tt');
    } else {
        return "";
    }
}

function addMinutes(date, minutes) {
    return new Date(date.getTime() + minutes * ONE_MINUTE);
}

function showDateTime(value) {
    if (value != null && value !== undefined) {
        return dateFormat(value, 'mm/dd/yyyy HH:MM');
    } else {
        return "";
    }
}

function isValidDate(dateString) {
    // First check for the pattern
    if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateString)) return false;
    // Parse the date parts to integers
    var parts = dateString.split("/");
    var day = parseInt(parts[1], 10);
    var month = parseInt(parts[0], 10);
    var year = parseInt(parts[2], 10);
    // Check the ranges of month and year
    if (year < 1000 || year > 3000 || month == 0 || month > 12) return false;
    var monthLength = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    // Adjust for leap years
    if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0)) monthLength[1] = 29;
    // Check the range of the day
    return day > 0 && day <= monthLength[month - 1];
}

function showTime(value) {
    if (value != null && value !== undefined) {
        return dateFormat(value, 'HH:MM');
    } else {
        return "";
    }
}

function showStandardTime(value) {
    var hours24 = parseInt(value.substring(0, 2), 10);
    var hours = ((hours24 + 11) % 12) + 1;
    var amPm = hours24 > 11 ? 'pm' : 'am';
    var minutes = value.substring(2);
    return hours + minutes + ' ' + amPm;
}

function showStandardDateTime(value) {
    if (value != null && value !== undefined) {
        return dateFormat(value, 'mm/dd/yyyy hh:MM tt');
    } else {
        return "";
    }
}

function statusValue(value) {
    if (value !== undefined) {
        return (value == true ? "Active" : "Not Active");
    } else {
        return "";
    }
}

function showValue(value) {
    if (value !== undefined) {
        return value;
    } else {
        return "";
    }
}

function yesNoValue(value) {
    if (value !== undefined) {
        return (value == true ? "Yes" : "No");
    } else {
        return "";
    }
}

function buildFullName(obj) {
    if (obj != null && obj !== undefined) {
        return util_buildFullName(showValue(obj.firstName), showValue(obj.middleName), showValue(obj.lastName));
    } else {
        return "";
    }
}

function removeAdditionalComma(value) {
    return value.replace(/,/g, "");
}

function validatePageInput(object) {
    page = parseInt(object.value);
    enteredPage = parseInt(object.value);
    if (isNaN(page) || page == 'undefined') {
        util_showMainMessage("Please enter a valid page number.");
        object.value = 1;
        return;
    }
    if (page > totalPages || page < 1) {
        util_showMainMessage("Entered value outside the page range.. Please enter a valid page.");
        object.value = currentPage;
        return;
    }
}

function createPaginationLinks(currentPage, totalPages) {
    var before_links = '';
    var after_links = '';
    if (window.location.href.indexOf("appt_calendar.html") > -1) {
        after_links = "<input type='button' value='Go' class='formButton' onclick='gotoPage();'/> ";
    } else {
        after_links = "<input type='button' value='Go' onclick='gotoPage();'/> ";
    }
    if (totalPages == 0 || totalPages == 1) {
        // Use the empty default strings...
    } else if (currentPage == 1) {
        after_links += "<img src='images/arrow_right.png' onclick='gotoNextPage();' style='vertical-align: middle;'/> " +
            " <img src='images/double_arrow_last.png' onclick='gotoLastPage();' style='vertical-align: middle;'/> ";
    } else if (currentPage != 1 && currentPage == totalPages) {
        before_links = "<img src='images/double_arrow_first.png' onclick='gotoFirstPage();' style='vertical-align: middle;'/> " +
            " <img src='images/arrow_left.png' onclick='gotoPreviousPage();' style='vertical-align: middle;'/> ";
    } else {
        before_links = "<img src='images/double_arrow_first.png' onclick='gotoFirstPage();' style='vertical-align: middle;'/> " +
            " <img src='images/arrow_left.png' onclick='gotoPreviousPage();' style='vertical-align: middle;'/>";
        after_links += "<img src='images/arrow_right.png' onclick='gotoNextPage();' style='vertical-align: middle;'/> " +
            " <img src='images/double_arrow_last.png' onclick='gotoLastPage();' style='vertical-align: middle;'/> ";
    }
    buildPagination(currentPage, before_links, after_links);
}

function createPageDropDownList() {
    var select_box = "Display Records: <select id='selectRecords' name='selectRecords' onchange='showSelected(this.value);'> " + " <option value='5'>5</option> " + " <option value='10'>10</option> " +
        " <option value='25'>25</option> " + " <option value='50'>50</option> " + " <option value='100'>100</option> " + " </select> ";
    $('.selectBox')
        .html(select_box);
    $('#selectBox')
        .html(select_box);
}

function showSelected(value) {
    max_results = value;
    currentPage = 1;
    apptInitialDisplay = initial_load;
    loadDataForRespectivePage();
}

function loadDataForRespectivePage() {
    if (/\/home.html#TemplateApprovalList$/.test(window.location.href)) {
        loadTemplatesToApproveData(currentPage);
    }
    if (/\/home.html#homeAppointmentList$/.test(window.location.href)) {
        loadBookedVisitsList(currentPage);
    }
    if ((/\/appt_calendar.html$/.test(window.location.href)) || (/\/appt_calendar.html#$/.test(window.location.href)) || (/\/appt_batch.html$/.test(window.location.href)) || (/\/home.html#$/.test(
            window.location.href)) || (/\/home.html#homeCalendar$/.test(window.location.href))) {
        loadBookedResourcesData(currentPage, eventid);
    }
    if ((/\/subject_screen.html$/.test(window.location.href)) || (/\/searchgrid_subject.html$/.test(window.location.href))) {
        loadSubjectData(currentPage);
    }
    if ((/\/studySubject_grid.html$/.test(window.location.href)) || (/\/study_subject.html$/.test(window.location.href))) {
        app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
        $('#addStudySubject')
            .css({
                display: "block"
            });
        $('#addStudySubjectData')
            .css({
                display: "block"
            });
        searchAppointmentWorkflow = false;
        loadAddStudySubjectData(currentPage);
    }
    if (/\/resource_screen.html$/.test(window.location.href)) {
        loadResourcesData(currentPage);
    }
    if (/\/resource_detail.html#DefaultAvailability$/.test(window.location.href)) {
        loadDefaultResourcesData(currentPage);
    }
    if (/\/resource_detail.html#ResourceAlternate$/.test(window.location.href)) {
        loadAlternateResourcesData(currentPage);
    }
    if (/\/resource_detail.html#TemporaryAdjustment$/.test(window.location.href)) {
        loadTemporaryAdjustmentsData(currentPage);
    }
    if (/\/alternate_resource.html$/.test(window.location.href)) {
        loadAddAlternateResourcesData(currentPage);
    }
    if (/\/sublocation_closure_screen.html#SublocationClosureInterval$/.test(window.location.href)) {
        loadSublocationClosureData(currentPage);
    }
    if (/\/study_screen.html$/.test(window.location.href)) {
        loadStudyScreenData(currentPage);
    }
    if (/\/study_detail.html#VisitTemplates$/.test(window.location.href)) {
        loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
    }
    if (/\/study_detail.html#StudySubjects$/.test(window.location.href)) {
        loadStudySubjectData(currentPage);
    }
    if (/\/study_detail.html#StudyMembers$/.test(window.location.href)) {
        loadStudyMemberData(currentPage);
    }
    if (/\/visit_detail.html$/.test(window.location.href)) {
        loadVisitApprovalTable(currentPage);
    }
    if (/\/appt_calendar.html#StudySearchAvailability$/.test(window.location.href)) {
        loadApptStudyData(currentPage);
    }
    if (/\/appt_calendar.html#VisitSearchAvailability$/.test(window.location.href)) {
        loadApptVisitData(currentPage);
    }
    if (/\/appt_calendar.html#SubjectSearchAvailability$/.test(window.location.href)) {
        loadApptSubjectData(currentPage);
    }
    if (/\/appt_calendar.html#ReviewTemplateResources$/.test(window.location.href)) {
        loadApptTemplateResourceData(currentPage);
    }
    if (window.location.href.indexOf("appt_list.html") > -1) {
        loadAppointmentBookedVisitsList(currentPage, apptInitialDisplay);
    }
    if (/\/mgmt_screen.html$/.test(window.location.href)) {
        loadUserData(currentPage);
    }
}

function resetUI() {
    max_results = undefined;
    sortBy = undefined;
    currentPage = 1;
    orderBy = 'ASC';
}

function sortingFunction(sort_by) {
    sortBy = sort_by;
    if (orderBy == "ASC") {
        orderBy = "DESC";
    } else {
        orderBy = "ASC";
    }
    currentPage = $('.input_page')
        .val();
    apptInitialDisplay = false;
    loadDataForRespectivePage();
}

function gotoFirstPage() {
    currentPage = $('.input_page')
        .val();
    if (currentPage == 1) {
        util_showMainMessage("You are already on the first page.");
        return;
    }
    currentPage = 1;
    apptInitialDisplay = false;
    loadDataForRespectivePage();
}

function gotoPreviousPage() {
    currentPage = $('.input_page')
        .val();
    if (currentPage == 1) {
        util_showMainMessage("You are already on the first page..There is no previous page.");
        return;
    }
    currentPage = parseInt(currentPage) - 1;
    apptInitialDisplay = false;
    loadDataForRespectivePage();
}

function gotoLastPage() {
    currentPage = $('.input_page')
        .val();
    if (currentPage == totalPages) {
        util_showMainMessage("You are already on the last page.");
        return;
    }
    currentPage = totalPages;
    apptInitialDisplay = false;
    loadDataForRespectivePage();
}

function gotoNextPage() {
    currentPage = $('.input_page')
        .val();
    if (currentPage == totalPages) {
        util_showMainMessage("You are already on the last page. There is no next page.");
        return;
    }
    if (currentPage > totalPages) {
        util_showMainMessage("Not a valid Page number!! Please enter a valid page number.");
        return;
    }
    currentPage = parseInt(currentPage) + 1;
    apptInitialDisplay = false;
    loadDataForRespectivePage();
}

function filterEnterKeySubmit(myfield, e) {
    var keycode;
    if (window.event) keycode = window.event.keyCode;
    else if (e) keycode = e.which;
    else return true;
    if (keycode == 13) {
        var studyFilterString = $.trim($('#appt_studyFilterText')
            .val());
        var visitFilterString = $.trim($('#appt_visitFilterText')
            .val());
        var subjectFilterString = $.trim($('#appt_subjectFilterText')
            .val());
        var calendarFilterString = $.trim($('#appointmentfilterString')
            .val());
        var calendarListFilterString = $.trim($('#apptlist_filters_string')
            .val());
        var finalString = $.trim($('#filters_string')
            .val());
        if (finalString == '') {
            if (studyFilterString != '') {
                finalString = studyFilterString;
                sessionStorage.setItem("filteredString", studyFilterString);
            } else if (visitFilterString != '') {
                finalString = visitFilterString;
                sessionStorage.setItem("filteredString", visitFilterString);
            } else if (subjectFilterString != '') {
                finalString = subjectFilterString;
                sessionStorage.setItem("filteredString", subjectFilterString);
            } else if (calendarListFilterString != '') {
                filterCalendarListViewClick();
                return false;
            } else if (calendarFilterString != '') {
                filterCalendarViewClick();
                return false;
            }
        }
        if (finalString == '') {
            util_showMainMessage("Please enter a filter value.");
            return false;
        } else {
            currentPage = 1;
            $('#appt_studyFilterButton')
                .attr("value", "Reset");
            $('#appt_visitFilterButton')
                .attr("value", "Reset");
            $('#appt_subjectFilterButton')
                .attr("value", "Reset");
            apptInitialDisplay = true;
            loadDataForRespectivePage();
            return false;
        }
    } else {
        return true;
    }
}

function paginationEnterKeySubmit(myfield, e) {
    var keycode;
    if (window.event) keycode = window.event.keyCode;
    else if (e) keycode = e.which;
    else return true;
    if (keycode == 13) {
        gotoPage(myfield.value);
        return false;
    } else return true;
}

function gotoPage(page) {
    if (page == undefined) {
        currentPage = enteredPage;
    } else {
        currentPage = page;
    }
    if (currentPage > totalPages) {
        util_showMainMessage("Not a valid Page number!! Please enter a valid page number.");
        return;
    }
    currentPage = parseInt(currentPage);
    apptInitialDisplay = false;
    loadDataForRespectivePage()
}

function buildPagination(currentPage, before_links, after_links) {
    if (currentPage == null || currentPage == "null") {
        currentPage = 1;
    }
    var pagination = "<div id='pagination'> " + before_links + " Page " +
        " <input type='text' class='input_page' onkeypress='return paginationEnterKeySubmit(this,event);' onchange='validatePageInput(this);' value='" + currentPage + "' style='width:25px;'/> " +
        " of " + totalPages + after_links + " </div>";
    $('.pagination_block')
        .html(pagination);
    $('#pagination_block')
        .html(pagination);
}

function getStudySelectedRowId(id) {
    var tdClass;
    if (appt_selectedStudy == null) {
        appt_selectedStudy = id;
        selectedStudy = id;
    } else if (appt_selectedStudy == id) {
        appt_selectedStudy = id;
        selectedStudy = id;
    } else if (appt_selectedStudy != id) {
        tdClass = ".selectClass" + appt_selectedStudy;
        $(tdClass)
            .css("background", "");
        $(tdClass)
            .css("color", "black");
        $(tdClass)
            .css("background-color", "");
        appt_selectedStudy = id;
        selectedStudy = id;
    }
    tdClass = ".selectClass" + appt_selectedStudy;
    $(tdClass)
        .css("background", "lightblue");
    $(tdClass)
        .css("color", "red");
    $(tdClass)
        .css("background-color", "lightblue");
}

function getVisitSelectedRowId(id, visitTypeId, visitDuration, relativeTime) {
    var tdClass;
    if (appt_selectedVisit == null) {
        appt_selectedVisit = id;
        selectedVisit = id;
    } else if (appt_selectedVisit == id) {
        appt_selectedVisit = id;
        selectedVisit = id;
    } else if (appt_selectedVisit != id) {
        tdClass = ".selectClass" + appt_selectedVisit;
        $(tdClass)
            .css("background", "");
        $(tdClass)
            .css("color", "black");
        $(tdClass)
            .css("background-color", "");
        appt_selectedVisit = id;
        selectedVisit = id;
    }
    tdClass = ".selectClass" + appt_selectedVisit;
    $(tdClass)
        .css("background", "lightblue");
    $(tdClass)
        .css("color", "red");
    $(tdClass)
        .css("background-color", "lightblue");
    appt_selectedVisitName = $(tdClass)
        .text();
    appt_selectedVisitType = visitTypeId;
    appt_selectedVisitDuration = visitDuration;
    appt_selectedVisitRelative = relativeTime;
    $('.dialog_study_visit')
        .text(appt_selectedVisitName);
}

function getSubjectSelectedRowId(id) {
    var tdClass;
    if (appt_selectedSubject == null) {
        appt_selectedSubject = id;
        selectedStudySubject = id;
    } else if (appt_selectedSubject == id) {
        appt_selectedSubject = id;
        selectedStudySubject = id;
    } else if (appt_selectedSubject != id) {
        tdClass = ".selectClass" + appt_selectedSubject;
        $(tdClass)
            .css("background", "");
        $(tdClass)
            .css("color", "black");
        $(tdClass)
            .css("background-color", "");
        appt_selectedSubject = id;
        selectedStudySubject = id;
    }
    tdClass = ".selectClass" + appt_selectedSubject;
    $(tdClass)
        .css("background", "lightblue");
    $(tdClass)
        .css("color", "red");
    $(tdClass)
        .css("background-color", "lightblue");
    appt_selectedSubjectName = $(tdClass + ':nth-child(2)')
            .text() + ' ' + $(tdClass + ':nth-child(1)')
            .text();
    $('.dialog_study_subject')
        .text(appt_selectedSubjectName);
}

function dialogCloseFunction() {
    window.location.hash = '';
    sessionStorage.setItem("is_navigated", false);
    sessionStorage.setItem("eventid", "");
}
Date.prototype.addDays = function(days) {
    var date = new Date(this.valueOf());
    date.setDate(date.getDate() + days);
    return date;
};
Date.prototype.subtractDays = function(days) {
    var date = new Date(this.valueOf());
    date.setDate(date.getDate() - days);
    return date;
};

function preventDefaultAction(event) {
    if (event.stopPropagation) {
        // for proper browsers ...
        event.stopPropagation();
    } else if (window.event) {
        // internet exploder uses cancelBubble ...
        window.event.cancelBubble = true;
    } else if (event.preventDefault) {
        event.preventDefault(event);
    }
}

function dateToDateHelperFormat(date) {
    var weekdays = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
    var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    var EEE = weekdays[date.getDay()];
    var MMM = months[date.getMonth()];
    var dd = twoPad(date.getDate()); // 1-31
    var yyyy = date.getFullYear();
    var HH = twoPad(date.getHours());
    var mm = twoPad(date.getMinutes());
    var ss = twoPad(date.getSeconds());
    return EEE + " " + MMM + " " + dd + " " + yyyy + " " + HH + ":" + mm + ":" + ss;
}

function twoPad(num) {
    return zeroPad(num, 2);
}

// from http://stackoverflow.com/questions/2998784/how-to-output-integers-with-leading-zeros-in-javascript
function zeroPad(num, size) {
    var s = num + "";
    while (s.length < size) s = "0" + s;
    return s;
}

function isNotStudyStaff() {
    return user.institutionRole.id != STUDY_STAFF;
}