/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
$(document).ready(function(){
    getResourceStaticLists();
});

function getResourceStaticLists() {
    $.get("rest/app/getStaticLists", {}, function(data) {	
	parsedData = $.parseJSON(data);
	sublocations = parsedData.sublocations;
	sublocationSelectOptions = buildSelectOptions(sublocations, 'name', 'choose');
	$("#sublocation_sublocation").html(sublocationSelectOptions);
    });
}

function commonResourceScreenData(){
    commonData();
    resourceModuleRoles();
    renderBreadcrumbs('resource_screen');
    resource_checkUnassignedResources();
    resetUI();
    initial_load = true;
    loadResourcesData(currentPage);
}

function commonCreateResourceData(){
    commonData();
    renderBreadcrumbs('resource_screen');
    resource_loadUnassignedResources();
    mode = JSON.parse(sessionStorage.getItem("mode"));
    setTimeout(function() { resource_setFormMode(mode); }, 500);
}

function getDefaultAvailability(){
    commonData();
    resourceModuleRoles();
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    renderBreadcrumbs('resource_detail_screen');
    parent.location.hash = "DefaultAvailability";
    resetUI();
    initial_load = true;
    var prevPage = sessionStorage.getItem("DASelectedPage");
    if (prevPage != currentPage) {
        currentPage = prevPage;
        sessionStorage.setItem("DASelectedPage", 1);
    }
    loadDefaultResourcesData(currentPage);    
    resource_showResourceDetail();
}

function getResourceAlternates() {
    commonData();
    resourceModuleRoles();
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    renderBreadcrumbs('resource_detail_screen');
    parent.location.hash = "ResourceAlternate";
    resetUI();
    initial_load = true;
    var prevPage = sessionStorage.getItem("RASelectedPage");
    if (prevPage != currentPage) {
        currentPage = prevPage;
        sessionStorage.setItem("RASelectedPage", 1);
    }
    loadAlternateResourcesData(currentPage);
    resource_showResourceDetail();
}

function getTemporaryAdjustments() {
    commonData();
    resourceModuleRoles();
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    renderBreadcrumbs('resource_detail_screen');
    parent.location.hash = "TemporaryAdjustment";
    resetUI();
    initial_load = true;
    var prevPage = sessionStorage.getItem("TASelectedPage");
    if (prevPage != currentPage) {
        currentPage = prevPage;
        sessionStorage.setItem("TASelectedPage", 1);
    }
    loadTemporaryAdjustmentsData(currentPage);
    resource_showResourceDetail();
}

function sublocationClosureScreenData() {
    commonData();
    renderBreadcrumbs('resource_close_sub_list');
    parent.location.hash = "SublocationClosureInterval";
    resetUI();
    initial_load = true;
    loadSublocationClosureData(currentPage);
}

function createSublocationClosureData() {
    commonData();
    renderBreadcrumbs('resource_close_sub_form');
    sublocationClosureInterval_createWidgets();
    sublocation_clearForm();
}

function defaultAvailabilityData() {
    commonData();
    mode = JSON.parse(sessionStorage.getItem("mode"));
    resource_da_setFormMode(mode);
}

function temporaryAdjustmentData() {
    commonData();
    mode = JSON.parse(sessionStorage.getItem("mode"));
    resource_ta_setFormMode(mode);
}

function alternateResourceData() {
    commonData();
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    renderBreadcrumbs('resource_alternative_form_screen');
    $('#saveAlternateResources').css({display: "none"});
    resetUI();
    initial_load = true;
    loadAddAlternateResourcesData(currentPage);
    resource_ra_ids = [];
}

function cancelAddAlternateResource() {
    resource_ra_ids = [];
    window.location.href = "resource_detail.html#ResourceAlternate";
}

function editResource(){
    sessionStorage.setItem("mode", JSON.stringify('edit'));
    window.location.href = "create_resource.html";
}

function addNewResourceClick() {
    if (NEW_RESOURCE_LINK_ENABLED == true) {
	sessionStorage.setItem("mode", JSON.stringify('new'));
	window.location.href = "create_resource.html";
    }
}

function addAlternateResourceClick() {
    var selectedRAPage = $('.input_page').val();
    sessionStorage.setItem("RASelectedPage", selectedRAPage);
    window.location.href = "alternate_resource.html";
}

function addDefaultAvailabilityClick() {
    sessionStorage.setItem("mode", JSON.stringify('new'));
    var selectedDAPage = $('.input_page').val();
    sessionStorage.setItem("DASelectedPage", selectedDAPage);
    window.location.href = "default_availability.html";
}

function addTemporaryAdjustmentClick() {
    sessionStorage.setItem("mode", JSON.stringify('new'));
    var selectedTAPage = $('.input_page').val();
    sessionStorage.setItem("TASelectedPage", selectedTAPage);
    window.location.href = "temporary_adjustment.html";
}

function resource_checkUnassignedResources() {
    $.getJSON("rest/resource/getUnassignedResources", function(data) {
	var check = data.resources;
	if(check[0] != undefined) {
	    $('#resource_newResourceLink').css({color: '#0A507D'});
	    NEW_RESOURCE_LINK_ENABLED = true;
	}
	else {
	    $('#resource_newResourceLink').css({color: '#AAAAAA'});
	    NEW_RESOURCE_LINK_ENABLED = false;
	}
    }); 
}

function addSublocationClosureClick() {
    window.location.href = "add_sublocation_closure.html";
}


function sublocationClosureClick() {
    window.location.href = "sublocation_closure_screen.html";
}