/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var changeSubjectId;
var orderBy;

function getSubjectStaticLists() {
    $.get("rest/app/getStaticLists", {}, function(data) {

        parsedData = $.parseJSON(data);

        states = parsedData.states;
        races = parsedData.races;
        ethnicities = parsedData.ethnicities;
        countries = parsedData.countries;
        genders = parsedData.genders;

        stateSelectOptions = buildSelectOptions(states, 'name', 'choose');
        raceSelectOptions = buildSelectOptions(races, 'name', 'choose');
        genderSelectOptions = buildSelectOptions(genders, 'name', 'choose');
        ethnicitySelectOptions = buildSelectOptions(ethnicities, 'name', 'choose');
        countrySelectOptions = buildSelectOptions(countries, 'name', 'choose');

        $("#subject_sex").html(genderSelectOptions);
        $("#subject_race").html(raceSelectOptions);
        $("#subject_ethnicity").html(ethnicitySelectOptions);
        $("#subject_state").html(stateSelectOptions);
        $("#subject_country").html(countrySelectOptions);
    });
}

var sortBySubjectMRN = "mrn";
var sortBySubjectLastName = "lastName";
var sortBySubjectFirstName = "firstName";
var sortBySubjectDOB = "birthdate";
var sortBySubjectCity = "city";
var sortBySubjectContact = "primaryContactNumber";

function loadSubjectData(currentPage){
    renderBreadcrumbs('subject_screen');
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    var filterString = $.trim($("#filters_string").val());
    var url;
    if (user.institutionRole.id == STUDY_STAFF){
        renderBreadcrumbs('subject_search_form');
        var name = JSON.parse(sessionStorage.getItem("subject_name"));
        var mrn = JSON.parse(sessionStorage.getItem("subject_mrn"));
        var birthdate = JSON.parse(sessionStorage.getItem("subject_birthdate"));
        var schedulerId = JSON.parse(sessionStorage.getItem("subject_schedulerId"));
        url = "rest/subject/getSearchSubjects?lastName="+(name != "" ? name : null)+"&mrn="+(mrn != "" ? mrn : null)+"&birthdate="+(birthdate != "" ? birthdate : null)+"&schedulerId="+(schedulerId != "" ? schedulerId : null)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySubjectLastName);
    } else {
        url = "rest/subject/getSubjects?page="+currentPage+"&maxResults="+(max_results != undefined ? max_results : 50)+"&filterString="+(filterString != undefined ? filterString : '')+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySubjectLastName);
    }
    $.getJSON(url, function(data) {
        var iteration = 0;
        totalData = data.totalCount;
        var sort_header;
        var mrn_header1 = 'sortable';
        var lastName_header2 = 'sortable';
        var firstName_header3 = 'sortable';
        var dob_header4 = 'sortable';
        var city_header5 = 'sortable';
        var contact_header6 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == sortBySubjectMRN){
            mrn_header1 = sort_header;
        } else if (sortBy == undefined || sortBy == sortBySubjectLastName){
            lastName_header2 = sort_header;
        } else if (sortBy == sortBySubjectFirstName){
            firstName_header3 = sort_header;
        } else if (sortBy == sortBySubjectDOB){
            dob_header4 = sort_header;
        } else if (sortBy == sortBySubjectCity){
            city_header5 = sort_header;
        } else if (sortBy == sortBySubjectContact){
            contact_header6 = sort_header;
        }

        var out =   " <table id='subjects'>"
            +  "  <tr>" +
            "   <td class= "+ lastName_header2 + " onclick='sortingFunction(sortBySubjectLastName)'><strong>Last Name</strong></td>" +
            "   <td class= "+ firstName_header3 + " onclick='sortingFunction(sortBySubjectFirstName)'><strong>First Name</strong></td> " +
            "   <td class= "+ mrn_header1 + " onclick='sortingFunction(sortBySubjectMRN)'><strong>MRN</strong></td>" +
            "   <td class= "+ dob_header4 + " onclick='sortingFunction(sortBySubjectDOB)'><strong>DOB</strong></td>" +
            "   <td class= "+ city_header5 + " onclick='sortingFunction(sortBySubjectCity)'><strong>City</strong></td>" +
            "   <td class= "+ contact_header6 + " onclick='sortingFunction(sortBySubjectContact)'><strong>Primary Contact #</strong></td>" +
            "   <td class='not_sortable'><strong>Status</strong></td>" +
            "   <td class='not_sortable'></td>" +
            "   <td class='not_sortable'></td>" +
            "  </tr>  ";

        $.each(data.subjectList, function(key, val) {
            out += "<tr>";
            out += "   <td>" + val.lastName + "</td>" +
                "          <td>" + val.firstName + "</td>" +
                "          <td>" + val.mrn + "</td>" +
                "          <td>" + showDate(val.dob) + "</td>" +
                "          <td>" + val.city + "</td>" +
                "          <td>" + val.primaryContact + "</td>" +
                "          <td>" + " <a href='javascript:subjectChangeStatusConfirmation("+val.id+")'>"+statusValue(val.status)+"</a>" + "</td>" +
                "	       <td>" + " <a href='javascript:showSubjectData("+val.id+")'>View Detail</a>"  + "</td>" +
                "	       <td>" + " <a href='javascript:addToStudy("+val.id+")'>Add to Study</a> " + "</td>" +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#subject_data').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");
        if (data.subjectList.length == 0) {
            totalData = 0;
            if (user.institutionRole.id == STUDY_STAFF){
                alert("Subject not found. Please check the name,mrn,date of birth, or scheduler ID and try again.");
                window.location.href = "search_subject.html";
            }
            util_showMainMessage("Subject not found. Please check the name,mrn,date of birth, or scheduler ID and try again.");
        }

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results)
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function commonSubjectDetailData(){
    commonData();
    var mode = JSON.parse(sessionStorage.getItem("mode"));
    var previousMode = JSON.parse(sessionStorage.getItem("previousMode"));
    if (previousMode == 'edit'){
        renderBreadcrumbs('subject_view_form');
        subject_setFormMode('view');
    }
    else if (mode == 'search_view'){
        renderBreadcrumbs('studyStaff_subject_view_form');
        subject_setFormMode('view');
    }
    else if (mode == 'view'){
        renderBreadcrumbs('subject_view_form');
        subject_setFormMode(mode);
    }
    else {
        subject_setFormMode(mode);
    }
}

function showSubjectData(id) {
    $.getJSON("rest/subject/getSubjectData?id="+id, function(data) {
        sessionStorage.setItem("subjectData", JSON.stringify(data));
        sessionStorage.setItem("mode", JSON.stringify('view'));
        window.location.href="subject_detail.html";
    });
}

function addToStudy(id) {
    changeSubjectId = id;
    getStudyLists();
    $('#subject_studyNameValidation').text('');
    $('.formSelectInput').css({display: "inline"});
    $("#addToStudyDialog").dialog({modal: true, height:460, width:700});
}

function addSubjectToStudyClick() {
    if($("#wizard_studyOptions").val().length < 1) {
        $('#subject_studyNameValidation').text('Please select a study name.');
        $('#subject_studyNameValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        return;
    }
    var studyId =  $('#wizard_studyOptions').val();
    jsonData = JSON.stringify({studyId: studyId, subject: changeSubjectId});
    $.post("rest/study/addStudytoSubject",{data:jsonData}, function(data) {
        var parsedData = $.parseJSON(data);
        if (parsedData.result == true) {
            alert("Subject added to the Study.");
        }
        else {
            alert(parsedData.errorMsg);
        }
        $('#subject_studyNameValidation').text('');
        $("#addToStudyDialog").dialog("close");
    });
}

function filterSubjectDataClick() {
    if ($.trim($("#filters_string").val()).length < 1) {
        util_showMainMessage("Please enter the filter value.");
        return;
    }
    resetUI();
    initial_load = true;
    loadSubjectData(currentPage);
}

function resetSubjectDataClick() {
    $("#filters_string").val('');
    resetUI();
    initial_load = true;
    loadSubjectData(currentPage);
}

function cancelSubjectToStudyClick() {
    $("#addToStudyDialog").dialog("close");
}

function subject_setFormMode(mode) {
    getBrowserVersion();
    s_mode = mode;

    user = JSON.parse(sessionStorage.getItem("userData"));
    if (mode == 'view') {
        app_selectedSubject = JSON.parse(sessionStorage.getItem("subjectData"));
        $('#subject_form_title').text('Additional Details');
        $('#subject_full_name').text(util_buildFullName(app_selectedSubject.firstName, app_selectedSubject.middleName, app_selectedSubject.lastName));
        $('.requiredFieldKey').css({visibility: "hidden"});
        $('#subject_form_buttons').css({visibility: "hidden"});
        $('.requiredIcon').css({visibility: "hidden"});
        $('.formTextReadOnly').css({display: "inline"});
        $('.formTextAreaSmaller').css({display: "none"});
        $('.formLabel2').css({display: "none"});
        $('.formTextInput').css({display: "none"});
        $('.formSelectInput').css({display: "none"});
        $('.subject_confirmFormItem').css({visibility: "hidden"});
        $('#subject_firstNameReadOnly').text(app_selectedSubject.firstName);
        $('#subject_middleNameReadOnly').text(app_selectedSubject.middleName);
        $('#subject_lastNameReadOnly').text(app_selectedSubject.lastName);
        $('#subject_sexReadOnly').text(app_selectedSubject.genderName);
        $('#subject_mrnReadOnly').text(app_selectedSubject.mrn);
        $('#subject_commentReadOnly').text(app_selectedSubject.comment);
        $('#subject_raceReadOnly').text(app_selectedSubject.raceName);
        $('#subject_ethnicityReadOnly').text(app_selectedSubject.ethnicityName);
        $('#subject_streetAddress1ReadOnly').text(app_selectedSubject.streetAddress1);
        $('#subject_streetAddress2ReadOnly').text(app_selectedSubject.streetAddress2);
        $('#subject_cityReadOnly').text(app_selectedSubject.city);
        $('#subject_stateReadOnly').text(app_selectedSubject.stateName);
        $('#subject_zipReadOnly').text(app_selectedSubject.zip);
        $('#subject_countryReadOnly').text(app_selectedSubject.countryName);
        $('#subject_primaryContactNumberReadOnly').text(app_selectedSubject.primaryContactNumber);
        var regexObj = /^\(?([0-9]{3})\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;
        $("#subject_primaryContactNumberReadOnly").text(app_selectedSubject.primaryContactNumber.replace(regexObj, "($1)$2-$3"));
        $('#subject_secondaryContactNumberReadOnly').text(app_selectedSubject.secondaryContactNumber);
        $('#subject_subjectSchedulerIdReadOnly').text(app_selectedSubject.subjectSchedulerId);
        var subject_birthdateVal = app_selectedSubject.birthdate;
        if (subject_birthdateVal != null) {
            if (majorVersion == "8"){
                var removeDash = subject_birthdateVal.replace(/-/g, '/');
                var removeTime = removeDash.replace(/T.*/,'');
                var newDate =  new Date(removeTime);
                var format_birthdate =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();

                $('#subject_birthdateReadOnly').text(format_birthdate);
            }
            else {
                $('#subject_birthdateReadOnly').text(dateFormat(subject_birthdateVal, 'mm/dd/yyyy'));
            }
        }
    }
    else if (mode == 'new') {
        renderBreadcrumbs('subject_new_form');
        $('.formLabel2').css({display: "inline-block"});
        $('#subject_full_name').text('');
        $('#subject_form_title').text('Create New Subject');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.subject_confirmFormItem').css({visibility: "visible"});
        $('.formTextAreaSmaller').css({display: "inline-block"});
        $('#subject_restoreButton').css({display: "none"});
        $('.formTextReadOnly').css({display: "none"});
        $('.formTextInput').css({display: "inline"});
        $('.formSelectInput').css({display: "inline"});
        $('#subject_editSubjectLink').css({visibility: "hidden"});
        $('#subject_form_buttons').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        getStudyLists();
        subject_clearForm();
        createSubjectDatePicker();
    }
    else if (mode == 'edit') {
        app_selectedSubject = JSON.parse(sessionStorage.getItem("subjectData"));
        if (user.institutionRole.id == STUDY_STAFF){
            renderBreadcrumbs('subject_studyStaff_edit_form');
        }
        else {
            renderBreadcrumbs('subject_edit_form');
        }
        $('.formLabel2').css({display: "inline-block"});
        $('#subject_form_title').text('Edit Subject');
        $('#subject_full_name').text(util_buildFullName(app_selectedSubject.firstName, app_selectedSubject.middleName, app_selectedSubject.lastName));
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.subject_confirmFormItem').css({visibility: "visible"});
        $('#subject_editSubjectLink').css({visibility: "hidden"});
        $('#subject_form_buttons').css({visibility: "visible"});
        $('.formTextAreaSmaller').css({display: "inline-block"});
        $('.formTextReadOnly').css({display: "none"});
        $('.formTextInput').css({display: "inline"});
        $('.formSelectInput').css({display: "inline"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#subject_restoreButton').css({display: "inline"});
        getStudyLists();
        subject_loadEditForm();
    }
}

function subject_loadEditForm() {
    sessionStorage.setItem("previousMode", JSON.stringify('edit'));
    $('#subject_firstName').val(app_selectedSubject.firstName);
    $('#subject_middleName').val(app_selectedSubject.middleName);
    $('#subject_lastName').val(app_selectedSubject.lastName);
    $('#subject_sex').val(app_selectedSubject.genderId);
    $('#subject_mrn').val(app_selectedSubject.mrn);
    $('#subject_race').val(app_selectedSubject.raceId);
    $('#subject_ethnicity').val(app_selectedSubject.ethnicityId);
    $('#subject_streetAddress1').val(app_selectedSubject.streetAddress1);
    $('#subject_streetAddress2').val(app_selectedSubject.streetAddress2);
    $('#subject_city').val(app_selectedSubject.city);
    $('#subject_state').val(app_selectedSubject.stateId);
    $('#subject_zip').val(app_selectedSubject.zip);
    $('#subject_comment').val(app_selectedSubject.comment);
    $('#subject_country').val(app_selectedSubject.countryId);
    $('#subject_primaryContactNumber').val(app_selectedSubject.primaryContactNumber);
    $('#subject_secondaryContactNumber').val(app_selectedSubject.secondaryContactNumber);
    $("#subject_study").val('');

    var subject_birthdateVal = app_selectedSubject.birthdate;
    $("#subject_birthdate").datepicker('setDate', subject_birthdateVal);
    createSubjectDatePicker();
}

function createSubjectDatePicker() {
    $("#subject_birthdate").datepicker({
        maxDate: "+0M +0D",
        numberOfMonths: 3,
        showButtonPanel: true,
        buttonImage: "images/calendar.gif",
        showOn: "button",
        buttonImageOnly: true
    });
}

function subject_clearForm() {
    $('#subject_full_name').val('');
    $('#subject_id').val('');
    $('#subject_firstName').val('');
    $('#subject_middleName').val('');
    $('#subject_lastName').val('');
    $('#subject_sex').val('');
    $('#subject_birthdate').val('');
    $('#subject_mrn').val('');
    $('#subject_race').val('');
    $('#subject_ethnicity').val('');
    $('#subject_streetAddress1').val('');
    $('#subject_streetAddress2').val('');
    $('#subject_city').val('');
    $('#subject_state').val('');
    $('#subject_zip').val('');
    $('#subject_comment').val('');
    $('#subject_country').val('');
    $('#subject_primaryContactNumber').val('');
    $('#subject_secondaryContactNumber').val('');
    $("#subject_study").val('');
}

function commonCreateSubjectData(){
    commonData();
    demographic_check = JSON.parse(sessionStorage.getItem("demographic_check"));
    if (demographic_check == true){
        document.getElementById("subject_submitButton").style.display="none";
        document.getElementById("subject_submitDemographicButton").style.display="inline";
    }
    else {
        document.getElementById("subject_submitButton").style.display="inline";
        document.getElementById("subject_submitDemographicButton").style.display="none";
    }
    $("#subject_primaryContactNumber").mask("999-999-9999");
    $("#subject_secondaryContactNumber").mask("999-999-9999");
    var mode = JSON.parse(sessionStorage.getItem("mode"));
    subject_setFormMode(mode);
    if (mode == 'edit'){
        demographic_check = false;
        sessionStorage.setItem("demographic_check", "false");
        setTimeout(function() { subject_loadEditForm(); }, 500);
    }
}

function checkinAppointmentClick() {
    changeDemographicDataDialog();
}

function changeDemographicDataDialog() {
    var comment = $.trim($("#wizard_comment").val());
    $("#demographicSubject-data-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                demographic_check = true;
                sessionStorage.setItem("eventid", JSON.stringify(eventid));
                sessionStorage.setItem("comment", JSON.stringify(comment));
                sessionStorage.setItem("demographic_check", "true");
                subjectEditData();
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                checkinDialog();
            }
        }
    });
}

function checkinDialog() {
    var comment = $.trim($("#wizard_comment").val());
    $("#checkin-visit-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                sessionStorage.setItem("eventid", JSON.stringify(eventid));
                sessionStorage.setItem("comment", JSON.stringify(comment));
                checkinAppointment();
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function subjectEditData(){
    sessionStorage.setItem("mode", JSON.stringify('edit'));
    window.location.href = "create_subject.html";
}

function addSubjectClick() {
    sessionStorage.setItem("mode", JSON.stringify('new'));
    window.location.href = "create_subject.html";
}

function restoreSubjectClick() {
    subject_clearErrors();
    subject_loadEditForm();
}

function cancelSubjectClick() {
    $.blockUI();
    redirectAfterCreateSubject();
}

function redirectAfterCreateSubject() {
    subject_clearErrors();
    var isVisible = $('#subject_submitDemographicButton').is(':visible');
    if (s_mode == 'new') {
        if (user.institutionRole.id == STUDY_STAFF) {
            window.location.href = "search_subject.html";
        }
        else {
            window.location.href = "subject_screen.html";
        }
    }
    else if (isVisible == true) {
        eventid = sessionStorage.getItem("eventid");
        navigateOverrideAction();
    }
    else {
        sessionStorage.setItem("mode", JSON.stringify('view'));
        window.location.href = "subject_detail.html";
    }
}

function crudSubjectClick() {
    processNewSubjectForm();
}

function crudDemographicSubjectClick() {
    processSubjectDemoDataForm();
}

function studyStaffSearchSubjectClick() {
    processSearchSubjectForm();
}

function processSearchSubjectForm() {
    var mrn = $.trim($("#subject_search_mrn").val());
    var name = $.trim($("#subject_search_lastName").val());
    var birthdate = $.trim($("#subject_search_birthdate").val());
    var subjectSchedulerId = $.trim($("#subject_search_schedulerId").val());
    if (($.trim($("#subject_search_lastName").val()).length < 1) && ($.trim($("#subject_search_mrn").val()).length < 1) && ($.trim($("#subject_search_birthdate").val()).length < 1)
        && ($.trim($("#subject_search_schedulerId").val()).length < 1)) {
        util_showMainMessage("Please enter at least 2 fields");
        $('#subject_responseLoading').css({visibility: "hidden"});
        return;
    }
    else if (($.trim($("#subject_search_lastName").val()).length < 1) && ($.trim($("#subject_search_birthdate").val()).length < 1) && ($.trim($("#subject_search_schedulerId").val()).length < 1)) {
        util_showMainMessage("Please enter at least 2 fields");
        $('#subject_responseLoading').css({visibility: "hidden"});
        return;
    }
    else if(($.trim($("#subject_search_lastName").val()).length < 1) && ($.trim($("#subject_search_mrn").val()).length < 1) && ($.trim($("#subject_search_schedulerId").val()).length < 1)) {
        util_showMainMessage("Please enter at least 2 fields");
        $('#subject_responseLoading').css({visibility: "hidden"});
        return;
    }
    else if(($.trim($("#subject_search_birthdate").val()).length < 1) && ($.trim($("#subject_search_mrn").val()).length < 1) && ($.trim($("#subject_search_schedulerId").val()).length < 1)) {
        util_showMainMessage("Please enter at least 2 fields");
        $('#subject_responseLoading').css({visibility: "hidden"});
        return;
    }
    else if (($.trim($("#subject_search_lastName").val()).length < 1) && ($.trim($("#subject_search_birthdate").val()).length < 1) && ($.trim($("#subject_search_mrn").val()).length < 1)) {
        util_showMainMessage("Please enter at least 2 fields");
        $('#subject_responseLoading').css({visibility: "hidden"});
        return;
    }

    $('#subject_responseLoading').css({visibility: "hidden"});
    sessionStorage.setItem("subject_mrn", JSON.stringify(mrn));
    sessionStorage.setItem("subject_name", JSON.stringify(name));
    sessionStorage.setItem("subject_birthdate", JSON.stringify(birthdate));
    sessionStorage.setItem("subject_schedulerId", JSON.stringify(subjectSchedulerId));
    window.location.href="searchgrid_subject.html";
}

function getStudyLists() {
    $.getJSON("rest/study/getNonClosedStudiesList", function(data) {
        studySelectOptions = buildStudySelectsOptions(data.studys, 'id', 'choose');
        $("#subject_study").html(studySelectOptions);
        $("#wizard_studyOptions").html(studySelectOptions);
    });
}

function buildStudySelectsOptions(list, optionTextProperty, choiceLabel) {
    var html = [];
    html[html.length] = "<option value=''>" + choiceLabel + "</option>";
    for (var i = 0, len = list.length; i < len; i++) {
        html[html.length] = "<option value='";
        html[html.length] = list[i].id;
        html[html.length] = "'>";
        html[html.length] = list[i].localId + ' - '+ list[i].name.substring(0,50);
        html[html.length] = "</option>";
    }
    return html.join('');
}

function changeSubjectStatusDialog(id) {
    $("#subject-status-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                changeSubjectId = id;
                jsonData = JSON.stringify({id: changeSubjectId, userId: user.id});
                $.post("rest/subject/changeSubjectStatus",{data:jsonData}, function(data) {
                    var parsedData = $.parseJSON(data);
                    resetUI();
                    initial_load = true;
                    loadSubjectData(currentPage);
                    util_showMainMessage("Subject Status changed");
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
            }
        }
    });
}

function subjectChangeStatusConfirmation(id) {
    changeSubjectStatusDialog(id);
}

function subject_clearErrors() {
    $('#subject_firstNameValidation').css({visibility: "hidden"});
    $('#subject_lastNameValidation').css({visibility: "hidden"});
    $('#subject_primaryPhoneValidation').css({visibility: "hidden"});
    $('#subject_sexValidation').css({visibility: "hidden"});
    $('#subject_birthdateValidation').css({visibility: "hidden"});
    $('#subject_raceValidation').css({visibility: "hidden"});
    $('#subject_ethnicityValidation').css({visibility: "hidden"});
    $('#subject_streetAddress1Validation').css({visibility: "hidden"});
    $('#subject_streetAddress2Validation').css({visibility: "hidden"});
    $('#subject_cityValidation').css({visibility: "hidden"});
    $('#subject_zipValidation').css({visibility: "hidden"});
    $('#subject_countryValidation').css({visibility: "hidden"});
    $('#subject_generalValidation').css({visibility: "hidden"});
    $('#subject_mrnValidation').css({visibility: "hidden"});
}

function processNewSubjectForm() {
    var isValid = true;
    subject_clearErrors();

    if($.trim($("#subject_firstName").val()).length < 1) {
        showError('#subject_firstNameValidation');
        isValid = false;
    }
    if($.trim($("#subject_lastName").val()).length < 1) {
        showError('#subject_lastNameValidation');
        isValid = false;
    }

    if($.trim($("#subject_sex").val()).length < 1) {
        showError('#subject_sexValidation');
        isValid = false;
    }
    if($.trim($("#subject_race").val()).length < 1) {
        showError('#subject_raceValidation');
        isValid = false;
    }

    if ($.trim($("#subject_primaryContactNumber").val()).length < 1) {
        showError('#subject_primaryPhoneValidation');
        isValid = false;
    }

    if($.trim($("#subject_ethnicity").val()).length < 1) {
        showError('#subject_ethnicityValidation');
        isValid = false;
    }

    if($.trim($("#subject_streetAddress1").val()).length < 1) {
        showError('#subject_streetAddress1Validation');
        isValid = false;
    }
    if($.trim($("#subject_streetAddress2").val()).length < 1) {
        showError('#subject_streetAddress2Validation');
    }

    if($.trim($("#subject_city").val()).length < 1) {
        showError('#subject_cityValidation');
        isValid = false;
    }
    if($("#subject_country").val().length < 1) {
        showError('#subject_countryValidation');
        isValid = false;
    }
    if(($.trim($("#subject_zip").val()).length < 5) || ($.trim($("#subject_zip").val()).length > 5)) {
        showError('#subject_zipValidation');
        isValid = false;
    }

    var candidateMrn = $.trim($("#subject_mrn").val());
    var mrnRegexObj = /^[0-9]+$/;
    if (candidateMrn.length < 1) {
        showError('#subject_mrnValidation');
        isValid = false;
    }
    else if ( ! mrnRegexObj.test(candidateMrn) ) {
        showError('#subject_mrnValidation', "MRN can only contain digits. Please remove all other characters and special characters before saving");
        isValid = false;
    }


    var regexObj = /^\(?([0-9]{3})\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;

    if (regexObj.test($.trim($("#subject_primaryContactNumber").val()))) {
        $("#subject_primaryContactNumber").val($.trim($("#subject_primaryContactNumber").val()).replace(regexObj, "($1) $2-$3"));
    }
    else {
        $('#subject_generalValidation').text('Primary Phone not a valid phone number format');
        $('#subject_generalValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if($.trim($("#subject_secondaryContactNumber").val()).length > 0) {
        if (regexObj.test($.trim($("#subject_secondaryContactNumber").val()))) {
            $("#subject_secondaryContactNumber").val($.trim($("#subject_secondaryContactNumber").val()).replace(regexObj, "($1) $2-$3"));
        }
        else {
            $('#subject_generalValidation').text('secondary phone not a valid phone number format');
            $('#subject_generalValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
            isValid = false;
        }
    }

    var DOB = null;
    var subject_birthdateVal = $("#subject_birthdate").val();

    if (subject_birthdateVal == '') {
        $('#subject_birthdateValidation').css({display:'inline'});
        $('#subject_birthdateValidation').text('Please enter valid birth date');
        $('#subject_birthdateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }
    else {
        DOB = $("#subject_birthdate").datepicker('getDate');
        DOB.setHours(0,0,0,0);

        var today = new Date();
        today.setHours(0,0,0,0);
        if (DOB != null) {
            if (DOB >= today) {
                $('#subject_birthdateValidation').css({display:'inline'});
                $('#subject_birthdateValidation').text('Please enter valid birth date');
                $('#subject_birthdateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
                isValid = false;
            }
        }
    }

    var studyId = $('#subject_study').val();
    var stateId = $('#subject_state').val();

    if (isValid == false) {
        return;
    }
    DOB.setHours(10);
    DOB.setMinutes(0);
    $('#subject_responseLoading').css({visibility: "visible"});

    jsonData = JSON.stringify({
        id: (app_selectedSubject != null ? app_selectedSubject.id : 0),
        firstName: $.trim($("#subject_firstName").val()),
        middleName: $.trim($("#subject_middleName").val()),
        lastName: $.trim($("#subject_lastName").val()),
        mrn: $.trim($("#subject_mrn").val()),
        gender: $.trim($("#subject_sex").val()),
        primaryContactNumber: $.trim($("#subject_primaryContactNumber").val()),
        secondaryContactNumber: $.trim($("#subject_secondaryContactNumber").val()),
        birthday: DOB.toString(),
        race: $('#subject_race').val(),
        ethnicity: $('#subject_ethnicity').val(),
        streetAddress1: $.trim($("#subject_streetAddress1").val()),
        streetAddress2: $.trim($("#subject_streetAddress2").val()),
        city: $('#subject_city').val(),
        state: (stateId != '' ? stateId : 0),
        country: $('#subject_country').val(),
        zip: $.trim($("#subject_zip").val()),
        comment : $.trim($("#subject_comment").val()),
        studyId : (studyId != '' ? studyId : 0),
        active: true,
        user: user
    });

    var url = "rest/subject/createSubject";
    if (s_mode == 'edit') {
        url = "rest/subject/updateSubject";
    }

    $.post(url, {data:jsonData}, function(data) {
        var parsedData = $.parseJSON(data);
        if (parsedData.result == false){
            util_showMainMessage(parsedData.errorMsg);
            $('#subject_responseLoading').css({visibility: "hidden"});
            return;
        }
        else {
            if (demoData == true) {
                checkinAppointment();
                return;
            }
            else {
                if (s_mode == 'new'){
                    alert("New subject had been created and please note, the Subject ID for this patient is: " + parsedData.subjectSchedulerId);
                }
                if (s_mode == 'edit') {
                    alert("Subject updated.");
                }
                $('#subject_responseLoading').css({visibility: "hidden"});
                subject_clearErrors();
                subjectModule();
            }
        }
    });
}

function showError(item, message) {
    $(item).css({display:'inline'});
    if (message == null) {
        message = 'Required Field';
    }
    $(item).text(message);
    $(item).css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
}

function commonSubjectGridData(){
    commonData();
    resetUI();
    loadSubjectData(currentPage);
}
var demoData = false;
function processSubjectDemoDataForm(){
    var isValid = true;
    subject_clearErrors();
    s_mode = 'edit';
    demoData = true;
    processNewSubjectForm();
}

function checkinAppointment() {
    var checkInComment = JSON.parse(sessionStorage.getItem("comment"));
    eventid = JSON.parse(sessionStorage.getItem("eventid"));
    home_check = JSON.parse(sessionStorage.getItem("home_cal"));
    $("#appt_wizard_scheduled_visit_details").dialog("close");
    $.blockUI();
    jsonData = JSON.stringify({id: eventid, comment: checkInComment});
    $.post("rest/appointment/checkinVisit",{data:jsonData}, function(data) {
        $.unblockUI();
        checkInComment = null;
        searching_appointments = false;
        util_showMainMessage("The visit has been Checked-In.");
        sessionStorage.setItem("is_navigated", false);
        sessionStorage.setItem("eventid", "");
        alert("The visit has been Checked-In.");
        if (home == true || home_check == true){
            homeModule();
        }
        else {
            appointmentModule();
            if (start != null){
                $('#appt_calendar').fullCalendar('gotoDate', start);
            }
            else {
                $('#appt_calendar').fullCalendar('gotoDate', new Date());
            }
        }
    });
}
