/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
function reportData() {
    commonData();
    renderBreadcrumbs('report_screen');
    report_renderReportGrid();
}

var reportName;
var selectedid;
var search_string;
var report_visitsFlaggedResult;
var report_protoNurseResult;
var report_protoNutritionistResult;
var report_staffAuditSubjectViewsResult;
var report_subjectAuditStaffViewsResult;
var report_overrideResult;
var report_subjectPurgeResult;
var report_userDataResult;
var report_offUnitResult;
var report_dailyOverviewResult;
var report_weeklyPharmResult;

var report_cancellationsResult;
var report_studyDataResult;

var report_studyVisitLocationResult;
var report_billableResourcesResult;
var report_transactionsResult;
var report_dailyResourceResult;
var report_dailyAdmResult;
var report_metaKitchenResult;
var report_metaKitchenByTimeResult;
var report_deptAndPiResult;
var report_billingResult;
var report_billingByInvestigatorResult;
var report_censusResult;
var report_levelOfServiceResult;
var report_studySubjectVisitResult;
var report_studyStatusChangeResult;
var report_subjectVisitHistoryResult;
var report_ancillaryOnlyByProtocolResult;
var report_crcAvailabilityResult;
var report_resourceLevelOfServiceResult;
var report_visitTemplateResult;
var report_nutritionTasksResult;
var report_visitDurationByVisitTypeResult;
var report_visitTerminatedPriorToCompletionResult;
var report_bookedVisitServiceLevelByTypeResult;
var report_roomAvailabilityCheckResult;
var exportStr = '';
var exportBIStr = '';
var exportCustomStr = '';

function renderReportData() {
    commonData();
    if (user.institutionRole.id == STUDY_STAFF){
        window.location.href = "access_denied.html";
    }
    report_selectedReport = JSON.parse(sessionStorage.getItem("reportData"));
    renderReportBreadcrumbs(report_selectedReport.title);
    $('#report_reportTitle').html(report_selectedReport.title);
    $('#report_result_screen').css({display: "none"});

    $('.report_startDate').css({height:"0px"});
    $('.report_startDate').css({visibility:"hidden"});
    $('.report_endDate').css({height:"0px"});
    $('.report_endDate').css({visibility:"hidden"});

    $('.report_piForm').css({height:"0px"});
    $('.report_piForm').css({visibility:"hidden"});
    $('.report_subjectForm').css({height:"0px"});
    $('.report_subjectForm').css({visibility:"hidden"});
    $('.report_mrnForm').css({height:"0px"});
    $('.report_mrnForm').css({visibility:"hidden"});

    $('#report_downloadButton').css({display: "none"});
    $('#report_customdownloadButton').css({display: "none"});
    $('#report_flatloadButton').css({display: "none"});
    $('#filter_functionality').css({display: "none"});
    $('#sort_functionality').css({display: "none"});
    report_clearForm();
    report_createWidgets();
    var today = new Date();
    var tomorrow = today.addDays(1);
    if(report_selectedReport.name == 'daily_overview' ||
        report_selectedReport.name == 'daily_adm' ||
        report_selectedReport.name == 'daily_resource') {
        var yesterday = today.subtractDays(1);
        $("#report_startDate").datepicker("setDate", yesterday);
    }
    else {
        var oneMonthAgo = new Date();
        oneMonthAgo.setMonth(today.getMonth() - 1);
        $("#report_startDate").datepicker("setDate", oneMonthAgo);
    }

    $("#report_endDate").datepicker("setDate", tomorrow);

    if (report_selectedReport.name == 'proto_by_nurse' ||
        report_selectedReport.name == 'proto_by_nutritionist' ||
        report_selectedReport.name == 'subject_purge' ||
        report_selectedReport.name == 'study_data' ||
        report_selectedReport.name == 'user_session' ||
        report_selectedReport.name == 'user_data' ||
        report_selectedReport.name == 'resource_level_of_service' ||
        report_selectedReport.name == 'visit_template_data') {

        $('.report_mrnForm').css({height:"0px"});
        $('.report_mrnForm').css({visibility:"hidden"});
        $('.report_subjectForm').css({height:"50px"});
        $('.report_subjectForm').css({visibility:"hidden"});
        $('.report_piForm').css({height:"50px"});
        $('.report_piForm').css({visibility:"hidden"});

        $('.report_startDate').css({height:"50px"});
        $('.report_startDate').css({visibility:"hidden"});
        $('.report_endDate').css({height:"50px"});
        $('.report_endDate').css({visibility:"hidden"});
    }
    else if (report_selectedReport.name == 'billing_by_investigator') {

        $('.report_piForm').css({height:"50px"});
        $('.report_piForm').css({visibility:"visible"});
        $('.report_mrnForm').css({height:"0px"});
        $('.report_mrnForm').css({visibility:"hidden"});
        $('.report_subjectForm').css({height:"50px"});
        $('.report_subjectForm').css({visibility:"hidden"});

        $('.report_startDate').css({height:"50px"});
        $('.report_startDate').css({visibility:"visible"});
        $('.report_endDate').css({height:"50px"});
        $('.report_endDate').css({visibility:"visible"});
    }
    else if (report_selectedReport.name == 'subject_audit_staff_views') {
        $('.report_mrnForm').css({height:"50px"});
        $('.report_mrnForm').css({visibility:"visible"});
        $('.report_subjectForm').css({height:"50px"});
        $('.report_subjectForm').css({visibility:"hidden"});
        $('.report_piForm').css({height:"50px"});
        $('.report_piForm').css({visibility:"hidden"});

        $('.report_startDate').css({height:"50px"});
        $('.report_startDate').css({visibility:"visible"});
        $('.report_endDate').css({height:"50px"});
        $('.report_endDate').css({visibility:"visible"});
    }
    else if (report_selectedReport.name == 'subject_visit_history' || report_selectedReport.name == 'study_subject_visit') {

        $('.report_piForm').css({height:"0px"});
        $('.report_piForm').css({visibility:"hidden"});
        $('.report_mrnForm').css({height:"0px"});
        $('.report_mrnForm').css({visibility:"hidden"});
        $('.report_subjectForm').css({height:"50px"});
        $('.report_subjectForm').css({visibility:"visible"});

        $('.report_startDate').css({height:"50px"});
        $('.report_startDate').css({visibility:"hidden"});
        $('.report_endDate').css({height:"50px"});
        $('.report_endDate').css({visibility:"hidden"});
    }
    else {
        $('.report_piForm').css({height:"50px"});
        $('.report_piForm').css({visibility:"hidden"});
        $('.report_mrnForm').css({height:"0px"});
        $('.report_mrnForm').css({visibility:"hidden"});
        $('.report_subjectForm').css({height:"50px"});
        $('.report_subjectForm').css({visibility:"hidden"});
        $('.report_startDate').css({height:"50px"});
        $('.report_startDate').css({visibility:"visible"});
        $('.report_endDate').css({height:"50px"});
        $('.report_endDate').css({visibility:"visible"});
    }

    // afterthoughts for certain reports
    if (report_selectedReport.name == 'daily_resource'){
        $('.report_piForm').css({display: "none"});
        $('.report_mrnForm').css({display: "none"});
        $('.report_subjectForm').css({display: "none"});
    }

    setFilterControls(report_selectedReport.name);
    toggleFilterTextInputVisibility();

    if (report_selectedReport.name == 'proto_by_nurse'){
        $('#report_sortTitle').html("Protocol Nurse Last Name");
    }
    else if (report_selectedReport.name == 'proto_by_nutritionist'){
        $('#report_sortTitle').html("Protocol Nutritionist Last Name");
    }
    else if (report_selectedReport.name == 'daily_resource'){
        $('#report_sortTitle').html("Resource Name");
    }
    else if (report_selectedReport.name == 'daily_adm'){
        $('#report_sortTitle').html("Subject Last Name");
    }
    else if (report_selectedReport.name == 'meta_kitchen'){
        $('#report_sortTitle').html("Subject Last Name");
    }
    else if (report_selectedReport.name == 'meta_kitchen_by_time'){
        $('#report_sortTitle').html("Resource Start Time");
    }
    else if (report_selectedReport.name == 'weekly_pharm'){
        $('#report_sortTitle').html("Study Name");
    }
    else if (report_selectedReport.name == 'study_visit_location'){
        $('#report_sortTitle').html("Visit Name");
    }
    else if (report_selectedReport.name == 'dept_and_pi'){
        $('#report_sortTitle').html("PI Last Name");
    }
    else if (report_selectedReport.name == 'billing'){
        $('#report_sortTitle').html("Study Name");
    }
    else if (report_selectedReport.name == 'billable_resources'){
        $('#report_sortTitle').html("Resource Name");
    }
    else if (report_selectedReport.name == 'billing_by_investigator'){
        $('#report_sortTitle').html("PI Last Name");
    }
    else if (report_selectedReport.name == 'transactions'){
        $('#report_sortTitle').html("Appointment Status");
    }
    else if (report_selectedReport.name == 'census'){
        $('#report_sortTitle').html("Appointment Status Reason");
    }
    else if (report_selectedReport.name == 'subject_purge'){
        $('#report_sortTitle').html("Subject Last Name");
    }
    else if (report_selectedReport.name == 'override'){
        $('#report_sortTitle').html("Performing User ID");
    }
    else if (report_selectedReport.name == 'subject_audit_staff_views'){
        $('#report_sortTitle').html("");
    }
    else if (report_selectedReport.name == 'staff_audit_subject_views'){
        $('#report_sortTitle').html("Subject Last Name");
    }
    else if (report_selectedReport.name == 'level_of_service'){
        $('#report_sortTitle').html("Study Name");
    }
    else if (report_selectedReport.name == 'user_data'){
        $('#report_sortTitle').html("User Last Name");
    }
    else if (report_selectedReport.name == 'daily_overview'){
        $('#report_sortTitle').html("Scheduled Start Time");
    }
    else if (report_selectedReport.name == 'off_unit'){
        $('#report_sortTitle').html(" Subject Last Name");
    }
    else if (report_selectedReport.name == 'study_subject_visit'){
        $('#report_sortTitle').html(" Subject Last Name");
    }
    else if (report_selectedReport.name == 'study_status_change'){
        $('#report_sortTitle').html("Date of Status Change");
    }
    else if (report_selectedReport.name == 'subject_visit_history'){
        $('#report_sortTitle').html(" Scheduled Visit Start Time");
    }
    else if (report_selectedReport.name == 'crc_availability'){
        $('#filter_functionality').css({display: "none"});
        $('#sort_functionality').css({display: "none"});
    }
    else if (report_selectedReport.name == 'resource_level_of_service'){
        $('#filter_functionality').css({display: "none"});
        $('#report_sortTitle').html(" Visit Name");
    }
    else if (report_selectedReport.name == 'visit_template_data'){
        $('#filter_functionality').css({display: "none"});
        $('#report_sortTitle').html(" Local ID");
    }
    else if (report_selectedReport.name == 'nutrition_tasks'){
        $('#report_sortTitle').html(" Local ID");
    }
    else if (report_selectedReport.name == 'visit_duration_by_visit_type'){
        $('#report_sortTitle').html(" Local ID");
    }
    else if (report_selectedReport.name == 'booked_visit_service_level_by_visit_type'){
        $('#report_sortTitle').html(" Visit Type");
    }
    else if (report_selectedReport.name == 'room_availability_check'){
        $('#report_sortTitle').html(" Resource Name");
    }
    else if (report_selectedReport.name == 'visit_terminated_prior_to_completion'){
        $('#report_sortTitle').html(" Study Name");
    }
    else if (report_selectedReport.name == 'ancillary_only_by_protocol'){
        $('#report_sortTitle').html(" Local ID");
    }
    else {
        $('#report_sortTitle').html("");
    }

    $("#report_sortDirectionSelect").val(1);
    $("#report_filterText").val('');
}

function setFilterControls(reportName) {
    $('#study_data_div').css({display: "none"});
    $('#cancellations_div').css({display: "none"});

    $("#report_filterSelect").html('');
    var html = [];
    switch (reportName) {
        case 'daily_resource':
            html[html.length] = "<option value='dailyresource_selectone'>Select One</option>";
            html[html.length] = "<option value='resource_name'>Resource Name</option>";
            html[html.length] = "<option value='subject_name'>Subject Last Name</option>";
            html[html.length] = "<option value='resource_group_nursing'>Resource Group: Nursing</option>";
            html[html.length] = "<option value='resource_group_nutrition'>Resource Group: Nutrition</option>";
            html[html.length] = "<option value='resource_group_room'>Resource Group: Room</option>";
            html[html.length] = "<option value='resource_group_lab'>Resource Group: Lab</option>";
            html[html.length] = "<option value='resource_group_other'>Resource Group: Other</option>";
            html[html.length] = "<option value='daily_resource_crc_approved'>CRC Approved: No</option>";
            break;
        case 'daily_adm':
            html[html.length] = "<option value='daily_adm_selectone'>Select One</option>";
            html[html.length] = "<option value='daily_adm_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='daily_adm_local_id'>Local ID</option>";
            html[html.length] = "<option value='daily_adm_mrn'>MRN</option>";
            html[html.length] = "<option value='daily_adm_resource'>Resource Name</option>";
            html[html.length] = "<option value='daily_adm_crc_approved'>CRC Approved: No</option>";
            break;
        case 'meta_kitchen':
            html[html.length] = "<option value='metakitch_selectone'>Select One</option>";
            html[html.length] = "<option value='metakitch_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='metakitch_local_id'>Local ID</option>";
            html[html.length] = "<option value='metakitch_mrn'>MRN</option>";
            html[html.length] = "<option value='metakitch_resource'>Resource Name</option>";
            html[html.length] = "<option value='metakitch_crc_approved'>CRC Approved: No</option>";
            break;
        case 'meta_kitchen_by_time':
            html[html.length] = "<option value='metakitchbytime_selectone'>Select One</option>";
            html[html.length] = "<option value='metakitchbytime_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='metakitchbytime_local_id'>Local ID</option>";
            html[html.length] = "<option value='metakitchbytime_mrn'>MRN</option>";
            html[html.length] = "<option value='metakitchbytime_resource'>Resource Name</option>";
            html[html.length] = "<option value='metakitchbytime_crc_approved'>CRC Approved: No</option>";
            break;
        case 'weekly_pharm':
            html[html.length] = "<option value='weeklypharm_selectone'>Select One</option>";
            html[html.length] = "<option value='weeklypharm_local_id'>Local ID</option>";
            html[html.length] = "<option value='weeklypharm_study'>Study Name</option>";
            html[html.length] = "<option value='weeklypharm_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='weeklypharm_sched_start_datetime'>Scheduled Visit Start Date/Time</option>";
            html[html.length] = "<option value='weeklypharm_crc_approved'>CRC Approved: No</option>";
            break;
        case 'proto_by_nurse':
            html[html.length] = "<option value='protonurse_selectone'>Select One</option>";
            html[html.length] = "<option value='proto_nurse'>Protocol Nurse Last Name</option>";
            html[html.length] = "<option value='protonurse_local_id'>Local ID</option>";
            html[html.length] = "<option value='protonurse_study_status'>Study Status</option>";
            break;
        case 'proto_by_nutritionist':
            html[html.length] = "<option value='protonutritionist_selectone'>Select One</option>";
            html[html.length] = "<option value='proto_nutritionist_last'>Protocol Nutritionist Last Name</option>";
            html[html.length] = "<option value='protonutritionist_local_id'>Local ID</option>";
            html[html.length] = "<option value='protonutritionist_study_status'>Study Status</option>";
            break;
        case 'study_visit_location':
            html[html.length] = "<option value='studyvisitlocation_selectone'>Select One</option>";
            html[html.length] = "<option value='studyvisitlocation_local_id'>Local ID</option>";
            html[html.length] = "<option value='studyvisitlocation_visit'>Visit Name</option>";
            html[html.length] = "<option value='studyvisitlocation_sublocation'>Sub-Location</option>";
            html[html.length] = "<option value='studyvisitlocation_crc_approved'>CRC Approved: No</option>";
            break;
        case 'dept_and_pi':
            html[html.length] = "<option value='deptandpi_selectone'>Select One</option>";
            html[html.length] = "<option value='deptandpi_department'>Department</option>";
            html[html.length] = "<option value='deptandpi_division'>Division</option>";
            html[html.length] = "<option value='deptandpi_investigator'>PI Last Name</option>";
            html[html.length] = "<option value='deptandpi_institution'>Institution</option>";
            html[html.length] = "<option value='deptandpi_credential'>Credential</option>";
            html[html.length] = "<option value='deptandpi_faculty_rank'>Faculty Rank</option>";
            html[html.length] = "<option value='deptandpi_crc_approved'>CRC Approved: No</option>";
            break;
        case 'billing':
            html[html.length] = "<option value='billing_selectone'>Select One</option>";
            html[html.length] = "<option value='billing_local_id'>Local ID</option>";
            html[html.length] = "<option value='billing_study'>Study Name</option>";
            html[html.length] = "<option value='billing_industry_initiated'>Industry Initiated: Yes</option>";
            html[html.length] = "<option value='billing_investigator'>PI Last Name</option>";
            html[html.length] = "<option value='billing_crc_approved'>CRC Approved: No</option>";
            break;
        case 'billable_resources':
            html[html.length] = "<option value='billable_resources_selectone'>Select One</option>";
            html[html.length] = "<option value='billable_resources_resource'>Resource Name</option>";
            html[html.length] = "<option value='billable_resources_study'>Study Name</option>";
            html[html.length] = "<option value='billable_resources_local_id'>Local ID</option>";
            html[html.length] = "<option value='billable_resources_investigator'>PI Last Name</option>";
            html[html.length] = "<option value='billable_resources_industry_initiated'>Industry Initiated: Yes</option>";
            html[html.length] = "<option value='billable_resources_crc_approved'>CRC Approved: No</option>";
            break;
        case 'billing_by_investigator':
            html[html.length] = "<option value='billingbyinvestigator_selectone'>Select One</option>";
            html[html.length] = "<option value='billingbyinvestigator_resource'>Resource Name</option>";
            html[html.length] = "<option value='billingbyinvestigator_study'>Study Name</option>";
            html[html.length] = "<option value='billingbyinvestigator_local_id'>Local ID</option>";
            html[html.length] = "<option value='billingbyinvestigator_investigator'>PI Last Name</option>";
            html[html.length] = "<option value='billingbyinvestigator_industry_initiated'>Industry Initiated: Yes</option>";
            html[html.length] = "<option value='billingbyinvestigator_crc_approved'>CRC Approved: No</option>";
            break;
        case 'transactions':
            html[html.length] = "<option value='transactions_selectone'>Select One</option>";
            html[html.length] = "<option value='transactions_study_visit_status'>Appointment Visit Status</option>";
            html[html.length] = "<option value='transactions_cancellation_type'>Cancellation Type</option>";
            html[html.length] = "<option value='transactions_cancellation_reason'>Cancellation Reason</option>";
            html[html.length] = "<option value='transactions_performing_user'>User Initiating Change Last Name</option>";
            break;
        case 'census':
            html[html.length] = "<option value='census_selectone'>Select One</option>";
            html[html.length] = "<option value='census_checkout_reason'>Check Out Reason</option>";
            html[html.length] = "<option value='census_investigator'>PI Last Name</option>";
            html[html.length] = "<option value='census_local_id'>Local ID</option>";
            html[html.length] = "<option value='census_study'>Study Name</option>";
            html[html.length] = "<option value='census_visit'>Visit Name</option>";
            html[html.length] = "<option value='census_crc_approved'>CRC Approved: No</option>";
            break;
        case 'subject_purge':
            html[html.length] = "<option value='subjectpurge_selectone'>Select One</option>";
            html[html.length] = "<option value='subjectpurge_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='subjectpurge_mrn'>MRN</option>";
            html[html.length] = "<option value='subjectpurge_performing_user'>Creating User</option>";
            break;
        case 'override':
            html[html.length] = "<option value='override_selectone'>Select One</option>";
            html[html.length] = "<option value='override_performing_user'>Performing User Id</option>";
            html[html.length] = "<option value='override_visit'>Visit Name</option>";
            html[html.length] = "<option value='override_local_id'>Local ID</option>";
            html[html.length] = "<option value='or_change_resource'>Override Reason - Change of Resource</option>";
            html[html.length] = "<option value='or_change_rn'>Override (resource otherwise not available) Approved by RN Resource Manager</option>";
            html[html.length] = "<option value='or_change_rd'>Override (resource otherwise not available) Approved by RD Resource Manager</option>";
            html[html.length] = "<option value='or_change_other'>Override (resource otherwise not available) Approved by Other Resource Manager</option>";
            html[html.length] = "<option value='or_ol_rn'>Overlap (double booking) Approved by RN Resource Manager</option>";
            html[html.length] = "<option value='or_ol_rd'>Overlap (double booking) Approved by RD Resource Manager</option>";
            html[html.length] = "<option value='or_ol_other'>Overlap (double booking) Approved by Other Resource Manager</option>";
            break;
        case 'subject_audit_staff_views':
            html[html.length] = "<option value='subjectaudit_selectone'>Select One</option>";
            html[html.length] = "<option value='subject_user_name'>User Last Name</option>";
            break;
        case 'staff_audit_subject_views':
            html[html.length] = "<option value='staffaudit_selectone'>Select One</option>";
            html[html.length] = "<option value='staff_user_name'>User Last Name</option>";
            html[html.length] = "<option value='staff_user_id'>User ID</option>";
            break;

        case 'study_data':
            $('#study_data_div').css({display: "block"});
            $('#old_filters').css({display: "none"});
            $('#sort_functionality').css({display: "none"});
            break;
        case 'cancellations':
            $('#cancellations_div').css({display: "block"});
            $('#old_filters').css({display: "none"});
            $('#sort_functionality').css({display: "none"});
            break;

        case 'user_data':
            html[html.length] = "<option value='user_data_selectone'>Select One</option>";
            html[html.length] = "<option value='user_data_user_name'>User Last Name</option>";
            html[html.length] = "<option value='user_data_inst_role'>Institution Role</option>";
            html[html.length] = "<option value='user_data_user_title'>User Title</option>";
            html[html.length] = "<option value='user_data_status_active'>Status: Active</option>";
            html[html.length] = "<option value='user_data_status_not_active'>Status: Not Active</option>";
            break;
        case 'daily_overview':
            html[html.length] = "<option value='daily_overview_selectone'>Select One</option>";
            html[html.length] = "<option value='daily_overview_local_id'>Local ID</option>";
            html[html.length] = "<option value='daily_overview_visit'>Visit Name</option>";
            html[html.length] = "<option value='daily_overview_subject'>Subject Last Name</option>";
            html[html.length] = "<option value='daily_overview_mrn'>MRN</option>";
            html[html.length] = "<option value='daily_overview_is_part_off_unit'>Is Part of Visit Off Unit?</option>";
            html[html.length] = "<option value='daily_overview_resource_type'>Resource Type</option>";
            html[html.length] = "<option value='daily_overview_sublocation'>Sublocation</option>";
            break;
        case 'off_unit':
            html[html.length] = "<option value='off_unit_selectone'>Select One</option>";
            html[html.length] = "<option value='off_unit_visit'>Visit Name</option>";
            html[html.length] = "<option value='off_unit_local_id'>Local ID</option>";
            html[html.length] = "<option value='off_unit_last_name'>Subject Last Name</option>";
            html[html.length] = "<option value='off_unit_mrn'>MRN</option>";
            html[html.length] = "<option value='off_unit_visit_type'>Visit Type</option>";
            html[html.length] = "<option value='off_unit_crc_approved'>CRC Approved: No</option>";
            html[html.length] = "<option value='off_unit_group_nursing'>Resource Group: Nursing</option>";
            html[html.length] = "<option value='off_unit_group_nutrition'>Resource Group: Nutrition</option>";
            html[html.length] = "<option value='off_unit_group_room'>Resource Group: Room</option>";
            html[html.length] = "<option value='off_unit_group_lab'>Resource Group: Lab</option>";
            html[html.length] = "<option value='off_unit_group_other'>Resource Group: Other</option>";
            break;
        case 'level_of_service':
            html[html.length] = "<option value='levelofservice_selectone'>Select One</option>";
            html[html.length] = "<option value='levelofservice_sl_nursing'>Nursing</option>";
            html[html.length] = "<option value='levelofservice_sl_nutrition'>Nutrition</option>";
            html[html.length] = "<option value='levelofservice_sl_processing'>Processing</option>";
            html[html.length] = "<option value='levelofservice_sl_setup'>Setup</option>";
            html[html.length] = "<option value='levelofservice_visit_type'>Visit Type</option>";
            html[html.length] = "<option value='levelofservice_appt_status'>Appointment Status</option>";
            html[html.length] = "<option value='levelofservice_checkout_reason'>Check Out Reason</option>";
            html[html.length] = "<option value='levelofservice_crc_approved'>CRC Approved: No</option>";
            break;
        case 'study_subject_visit':
            html[html.length] = "<option value='studysubjectvisit_selectone'>Select One</option>";
            html[html.length] = "<option value='studysubjectvisit_localId'>Local ID</option>";
            html[html.length] = "<option value='studysubjectvisit_appointment'>Appointment Status</option>";
            html[html.length] = "<option value='studysubjectvisit_crc_approved'>CRC Approved: No</option>";
            break;
        case 'subject_visit_history':
            html[html.length] = "<option value='subjectvisithistory_selectone'>Select One</option>";
            html[html.length] = "<option value='subjectvisithistory_localId'>Local ID</option>";
            html[html.length] = "<option value='subjectvisithistory_crc_approved'>CRC Approved: No</option>";
            break;
        case 'study_status_change':
            html[html.length] = "<option value='studystatuschange_selectone'>Select One</option>";
            html[html.length] = "<option value='studystatuschange_local_id'>Local ID</option>";
            html[html.length] = "<option value='studystatuschange_investigator'>PI Last Name </option>";
            html[html.length] = "<option value='studystatuschange_study_status'>Study Status</option>";
            html[html.length] = "<option value='studystatuschange_crc_approved'>CRC Approved: No</option>";
            break;
        case 'crc_availability':
            html[html.length] = "<option value='crcavailability_selectone'>Select One</option>";
            break;
        case 'resource_level_of_service':
            html[html.length] = "<option value='resourcelevelofservice_selectone'>Select One</option>";
            html[html.length] = "<option value='resourcelevelofservice_localID'>Local ID</option>";
            html[html.length] = "<option value='resourcelevelofservice_visitName'>Visit Name</option>";
            break;
        case 'visit_template_data':
            html[html.length] = "<option value='visittemplatedata_selectone'>Select One</option>";
            html[html.length] = "<option value='visittemplatedata_localID'>Local ID</option>";
            html[html.length] = "<option value='visittemplatedata_visitName'>Visit Name</option>";
            break;
        case 'nutrition_tasks':
            html[html.length] = "<option value='nutritiontasks_selectone'> Select One </option>";
            html[html.length] = "<option value='nutritiontasks_local_id'>Local ID</option>";
            html[html.length] = "<option value='nutritiontasks_name'>Subject Last Name</option>";
            html[html.length] = "<option value='nutritiontasks_anthropometry_simple'> Anthropometry Simple </option>";
            html[html.length] = "<option value='nutritiontasks_anthropometry_complex'> Anthropometry Complex </option>";
            html[html.length] = "<option value='nutritiontasks_meal_plan_calculation'> Meal Plan Calculation </option>";
            html[html.length] = "<option value='nutritiontasks_nutrient_analysis'>Nutrient Analysis</option>";
            html[html.length] = "<option value='nutritiontasks_education_time'>Education Time </option>";
            html[html.length] = "<option value='nutritiontasks_questionnaire_time'> Questionnaire Time </option>";
            html[html.length] = "<option value='nutritiontasks_crc_approved'>CRC Approved: No</option>";
            break;
        case 'visit_duration_by_visit_type':
            html[html.length] = "<option value='visitdurationbyvisittype_selectone'> Select One </option>";
            html[html.length] = "<option value='visitdurationbyvisittype_visitname'>Visit Name</option>";
            html[html.length] = "<option value='visitdurationbyvisittype_visittype'>Visit Type</option>";
            break;
        case 'booked_visit_service_level_by_visit_type':
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_selectone'> Select One </option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level0'>Level 0</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level1'>Level 1</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level2'>Level 2</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level3'>Level 3</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level4'>Level 4</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level5'>Level 5</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level6'>Level 6</option>";
            html[html.length] = "<option value='bookedvisitservicelevelbyvisittype_level7'>Level 7</option>";
            break;
        case 'room_availability_check':
            html[html.length] = "<option value='roomavailabilitycheck_selectone'> Select One </option>";
            html[html.length] = "<option value='roomavailabilitycheck_level0'>Resource Name</option>";
            break;
        case 'visit_terminated_prior_to_completion':
            html[html.length] = "<option value='visitterminatedpriortocompletion_selectone'> Select One </option>";
            html[html.length] = "<option value='visitterminatedpriortocompletion_level0'>Study Name</option>";
            html[html.length] = "<option value='visitterminatedpriortocompletion_level1'>Visit Name</option>";
            html[html.length] = "<option value='visitterminatedpriortocompletion_level2'>Subject Name</option>";
            break;
        case 'ancillary_only_by_protocol':
            html[html.length] = "<option value='ancillaryonlybyprotocol_selectone'> Select One </option>";
            html[html.length] = "<option value='ancillaryonlybyprotocol_localID'>Local ID </option>";
            html[html.length] = "<option value='ancillaryonlybyprotocol_crc_approved'>CRC Approved: No</option>";
            break;
    }

    var result = html.join('');
    $("#report_filterSelect").html(result);
}

function filterSelectionChanged() {
    //code to check if the selected value is resource type
    if($("#report_filterSelect option:selected").val() == 'daily_overview_resource_type'){
        var html = [];
        $('#overview_resource_type').css({display:''});
        var jsonData = null;
        $.post("rest/report/loadResourceTypes", {data:jsonData}, function(data) {
            parsedData = $.parseJSON(data);
            var resourceTypes = parsedData.resourceTypes;
            html[html.length] = "<option value=''>Select Resource Type</option>";
            $.each(resourceTypes, function(i,item){
                html[html.length] = "<option value="+item+">"+item+"</option>";

            });
            var result = html.join('');
            $("#overview_resource_type").html(result);
        });
    }
    else if($("#report_filterSelect option:selected").val() == 'daily_overview_sublocation'){
        var html = [];
        $('#overview_sublocation').css({display:''});
        var jsonData =null;
        $.post("rest/report/loadSublocations", {data:jsonData}, function(data) {
            parsedData = $.parseJSON(data);
            var sublocations = parsedData.sublocations;
            html[html.length] = "<option value=''>Select Sublocation</option>";
            $.each(sublocations, function(i,item){
                html[html.length] = "<option value="+item.name+">"+item.name+"</option>";

            });
            var result = html.join('');
            $("#overview_sublocation").html(result);
        });
    }
    else {
        $('#overview_resource_type').css({display:'none'});
        $('#overview_sublocation').css({display:'none'});
    }
    toggleFilterTextInputVisibility();
}

function getStartTime() {
    return $("#report_startDate").datepicker('getDate').valueOf();
}

function getEndTime() {
    return $("#report_endDate").datepicker('getDate').valueOf();
}

function sortSelectionChanged() {
    if($("#report_sortDirectionSelect").val() == 1) {
        if (report_selectedReport.name == 'staff_audit_subject_views'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()});
            $.post("rest/report/getReport?name=staff_audit_subject_views"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_staffAuditSubjectViewsResult = parsedData.staffAuditSubjectViewsReport;
                report_showStaffAuditSubjectViewsResults();
            });
        }
        else if (report_selectedReport.name == 'subject_audit_staff_views'){

        }
        else if (report_selectedReport.name == 'daily_resource'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_resource"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyResourceResult = parsedData.dailyResourceReport;
                report_showDailyResourceResults();
            });
        }
        else if (report_selectedReport.name == 'daily_adm'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_adm"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyAdmResult = parsedData.dailyAdmReport;
                report_showDailyAdmResults();
            });
        }
        else if (report_selectedReport.name == 'meta_kitchen'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=meta_kitchen"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_metaKitchenResult = parsedData.metaKitchenReport;
                report_showMetaKitchenResults();
            });
        }
        else if (report_selectedReport.name == 'meta_kitchen_by_time'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=meta_kitchen_by_time"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_metaKitchenByTimeResult = parsedData.metaKitchenReport;
                report_showMetaKitchenByTimeResults();
            });
        }
        else if (report_selectedReport.name == 'weekly_pharm'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=weekly_pharm"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_weeklyPharmResult = parsedData.weeklyPharmReport;
                report_showWeeklyPharmResults();
            });
        }
        else if (report_selectedReport.name == 'proto_by_nurse'){
            $.post("rest/report/getReport?name=proto_nurse"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_protoNurseResult = parsedData.protoNurseNutritionReport;
                report_showProtoNurseResults();
            });
        }
        else if (report_selectedReport.name == 'proto_by_nutritionist'){
            $.post("rest/report/getReport?name=proto_nutritionist"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_protoNutritionistResult = parsedData.protoNurseNutritionReport;
                report_showProtoNutritionistResults();
            });
        }
        else if (report_selectedReport.name == 'study_visit_location'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=study_visit_location"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studyVisitLocationResult = parsedData.studyVisitLocationReport;
                report_showStudyVisitLocationResults();
            });
        }
        else if (report_selectedReport.name == 'dept_and_pi'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=dept_and_pi"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_deptAndPiResult = parsedData.deptAndPiReport;
                report_showDeptAndPiResults();
            });
        }
        else if (report_selectedReport.name == 'billing'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=billing"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billingResult = parsedData.billingReport;
                report_showBillingResults();
            });
        }
        else if (report_selectedReport.name == 'billable_resources'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=billable_resources"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billableResourcesResult = parsedData.billableResourcesReport;
                report_showBillableResourcesResults();
            });
        }
        else if (report_selectedReport.name == 'billing_by_investigator'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime(),
                piFirstName: $.trim($("#report_piFirstName").val()),
                piLastName: $.trim($("#report_piLastName").val())
            });
            $.post("rest/report/getReport?name=billing_by_investigator"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billingByInvestigatorResult = parsedData.billingByInvestigatorReport;
                report_showBillingByInvestigatorResults();
            });
        }
        else if (report_selectedReport.name == 'transactions'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=transactions"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_transactionsResult = parsedData.transactionsReport;
                report_showTransactionsResults();
            });
        }
        else if (report_selectedReport.name == 'census'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=census"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_censusResult = parsedData.censusReport;
                report_showCensusResults();
            });
        }
        else if (report_selectedReport.name == 'subject_purge'){
            $.post("rest/report/getReport?name=subject_purge"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_subjectPurgeResult = parsedData.subjectPurgeReport;
                report_showSubjectPurgeResults();
            });
        }
        else if (report_selectedReport.name == 'override'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });

            $.post("rest/report/getReport?name=override"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_overrideResult = parsedData.overrideReport;
                report_showOverrideResults();
            });
        }
        else if (report_selectedReport.name == 'user_data'){
            $.post("rest/report/getReport?name=user_data"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_userDataResult = parsedData.userDataReport;
                report_showUserDataResults();
            });
        }
        else if (report_selectedReport.name == 'daily_overview'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_overview"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyOverviewResult = parsedData.dailyOverviewReport;
                report_showDailyOverviewResults();
            });
        }
        else if (report_selectedReport.name == 'off_unit'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=off_unit"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_offUnitResult = parsedData.offUnitReport;
                report_showOffUnitResults();
            });
        }
        else if (report_selectedReport.name == 'level_of_service'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=level_of_service"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_levelOfServiceResult = parsedData.levelOfServiceReport;
                report_showLevelOfServiceResults();
            });
        }
        else if (report_selectedReport.name == 'study_subject_visit'){
            var jsonData = JSON.stringify({
                subjectLastName: $.trim($("#report_subjectLastName").val()),
                subjectMRN: $.trim($("#report_subjectMRN").val()),
                subjectDOB: $.trim($("#report_subjectDOB").val())
            });
            $.post("rest/report/getReport?name=study_subject_visit"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studySubjectVisitResult = parsedData.studySubjectVisitReport;
                report_showStudySubjectVisitResults();
            });
        }
        else if (report_selectedReport.name == 'study_status_change'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=study_status_change"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studyStatusChangeResult = parsedData.studyStatusChangeReport;
                report_showStudyStatusChangeResults();
            });
        }
        else if (report_selectedReport.name == 'subject_visit_history'){
            var jsonData = JSON.stringify({
                subjectLastName: $.trim($("#report_subjectLastName").val()),
                subjectMRN: $.trim($("#report_subjectMRN").val()),
                subjectDOB: $.trim($("#report_subjectDOB").val())
            });
            $.post("rest/report/getReport?name=subject_visit_history"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_subjectVisitHistoryResult = parsedData.subjectVisitHistoryReport;
                report_showSubjectVisitHistoryResults();
            });
        }
        else if (report_selectedReport.name == 'crc_availability'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=crc_availability"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_crcAvailabilityResult = parsedData.crcAvailabilityReport;
                report_showCRCAvailabilityResults();
            });
        }
        else if (report_selectedReport.name == 'resource_level_of_service'){
            $.post("rest/report/getReport?name=resource_level_of_service"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_resourceLevelOfServiceResult = parsedData.levelOfServiceReport;
                report_showResourceLevelOfServiceResults();
            });
        }
        else if (report_selectedReport.name == 'visit_template_data'){
            $.post("rest/report/getReport?name=visit_template_data"+'&sortId=1', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitTemplateResult = parsedData.visitTemplateReport;
                report_showVisitTemplateResults();
            });
        }
        else if (report_selectedReport.name == 'nutrition_tasks'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=nutrition_tasks"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_nutritionTasksResult = parsedData.nutritionTasksReport;
                report_showNutritionTasksResults();
            });
        }
        else if (report_selectedReport.name == 'visit_duration_by_visit_type'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visit_duration_by_visit_type"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitDurationByVisitTypeResult = parsedData.visitDurationByVisitType;
                report_showVisitDurationByVisitTypeResults();
            });
        }
        else if (report_selectedReport.name == 'booked_visit_service_level_by_visit_type'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=booked_visit_service_level_by_visit_type"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_bookedVisitServiceLevelByTypeResult = parsedData.bookedVisitServiceLevelByTypeReport;
                report_showBookedVisitServiceLevelByTypeResults();
            });
        }
        else if (report_selectedReport.name == 'visit_terminated_prior_to_completion'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visit_terminated_prior_to_completion"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitTerminatedPriorToCompletionResult = parsedData.visitTerminatedPriorToCompletion;
                report_showVisitTerminatedPriorToCompletionResults();
            });
        }
        else if (report_selectedReport.name == 'ancillary_only_by_protocol'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=ancillary_only_by_protocol"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_ancillaryOnlyByProtocolResult = parsedData.ancillaryOnlyByProtocolReport;
                report_showAncillaryOnlyByProtocolResults();
            });
        }
        else if (report_selectedReport.name == 'visits_flagged_edit'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visits_flagged_edit"+'&sortId=1', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitsFlaggedResult = parsedData.visitsFlaggedResult;
                report_showVisitsFlaggedResults();
            });
        }
    }

    else {


        if (report_selectedReport.name == 'staff_audit_subject_views'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()});
            $.post("rest/report/getReport?name=staff_audit_subject_views"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_staffAuditSubjectViewsResult = parsedData.staffAuditSubjectViewsReport;
                report_showStaffAuditSubjectViewsResults();
            });
        }
        else if (report_selectedReport.name == 'subject_audit_staff_views'){

        }
        else if (report_selectedReport.name == 'daily_resource'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_resource"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyResourceResult = parsedData.dailyResourceReport;
                report_showDailyResourceResults();
            });
        }
        else if (report_selectedReport.name == 'daily_adm'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_adm"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyAdmResult = parsedData.dailyAdmReport;
                report_showDailyAdmResults();
            });
        }
        else if (report_selectedReport.name == 'meta_kitchen'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=meta_kitchen"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_metaKitchenResult = parsedData.metaKitchenReport;
                report_showMetaKitchenResults();
            });
        }
        else if (report_selectedReport.name == 'meta_kitchen_by_time'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=meta_kitchen_by_time"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_metaKitchenByTimeResult = parsedData.metaKitchenReport;
                report_showMetaKitchenByTimeResults();
            });
        }
        else if (report_selectedReport.name == 'weekly_pharm'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=weekly_pharm"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_weeklyPharmResult = parsedData.weeklyPharmReport;
                report_showWeeklyPharmResults();
            });
        }
        else if (report_selectedReport.name == 'proto_by_nurse'){
            $.post("rest/report/getReport?name=proto_nurse"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_protoNurseResult = parsedData.protoNurseNutritionReport;
                report_showProtoNurseResults();
            });
        }
        else if (report_selectedReport.name == 'proto_by_nutritionist'){
            $.post("rest/report/getReport?name=proto_nutritionist"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_protoNutritionistResult = parsedData.protoNurseNutritionReport;
                report_showProtoNutritionistResults();
            });
        }
        else if (report_selectedReport.name == 'study_visit_location'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=study_visit_location"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studyVisitLocationResult = parsedData.studyVisitLocationReport;
                report_showStudyVisitLocationResults();
            });
        }
        else if (report_selectedReport.name == 'dept_and_pi'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=dept_and_pi"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_deptAndPiResult = parsedData.deptAndPiReport;
                report_showDeptAndPiResults();
            });
        }
        else if (report_selectedReport.name == 'billing'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=billing"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billingResult = parsedData.billingReport;
                report_showBillingResults();
            });
        }
        else if (report_selectedReport.name == 'billable_resources'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=billable_resources"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billableResourcesResult = parsedData.billableResourcesReport;
                report_showBillableResourcesResults();
            });
        }
        else if (report_selectedReport.name == 'billing_by_investigator'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime(),
                piFirstName: $.trim($("#report_piFirstName").val()),
                piLastName: $.trim($("#report_piLastName").val())
            });
            $.post("rest/report/getReport?name=billing_by_investigator"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_billingByInvestigatorResult = parsedData.billingByInvestigatorReport;
                report_showBillingByInvestigatorResults();
            });
        }
        else if (report_selectedReport.name == 'transactions'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=transactions"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_transactionsResult = parsedData.transactionsReport;
                report_showTransactionsResults();
            });
        }
        else if (report_selectedReport.name == 'census'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=census"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_censusResult = parsedData.censusReport;
                report_showCensusResults();
            });
        }
        else if (report_selectedReport.name == 'subject_purge'){
            $.post("rest/report/getReport?name=subject_purge"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_subjectPurgeResult = parsedData.subjectPurgeReport;
                report_showSubjectPurgeResults();
            });
        }
        else if (report_selectedReport.name == 'override'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });

            $.post("rest/report/getReport?name=override"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_overrideResult = parsedData.overrideReport;
                report_showOverrideResults();
            });
        }
        else if (report_selectedReport.name == 'user_data'){
            $.post("rest/report/getReport?name=user_data"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_userDataResult = parsedData.userDataReport;
                report_showUserDataResults();
            });
        }
        else if (report_selectedReport.name == 'daily_overview'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=daily_overview"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_dailyOverviewResult = parsedData.dailyOverviewReport;
                report_showDailyOverviewResults();
            });
        }
        else if (report_selectedReport.name == 'off_unit'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=off_unit"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_offUnitResult = parsedData.offUnitReport;
                report_showOffUnitResults();
            });
        }
        else if (report_selectedReport.name == 'level_of_service'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=level_of_service"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_levelOfServiceResult = parsedData.levelOfServiceReport;
                report_showLevelOfServiceResults();
            });
        }
        else if (report_selectedReport.name == 'study_subject_visit'){
            var jsonData = JSON.stringify({
                subjectLastName: $.trim($("#report_subjectLastName").val()),
                subjectMRN: $.trim($("#report_subjectMRN").val()),
                subjectDOB: $.trim($("#report_subjectDOB").val())
            });
            $.post("rest/report/getReport?name=study_subject_visit"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studySubjectVisitResult = parsedData.studySubjectVisitReport;
                report_showStudySubjectVisitResults();
            });
        }
        else if (report_selectedReport.name == 'study_status_change'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=study_status_change"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_studyStatusChangeResult = parsedData.studyStatusChangeReport;
                report_showStudyStatusChangeResults();
            });
        }
        else if (report_selectedReport.name == 'subject_visit_history'){
            var jsonData = JSON.stringify({
                subjectLastName: $.trim($("#report_subjectLastName").val()),
                subjectMRN: $.trim($("#report_subjectMRN").val()),
                subjectDOB: $.trim($("#report_subjectDOB").val())
            });
            $.post("rest/report/getReport?name=subject_visit_history"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_subjectVisitHistoryResult = parsedData.subjectVisitHistoryReport;
                report_showSubjectVisitHistoryResults();
            });
        }
        else if (report_selectedReport.name == 'crc_availability'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=crc_availability"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_crcAvailabilityResult = parsedData.crcAvailabilityReport;
                report_showCRCAvailabilityResults();
            });
        }
        else if (report_selectedReport.name == 'resource_level_of_service'){
            $.post("rest/report/getReport?name=resource_level_of_service"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_resourceLevelOfServiceResult = parsedData.levelOfServiceReport;
                report_showResourceLevelOfServiceResults();
            });
        }
        else if (report_selectedReport.name == 'visit_template_data'){
            $.post("rest/report/getReport?name=visit_template_data"+'&sortId=2', {}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitTemplateResult = parsedData.visitTemplateReport;
                report_showVisitTemplateResults();
            });
        }
        else if (report_selectedReport.name == 'nutrition_tasks'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=nutrition_tasks"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_nutritionTasksResult = parsedData.nutritionTasksReport;
                report_showNutritionTasksResults();
            });
        }
        else if (report_selectedReport.name == 'visit_duration_by_visit_type'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visit_duration_by_visit_type"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitDurationByVisitTypeResult = parsedData.visitDurationByVisitType;
                report_showVisitDurationByVisitTypeResults();
            });
        }
        else if (report_selectedReport.name == 'booked_visit_service_level_by_visit_type'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=booked_visit_service_level_by_visit_type"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_bookedVisitServiceLevelByTypeResult = parsedData.bookedVisitServiceLevelByTypeReport;
                report_showBookedVisitServiceLevelByTypeResults();
            });
        }
        else if (report_selectedReport.name == 'visit_terminated_prior_to_completion'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visit_terminated_prior_to_completion"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitTerminatedPriorToCompletionResult = parsedData.visitTerminatedPriorToCompletion;
                report_showVisitTerminatedPriorToCompletionResults();
            });
        }
        else if (report_selectedReport.name == 'ancillary_only_by_protocol'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=ancillary_only_by_protocol"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_ancillaryOnlyByProtocolResult = parsedData.ancillaryOnlyByProtocolReport;
                report_showAncillaryOnlyByProtocolResults();
            });
        }
        else if (report_selectedReport.name == 'visits_flagged_edit'){
            var jsonData = JSON.stringify({
                startTime: getStartTime(),
                endTime: getEndTime()
            });
            $.post("rest/report/getReport?name=visits_flagged_edit"+'&sortId=2', {data:jsonData}, function(data) {
                parsedData = $.parseJSON(data);
                report_visitsFlaggedResult = parsedData.visitsFlaggedResult;
                report_showVisitsFlaggedResults();
            });
        }
    }
}

function  toggleFilterTextInputVisibility() {
    switch($("#report_filterSelect option:selected").val()) {
        case 'resource_group_nursing':
        case 'resource_group_nutrition':
        case 'resource_group_room':
        case 'resource_group_lab':
        case 'resource_group_other':
        case 'off_unit_group_nursing':
        case 'off_unit_group_nutrition':
        case 'off_unit_group_room':
        case 'off_unit_group_lab':
        case 'off_unit_group_other':
        case 'daily_adm_crc_approved':
        case 'daily_resource_crc_approved':
        case 'billable_resources_crc_approved':
        case 'billable_resources_industry_initiated':
        case 'billing_crc_approved':
        case 'billing_industry_initiated':
        case 'billingbyinvestigator_crc_approved':
        case 'billingbyinvestigator_industry_initiated':
        case 'census_crc_approved':
        case 'deptandpi_crc_approved':
        case 'levelofservice_crc_approved':
        case 'metakitch_crc_approved':
        case 'metakitchbytime_crc_approved':
        case 'weeklypharm_crc_approved':
        case 'off_unit_crc_approved':
        case 'nutritiontasks_crc_approved':
        case 'studyvisitlocation_crc_approved':
        case 'studystatuschange_crc_approved':
        case 'studysubjectvisit_crc_approved':
        case 'subjectvisithistory_crc_approved':
        case 'ancillaryonlybyprotocol_crc_approved':
        case 'or_change_resource':
        case 'or_change_rn':
        case 'or_change_rd':
        case 'or_change_other':
        case 'or_ol_rn':
        case 'or_ol_rd':
        case 'or_ol_other':
        case 'user_data_status_active':
        case 'user_data_status_not_active':
        case 'bookedvisitservicelevelbyvisittype_level0':
        case 'bookedvisitservicelevelbyvisittype_level1':
        case 'bookedvisitservicelevelbyvisittype_level2':
        case 'bookedvisitservicelevelbyvisittype_level3':
        case 'bookedvisitservicelevelbyvisittype_level4':
        case 'bookedvisitservicelevelbyvisittype_level5':
        case 'bookedvisitservicelevelbyvisittype_level6':
        case 'bookedvisitservicelevelbyvisittype_level7':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Filter");
            $('#report_filterButton').css({display: "inline"});
            break;
        case 'subjectaudit_selectone':
        case 'staffaudit_selectone':
        case 'dailyresource_selectone':
        case 'daily_adm_selectone':
        case 'metakitch_selectone':
        case 'metakitchbytime_selectone':
        case 'weeklypharm_selectone':
        case 'protonurse_selectone':
        case 'protonutritionist_selectone':
        case 'studyvisitlocation_selectone':
        case 'deptandpi_selectone':
        case 'billing_selectone':
        case 'billable_resources_selectone':
        case 'billingbyinvestigator_selectone':
        case 'transactions_selectone':
        case 'census_selectone':
        case 'subjectpurge_selectone':
        case 'override_selectone':
        case 'user_data_selectone':
        case 'daily_overview_selectone':
        case 'off_unit_selectone':
        case 'levelofservice_selectone':
        case 'studysubjectvisit_selectone':
        case 'studystatuschange_selectone':
        case 'subjectvisithistory_selectone':
        case 'crcavailability_selectone':
        case 'resourcelevelofservice_selectone':
        case 'visittemplatedata_selectone':
        case 'nutritiontasks_selectone':
        case 'visitdurationbyvisittype_selectone':
        case 'bookedvisitservicelevelbyvisittype_selectone':
        case 'ancillaryonlybyprotocol_selectone':
        case 'visitterminatedpriortocompletion_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "none"});
            break;
        default:
            $('#report_filterText').css({display:"inline"});
            $('#report_filterButton').attr("value", "Filter");
            $('#report_filterButton').css({display: "inline"});
            break;
    }
    if($("#report_filterSelect option:selected").val() == 'daily_overview_resource_type'
        || $("#report_filterSelect option:selected").val() == 'daily_overview_sublocation'){
        $('#report_filterText').css({display:"none"});
    }

}

function handleReportErrorFromBackEnd(xhr, status, error) {
    $('#report_results').html("Sorry, there was an error fetching data. (Error: '" + error + "'. " + "Status: '" + xhr.status + "')");
    report_handleDataResponse(0);
}

function studyFilterSelectionChanged() {
    url =  "rest/report/studyDataReport" +
        "?sortStrategy=" +  $.trim($("#study_data_sort_direction option:selected").val());

    fundingValue = $.trim($("#study_data_funding_source option:selected").val());
    studyStatus =  $.trim($("#study_data_study_status option:selected").val());
    localId =      $.trim($("#study_data_local_id").val());
    name =         $.trim($("#study_data_study_name").val());

    if (fundingValue != 0) url += "&fundingSource=" + fundingValue;
    if (studyStatus != 0)  url += "&studyStatus=" + studyStatus;
    if (localId)           url += "&localId=" + localId;
    if (name)              url += "&name=" + name;

    $('#report_loadMessage').css({display: "block"});
    $('#report_emptyMessage').css({display: "none"});
    $('#report_result_screen').css({display: "block"});
    $('#report_results').html('');
    $('#report_downloadButton').css({display: "inline-block"});
    $('#report_customdownloadButton').css({display: "none"});
    $('#report_flatloadButton').css({display: "none"});

    report_getReport(url, 'report_studyDataResult', report_showStudyDataResults);
}

function cancellationFilterSelectionChanged() {
    url =  timedUrl("rest/report/cancellationsReport") +
        "&sortStrategy=" +  $.trim($("#cancellations_sort_direction option:selected").val());

    localId =      $.trim($("#cancellations_local_id").val());
    name =         $.trim($("#cancellations_pi_name").val());
    type =         $.trim($("#cancellations_type option:selected").val());
    reason =       $.trim($("#cancellationReasons").val());
    noApprove =    $.trim($("#cancellations_crcApproved option:selected").val());

    if (localId)         url += "&localId=" + localId;
    if (name)            url += "&name=" + name;
    if (type != 0)       url += "&type=" + type;
    if (reason != 0)     url += "&reason=" + reason;
    if (noApprove != 0)  url += "&noApprove=" + noApprove;

    $('#report_loadMessage').css({display: "block"});
    $('#report_emptyMessage').css({display: "none"});
    $('#report_result_screen').css({display: "block"});
    $('#report_results').html('');
    $('#report_downloadButton').css({display: "inline-block"});
    $('#report_customdownloadButton').css({display: "none"});
    $('#report_flatloadButton').css({display: "none"});

    report_getReport(url, 'report_cancellationsResult', report_showCancellationsResults);
}


function filterReports() {
    $("#report_sortDirectionSelect").val(1);
    switch($("#report_filterSelect option:selected").val()) {

        // staff audit
        case 'staffaudit_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'staff_user_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'staff_user_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'staffaudit_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'staff_user_name'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'staff_user_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'staff_audit_subject_views'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()});
                $.post("rest/report/getReport?name=staff_audit_subject_views"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_staffAuditSubjectViewsResult = parsedData.staffAuditSubjectViewsReport;
                    report_showStaffAuditSubjectViewsResults();
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('staffaudit_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // Subject audit
        case 'subjectaudit_selectone':
            selectedid = 0;
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'subject_user_name':
            selectedid = 1;
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
            if (report_selectedReport.name == 'subject_audit_staff_views'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime(),
                    mrn: $.trim($("#report_mrn").val())
                });
                $.post("rest/report/getReport?name=subject_audit_staff_views"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_subjectAuditStaffViewsResult = parsedData.subjectAuditStaffViewsReport;
                    report_showSubjectAuditStaffViewsResults();
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('subjectaudit_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // daily resource

        case 'dailyresource_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'resource_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'subject_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resource_group_nursing':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resource_group_nutrition':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resource_group_room':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resource_group_lab':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resource_group_other':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_resource_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'dailyresource_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'resource_name'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'subject_name'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resource_group_nursing'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resource_group_nutrition'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resource_group_room'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resource_group_lab'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resource_group_other'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_resource_crc_approved'){
                selectedid = 8;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'daily_resource'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=daily_resource"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_dailyResourceResult = parsedData.dailyResourceReport;
                    report_showDailyResourceResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('dailyresource_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Daily Admission
        case 'daily_adm_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'daily_adm_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_adm_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_adm_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_adm_resource':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_adm_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'daily_adm_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'daily_adm_subject'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_adm_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_adm_mrn'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_adm_resource'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_adm_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'daily_adm'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=daily_adm"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_dailyAdmResult = parsedData.dailyAdmReport;
                    report_showDailyAdmResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('daily_adm_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Metabolic kitchen

        case 'metakitch_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'metakitch_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitch_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitch_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitch_resource':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitch_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'metakitch_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'metakitch_subject'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitch_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitch_mrn'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitch_resource'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitch_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'meta_kitchen'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=meta_kitchen"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_metaKitchenResult = parsedData.metaKitchenReport;
                    report_showMetaKitchenResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('metakitch_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Metabolic kitchen By Time

        case 'metakitchbytime_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'metakitchbytime_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitchbytime_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitchbytime_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitchbytime_resource':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'metakitchbytime_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'metakitchbytime_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'metakitchbytime_subject'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitchbytime_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitchbytime_mrn'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitchbytime_resource'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'metakitchbytime_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'meta_kitchen_by_time'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=meta_kitchen_by_time"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_metaKitchenByTimeResult = parsedData.metaKitchenReport;
                    report_showMetaKitchenByTimeResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('metakitchbytime_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Weekly Pharmacy

        case 'weeklypharm_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'weeklypharm_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'weeklypharm_study':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'weeklypharm_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'weeklypharm_sched_start_datetime':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'weeklypharm_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'weeklypharm_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'weeklypharm_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'weeklypharm_study'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'weeklypharm_subject'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'weeklypharm_sched_start_datetime'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'weeklypharm_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'weekly_pharm'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=weekly_pharm"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_weeklyPharmResult = parsedData.weeklyPharmReport;
                    report_showWeeklyPharmResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('weeklypharm_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Protocol By Nurse

        case 'protonurse_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'proto_nurse':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'protonurse_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'protonurse_study_status':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'protonurse_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'proto_nurse'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'protonurse_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'protonurse_study_status'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }


            if (report_selectedReport.name == 'proto_by_nurse'){
                $.post("rest/report/getReport?name=proto_nurse"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_protoNurseResult = parsedData.protoNurseNutritionReport;
                    report_showProtoNurseResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('protonurse_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Protocol By Nutritionist

        case 'protonutritionist_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'proto_nutritionist_last':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'protonutritionist_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'protonutritionist_study_status':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'protonutritionist_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'proto_nutritionist_last'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'protonutritionist_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'protonutritionist_study_status'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'proto_by_nutritionist'){
                $.post("rest/report/getReport?name=proto_nutritionist"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_protoNutritionistResult = parsedData.protoNurseNutritionReport;
                    report_showProtoNutritionistResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('protonutritionist_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // Study Visit Location
        case 'studyvisitlocation_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'studyvisitlocation_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studyvisitlocation_visit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studyvisitlocation_sublocation':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studyvisitlocation_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'studyvisitlocation_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'studyvisitlocation_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studyvisitlocation_visit'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studyvisitlocation_sublocation'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studyvisitlocation_crc_approved'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'study_visit_location'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=study_visit_location"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_studyVisitLocationResult = parsedData.studyVisitLocationReport;
                    report_showStudyVisitLocationResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('studyvisitlocation_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Department and PI

        case 'deptandpi_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'deptandpi_department':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_division':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_institution':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_credential':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_faculty_rank':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'deptandpi_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'deptandpi_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_department'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_division'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_investigator'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_institution'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_credential'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_faculty_rank'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'deptandpi_crc_approved'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'dept_and_pi'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=dept_and_pi"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_deptAndPiResult = parsedData.deptAndPiReport;
                    report_showDeptAndPiResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('deptandpi_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Billing Report

        case 'billing_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'billing_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billing_study':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billing_industry_initiated':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billing_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billing_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'billing_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'billing_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billing_study'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billing_industry_initiated'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billing_investigator'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billing_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'billing'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=billing"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_billingResult = parsedData.billingReport;
                    report_showBillingResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('billing_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Billable Resources

        case 'billable_resources_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'billable_resources_resource':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billable_resources_study':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billable_resources_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billable_resources_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billable_resources_industry_initiated':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billable_resources_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'billable_resources_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_resource'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_study'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_local_id'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_investigator'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_industry_initiated'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billable_resources_crc_approved'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'billable_resources'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=billable_resources"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_billableResourcesResult = parsedData.billableResourcesReport;
                    report_showBillableResourcesResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('billable_resources_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Billing By Investigator

        case 'billingbyinvestigator_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'billingbyinvestigator_resource':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billingbyinvestigator_study':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billingbyinvestigator_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billingbyinvestigator_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billingbyinvestigator_industry_initiated':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'billingbyinvestigator_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'billingbyinvestigator_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_resource'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_study'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_local_id'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_investigator'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_industry_initiated'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'billingbyinvestigator_crc_approved'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'billing_by_investigator'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime(),
                    piFirstName: $.trim($("#report_piFirstName").val()),
                    piLastName: $.trim($("#report_piLastName").val())
                });
                $.post("rest/report/getReport?name=billing_by_investigator"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_billingByInvestigatorResult = parsedData.billingByInvestigatorReport;
                    report_showBillingByInvestigatorResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('billingbyinvestigator_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Operation Transactions

        case 'transactions_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'transactions_study_visit_status':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'transactions_cancellation_type':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'transactions_cancellation_reason':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'transactions_performing_user':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'transactions_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'transactions_study_visit_status'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'transactions_cancellation_type'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'transactions_cancellation_reason'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'transactions_performing_user'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'transactions'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=transactions"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_transactionsResult = parsedData.transactionsReport;
                    report_showTransactionsResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('transactions_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Census Report

        case 'census_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'census_checkout_reason':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'census_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'census_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'census_study':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'census_visit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'census_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'census_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'census_checkout_reason'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'census_investigator'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'census_local_id'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'census_study'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'census_visit'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'census_crc_approved'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'census'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=census"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_censusResult = parsedData.censusReport;
                    report_showCensusResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('census_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Subject Purge

        case 'subjectpurge_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'subjectpurge_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'subjectpurge_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'subjectpurge_performing_user':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'subjectpurge_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'subjectpurge_subject'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'subjectpurge_mrn'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'subjectpurge_performing_user'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'subject_purge'){
                $.post("rest/report/getReport?name=subject_purge"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_subjectPurgeResult = parsedData.subjectPurgeReport;
                    report_showSubjectPurgeResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('subjectpurge_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }



        // Override Report

        case 'override_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'override_performing_user':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'override_visit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'override_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_change_resource':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_change_rn':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_change_rd':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_change_other':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_ol_rn':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_ol_rd':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'or_ol_other':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'override_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'override_performing_user'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'override_visit'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'override_local_id'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_change_resource'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_change_rn'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_change_rd'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_change_other'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_ol_rn'){
                selectedid = 8;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_ol_rd'){
                selectedid = 9;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'or_ol_other'){
                selectedid = 10;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'override'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });

                $.post("rest/report/getReport?name=override"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_overrideResult = parsedData.overrideReport;
                    report_showOverrideResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('override_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // User Data
        case 'user_data_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'user_data_user_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'user_data_inst_role':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'user_data_user_title':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'user_data_status_active':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'user_data_status_not_active':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'user_data_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'user_data_user_name'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'user_data_inst_role'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'user_data_user_title'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'user_data_status_active'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'user_data_status_not_active'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'user_data'){
                $.post("rest/report/getReport?name=user_data"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_userDataResult = parsedData.userDataReport;
                    report_showUserDataResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('user_data_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Daily Overview

        case 'daily_overview_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'daily_overview_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_overview_visit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_overview_resource_type':
            search_string = $("#overview_resource_type option:selected").val();
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
            $('#overview_resource_type').css({display: "none"});
        case 'daily_overview_sublocation':
            search_string = $("#overview_sublocation option:selected").val();
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
            $('#overview_sublocation').css({display: "none"});
        case 'daily_overview_subject':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_overview_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'daily_overview_is_part_off_unit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'daily_overview_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_visit'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_subject'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_mrn'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_is_part_off_unit'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_resource_type'){
                search_string = $("#overview_resource_type option:selected").val();
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
                $('#report_filterButton').css({display: "inline"});
                $('#overview_resource_type').css({display: "none"});
            }
            else if ($('#report_filterSelect').val() == 'daily_overview_sublocation'){
                search_string = $("#overview_sublocation option:selected").val();
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
                $('#report_filterButton').css({display: "inline"});
                $('#overview_sublocation').css({display: "none"});
            }

            if (report_selectedReport.name == 'daily_overview'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });

                $.post("rest/report/getReport?name=daily_overview"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_dailyOverviewResult = parsedData.dailyOverviewReport;
                    report_showDailyOverviewResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('daily_overview_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        // Off Unit Report

        case 'off_unit_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'off_unit_visit':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_last_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_visit_type':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_group_nursing':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_group_nutrition':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_group_room':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_group_lab':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_group_other':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'off_unit_mrn':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'off_unit_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_visit'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_local_id'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_last_name'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_visit_type'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_group_nursing'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_group_nutrition'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_group_room'){
                selectedid = 8;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_group_lab'){
                selectedid = 9;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_group_other'){
                selectedid = 10;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'off_unit_mrn'){
                selectedid = 11;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'off_unit'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=off_unit"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_offUnitResult = parsedData.offUnitReport;
                    report_showOffUnitResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('off_unit_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Level of Service Report

        case 'levelofservice_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'levelofservice_sl_nursing':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_sl_nutrition':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_sl_processing':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_sl_setup':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_visit_type':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_appt_status':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_checkout_reason':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'levelofservice_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'levelofservice_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_sl_nursing'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_sl_nutrition'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_sl_processing'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_sl_setup'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_visit_type'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_appt_status'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_checkout_reason'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'levelofservice_crc_approved'){
                selectedid = 8;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'level_of_service'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=level_of_service"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_levelOfServiceResult = parsedData.levelOfServiceReport;
                    report_showLevelOfServiceResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('levelofservice_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Study Subject Visit Report

        case 'studysubjectvisit_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'studysubjectvisit_localId':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studysubjectvisit_appointment':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studysubjectvisit_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'studysubjectvisit_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'studysubjectvisit_localId'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studysubjectvisit_appointment'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studysubjectvisit_crc_approved'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'study_subject_visit'){
                var jsonData = JSON.stringify({
                    subjectLastName: $.trim($("#report_subjectLastName").val()),
                    subjectMRN: $.trim($("#report_subjectMRN").val()),
                    subjectDOB: $.trim($("#report_subjectDOB").val())
                });
                $.post("rest/report/getReport?name=study_subject_visit"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_studySubjectVisitResult = parsedData.studySubjectVisitReport;
                    report_showStudySubjectVisitResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('studysubjectvisit_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // Study Status Change Report

        case 'studystatuschange_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'studystatuschange_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studystatuschange_investigator':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studystatuschange_study_status':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'studystatuschange_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'studystatuschange_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'studystatuschange_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studystatuschange_investigator'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studystatuschange_study_status'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'studystatuschange_crc_approved'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'study_status_change'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=study_status_change"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_studyStatusChangeResult = parsedData.studyStatusChangeReport;
                    report_showStudyStatusChangeResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('studystatuschange_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Subject Visit History Report

        case 'subjectvisithistory_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'subjectvisithistory_localId':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'subjectvisithistory_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'subjectvisithistory_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'subjectvisithistory_localId'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'subjectvisithistory_crc_approved'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'subject_visit_history'){
                var jsonData = JSON.stringify({
                    subjectLastName: $.trim($("#report_subjectLastName").val()),
                    subjectMRN: $.trim($("#report_subjectMRN").val()),
                    subjectDOB: $.trim($("#report_subjectDOB").val())
                });
                $.post("rest/report/getReport?name=subject_visit_history"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_subjectVisitHistoryResult = parsedData.subjectVisitHistoryReport;
                    report_showSubjectVisitHistoryResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('subjectvisithistory_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //CRC Availability Report

        case 'crcavailability_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");


            if ($('#report_filterSelect').val() == 'crcavailability_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }

            if (report_selectedReport.name == 'crc_availability'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=crc_availability"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_crcAvailabilityResult = parsedData.crcAvailabilityReport;
                    report_showCRCAvailabilityResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('crcavailability_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Ancillary Only Visits By Protocol

        case 'ancillaryonlybyprotocol_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'ancillaryonlybyprotocol_localID':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'ancillaryonlybyprotocol_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'ancillaryonlybyprotocol_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'ancillaryonlybyprotocol_localID'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'ancillaryonlybyprotocol_crc_approved'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }


            if (report_selectedReport.name == 'ancillary_only_by_protocol'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=ancillary_only_by_protocol"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_ancillaryOnlyByProtocolResult = parsedData.ancillaryOnlyByProtocolReport;
                    report_showAncillaryOnlyByProtocolResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('ancillaryonlybyprotocol_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Resource Level Of Service Report

        case 'resourcelevelofservice_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'resourcelevelofservice_localID':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'resourcelevelofservice_visitName':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'resourcelevelofservice_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'resourcelevelofservice_localID'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'resourcelevelofservice_visitName'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'resource_level_of_service'){
                $.post("rest/report/getReport?name=resource_level_of_service"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_resourceLevelOfServiceResult = parsedData.levelOfServiceReport;
                    report_showResourceLevelOfServiceResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('resourcelevelofservice_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        // Nutrition Tasks Report

        case 'nutritiontasks_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'nutritiontasks_local_id':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_name':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_anthropometry_simple':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_anthropometry_complex':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_meal_plan_calculation':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_nutrient_analysis':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_education_time':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_questionnaire_time':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'nutritiontasks_crc_approved':
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'nutritiontasks_selectone'){
                selectedid = 0 ;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_local_id'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_name'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_anthropometry_simple'){
                selectedid = 3 ;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_anthropometry_complex'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_meal_plan_calculation'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_nutrient_analysis'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_education_time'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_questionnaire_time'){
                selectedid = 8;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'nutritiontasks_crc_approved'){
                selectedid = 9;
                $('#report_filterButton').attr("value", "Reset");
            }

            if (report_selectedReport.name == 'nutrition_tasks'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=nutrition_tasks"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_nutritionTasksResult = parsedData.nutritionTasksReport;
                    report_showNutritionTasksResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('nutritiontasks_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Visit Duartion By Visit Type

        case 'visitdurationbyvisittype_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'visitdurationbyvisittype_visitname':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'visitdurationbyvisittype_visittype':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'visitdurationbyvisittype_selectone'){
                selectedid = 0 ;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visitdurationbyvisittype_visitname'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visitdurationbyvisittype_visittype'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Reset");
            }

            if (report_selectedReport.name == 'visit_duration_by_visit_type'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=visit_duration_by_visit_type"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_visitDurationByVisitTypeResult = parsedData.visitDurationByVisitType;
                    report_showVisitDurationByVisitTypeResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('visitdurationbyvisittype_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }

        //Booked Visit Service levels by type

        case 'bookedvisitservicelevelbyvisittype_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'bookedvisitservicelevelbyvisittype_level0':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level1':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level2':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level3':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level4':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level5':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level6':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'bookedvisitservicelevelbyvisittype_level7':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");


            if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_selectone'){
                selectedid = -1;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level0'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level1'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level2'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level3'){
                selectedid = 3 ;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level4'){
                selectedid = 4;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level5'){
                selectedid = 5;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level6'){
                selectedid = 6;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'bookedvisitservicelevelbyvisittype_level7'){
                selectedid = 7;
                $('#report_filterButton').attr("value", "Reset");
            }


            if (report_selectedReport.name == 'booked_visit_service_level_by_visit_type'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=booked_visit_service_level_by_visit_type"+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_bookedVisitServiceLevelByTypeResult = parsedData.bookedVisitServiceLevelByTypeReport;
                    report_showBookedVisitServiceLevelByTypeResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('bookedvisitservicelevelbyvisittype_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = -1;
                });
            }

        //Visit Template Data Report

        case 'visittemplatedata_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'visittemplatedata_localID':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'visittemplatedata_visitName':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'visittemplatedata_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visittemplatedata_localID'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Filter");
            }
            else if ($('#report_filterSelect').val() == 'visittemplatedata_visitName'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Filter");
            }

            if (report_selectedReport.name == 'visit_template_data'){
                $.post("rest/report/getReport?name=visit_template_data"+'&filterString='+search_string+'&filterId='+selectedid, {}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_visitTemplateResult = parsedData.visitTemplateReport;
                    report_showVisitTemplateResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('visittemplatedata_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }


        //Visit Terminated Prior to Completion

        case 'visitterminatedpriortocompletion_selectone':
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').attr("value", "Reset");
        case 'visitterminatedpriortocompletion_level0':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'visitterminatedpriortocompletion_level1':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");
        case 'visitterminatedpriortocompletion_level2':
            search_string = $.trim($("#report_filterText").val());
            $('#report_filterText').css({display:"none"});
            $('#report_filterButton').css({display: "inline"});
            $('#report_filterButton').attr("value", "Filter");

            if ($('#report_filterSelect').val() == 'visitterminatedpriortocompletion_selectone'){
                selectedid = 0;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visitterminatedpriortocompletion_level0'){
                selectedid = 1;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visitterminatedpriortocompletion_level1'){
                selectedid = 2;
                $('#report_filterButton').attr("value", "Reset");
            }
            else if ($('#report_filterSelect').val() == 'visitterminatedpriortocompletion_level2'){
                selectedid = 3;
                $('#report_filterButton').attr("value", "Reset");
            }

            if (($("#report_filterSelect option:selected").val() != 'subjectaudit_selectone') && ($("#report_filterSelect option:selected").val() != 'staffaudit_selectone')
                && ($("#report_filterSelect option:selected").val() != 'dailyresource_selectone') && ($("#report_filterSelect option:selected").val() != 'resource_group_nursing')
                && ($("#report_filterSelect option:selected").val() != 'resource_group_room') && ($("#report_filterSelect option:selected").val() != 'resource_group_lab')
                && ($("#report_filterSelect option:selected").val() != 'resource_group_other') && ($("#report_filterSelect option:selected").val() != 'resource_group_nutrition')
                && ($("#report_filterSelect option:selected").val() != 'daily_adm_selectone') && ($("#report_filterSelect option:selected").val() != 'metakitch_selectone')
                && ($("#report_filterSelect option:selected").val() != 'weeklypharm_selectone')
                && ($("#report_filterSelect option:selected").val() != 'protonurse_selectone') && ($("#report_filterSelect option:selected").val() != 'studyvisitlocation_selectone')
                && ($("#report_filterSelect option:selected").val() != 'deptandpi_selectone') && ($("#report_filterSelect option:selected").val() != 'billing_selectone')
                && ($("#report_filterSelect option:selected").val() != 'billable_resources_selectone') && ($("#report_filterSelect option:selected").val() != 'billingbyinvestigator_selectone')
                && ($("#report_filterSelect option:selected").val() != 'transactions_selectone') && ($("#report_filterSelect option:selected").val() != 'census_selectone')
                && ($("#report_filterSelect option:selected").val() != 'subjectpurge_selectone') && ($("#report_filterSelect option:selected").val() != 'override_selectone')
                && ($("#report_filterSelect option:selected").val() != 'or_change_resource') && ($("#report_filterSelect option:selected").val() != 'or_change_rn')
                && ($("#report_filterSelect option:selected").val() != 'or_change_rd') && ($("#report_filterSelect option:selected").val() != 'or_change_other')
                && ($("#report_filterSelect option:selected").val() != 'or_ol_rn') && ($("#report_filterSelect option:selected").val() != 'or_ol_rd')
                && ($("#report_filterSelect option:selected").val() != 'or_ol_other')
                && ($("#report_filterSelect option:selected").val() != 'user_data_selectone')
                && ($("#report_filterSelect option:selected").val() != 'user_data_status_active') && ($("#report_filterSelect option:selected").val() != 'user_data_status_not_active')
                && ($("#report_filterSelect option:selected").val() != 'daily_overview_selectone') && ($("#report_filterSelect option:selected").val() != 'off_unit_selectone')
                && ($("#report_filterSelect option:selected").val() != 'levelofservice_selectone') && ($("#report_filterSelect option:selected").val() != 'metakitchbytime_selectone')
                && ($("#report_filterSelect option:selected").val() != 'studysubjectvisit_selectone') && ($("#report_filterSelect option:selected").val() != 'subjectvisithistory_selectone')
                && ($("#report_filterSelect option:selected").val() != 'studystatuschange_selectone') && ($("#report_filterSelect option:selected").val() != 'crcavailability_selectone')
                && ($("#report_filterSelect option:selected").val() != 'resourcelevelofservice_selectone') && ($("#report_filterSelect option:selected").val() != 'nutritiontasks_selectone')
                && ($("#report_filterSelect option:selected").val() != 'visittemplatedata_selectone') && ($("#report_filterSelect option:selected").val() != 'visitdurationbyvisittype_selectone')
                && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_selectone') && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level0')
                && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level1')  && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level2')
                && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level3')  && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level4')
                && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level5')  && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level6')
                && ($("#report_filterSelect option:selected").val() != 'bookedvisitservicelevelbyvisittype_level7')  && ($("#report_filterSelect option:selected").val() != 'visitterminatedpriortocompletion_selectone')
                && ($("#report_filterSelect option:selected").val() != 'daily_resource_crc_approved') && ($("#report_filterSelect option:selected").val() != 'deptandpi_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'levelofservice_crc_approved') && ($("#report_filterSelect option:selected").val() != 'metakitch_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'metakitchbytime_crc_approved') && ($("#report_filterSelect option:selected").val() != 'nutritiontasks_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'off_unit_crc_approved') && ($("#report_filterSelect option:selected").val() != 'studystatuschange_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'studyvisitlocation_crc_approved') && ($("#report_filterSelect option:selected").val() != 'subjectvisithistory_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'weeklypharm_crc_approved') && ($("#report_filterSelect option:selected").val() != 'daily_adm_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'billing_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'census_crc_approved') && ($("#report_filterSelect option:selected").val() != 'billingbyinvestigator_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'ancillaryonlybyprotocol_selectone') && ($("#report_filterSelect option:selected").val() != 'ancillaryonlybyprotocol_crc_approved')
                && ($("#report_filterSelect option:selected").val() != 'billingbyinvestigator_industry_initiated') && ($("#report_filterSelect option:selected").val() != 'billing_industry_initiated')
                && ($("#report_filterSelect option:selected").val() != 'billable_resources_crc_approved') && ($("#report_filterSelect option:selected").val() != 'billable_resources_industry_initiated')
                && ($("#report_filterSelect option:selected").val() != 'protonutritionist_selectone') && ($("#report_filterSelect option:selected").val() != 'off_unit_group_nursing')
                && ($("#report_filterSelect option:selected").val() != 'off_unit_group_room') && ($("#report_filterSelect option:selected").val() != 'off_unit_group_lab')
                && ($("#report_filterSelect option:selected").val() != 'off_unit_group_other') && ($("#report_filterSelect option:selected").val() != 'off_unit_group_nutrition')){

                if(($("#report_filterSelect option:selected").val() != 'daily_overview_selectone') && ($("#overview_resource_type option:selected").val() != null)){
                    search_string = $("#overview_resource_type option:selected").val();
                }
                else if(($("#report_filterSelect option:selected").val() != 'daily_overview_selectone') && ($("#overview_sublocation option:selected").val() != null)){
                    search_string = $("#overview_sublocation option:selected").val();
                }

                if (search_string == null || search_string == ''){
                    util_showMainMessage("Please Enter the Filter Value.");
                    $("#report_filterSelect option:selected").val();
                    $("#report_filterText").val('');
                    return;
                }
            }
            else {
                $('#report_filterButton').attr("value", "Filter");
                $('#report_filterButton').css({display: "none"});
            }

            if (report_selectedReport.name == 'visit_terminated_prior_to_completion'){
                var jsonData = JSON.stringify({
                    startTime: getStartTime(),
                    endTime: getEndTime()
                });
                $.post("rest/report/getReport?name=visit_terminated_prior_to_completion"+'&filterString='+search_string+'&filterId='+selectedid, {data:jsonData}, function(data) {
                    parsedData = $.parseJSON(data);
                    report_visitTerminatedPriorToCompletionResult = parsedData.visitTerminatedPriorToCompletion;
                    report_showVisitTerminatedPriorToCompletionResults();
                    $('#report_filterButton').css({display:"inline"});
                    $('#report_filterButton').attr("value", "Reset");
                    $("#report_filterText").val('');
                    $('#report_filterSelect').val('visitterminatedpriortocompletion_selectone');
                    $('#report_filterText').css({display:"none"});
                    selectedid = 0;
                });
            }
    }
}

function report_createWidgets() {
    $("#report_startDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true,
        onSelect: function (selectedDate) {
            $("#report_endDate").datepicker("option", "minDate", selectedDate);
        }
    });

    $("#report_endDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true
    });
    $("#report_startDate").datepicker("setDate", new Date());
    $("#report_startDate").mask("99/99/9999");
    $("#report_endDate").datepicker("setDate", new Date());
    $("#report_endDate").mask("99/99/9999");
}

function report_getAncillaryOnlyByProtocolReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=ancillary_only_by_protocol", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_ancillaryOnlyByProtocolResult = parsedData.ancillaryOnlyByProtocolReport;
        report_showAncillaryOnlyByProtocolResults();
    });
}

function report_getVisitDurationByVisitTypeReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=visit_duration_by_visit_type", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_visitDurationByVisitTypeResult = parsedData.visitDurationByVisitType;
        report_showVisitDurationByVisitTypeResults();
    });
}

function report_getProtoNurseReport() {
    $.post("rest/report/getReport?name=proto_nurse", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_protoNurseResult = parsedData.protoNurseNutritionReport;
        report_showProtoNurseResults();
    });
}

function report_getReport(url, resultVar, showFunction) {
    $.get(url, {}, function(data) {
        parsedData = $.parseJSON(data);

        window[resultVar] = parsedData;

        showFunction();
    })
        .error(handleReportErrorFromBackEnd);
}

function timedUrl(url) {
    startTime = getStartTime();
    endTime = getEndTime();

    url += "?startTime=" + startTime;
    url += "&endTime=" + endTime;

    return url;
}
function report_getInitialStudyDataReport() {
    report_getReport("rest/report/studyDataReport", 'report_studyDataResult', report_showStudyDataResults);
}

function report_getInitialCancellationsReport() {
    url = timedUrl("rest/report/cancellationsReport");
    $.get("rest/app/getStaticLists", {}, function(data) {
        var parsedData = $.parseJSON(data);
        var cancellationReasons = parsedData.cancellationReasons;
        var cancellationReasonSelectOptions = buildSelectOptions(cancellationReasons, 'name', 'choose');
        $("#cancellationReasons").html(cancellationReasonSelectOptions);
    });
    report_getReport(url, 'report_cancellationsResult', report_showCancellationsResults);
}

function report_getProtoNutritionistReport() {
    $.post("rest/report/getReport?name=proto_nutritionist", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_protoNutritionistResult = parsedData.protoNurseNutritionReport;
        report_showProtoNutritionistResults();
    });
}

function report_getSubjectPurgeReport() {
    $.post("rest/report/getReport?name=subject_purge", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_subjectPurgeResult = parsedData.subjectPurgeReport;
        report_showSubjectPurgeResults();
    });
}

function report_getVisitTemplateDataReport() {
    $.post("rest/report/getReport?name=visit_template_data", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_visitTemplateResult = parsedData.visitTemplateReport;
        report_showVisitTemplateResults();
    });
}


function report_getStaffAuditSubjectViewsReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=staff_audit_subject_views", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_staffAuditSubjectViewsResult = parsedData.staffAuditSubjectViewsReport;
        report_showStaffAuditSubjectViewsResults();
    });
}

function report_getSubjectAuditStaffViewsReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime(),
        mrn: $.trim($("#report_mrn").val())
    });
    $.post("rest/report/getReport?name=subject_audit_staff_views", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_subjectAuditStaffViewsResult = parsedData.subjectAuditStaffViewsReport;
        report_showSubjectAuditStaffViewsResults();
    });
}

function report_getOverrideReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=override", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_overrideResult = parsedData.overrideReport;
        report_showOverrideResults();
    });
}


function report_getOffUnitReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=off_unit", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_offUnitResult = parsedData.offUnitReport;
        report_showOffUnitResults();
    });
}


function report_getDailyOverviewReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=daily_overview", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_dailyOverviewResult = parsedData.dailyOverviewReport;
        report_showDailyOverviewResults();
    });
}

function report_getVisitsFlaggedReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=visits_flagged_edit", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_visitsFlaggedResult = parsedData.visitsFlaggedResult;
        report_showVisitsFlaggedResults();
    });
}


function report_getWeeklyPharmReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=weekly_pharm", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_weeklyPharmResult = parsedData.weeklyPharmReport;
        report_showWeeklyPharmResults();
    });
}

function isItBadMessage(parsedData) {
    result = false; // optimism

    if (parsedData.badMessage) {
        $('#report_results').html(parsedData.badMessage);
        report_handleDataResponse(0);
        result = true;
    }
    return result;
}

function report_getStudyVisitLocationReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=study_visit_location", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_studyVisitLocationResult = parsedData.studyVisitLocationReport;
        report_showStudyVisitLocationResults();
    });
}

function report_getUserDataReport() {
    $.post("rest/report/getReport?name=user_data", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_userDataResult = parsedData.userDataReport;
        report_showUserDataResults();
    });
}

function report_getBillableResourcesReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=billable_resources", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_billableResourcesResult = parsedData.billableResourcesReport;
        report_showBillableResourcesResults();
    });
}

function report_getTransactionsReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=transactions", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_transactionsResult = parsedData.transactionsReport;
        report_showTransactionsResults();
    });
}

function report_getDailyResourceReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=daily_resource", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_dailyResourceResult = parsedData.dailyResourceReport;
        report_showDailyResourceResults();
    });
}

function report_getDailyAdmReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=daily_adm", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_dailyAdmResult = parsedData.dailyAdmReport;
        report_showDailyAdmResults();
    });
}

function report_getMetaKitchenReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=meta_kitchen", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_metaKitchenResult = parsedData.metaKitchenReport;
        report_showMetaKitchenResults();
    });
}

function report_getMetaKitchenByTimeReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=meta_kitchen_by_time", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_metaKitchenByTimeResult = parsedData.metaKitchenReport;
        report_showMetaKitchenByTimeResults();
    });
}

function report_getDeptAndPiReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=dept_and_pi", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_deptAndPiResult = parsedData.deptAndPiReport;
        report_showDeptAndPiResults();
    });
}


function report_getBillingReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=billing", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_billingResult = parsedData.billingReport;
        report_showBillingResults();
    });
}


function report_getBillingByInvestigatorReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime(),
        piFirstName: $.trim($("#report_piFirstName").val()),
        piLastName: $.trim($("#report_piLastName").val())
    });
    $.post("rest/report/getReport?name=billing_by_investigator", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_billingByInvestigatorResult = parsedData.billingByInvestigatorReport;
        report_showBillingByInvestigatorResults();
    });
}


function report_getCensusReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=census", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_censusResult = parsedData.censusReport;
        report_showCensusResults();
    });
}


function report_getLevelOfServiceReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=level_of_service", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_levelOfServiceResult = parsedData.levelOfServiceReport;
        report_showLevelOfServiceResults();
    });
}

function report_getResourceLevelOfServiceReport() {
    $.post("rest/report/getReport?name=resource_level_of_service", {}, function(data) {
        parsedData = $.parseJSON(data);
        report_resourceLevelOfServiceResult = parsedData.levelOfServiceReport;
        report_showResourceLevelOfServiceResults();
    });
}


function report_getStudySubjectVisitReport() {
    var jsonData = JSON.stringify({
        subjectLastName: $.trim($("#report_subjectLastName").val()),
        subjectMRN: $.trim($("#report_subjectMRN").val()),
        subjectDOB: $.trim($("#report_subjectDOB").val())});
    $.post("rest/report/getReport?name=study_subject_visit", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_studySubjectVisitResult = parsedData.studySubjectVisitReport;
        report_showStudySubjectVisitResults();
    });
}

function report_getStudyStatusChangeReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=study_status_change", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_studyStatusChangeResult = parsedData.studyStatusChangeReport;
        report_showStudyStatusChangeResults();
    });
}

function report_getSubjectVisitHistoryReport() {
    var jsonData = JSON.stringify({
        subjectLastName: $.trim($("#report_subjectLastName").val()),
        subjectMRN: $.trim($("#report_subjectMRN").val()),
        subjectDOB: $.trim($("#report_subjectDOB").val())});
    $.post("rest/report/getReport?name=subject_visit_history", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_subjectVisitHistoryResult = parsedData.subjectVisitHistoryReport;
        report_showSubjectVisitHistoryResults();
    });
}

function report_getCRCAvailabilityReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=crc_availability", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_crcAvailabilityResult = parsedData.crcAvailabilityReport;
        report_showCRCAvailabilityResults();
    });
}

function report_getNutritionTasksReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=nutrition_tasks", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_nutritionTasksResult = parsedData.nutritionTasksReport;
        report_showNutritionTasksResults();
    });
}


function report_getBookedVisitServiceLevelByTypeReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=booked_visit_service_level_by_visit_type", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_bookedVisitServiceLevelByTypeResult = parsedData.bookedVisitServiceLevelByTypeReport;
        report_showBookedVisitServiceLevelByTypeResults();
    });
}

function report_getRoomAvailabilityCheckReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=room_availability_check", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_roomAvailabilityCheckResult = parsedData.roomAvailabilityCheck;
        report_showRoomAvailabilityCheckResults();
    });
}

function report_getVisitTerminatedPriorToCompletionReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=visit_terminated_prior_to_completion", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_visitTerminatedPriorToCompletionResult = parsedData.visitTerminatedPriorToCompletion;
        report_showVisitTerminatedPriorToCompletionResults();
    });
}

function report_renderReportGrid() {
    commonData();
    $.getJSON("rest/report/getReports", function(data) {
        var iteration = 0;

        var out =
            " <table id='reports'>" +
            "  <tr>" +
            "   <td><strong>Name</strong></td> " +
            "   <td><strong>Description</strong></td>" +
            "  </tr> ";

        $.each(data.reports, function(key, val) {
            out +=  "<tr onclick='getReportSelectedRowId("+val.id+")'>"
            out += "   <td>" + val.title + "</td>" +
                "          <td>" + val.description + "</td>" +
                " </tr>";
            iteration++;
        });

        out += "  </table>";

        $('#reportDataTable').html(out);
    });
}

function getReportSelectedRowId(id) {
    $.getJSON("rest/report/getReportData?id="+id, function(data) {
        sessionStorage.setItem("reportData", JSON.stringify(data));
        window.location.href = "report_screen.html";
    });
}

function submitReport() {
    var isValid = true;
    $('.formElementRequired').css({visibility: "hidden"});

    if (report_selectedReport.name != 'proto_by_nurse' &&
        report_selectedReport.name != 'proto_by_nutritionist' &&
        report_selectedReport.name != 'subject_purge' &&
        report_selectedReport.name != 'study_data' &&
        report_selectedReport.name != 'user_session' &&
        report_selectedReport.name != 'user_data' &&
        report_selectedReport.name != 'resource_level_of_service' &&
        report_selectedReport.name != 'visit_template_data' ) {

        var report_startDateVal = $("#report_startDate").datepicker('getDate');
        var report_endDateVal = $("#report_endDate").datepicker('getDate');

        if (report_startDateVal == null) {
            showError('#report_startDateValidation', 'Please enter valid start date');
            isValid = false;
        }
        if (report_endDateVal == null) {
            showError('#report_endDateValidation', 'Please enter valid end date');
            isValid = false;
        }
        if (report_startDateVal > report_endDateVal) {
            showError('#report_startDateValidation', 'Please enter valid date range');
            showError('#report_endDateValidation', 'Please enter valid date range');
            isValid = false;
        }
    }
    if (report_selectedReport.name == 'subject_audit_staff_views') {
        if($.trim($("#report_mrn").val()).length < 1) {
            showError('#report_mrnValidation');
            isValid = false;
        }
    }

    if (report_selectedReport.name == 'subject_visit_history' || report_selectedReport.name == 'study_subject_visit') {
        if (($.trim($("#report_subjectLastName").val()).length < 1) && ($.trim($("#report_subjectMRN").val()).length < 1)
            && ($.trim($("#report_subjectDOB").val()).length < 1))  {
            util_showMainMessage("Please enter value for at least one of the fields.");
            isValid = false;
        }
    }

    if (isValid == false) {
        return;
    }

    $('#report_loadMessage').css({display: "block"});
    $('#report_emptyMessage').css({display: "none"});
    $('#report_result_screen').css({display: "block"});
    $('#report_results').html('');
    $("#report_sortDirectionSelect").val(1);
    $('#report_downloadButton').css({display: "inline-block"});
    $('#report_customdownloadButton').css({display: "none"});
    $('#report_flatloadButton').css({display: "none"});
    if (report_selectedReport.name == 'crc_availability' || report_selectedReport.name == 'visits_flagged_edit'){
        $('#filter_functionality').css({display: "none"});
    }
    else {
        $('#filter_functionality').css({display: "inline-block"});
    }
    if (report_selectedReport.name == 'subject_audit_staff_views'
        || report_selectedReport.name == 'crc_availability'
        || report_selectedReport.name == 'visits_flagged_edit'

        || report_selectedReport.name == 'study_data'
        || report_selectedReport.name == 'cancellations'

    ){
        $('#sort_functionality').css({display: "none"});
    }
    else {
        $('#sort_functionality').css({display: "inline-block"});
    }

    if (report_selectedReport.name == 'daily_overview' || report_selectedReport.name == 'daily_resource'){
        $('#report_customdownloadButton').css({display: "inline-block"});
        var buttonVal = "Nutrition Export";
        report_selectedReport.name == 'daily_overview' ? buttonVal = "Nursing & Room Export" : buttonVal;
        document.getElementById("report_customdownloadButton").value = buttonVal;
    }
    else {
        $('#report_customdownloadButton').css({display: "none"});
    }

    if (report_selectedReport.name == 'meta_kitchen'){
        $('#report_flatloadButton').css({display: "inline-block"});
    }
    else {
        $('#report_flatloadButton').css({display: "none"});
    }

    if (report_selectedReport.name == 'user_data') { report_getUserDataReport(); }
    else if (report_selectedReport.name == 'weekly_pharm') { report_getWeeklyPharmReport(); }
    else if (report_selectedReport.name == 'study_visit_location') { report_getStudyVisitLocationReport(); }
    else if (report_selectedReport.name == 'billable_resources') { report_getBillableResourcesReport(); }
    else if (report_selectedReport.name == 'transactions') { report_getTransactionsReport(); }
    else if (report_selectedReport.name == 'daily_resource') { report_getDailyResourceReport(); }
    else if (report_selectedReport.name == 'daily_adm') { report_getDailyAdmReport(); }
    else if (report_selectedReport.name == 'meta_kitchen') { report_getMetaKitchenReport(); }
    else if (report_selectedReport.name == 'meta_kitchen_by_time') { report_getMetaKitchenByTimeReport(); }
    else if (report_selectedReport.name == 'dept_and_pi') { report_getDeptAndPiReport(); }
    else if (report_selectedReport.name == 'billing') { report_getBillingReport(); }
    else if (report_selectedReport.name == 'billing_by_investigator') { report_getBillingByInvestigatorReport(); }
    else if (report_selectedReport.name == 'census') { report_getCensusReport(); }
    else if (report_selectedReport.name == 'level_of_service') { report_getLevelOfServiceReport(); }
    else if (report_selectedReport.name == 'study_subject_visit') { report_getStudySubjectVisitReport(); }
    else if (report_selectedReport.name == 'study_status_change') { report_getStudyStatusChangeReport(); }
    else if (report_selectedReport.name == 'subject_visit_history') { report_getSubjectVisitHistoryReport(); }
    else if (report_selectedReport.name == 'crc_availability') { report_getCRCAvailabilityReport(); }
    else if (report_selectedReport.name == 'resource_level_of_service') { report_getResourceLevelOfServiceReport(); }
    else if (report_selectedReport.name == 'visit_template_data') { report_getVisitTemplateDataReport(); }
    else if (report_selectedReport.name == 'visit_duration_by_visit_type') { report_getVisitDurationByVisitTypeReport(); }
    else if (report_selectedReport.name == 'booked_visit_service_level_by_visit_type') { report_getBookedVisitServiceLevelByTypeReport(); }
    else if (report_selectedReport.name == 'room_availability_check') { report_getRoomAvailabilityCheckReport(); }
    else if (report_selectedReport.name == 'nutrition_tasks') { report_getNutritionTasksReport(); }
    else if (report_selectedReport.name == 'visit_terminated_prior_to_completion') { report_getVisitTerminatedPriorToCompletionReport(); }
    else if (report_selectedReport.name == 'ancillary_only_by_protocol') { report_getAncillaryOnlyByProtocolReport(); }
    else if (report_selectedReport.name == 'visits_flagged_edit') { report_getVisitsFlaggedReport(); }
    else if (report_selectedReport.name == 'daily_overview') { report_getDailyOverviewReport(); }
    else if (report_selectedReport.name == 'off_unit') { report_getOffUnitReport(); }
    else if (report_selectedReport.name == 'subject_purge') { report_getSubjectPurgeReport(); }
    else if (report_selectedReport.name == 'override') { report_getOverrideReport(); }
    else if (report_selectedReport.name == 'subject_audit_staff_views') { report_getSubjectAuditStaffViewsReport(); }
    else if (report_selectedReport.name == 'staff_audit_subject_views') { report_getStaffAuditSubjectViewsReport(); }
    else if (report_selectedReport.name == 'proto_by_nutritionist') { report_getProtoNutritionistReport(); }
    else if (report_selectedReport.name == 'proto_by_nurse') { report_getProtoNurseReport(); }

    else if (report_selectedReport.name == 'study_data') { report_getInitialStudyDataReport(); }
    else if (report_selectedReport.name == 'cancellations') { report_getInitialCancellationsReport(); }
}

function report_clearForm() {
    $('#report_piFirstName').val('');
    $('#report_piLastName').val('');
    $('#report_mrn').val('');
    $('#report_subjectLastName').val('');
    $('#report_subjectMRN').val('');
    $('#report_subjectDOB').val('');
    $('.formElementRequired').css({visibility: "hidden"});
}

function report_handleDataResponse(rowCount) {
    $('#report_loadMessage').css({display: "none"});
    if(rowCount < 1) {
        $('#report_emptyMessage').css({display: "block"});
    }
    else {
        $('#report_emptyMessage').css({display: "none"});
    }
}

function report_showStudyDataResults() {
    var out = "";
    report_handleDataResponse(report_studyDataResult.length);
    exportStr = '';

    for (var i=0;i< report_studyDataResult.length;i++) {

        var r = report_studyDataResult[i];

        var fourFundInfosArray = getFourFundingSources(r);

        var funding1 = fourFundInfosArray[0].name;
        var comment1 = fourFundInfosArray[0].comment;
        var funding2 = fourFundInfosArray[1].name;
        var comment2 = fourFundInfosArray[1].comment;
        var funding3 = fourFundInfosArray[2].name;
        var comment3 = fourFundInfosArray[2].comment;
        var funding4 = fourFundInfosArray[3].name;
        var comment4 = fourFundInfosArray[3].comment;

        out +=
            "    <div class='reportRow'>" +
            "      <div class='secondaryNameBlock'>" +
            "       <div class='mainName'>" + r.localId + "</div>" +
            "      </div>" +
            "      <div style='clear: both;'></div>" +
            "      <table width='100%' border='0' cellspacing='0' cellpadding='5'>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Study Name</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.name + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>PI Name</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.investigator) + "</td>" +
            "        </tr>";
        out +=
            "        <tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Institution</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.institution.longName) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>PI email</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.investigator.email) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Local ID</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.localId + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>PI phone #1</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.investigator.primaryPhone) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Catalyst ID</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.catalystId) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>PI pager</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.investigator.pager) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Status</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.studyStatus.shortName + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Primary Scheduling Contact</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.scheduler) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Last Status Change</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDateTime(r.statusChange) + "</td>" +
            "          <td width='25%' align='left' valign='top' style='font-weight:bold'>Primary Scheduling Contact email</td>" +
            "          <td width='25%' align='left' valign='top'>" + showValue(r.scheduler.email) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB #</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.irb) + "</td>" +
            "          <td width='25%' align='left' valign='top' style='font-weight:bold'>Primary Scheduling Contact phone</td>" +
            "          <td width='25%' align='left' valign='top'>" + showValue(r.scheduler.primaryPhone) + "</td>" +
            "        </tr>" +
            "        <tr>";
        out +=
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB Institution</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.irbInstitution.name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Secondary Scheduling Contact</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.secondaryScheduler) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB Approval Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDate(r.irbApprovalDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Secondary Scheduling Contact Email</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.secondaryScheduler.email) + "</td>" +
            "        </tr>";
        out +=

            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB Renewal Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDate(r.irbRenewalDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Secondary Scheduling Contact phone</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.secondaryScheduler.primaryPhone)  + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB Expiration Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDate(r.irbExpiration) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Third Scheduling Contact</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.scheduler3) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>CRC Approved</td>" +
            "          <td width='29%' align='left' valign='top'>" + yesNoValue(r.crcFunded) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Third Scheduling Contact Email</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.scheduler3.email) + "</td>" +
            "        </tr>" +
            "        <tr>";
        out +=

            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>CRC Category</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.crcCategory + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Third Scheduling Contact Phone</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.scheduler3.primaryPhone) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Industry Inititated</td>" +
            "          <td width='29%' align='left' valign='top'>" + yesNoValue(r.industryInitiated) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 1</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.physician) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Source 1</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(funding1) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 1 email</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician.email) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Comment 1</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(comment1) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 1 phone #1</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician.primaryPhone) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Source 2</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(funding2) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 1 pager</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician.pager) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Comment 2</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(comment2) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 2</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.physician2) + "</td>" +
            "        </tr>";
        out +=
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Source 3</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(funding3) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 2 email</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician2.email) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Comment 3</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(comment3) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 2 phone #1</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician2.primaryPhone) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Source 4</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(funding4) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Responsible Physician 2 pager</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.physician2.pager) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Funding Comment 4</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(comment4) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Protocol Nurse</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.protocolNurse)  + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Start Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDate(r.expectedStartDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Associate Protocol Nurse</td>" +
            "          <td width='29%' align='left' valign='top'>" + buildFullName(r.associateNurse) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>End Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDate(r.expectedEndDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Protocol Nutritionist</td>" +
            "          <td width='29%' align='left' valign='top'>"  + buildFullName(r.protocolNutritionist)  + "</td>" +
            "        </tr>";
        out +=

            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>First Visit Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDateTime(r.firstVisitDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Associate Protocol Nutritionist</td>" +
            "          <td width='29%' align='left' valign='top'>"  + buildFullName(r.associateProtocolNutritionist)  + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Last Scheduled Visit Date</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDateTime(r.lastScheduledVisitDate) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Total Inpatient Visits</td>" +
            "          <td width='29%' align='left' valign='top'>"  + showValue(r.totalInpatientVisits)  + "</td>" +
            "        </tr>" +
            "        <tr>";
        out +=
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Total Subjects</td>" +
            "          <td width='29%' align='left' valign='top'>"  + showValue(r.totalSubjects)  + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Total Outpatient Visits</td>" +
            "          <td width='29%' align='left' valign='top'>"  + showValue(r.totalOutpatientVisits)  + "</td>" +
            "        </tr>" +
            "      </table>" +
            "    </div>" +
            "    <hr class='report' />";


        if (i == 0) {
            exportStr +=
                "Study Name," +
                "Institution," +
                "Local ID," +
                "Catalyst ID," +
                "Status," +
                "Last Status Change," +
                "IRB #," +
                "IRB Institution," +
                "IRB Approval Date," +
                "IRB Renewal Date," +
                "IRB Expiration Date," +
                "CRC Approved," +
                "CRC Category," +
                "Industry Initiated," +
                "Start Date," +
                "End Date," +
                "First Visit Date," +
                "Last Scheduled Visit Date," +
                "Total Inpatient Visits," +
                "Total Outpatient Visits," +
                "Total Subjects," +

                "Funding Source 1," +
                "Funding Centers and Institutes 1," +
                "Funding Grant ID 1," +
                "Funding Site Cost Center 1," +
                "Funding Total Direct Dollar Award 1," +
                "Funding Total Indirect Dollar Award 1," +
                "Funding Project Start Date 1," +
                "Funding Project End Date 1," +
                "Funding Comment 1," +

                "Funding Source 2," +
                "Funding Centers and Institutes 2," +
                "Funding Grant ID 2," +
                "Funding Site Cost Center 2," +
                "Funding Total Direct Dollar Award 2," +
                "Funding Total Indirect Dollar Award 2," +
                "Funding Project Start Date 2," +
                "Funding Project End Date 2," +
                "Funding Comment 2," +

                "Funding Source 3," +
                "Funding Centers and Institutes 3," +
                "Funding Grant ID 3," +
                "Funding Site Cost Center 3," +
                "Funding Total Direct Dollar Award 3," +
                "Funding Total Indirect Dollar Award 3," +
                "Funding Project Start Date 3," +
                "Funding Project End Date 3," +
                "Funding Comment 3," +

                "Funding Source 4," +
                "Funding Centers and Institutes 4," +
                "Funding Grant ID 4," +
                "Funding Site Cost Center 4," +
                "Funding Total Direct Dollar Award 4," +
                "Funding Total Indirect Dollar Award 4," +
                "Funding Project Start Date 4," +
                "Funding Project End Date 4," +
                "Funding Comment 4," +

                "PI Name," +
                "PI Email," +
                "PI Phone #1," +
                "PI Pager," +
                "Primary Scheduling Contact," +
                "Primary Scheduling Contact Email," +
                "Primary Scheduling Contact Phone," +
                "Secondary Scheduling Contact," +
                "Secondary Scheduling Contact Email," +
                "Secondary Scheduling Contact Phone," +
                "Third Scheduling Contact," +
                "Third Scheduling Contact Email," +
                "Third Scheduling Contact Phone," +
                "Responsible Physician 1," +
                "Responsible Physician 1 email," +
                "Responsible Physician 1 Phone#1," +
                "Responsible Physician 1 Pager," +
                "Responsible Physician 2," +
                "Responsible Physician 2 Email," +
                "Responsible Physician 2 Phone#1," +
                "Responsible Physician 2 Pager," +
                "Protocol Nurse," +
                "Associate Protocol Nurse," +
                "Protocol Nutritionist," +
                "Associate Protocol Nutritionist" +
                "";

            exportStr += '\n';
        }

        exportStr += '\"'
            +removeAdditionalComma(r.name)                    +'\",\"'
            +removeAdditionalComma(r.institution.longName)    +'\",\"'
            +removeAdditionalComma(r.localId)                 +'\",\"'
            +showValue(r.catalystId)                          +'\",\"'
            +r.studyStatus.shortName                          +'\",\"'
            +showDateTime(r.statusChange)                     +'\",\"'
            +showValue(r.irb)                                 +'\",\"'
            +showValue(r.irbInstitution.name)                 +'\",\"'
            +showDate(r.irbApprovalDate)                      +'\",\"'
            +showDate(r.irbRenewalDate)                       +'\",\"'
            +showDate(r.irbExpiration)                        +'\",\"'
            +yesNoValue(r.crcFunded)                          +'\",\"'
            +r.crcCategory                                    +'\",\"'
            +yesNoValue(r.industryInitiated)                  +'\",\"'
            +showDate(r.expectedStartDate)                    +'\",\"'
            +showDate(r.expectedEndDate)                      +'\",\"'
            +showDateTime(r.firstVisitDate)                   +'\",\"'
            +showDateTime(r.lastScheduledVisitDate)           +'\",\"'
            +showValue(r.totalInpatientVisits )               +'\",\"'
            +showValue(r.totalOutpatientVisits)               +'\",\"'
            +showValue(r.totalSubjects)                       +'\",\"'

            +exportFundInfosArray(fourFundInfosArray)

            + buildFullName(r.investigator)                   +'\",\"'
            +showValue(r.investigator.email)                  +'\",\"'
            +showValue(r.investigator.primaryPhone)           +'\",\"'
            +showValue(r.investigator.pager)                  +'\",\"'
            +buildFullName(r.scheduler)                       +'\",\"'
            +showValue(r.scheduler.email)                     +'\",\"'
            +showValue(r.scheduler.primaryPhone)              +'\",\"'
            +buildFullName(r.secondaryScheduler)              +'\",\"'
            +showValue(r.secondaryScheduler.email)            +'\",\"'
            +showValue(r.secondaryScheduler.primaryPhone)     +'\",\"'
            +buildFullName(r.scheduler3)                      +'\",\"'
            +showValue(r.scheduler3.email)                    +'\",\"'
            +showValue(r.scheduler3.primaryPhone)             +'\",\"'
            +buildFullName(r.physician)                       +'\",\"'
            +showValue(r.physician.email)                     +'\",\"'
            +showValue(r.physician.primaryPhone)              +'\",\"'
            +showValue(r.physician.pager)                     +'\",\"'
            +buildFullName(r.physician2)                      +'\",\"'
            +showValue(r.physician2.email)                    +'\",\"'
            +showValue(r.physician2.primaryPhone)             +'\",\"'
            +showValue(r.physician2.pager)                    +'\",\"'
            +buildFullName(r.protocolNurse)                   +'\",\"'
            +buildFullName(r.associateNurse)                  +'\",\"'
            +buildFullName(r.protocolNutritionist)            +'\",\"'
            +buildFullName(r.associateProtocolNutritionist)   +'\"'   // last one
            + "";

        exportStr += '\n';
    }

    $('#report_results').html(out);
}

function getFourFundingSources(r) {
    var fundingSourceInfoList = r.fundingSourceInfoList;

    var displayFourFundInfos = new Array();

    var listToOrderedFundInfo = new Object();
    for (var i=0; i<fundingSourceInfoList.length; i++) {
        var fundInfo = fundingSourceInfoList[i];
        var oneToFour = fundInfo.oneToFour;

        listToOrderedFundInfo[oneToFour] = fundInfo;
    }

    for (var i=1; i<5; i++) {
        var displayFundInfo = new Object();

        displayFundInfo.name = '';
        displayFundInfo.centers = '';
        displayFundInfo.grant = '';
        displayFundInfo.costCenter = '';
        displayFundInfo.direct = '';
        displayFundInfo.indirect = '';
        displayFundInfo.start = '';
        displayFundInfo.end = '';
        displayFundInfo.comment = '';

        var fundInfo = listToOrderedFundInfo[i];
        if (fundInfo != null) {
            displayFundInfo.name =                        fundInfo.name ? fundInfo.name : '';
            displayFundInfo.centers = fundInfo.centerAndInstitutionName ? fundInfo.centerAndInstitutionName : '';
            displayFundInfo.grant =                      fundInfo.grant ? fundInfo.grant : '';
            displayFundInfo.costCenter =                fundInfo.center ? fundInfo.center : '';
            displayFundInfo.direct =               fundInfo.directAward ? fundInfo.directAward : '';
            displayFundInfo.indirect =           fundInfo.indirectAward ? fundInfo.indirectAward : '';
            displayFundInfo.start =                      fundInfo.start ? fundInfo.start : '';
            displayFundInfo.end =                          fundInfo.end ? fundInfo.end : '';
            displayFundInfo.comment =                  fundInfo.comment ? fundInfo.comment : '';
        }

        displayFourFundInfos.push(displayFundInfo);
    }

    return displayFourFundInfos;
}

function exportFundInfosArray(fundInfoArray) {
    var result = "";

    for (var i=0; i<4; i++) {
        displayFundInfo = fundInfoArray[i];

        result +=
            displayFundInfo.name       +'\",\"' +
            displayFundInfo.centers    +'\",\"' +
            displayFundInfo.grant      +'\",\"' +
            displayFundInfo.costCenter +'\",\"' +
            displayFundInfo.direct     +'\",\"' +
            displayFundInfo.indirect   +'\",\"' +
            showDate(displayFundInfo.start)      +'\",\"' +
            showDate(displayFundInfo.end)        +'\",\"' +
            displayFundInfo.comment    +'\",\"' +
            "";
    }
    return result;
}

function report_showUserDataResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_userDataResult.length);
    exportStr +='Full Name,User Title,Role,Department,Division,Institution,Status,Credential,Faculty Rank,Primary Phone,Secondary Phone,Email';
    exportStr +='\n';

    for (var i=0;i < report_userDataResult.length;i++) {
        var r = report_userDataResult[i];
        out +=
            "    <div class='reportRow'>" +
            "      <div class='secondaryNameBlock'>" +
            "       <div class='mainName'>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</div>" +
            "      </div>" +
            "      <div style='clear: both;'></div>" +
            "      <table width='100%' border='0' cellspacing='0' cellpadding='5'>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>User Title</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.role.name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Credential</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(showValue(r.credential).name) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Role</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.institutionRole.name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Faculty Rank</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(showValue(r.facultyRank).name) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Department</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(showValue(r.department).name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Primary Phone</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.primaryPhone + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Division</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(showValue(r.division).name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Secondary Phone</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.secondaryPhone + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Institution</td>" +
            "          <td width='29%' align='left' valign='top'>" + showValue(r.institution.name) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Email</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.email + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Status</td>" +
            "          <td width='29%' align='left' valign='top'>" + statusValue(r.active) + "</td>" +
            "        </tr>" +
            "      </table>" +
            "    </div>" +
            "    <hr class='report' />";
        exportStr +='\"'+util_buildFullName(r.firstName, r.middleName, r.lastName) +'\",\"'+ showValue(r.role.name) + '\",\"'+showValue(r.institutionRole.name)+ '\",\"'
            +showValue(showValue(r.department).name)+ '\",\"'+showValue(showValue(r.division).name)+ '\",\"'
            +showValue(r.institution.name)+ '\",\"'+statusValue(r.active)+ '\",\"'+showValue(showValue(r.credential).name) + '\",\"'
            +showValue(showValue(r.facultyRank).name)+ '\",\"'+r.primaryPhone + '\",\"'+showValue(r.secondaryPhone)+'\",\"'+r.email+'\"';
        exportStr +='\n';
    }
    $('#report_results').html(out);
}

function report_showStaffAuditSubjectViewsResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_staffAuditSubjectViewsResult.length);
    var currentSubjectId = -1;
    var previousSubjectId = -1;
    var currentUserId = -1;
    var previousUserId = -1;
    var iteration = 0;
    var currentAction;
    var currentDate;
    var previousAction;
    var previousDate;
    var tableRow = 0;

    for (var i=0;i< report_staffAuditSubjectViewsResult.length;i++) {
        var r = report_staffAuditSubjectViewsResult[i];
        currentSubjectId = r.subjectId;
        currentUserId = r.userId;
        currentAction = r.actionPerformed;
        currentDate = r.date;
        if (iteration != 0 && currentSubjectId != previousSubjectId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentSubjectId != previousSubjectId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='24%'>MRN</th>" +
                "          <th width='12%'>Action Performed</th>" +
                "          <th width='12%'>Date</th>" +
                "          <th width='11%'>IP Address</th>" +
                "          <th width='11%'>User</th>" +
                "          <th width='11%'>User ID</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Subject Name,MRN,Action Performed,Date,IP Address,User,User ID\n';
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "<td>" + r.mrn + "</td>" +
            "          <td>" + r.actionPerformed + "</td>" +
            "          <td>" + showDateTime(r.date) + "</td>" +
            "          <td>" + r.ipAddress + "</td>" +
            "          <td>" + util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + "</td>" +
            "          <td>" + r.ecommons + "</td>" +
            "        </tr>";

        previousSubjectId = currentSubjectId;
        previousUserId = currentUserId;
        previousAction = currentAction;
        previousDate = currentDate;

        if (iteration != 0 && currentSubjectId == previousSubjectId && currentUserId != previousUserId && currentAction != previousAction && currentDate != previousDate)  {
            out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
            out +=  "<td>" + r.mrn + "</td>" +
                "          <td>" + r.actionPerformed + "</td>" +
                "          <td>" + showDateTime(r.date) + "</td>" +
                "          <td>" + r.ipAddress + "</td>" +
                "          <td>" + util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + "</td>" +
                "          <td>" + r.ecommons + "</td>" +
                "        </tr>";
        }
        if(tableRow == 0){exportStr +=util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName);}
        exportStr += ',\"'+r.mrn + '\",' + r.actionPerformed + ',\"' + showDateTime(r.date) + '\",' + r.ipAddress +',' +
            util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + ',' + r.ecommons +'\n';
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showSubjectAuditStaffViewsResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_subjectAuditStaffViewsResult.length);
    var currentSubjectId = -1;
    var previousSubjectId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_subjectAuditStaffViewsResult.length;i++) {
        var r = report_subjectAuditStaffViewsResult[i];
        currentSubjectId = r.subjectId;

        if (iteration != 0 && currentSubjectId != previousSubjectId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentSubjectId != previousSubjectId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.subjectName + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='12%'>User</th>" +
                "          <th width='12%'>Title</th>" +
                "          <th width='12%'>Department</th>" +
                "          <th width='12%'>Institution</th>" +
                "          <th width='12%'>Action Performed</th>" +
                "          <th width='12%'>Date</th>" +
                "          <th width='11%'>IP Address</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Subject Name,User,Title,Department,Institution,Action Performed,Date,IP Address\n';
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "<td>" + util_buildFullName(r.userId.firstName, r.userId.middleName, r.userId.lastName) + "</td>" +
            "          <td>" + r.userId.role.name + "</td>" +
            "          <td>" + showValue(showValue(r.userId.department).name) + "</td>" +
            "          <td>" + r.userId.institution.name + "</td>" +
            "          <td>" + r.actionPerformed + "</td>" +
            "          <td>" + showDateTime(r.date) + "</td>" +
            "          <td>" + r.ipAddress + "</td>" +
            "        </tr>";

        exportStr += '\"'+removeAdditionalComma(r.subjectName)+ '\",\"'+util_buildFullName(r.userId.firstName, r.userId.middleName, r.userId.lastName)
            + '\",' + r.userId.role.name + ',' + showValue(showValue(r.userId.department).name)
            + ',' + r.userId.institution.name +',' + r.actionPerformed + ',' + showDateTime(r.date) +',' + r.ipAddress +'\n';

        previousSubjectId = currentSubjectId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showProtoNurseResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_protoNurseResult.length);
    var currentNurseId = -1;
    var previousNurseId = -1;
    var iteration = 0;

    for (var i=0;i< report_protoNurseResult.length;i++) {
        var r = report_protoNurseResult[i];
        currentNurseId = r.nurseId;

        if (iteration != 0 && currentNurseId != previousNurseId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentNurseId != previousNurseId)  {
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='24%'>Study Name</th>" +
                "          <th width='12%'>Catalyst ID</th>" +
                "          <th width='12%'>Local Id</th>" +
                "          <th width='11%'>Study Status</th>" +
                "          <th width='11%'>IRB #</th>" +
                "          <th width='11%'>IRB Expiration</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Full Name,Study Name,Catalyst ID,Local Id,Study Status,IRB #,IRB Expiration\n';
            exportStr +=removeAdditionalComma(util_buildFullName(r.firstName, r.middleName, r.lastName));
        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "<td>" + r.name + "</td>" +
            "          <td>" + r.catalystId + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + r.studyStatusName + "</td>" +
            "          <td>" + r.irb + "</td>" +
            "          <td>" + showDate(r.irbExpiration) + "</td>" +
            "        </tr>";

        exportStr += ',\"'+r.name + '\",' + removeAdditionalComma(r.catalystId) + ',' + removeAdditionalComma(r.localId) + ',' + r.studyStatusName +',' +
            r.irb + ',' + showDate(r.irbExpiration) + '\n';
        previousNurseId = currentNurseId;
        iteration++;
    }
    $('#report_results').html(out);
}

function report_showProtoNutritionistResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_protoNutritionistResult.length);
    var currentNutritionistId = -1;
    var previousNutritionistId = -1;
    var iteration = 0;

    for (var i=0;i< report_protoNutritionistResult.length;i++) {
        var r = report_protoNutritionistResult[i];
        currentNutritionistId = r.nurseId;

        if (iteration != 0 && currentNutritionistId != previousNutritionistId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentNutritionistId != previousNutritionistId)  {
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='24%'>Study Name</th>" +
                "          <th width='12%'>Catalyst ID</th>" +
                "          <th width='12%'>Local Id</th>" +
                "          <th width='11%'>Study Status</th>" +
                "          <th width='11%'>IRB #</th>" +
                "          <th width='11%'>IRB Expiration</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Full Name,Study Name,Catalyst ID,Local Id,Study Status,IRB #,IRB Expiration\n';
            exportStr +=removeAdditionalComma(util_buildFullName(r.firstName, r.middleName, r.lastName));
        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=    "<td>" + r.name + "</td>" +
            "          <td>" + r.catalystId + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + r.studyStatusName + "</td>" +
            "          <td>" + r.irb + "</td>" +
            "          <td>" + showDate(r.irbExpiration) + "</td>" +
            "        </tr>";
        exportStr += ',\"'+r.name + '\",' + removeAdditionalComma(r.catalystId) + ',' + removeAdditionalComma(r.localId) + ',' + r.studyStatusName +',' +
            r.irb + ',' + showDate(r.irbExpiration) + '\n';
        previousNutritionistId = currentNutritionistId;
        iteration++;
    }
    $('#report_results').html(out);
}

function report_showOverrideResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_overrideResult.length);
    var currentUserId = -1;
    var previousUserId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_overrideResult.length;i++) {
        var r = report_overrideResult[i];
        currentUserId = r.performingUser.id;

        if (iteration != 0 && currentUserId != previousUserId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentUserId != previousUserId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.performingUser.firstName, r.performingUser.middleName, r.performingUser.lastName) + " (" +r.performingUser.ecommonsId + ")" + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='12%'>Override Time</th>" +
                "          <th width='24%'>Override Reason</th>" +
                "          <th width='12%'>Resource Name</th>" +
                "          <th width='12%'>Visit Name</th>" +
                "          <th width='10%'>Scheduled Visit Time</th>" +
                "          <th width='12%'>Catalyst Id</th>" +
                "          <th width='12%'>Local Id</th>" +
                "          <th width='12%'>IRB #</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + showDateTime(r.date) + "</td>" +
            "          <td>" + showValue(showValue(r.appointmentOverrideReason).name) + "</td>" +
            "          <td>" + showValue(showValue(r.affectedResource).name) + "</td>" +
            "          <td>" + showValue(r.bookedVisit.name) + "</td>" +
            "          <td>" + showDateTime(r.bookedVisit.scheduledStartTime) + "</td>" +
            "          <td>" + showValue(r.bookedVisit.study.catalystId) + "</td>" +
            "          <td>" + showValue(r.bookedVisit.study.localId) + "</td>" +
            "          <td>" + showValue(r.bookedVisit.study.irb) + "</td>" +
            "        </tr>";
        if (iteration == 0){
            exportStr += 'Performing User,Override Time,Override Reason,Resource Name,Visit Name,Scheduled Visit Time,Catalyst ID,Local Id,IRB #\n';
        }
        if(tableRow == 0){exportStr +=util_buildFullName(r.performingUser.firstName, r.performingUser.middleName, r.performingUser.lastName) + " (" +r.performingUser.ecommonsId + ")";}
        exportStr += ',\"'+showDateTime(r.date) + '\",' + showValue(showValue(r.appointmentOverrideReason).name) + ',' + removeAdditionalComma(showValue(showValue(r.affectedResource).name))
            + ',' + showValue(r.bookedVisit.name) +',' + showDateTime(r.bookedVisit.scheduledStartTime) + ',' + showValue(r.bookedVisit.study.catalystId) +
            ',' + showValue(r.bookedVisit.study.localId) +',' + showValue(r.bookedVisit.study.irb) +'\n';

        previousUserId = currentUserId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showOffUnitResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_offUnitResult.length);
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_offUnitResult.length;i++) {
        var r = report_offUnitResult[i];
        currentVisit = r.bookedVisitId;

        if (iteration != 0 && currentVisit != previousVisit)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentVisit != previousVisit)  {
            var divVisitStatusClass = null;
            if (r.visitStatus == 'Scheduled'){
                divVisitStatusClass = " <div class='statusBlock reportSecondary'>" ;
            }
            else if (r.visitStatus == 'Checked-In'){
                divVisitStatusClass = " <div class='statusBlock reportCheckedInSecondary'>" ;
            }
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.visitName + " - " + r.visitType + "</div>" +
                "      </div>" +
                "      <div class='statusBlockContainer'>" +
                divVisitStatusClass 		   +
                "          <div class='label'>Subject Name</div>" +
                "          <div class='value'>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</div>" +
                "          <div class='label'>MRN</div>" +
                "          <div class='value'>" + r.mrn + "</div>" +
                "          <div class='label'>Gender</div>" +
                "          <div class='value'>" + r.genderName + "</div>" +
                "          <div class='label'>Birth Date</div>" +
                "          <div class='value'>" + r.birthdate + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>IRB #</div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>Visit Start Time</div>" +
                "          <div class='value'>" + showDateTime(r.scheduledStartTime) + "</div>" +
                "          <div class='label'>Visit End Time</div>" +
                "          <div class='value'>" + showDateTime(r.scheduledEndTime) + "</div>" +
                "          <div class='label'>Comment</div>" +
                "          <div class='value'>" + r.comment + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Resource Name</th>" +
                "          <th>Resource Start Time</th>" +
                "          <th>Resource End Time</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr +='Visit Name-Visit Type,Subject Name,MRN,Gender,Birth Date,Local ID,IRB #,Visit Start Time,Visit End Time,Comment,';
            exportStr +='Resource Name,Start Time,End Time'+ '\n';
        }


        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>"  + r.resourceName +  "</td>" +
            "          <td>" + showDateTime(r.resourceStartTime) + "</td>" +
            "          <td>" + showDateTime(r.resourceEndTime) + "</td>" +
            "          <td> </td>" +
            "        </tr>";
        if(tableRow == 0){
            exportStr +='\"'+r.visitName + " - " + r.visitType+ '\",\"'+util_buildFullName(r.firstName, r.middleName, r.lastName)+ '\",\"'
                +r.mrn+ '\",\"'+r.genderName+ '\",\"'+r.birthdate+ '\",\"'
                +r.localId+ '\",\"'+r.irb+ '\",\"'+showDateTime(r.scheduledStartTime)+ '\",\"'
                +showDateTime(r.scheduledEndTime)+ '\",\"'+r.comment+'\",';
        }else{
            exportStr +=',,,,,,,,,,';
        }
        exportStr +='\"'+removeAdditionalComma(r.resourceName) + '\",\"' + showDateTime(r.resourceStartTime) + '\",\"' + showDateTime(r.resourceEndTime) + '\"\n';
        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showDailyOverviewResults() {
    var out = "";
    exportStr = '';
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;
    report_handleDataResponse(report_dailyOverviewResult.length);

    for (var i=0;i< report_dailyOverviewResult.length;i++) {
        var r = report_dailyOverviewResult[i];
        currentVisit = r.bookedVisitId;

        if (iteration != 0 && currentVisit != previousVisit)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentVisit != previousVisit)  {
            var divVisitStatusClass = null;
            if (r.visitStatus == 'Scheduled'){
                divVisitStatusClass = " <div class='statusBlock reportSecondary'>" ;
            }
            else if (r.visitStatus == 'Checked-In'){
                divVisitStatusClass = " <div class='statusBlock reportCheckedInSecondary'>" ;
            }
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.scheduledStartTime + " - " + r.scheduledEndTime + "</div>" +
                "      </div>" +
                "      <div class='statusBlockContainer'>" +
                divVisitStatusClass 	   +
                "          <div class='label'>Subject </div>" +
                "          <div class='value'>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</div>" +
                "          <div class='label'>MRN</div>" +
                "          <div class='value'>" + r.mrn + "</div>" +
                "          <div class='label'>Gender</div>" +
                "          <div class='value'>" + r.genderName + "</div>" +
                "          <div class='label'>Birth Date</div>" +
                "          <div class='value'>" + r.birthdate + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>IRB #</div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>Visit Name</div>" +
                "          <div class='value'>" + r.visitName + "</div>" +
                "          <div class='label'>Visit Type</div>" +
                "          <div class='value'>" + r.visitType + "</div>" +
                "          <div class='label'>Sublocation</div>" +
                "          <div class='value'>" + r.sublocationName + "</div>" +
                "          <div class='label'>Is part of the Visit Off Unit?</div>" +
                "          <div class='value'>" + r.offInstitution + "</div>" +
                "          <div class='label'>Check-In</div>" +
                "          <div class='value'>" + '' + "</div>" +
                "          <div class='label'>Check-Out</div>" +
                "          <div class='value'>" + '' + "</div>" +
                "          <div class='label'>Comment</div>" +
                "          <div class='value'>" + '' + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Resource Name</th>" +
                "          <th>Resource Start Time</th>" +
                "          <th>Resource End Time</th>" +
                "          <th>Comment</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>"  + r.resourceName +  "</td>" +
            "          <td>" + showDateTime(r.resourceStartTime) + "</td>" +
            "          <td>" + showDateTime(r.resourceEndTime) + "</td>" +
            "          <td>" + r.comment + "</td>" +
            "        </tr>";
        if(iteration == 0){
            exportStr +='Visit Length,Subject,MRN,Gender,Birth Date,Local ID,IRB #,Visit Name,Visit Type,Sublocation,Is part of the Visit Off Unit?,';
            exportStr +='Resource Name,Start Time,End Time,Comment'+ '\n';
        }
        exportStr +='\"'+showDateTime(r.scheduledStartTime) + " - " + showDateTime(r.scheduledEndTime)+ '\",\"'+util_buildFullName(r.firstName, r.middleName, r.lastName)+ '\",\"'
            +r.mrn+ '\",\"'+r.genderName+ '\",\"'+r.birthdate+ '\",\"'
            +r.localId+ '\",\"'+r.irb+ '\",\"'+ r.visitName + '\",\"'
            +r.visitType+ '\",\"'+r.sublocationName+ '\",\"'+r.offInstitution
            +'\",\"'+removeAdditionalComma(r.resourceName) + '\",\"' +showDateTime(r.resourceStartTime) + '\",\"' +showDateTime(r.resourceEndTime)+ '\",\"' +r.comment + '\"\n';
        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }

    $('#report_results').html(out);
}


function calculateAndFormatVisitTime(startTime, endTime) {
    if (startTime != null && endTime != null){
        var startDateMillis = Date.parse(startTime);
        var endDateMillis = Date.parse(endTime);
        var timeDiffInMillis = endDateMillis - startDateMillis;
        var timeDiffInMinutes = Math.floor(timeDiffInMillis / 60000);
        var timeDiffInDays = Math.floor(timeDiffInMinutes / 1440);
        var remainingMinutesInDay = timeDiffInMinutes % 1440;
        var remainingHoursInDay =  Math.floor(remainingMinutesInDay / 60);
        var remainingMinutesInHour = remainingMinutesInDay % 60;
        return util_formatVisitTime(timeDiffInDays, remainingHoursInDay, remainingMinutesInHour);
    }
    else {
        return "";
    }
}

function calculateTimeInDays(startTime, endTime) {
    if (startTime != null && endTime != null){
        var startDate = new Date(startTime);
        var endDate = new Date(endTime);

        var millisPerDay = (1000 * 60 * 60 * 24); // seconds, minutes, hours, days

        var diffInMillis = endDate - startDate;
        var wholeDays = Math.floor(diffInMillis / millisPerDay);
        var fractionDay = diffInMillis % millisPerDay;

        var startDatePlusFraction = new Date(startDate);
        startDatePlusFraction.setMilliseconds(
            fractionDay + startDate.getMilliseconds());

        var startDateDate = startDate.getDate();
        var startDatePlusFractionDate = startDatePlusFraction.getDate();

        if (startDateDate != startDatePlusFractionDate) {
            // crosses a day boundary, e.g. 1 to 2, or even 31 to 1
            wholeDays++;
        }

        return wholeDays;
    }
    else{
        return "";
    }
}

function calculateAndFormatVisitTimeInMinutes(startTime, endTime) {
    if (startTime != null && endTime != null){
        var startDateMillis = Date.parse(startTime);
        var endDateMillis = Date.parse(endTime);
        var timeDiffInMillis = endDateMillis - startDateMillis;
        var timeDiffInMinutes = Math.floor(timeDiffInMillis / 60000);
        return timeDiffInMinutes;
    }
    else{
        return "";
    }
}

function calculateAndFormatDuration(timeInMinutes) {
    if (timeInMinutes != null){
        var timeDiffInDays = Math.floor(timeInMinutes / 1440);
        var remainingMinutesInDay = timeInMinutes % 1440;
        var remainingHoursInDay =  Math.floor(remainingMinutesInDay / 60);
        var remainingMinutesInHour = remainingMinutesInDay % 60;
        return util_formatVisitTime(timeDiffInDays, remainingHoursInDay, remainingMinutesInHour);
    }
    else {
        return "";
    }
}


function report_showWeeklyPharmResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_weeklyPharmResult.length);
    var currentStudyId = -1;
    var previousStudyId = -1;
    var iteration = 0;

    for (var i=0;i< report_weeklyPharmResult.length;i++) {
        var r = report_weeklyPharmResult[i];
        currentStudyId = r.studyId;

        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        if (currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.studyName + "</div>" +
                "      </div>" +
                "      <div class='statusBlockContainer'>" +
                " 	<div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>Catalyst ID</div>" +
                "          <div class='value'>" + r.catalystId + "</div>" +
                "          <div class='label'>IRB #</div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>IRB Expiration</div>" +
                "          <div class='value'>" + showValue(r.irbExpiration) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='15%'>Subject</th>" +
                "          <th width='11%'>MRN</th>" +
                "          <th width='11%'>Gender</th>" +
                "          <th width='11%'>Visit Name</th>" +
                "          <th width='14%'>Visit Start Time</th>" +
                "          <th width='14%'>Visit End Time</th>" +
                "          <th width='15%'>Visit Length</th>" +
                "          <th width='12%'>Appointment Status</th>" +
                "        </tr>";
        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=    "<td>" + util_buildFullName(r.firstName, r.middleName, r.lastName) + "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + r.genderName + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime)+ "</td>" +
            "          <td>" + visitLengthLabel + "</td>" +
            "          <td>" + r.appointmentStatus + "</td>" +
            "        </tr>";

        if (iteration == 0){
            exportStr += 'Study Name,Catalyst ID,Local Id,IRB #,IRB Expiration,Subject,MRN,Gender,Visit Name,Visit Start Time,Visit End Time,Visit Length,Appointment Status \n';
        }
        exportStr +=removeAdditionalComma(r.studyName)+ ',' + removeAdditionalComma(r.catalystId) +',' + removeAdditionalComma(r.localId) + ',' + r.irb +','+showDate(r.irbExpiration)+
            ',\"'+util_buildFullName(r.firstName, r.middleName, r.lastName) + '\",' + removeAdditionalComma(r.mrn) + ',' + r.genderName+
            ',' + r.visitName + ',\"' + showDateTime(r.scheduledStartTime)+ '\"' + ',\"' + showDateTime(r.scheduledEndTime)+ '\"'
            +','+visitLengthLabel+','+r.appointmentStatus+'\n';

        previousStudyId = currentStudyId;
        iteration++;
    }

    $('#report_results').html(out);
}


function report_showCancellationsResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_cancellationsResult.length);

    for (var i=0;i< report_cancellationsResult.length;i++) {

        var r = report_cancellationsResult[i];
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));

        out +=
            "    <div class='reportRow'>" +
            "      <div class='secondaryNameBlock'>" +
            "       <div class='mainName'>" + r.asrName + "</div>" +
            "      </div>" +
            "      <div style='clear: both;'></div>" +
            "      <table width='100%' border='0' cellspacing='0' cellpadding='5'>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Subject</td>" +
            "          <td width='29%' align='left' valign='top'>" +  util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>PI Name</td>" +
            "          <td width='29%' align='left' valign='top'>" +  util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>MRN</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.mrn + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Cancel Date</td>" +
            "          <td width='29%' align='left' valign='top'>" +  showDateTime(r.cancelDate) + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Visit Start Time</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Catalyst ID</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.catalystId + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Visit End Time</td>" +
            "          <td width='29%' align='left' valign='top'>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Local ID</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.localId + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Visit Length</td>" +
            "          <td width='29%' align='left' valign='top'>" + visitLengthLabel + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>IRB #</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.irb + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Study Name</td>" +
            "          <td width='29%' align='left' valign='top' style='word-wrap: break-word;'>" + r.studyName + "</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Visit Name</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.visitName + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Cancellation Type</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.cancelStatus +"</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Visit Type</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.visitTypeName + "</td>" +
            "        </tr>" +
            "        <tr>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>User</td>" +
            "          <td width='29%' align='left' valign='top'>" + r.user +"</td>" +
            "          <td width='21%' align='left' valign='top' style='font-weight:bold'>Scheduled Date</td>" +
            "          <td width='29%' align='left' valign='top'>"+ showDateTime(r.scheduledDate) +"</td>" +
            "        </tr>" +
            "      </table>" +
            "    </div>" +
            "    <hr class='report' />";

        if (i == 0){
            exportStr +="Study Name,Catalyst ID,Local ID,IRB #,PI Name,Subject,MRN,Visit Name,Visit Type,Visit Start Time,"
                +"Visit End Time,Visit Length,Scheduled Date,Cancel Date,Reason,Cancellation Type,User";
            exportStr +='\n';
        }

        exportStr +='\"'+removeAdditionalComma(r.studyName) + '\",\"'+r.catalystId+ '\",\"'+r.localId+ '\",\"'+r.irb+ '\",\"'
            +util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName)+ '\",\"'
            +util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"'
            +r.mrn + '\",\"'+r.visitName+ '\",\"'+r.visitTypeName+ '\",\"'+showDateTime(r.scheduledStartTime)+ '\",\"'
            +showDateTime(r.scheduledEndTime) + '\",\"'+visitLengthLabel+ '\",\"'+r.scheduledDate+ '\",\"'+r.cancelDate+ '\",\"'
            +r.asrName + '\",\"'+r.cancelStatus+ '\",\"'+r.user +'\"';
        exportStr +='\n';
    }

    $('#report_results').html(out);
}


function report_showStudyVisitLocationResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_studyVisitLocationResult.length);
    var currentVisitTypeId = -1;
    var previousVisitTypeId = -1;
    var currentVisitId = -1;
    var previousVisitId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0; i < report_studyVisitLocationResult.length; i++) {
        var r = report_studyVisitLocationResult[i];
        currentVisitTypeId = r.visitTypeId;
        currentVisitId = r.visitId;

        if (iteration != 0 && currentVisitTypeId != previousVisitTypeId && previousVisitId != currentVisitId) {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentVisitTypeId != previousVisitTypeId && previousVisitId != currentVisitId) {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.sublocationName + "</div>" +
                "      </div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Visit Name</th>" +
                "          <th>Visit Type</th>" +
                "          <th>Check In Time</th>" +
                "          <th>Check Out Time</th>" +
                "          <th>Visit Duration</th>" +
                "          <th>Subject Name</th>" +
                "          <th>MRN</th>" +
                "          <th>Gender</th>" +
                "          <th>Study Name</th>" +
                "          <th>Catalyst ID</th>" +
                "          <th>Local ID</th>" +
                "          <th>IRB #</th>" +
                "        </tr>";

            if (iteration == 0){
                exportStr += 'Location Name,Visit Name,Visit Type,Check In Time,Check Out Time,Visit Duration,Subject Name,MRN,Gender,Study Name,Catalyst ID,Local Id,IRB #'+ '\n';
            }
        }

        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>"  + r.visitTypeName +  "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td>" + showValue(visitLengthLabel) + "</td>" +
            "          <td>"  + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +  "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + r.genderName + "</td>" +
            "          <td>" + r.studyName + "</td>" +
            "          <td>" + showValue(r.catalystId) + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + showValue(r.irb) + "</td>" +
            "        </tr>";
        exportStr += r.sublocationName +','+removeAdditionalComma(r.visitTypeName) +','+ r.visitType.name +','+ showDateTime(r.checkInTime)
            +','+showDateTime(r.checkOutTime) +','+ showValue(visitLengthLabel)
            +','+removeAdditionalComma(util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName))
            + ',' + removeAdditionalComma(r.mrn) +','+ r.genderName + ',' +removeAdditionalComma(r.studyName)
            +','+removeAdditionalComma(showValue(r.catalystId)) +','+removeAdditionalComma(r.localId) +','+showValue(r.irb)+'\n';

        previousVisitTypeId = currentVisitTypeId;
        previousVisitId = currentVisitId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showBillableResourcesResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_billableResourcesResult.length);
    var currentResourceId  = -1;
    var previousResourceId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_billableResourcesResult.length;i++) {
        var r = report_billableResourcesResult[i];
        currentResourceId = r.resourceId;

        if (iteration != 0 && currentResourceId != previousResourceId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentResourceId != previousResourceId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.resourceName + "</div>" +
                "      </div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th style='word-wrap: break-word;'> Check-In Time </th>" +
                "          <th style='word-wrap: break-word;'> Check-Out Time </th>" +
                "          <th style='word-wrap: break-word;'> Visit Length </th>" +
                "          <th style='word-wrap: break-word;'> Subject Name </th>" +
                "          <th style='word-wrap: break-word;'> MRN </th>" +
                "          <th style='word-wrap: break-word;'> Study Name </th>" +
                "          <th style='word-wrap: break-word;'> Catalyst ID </th>" +
                "          <th style='word-wrap: break-word;'> Local ID </th>" +
                "          <th style='word-wrap: break-word;'> IRB # </th>" +
                "          <th style='word-wrap: break-word;'> PI </th>" +
                "          <th style='word-wrap: break-word;'> Industry Initiated </th>" +
                "          <th style='word-wrap: break-word;'> CRC Approved Study </th>" +
                "          <th style='word-wrap: break-word;'> Visit Name </th>" +
                "          <th style='word-wrap: break-word;'> Visit Type </th>" +
                "          <th style='word-wrap: break-word;'> Sublocation </th>" +
                "          <th style='word-wrap: break-word;'> Booked Resource Scheduled Start Time </th>" +
                "          <th style='word-wrap: break-word;'> Booked Resource Scheduled End Time </th>" +
                "          <th style='word-wrap: break-word;'> Booked Visit Comment </th>" +
                "        </tr>";

            if (iteration == 0){
                exportStr +='Resource Name,Check In Time,Check Out Time,Visit Length,Subject Name,MRN,Industry Initiated,CRC Approved Study,Sublocation,Study Name,Catalyst ID,Local ID,IRB #,PI,Visit Name,Visit Type,Booked Resource Scheduled Start Time,Booked Resource Scheduled End Time, Booked Resource Activities, Booked Resource Activities Comment, Booked Resource Activities Quantity, Booked Visit Comment '+ '\n';
            }
        }
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td style='word-wrap: break-word;'>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + visitLengthLabel + "</td>" +
            "          <td style='word-wrap: break-word;'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +  "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.mrn + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.studyName + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showValue(r.catalystId) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.localId + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showValue(r.irb) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) +  "</td>" +
            "          <td style='word-wrap: break-word;'>" + yesNoValue(r.industryInitiated) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + yesNoValue(r.crcFunded) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.visitName + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.visitTypeName + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.sublocationName +  "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.scheduledStartTime + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.scheduledEndTime + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showValue(r.bookedVisitComment)+ "</td>" +
            "        </tr>";

        exportStr +=removeAdditionalComma(r.resourceName);
        exportStr +=',\"'+showDateTime(r.checkInTime) + '\",\"' + showDateTime(r.checkOutTime) + '\",\"' + visitLengthLabel
            + '\",\"' + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +'\",\"' + r.mrn
            +'\",\"' + yesNoValue(r.industryInitiated)+'\",\"'+yesNoValue(r.crcFunded)
            +'\",\"' + r.sublocationName +'\",\"' + removeAdditionalComma(r.studyName) +'\",\"' + showValue(r.catalystId)+'\",\"' + r.localId
            +'\",\"' +showValue(r.irb)+'\",\"' +util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) +'\",\"'
            +r.visitName +'\",\"'+r.visitTypeName+'\",\"'+r.scheduledStartTime +'\",\"'+r.scheduledEndTime+'\",\"'+removeAdditionalComma(r.resourceActivities)
            +'\",\"'+removeAdditionalComma(r.resourceActivitiesComment) +'\",\"'+removeAdditionalComma(r.resourceActivitiesQuantity) +'\",\"'+r.bookedVisitComment +'\",\"'+'\"\n';
        previousResourceId = currentResourceId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showTransactionsResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_transactionsResult.length);
    var currentAsrId  = -1;
    var previousAsrId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_transactionsResult.length;i++) {
        var r = report_transactionsResult[i];
        currentAsrId = r.asrId;

        if (iteration != 0 && currentAsrId != previousAsrId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentAsrId != previousAsrId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" +  r.visitName + " - " + r.appointmentStatus + "</div>" +
                "      </div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Appointment Status Reason</th>" +
                "          <th>Status Change Time</th>" +
                "          <th>Cancellation Type</th>" +
                "          <th>Cancellation Reason</th>" +
                "          <th>User Initiating Change</th>" +
                "          <th>Scheduled Start Time</th>" +
                "          <th>Scheduled End Time</th>" +
                "          <th>Visit Length</th>" +
                "          <th>Study Name</th>" +
                "          <th>PI</th>" +
                "          <th>Primary Contact</th>" +
                "          <th>Catalyst ID</th>" +
                "          <th>Local ID</th>" +
                "          <th>IRB #</th>" +
                "          <th>Subject Name</th>" +
                "          <th>MRN</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr +=r.visitName + " - " + r.appointmentStatus + '\n';
            exportStr +='Appointment Status Reason,Status Change Time,Cancellation Type,Cancellation Reason,User Initiating Change,Scheduled Start Time,Scheduled End Time,Visit Length,Study Name,PI,Primary Contact,Catalyst ID,Local ID,IRB #,Subject Name,MRN '+ '\n';
        }

        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + r.asrName + "</td>" +
            "          <td>" + showDateTime(r.cancelTime) + "</td>" +
            "          <td>" + r.cancelStatus + "</td>" +
            "          <td>" + r.cancelStatusReason + "</td>" +
            "          <td>" + r.ecommonsId + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + visitLengthLabel + "</td>" +
            "          <td>" + r.studyName + "</td>" +
            "          <td>" + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) +  "</td>" +
            "          <td>" + util_buildFullName(r.psFirstName, r.psMiddleName, r.psLastName) +  "</td>" +
            "          <td>" + r.catalystId + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + r.irb + "</td>" +
            "          <td>"  + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +  "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "        </tr>";
        exportStr +='\"'+r.asrName + '\",\"' + showDateTime(r.cancelTime) + '\",\"' + r.cancelStatus + '\",\"' + r.cancelStatusReason +'\",\"' + r.ecommonsId +'\",\"'
            +showDateTime(r.scheduledStartTime) +'\",\"' + showDateTime(r.scheduledEndTime) +'\",\"' + visitLengthLabel + '\",\"'
            + removeAdditionalComma(r.studyName) +'\",\"' + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) +'\",\"'
            + util_buildFullName(r.psFirstName, r.psMiddleName, r.psLastName) +'\",\"'
            +r.catalystId +'\",\"' +r.localId +'\",\"' +r.irb +'\",\"'
            +util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)+'\",\"'
            + r.mrn+'\"\n';
        previousAsrId = currentAsrId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showDailyResourceResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_dailyResourceResult.length);
    var currentResourceTypeId  = -1;
    var previousResourceTypeId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_dailyResourceResult.length;i++) {
        var r = report_dailyResourceResult[i];
        currentResourceTypeId = r.resourceTypeId;

        if (iteration != 0 && currentResourceTypeId != previousResourceTypeId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }
        if (currentResourceTypeId != previousResourceTypeId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.resourceName + "</div>" +
                "      </div>"  +
                "      <div class='resourceTypeValue'>" +
                "        Resource Type: <span style='font-weight: bold;'>" + r.resourceTypeName + "</span>" +
                "      </div>" +
                "      <div style='clear: both; height: 5px'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th style='width:12%;'>Subject Name</th>" +
                "          <th style='width:8%;'>MRN</th>" +
                "          <th style='width:9%;'>Local ID</th>" +
                "          <th style='width:10%;'>IRB #</th>" +
                "          <th style='width:10%;'>Visit ID</th>" +
                "          <th style='width:17%;'>Visit Name</th>" +
                "          <th style='width:11%;'>Resource Start Time</th>" +
                "          <th style='width:11%;'>Resource End Time</th>" +
                "          <th style='width:13%;'>Resource Usage Duration</th>" +
                "        </tr>";
        }

        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>"  + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +  "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + r.irb + "</td>" +
            "          <td>" + r.visitId + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + visitLengthLabel + "</td>" +
            "        </tr>";

        if (r.comment && r.comment != "") {
            out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
            out +=
                "          <td class='indent11px' colspan='9'>Comment: " + r.comment + "</td>" +
                "        </tr>";
        }

        if (iteration == 0){
            exportStr +='Resource Name,Resource Type,';
            exportStr +='Subject Name,MRN,Local ID,IRB #,Visit ID,Visit Name,Resource Start Time,Resource End Time,Resource Usage Duration,Comment'+ '\n';
        }
        exportStr +='\"'+removeAdditionalComma(r.resourceName) + '\",\"'+r.resourceTypeName+'\",\"'+
            util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"' + r.mrn + '\",\"' + r.localId + '\",\"' + showValue(r.irb) +'\",\"'
            + r.visitId +'\",\"'
            + r.visitName +'\",\"'
            + showDateTime(r.scheduledStartTime) +'\",\"' + showDateTime(r.scheduledEndTime) +'\",\"' + visitLengthLabel+'\",\"' + r.comment
            +'\"\n';
        previousResourceTypeId = currentResourceTypeId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}



function report_showDailyAdmResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_dailyAdmResult.length);
    var currentSubjectId  = -1;
    var previousSubjectId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_dailyAdmResult.length;i++) {
        var r = report_dailyAdmResult[i];
        currentSubjectId = r.subjectId;
        if (iteration != 0 && currentSubjectId != previousSubjectId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }
        if (currentSubjectId != previousSubjectId) {
            var divVisitStatusClass = null;
            if (r.visitStatus == 'Scheduled'){
                divVisitStatusClass = " <div class='statusBlock reportSecondary'>" ;
            }
            else if (r.visitStatus == 'Checked-In'){
                divVisitStatusClass = " <div class='statusBlock reportCheckedInSecondary'>" ;
            }
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                divVisitStatusClass 	   +
                "          <div class='label'>DOB</div>" +
                "          <div class='value'>" + r.birthdate + "</div>" +
                "          <div class='label'>MRN</div>" +
                "          <div class='value'>" + r.mrn + "</div>" +
                "          <div class='label'>Gender</div>" +
                "          <div class='value'>" + r.genderName + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>IRB #</div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>Visit Name</div>" +
                "          <div class='value'>" + r.visitName + "</div>" +
                "          <div class='label'>Visit Status</div>" +
                "          <div class='value'>" + r.visitStatus + "</div>" +
                "          <div class='label'>Check In Time</div>" +
                "          <div class='value'>" + showDateTime(r.checkInTime) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Resource Name</th>" +
                "          <th>Resource Start Time</th>" +
                "          <th>Resource End Time</th>" +
                "          <th>Comment</th>" +
                "        </tr>";
        }

        previousSubjectId = currentSubjectId;

        if (currentSubjectId == previousSubjectId) {
            out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
            out += "   <td>" + r.resourceName + "</td>" +
                "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
                "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
                "          <td>" + r.comment + "</td>" +
                "        </tr>";
        }

        if(iteration == 0) {
            exportStr +='Subject Name,DOB,MRN,Gender,Local ID,IRB #,Visit Name,Visit Status, Check In Time,';
            exportStr +='Resource Name,Resource Start Time,Resource End Time,Comment'+ '\n';
        }
        exportStr +='\"'+util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"'
            +r.birthdate+ '\",\"'+r.mrn+ '\",\"'+r.genderName+ '\",\"'
            +r.localId+ '\",\"'+r.irb+ '\",\"'+r.visitName+ '\",\"'+r.visitStatus+ '\",\"'+showDateTime(r.checkInTime)
            +'\",\"'+removeAdditionalComma(r.resourceName) + '\",\"' + showDateTime(r.scheduledStartTime) + '\",\"' + showDateTime(r.scheduledEndTime) + '\",\"' + r.comment + '\"\n';
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showMetaKitchenResults() {
    var out = "";
    exportStr = '';
    exportCustomStr = ' ';
    report_handleDataResponse(report_metaKitchenResult.length);
    var currentSubjectId  = -1;
    var previousSubjectId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_metaKitchenResult.length;i++) {
        var r = report_metaKitchenResult[i];

        currentSubjectId = r.subjectId;

        if (r.resourceName != undefined){
            if (iteration != 0 && currentSubjectId != previousSubjectId)  {
                out += " </table>" +
                    "    </div>" +
                    "  <hr class='report' />";
            }
            if (currentSubjectId != previousSubjectId)  {
                tableRow = 0;
                out +=
                    "    <div class='reportRow'>" +
                    "      <div class='secondaryNameBlock'>" +
                    "       <div class='mainName'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</div>" +
                    "      </div>"  +
                    "      <div class='statusBlockContainer'>" +
                    "        <div class='statusBlock reportNoStatusSecondary'>" +
                    "          <div class='label'>MRN</div>" +
                    "          <div class='value'>" + r.mrn + "</div>" +
                    "          <div class='label'>DOB</div>" +
                    "          <div class='value'>" + r.birthdate + "</div>" +
                    "          <div class='label'>Local ID</div>" +
                    "          <div class='value'>" + r.localId + "</div>" +
                    "        </div>" +
                    "      </div>" +
                    "      <div style='clear: both;'></div>" +
                    "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                    "        <tr style='font-weight:bold'>" +
                    "          <th>Meal Start Date/Time</th>" +
                    "          <th>Resource Name</th>" +
                    "          <th>Room</th>" +
                    "          <th>Visit Start Date/Time</th>" +
                    "        </tr>";
                exportStr +=util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) +',,,,MRN,' + r.mrn+ '\n';
                exportStr +=',,,,Local ID,' +r.localId+ '\n';
                exportStr +=',,,,DOB,' + r.birthdate+ '\n';
                exportStr +='Meal Start Date/Time,Resource Name,Room,Visit Start Date/Time,Comment'+ '\n';
            }

            out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
            out += "   <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
                "          <td>" + r.resourceName + "</td>" +
                "          <td>" + showValue(r.room) + "</td>" +
                "          <td>" + showDateTime(r.checkInTime) + ' - ' + showDateTime(r.checkOutTime) + "</td>" +
                "        </tr>";
            previousSubjectId = currentSubjectId;

            if (iteration == 0){
                exportCustomStr += 'Subject Name,Meal Start Date/Time,Local ID,Resource Name,MRN,DOB,Room,Visit Start Date/Time,Comment'+ '\n';
            }

            exportCustomStr +='\"'+ util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)+ '\",\"'+showDateTime(r.scheduledStartTime)
                + '\",\"'+ r.localId +'\",\"'+ removeAdditionalComma(r.resourceName)+'\",\"'+r.mrn+'\",\"'
                +r.birthdate+ '\",\"' +showValue(r.room)+ '\",\"'+showDateTime(r.checkInTime) + ' - ' + showDateTime(r.checkOutTime)+ '\"';

            if(i != report_metaKitchenResult.totalCount-1) exportStr +='\n';
            iteration++;
            tableRow++;
            exportStr +=showDateTime(r.scheduledStartTime)+',\"'+ removeAdditionalComma(r.resourceName) +'\",\"'+
                showValue(r.room) +'\",\"'+showDateTime(r.checkInTime) + ' - ' +showDateTime(r.checkOutTime)+ '\"\n';
            if(i != report_metaKitchenResult.totalCount-1) exportCustomStr +='\n';
        }
    }
    $('#report_results').html(out);
}

function report_showMetaKitchenByTimeResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_metaKitchenByTimeResult.length);
    var currentSubjectId  = -1;
    var previousSubjectId  = -1;
    var iteration = 0;
    var tableRow = 0;
    for (var i=0;i< report_metaKitchenByTimeResult.length;i++) {
        var j =i;
        var r = report_metaKitchenByTimeResult[i];
        var rs = report_metaKitchenByTimeResult[j++];
        currentSubjectId = r.subjectId;
        if (r.resourceName != undefined) {
            if (iteration != 0 && currentSubjectId != previousSubjectId)  {
                out += " </table>" +
                    "    </div>" +
                    "  <hr class='report' />";
            }

            if (currentSubjectId != previousSubjectId)  {
                tableRow = 0;
                out +=
                    "    <div class='reportRow'>" +
                    "      <div style='clear: both;'></div>" +
                    "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                    "        <tr style='font-weight:bold'>" +
                    "          <th>Meal Start Date/Time</th>" +
                    "          <th>Subject Name</th>" +
                    "          <th>Local ID</th>" +
                    "          <th>Resource Name</th>" +
                    "          <th>MRN</th>" +
                    "          <th>DOB</th>" +
                    "          <th>Room</th>" +
                    "          <th>Visit Start/End Time</th>" +
                    "        </tr>";
            }

            out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
            out += "   <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
                "          <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
                "          <td>" + r.localId + "</td>" +
                "          <td>" + r.resourceName + "</td>" +
                "          <td>" + r.mrn + "</td>" +
                "          <td>" + r.birthdate + "</td>" +
                "          <td>" + showValue(r.room) + "</td>" +
                "          <td>" + showDateTime(r.checkInTime) + ' - ' +showDateTime(r.checkOutTime) + "</td>" +
                "        </tr>";
            previousSubjectId = currentSubjectId;

            if (iteration == 0){
                exportStr += 'Meal Start Date/Time,Subject,Local ID,Resource Name,MRN,DOB,Room,Visit Start/End Time,Comment'+ '\n';

            }

            exportStr +='\"'+ showDateTime(r.scheduledStartTime)+ '\",\"'+util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)
                + '\",\"'+ r.localId +'\",\"'+ removeAdditionalComma(r.resourceName)+'\",\"'+r.mrn+'\",\"'+r.birthdate+ '\",\"' +showValue(r.room)+ '\",\"'+
                showDateTime(r.checkInTime) + ' - ' +showDateTime(r.checkOutTime)+ '\"';
            if(i != report_metaKitchenByTimeResult.totalCount-1) exportStr +='\n';
            iteration++;
            tableRow++;
        }
    }
    $('#report_results').html(out);
}

function report_showStudySubjectVisitResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_studySubjectVisitResult.length);
    var currentSubjectId  = -1;
    var previousSubjectId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_studySubjectVisitResult.length;i++) {
        var r = report_studySubjectVisitResult[i];
        currentSubjectId = r.mrn;

        if (iteration != 0 && currentSubjectId != previousSubjectId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }
        if (currentSubjectId != previousSubjectId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>MRN</div>" +
                "          <div class='value'>" + r.mrn + "</div>" +
                "          <div class='label'>DOB</div>" +
                "          <div class='value'>" + r.dob + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Visit Name</th>" +
                "          <th>Scheduled Visit Start Time</th>" +
                "          <th>Scheduled Visit End Time</th>" +
                "          <th>Appointment Status</th>" +
                "          <th>Local Id</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + r.appointmentStatus + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "        </tr>";
        if(tableRow == 0){
            exportStr +='Subject Name,MRN,DOB,';
            exportStr +='Visit Name,Scheduled Visit Start Time,Scheduled Visit End Time,Appointment Status,Local ID'+ '\n';
        }

        exportStr +='\"'+util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)+ '\",\"'+r.mrn+ '\",\"'+r.dob+'\",\"'
            + r.visitName + '\",\"' + showDateTime(r.scheduledStartTime) + '\",\"' + showDateTime(r.scheduledEndTime) + '\",\"'
            + r.appointmentStatus +'\",\"' + r.localId+'\"\n';
        previousSubjectId = currentSubjectId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showStudyStatusChangeResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_studyStatusChangeResult.length);
    var currentStudyId  = -1;
    var previousStudyId  = -1;
    var iteration = 0;
    var tableRow = 0;
    for (var i=0;i< report_studyStatusChangeResult.length;i++) {
        var r = report_studyStatusChangeResult[i];
        currentStudyId = r.studyId;

        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }
        if (currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.studyName + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>PI</div>" +
                "          <div class='value'>" + showValue(r.pi) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Study Status</th>" +
                "          <th>Date of Status Change</th>" +
                "          <th>User</th>" +
                "        </tr>";
            if(i == 0){
                exportStr +='Local ID,PI,';
                exportStr +='Study Status, Date of Status Change, User'+'\n';
            }
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +="    <td>" + showValue(r.studyStatus) + "</td>" +
            "          <td>" + showDateTime(r.dateStatusChange) + "</td>" +
            "          <td>" + util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + "</td>" +
            "        </tr>";

        exportStr +='\"'+r.localId+ '\",\"'+ showValue(r.pi) + '\",\"' + r.studyStatus+ '\",\"'
            + showDateTime(r.dateStatusChange) + '\",\"' + util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) +'\"\n';
        previousStudyId = currentStudyId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}
function report_showSubjectVisitHistoryResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_subjectVisitHistoryResult.length);
    var currentSubjectId  = -1;
    var previousSubjectId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_subjectVisitHistoryResult.length;i++) {
        var r = report_subjectVisitHistoryResult[i];
        currentSubjectId = r.mrn;

        if (iteration != 0 && currentSubjectId != previousSubjectId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }
        if (currentSubjectId != previousSubjectId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>MRN</div>" +
                "          <div class='value'>" + r.mrn + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Visit Name</th>" +
                "          <th>Scheduled Visit Start Time</th>" +
                "          <th>Scheduled Visit End Time</th>" +
                "          <th>Appointment Status</th>" +
                "          <th>Local Id</th>" +
                "          <th>Cancel Date</th>" +
                "          <th>Cancel Status Reason</th>" +
                "          <th>Check In Date</th>" +
                "          <th>Check Out Date</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + r.appointmentStatus + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + showDateTime(r.cancelDate) + "</td>" +
            "          <td>" + showValue(r.cancelStatusReason) + "</td>" +
            "          <td>" + showDateTime(r.checkInDate) + "</td>" +
            "          <td>" + showDateTime(r.checkOutDate) + "</td>" +
            "        </tr>";

        if (tableRow == 0){
            exportStr +='Subject Name,MRN,';
            exportStr +='Visit Name,Scheduled Visit Start Time,Scheduled Visit End Time,Appointment Status,Local ID, Cancel Date, Cancel Status Reason, Check In Date, Check Out Date'+ '\n';
        }
        exportStr +='\"'+util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)  + '\",\"'+r.mrn+ '\",\"'+r.visitName
            + '\",\"' + showDateTime(r.scheduledStartTime) + '\",\"' + showDateTime(r.scheduledEndTime) + '\",\"' + r.appointmentStatus +'\",\"' + r.localId
            +'\",\"' + showDateTime(r.cancelDate) +'\",\"' + showValue(r.cancelStatusReason) +'\",\"' + showDateTime(r.checkInDate) + '\",\"'
            + showDateTime(r.checkOutDate) +'\"\n';
        previousSubjectId = currentSubjectId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}



function report_showDeptAndPiResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_deptAndPiResult.length);
    var currentPiId  = -1;
    var previousPiId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_deptAndPiResult.length;i++) {
        var r = report_deptAndPiResult[i];
        currentPiId = r.piId;

        if (iteration != 0 && currentPiId != previousPiId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentPiId != previousPiId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlockBlackText reportCheckedOutSecondary'>" +
                "          <div class='label'>Department</div>" +
                "          <div class='value'>" + r.piDepartment + "</div>" +
                "          <div class='label'>Division</div>" +
                "          <div class='value'>" + r.piDivision + "</div>" +
                "          <div class='label'>Faculty Rank</div>" +
                "          <div class='value'>" + r.piFacultyRank + "</div>" +
                "          <div class='label'>Credential</div>" +
                "          <div class='value'>" + r.piCredential + "</div>" +
                "          <div class='label'>Institution</div>" +
                "          <div class='value'>" + r.piInstitution + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Study Name</th>" +
                "          <th>Catalyst ID</th>" +
                "          <th>Local ID</th>" +
                "          <th>IRB #</th>" +
                "          <th>Visit Name</th>" +
                "          <th>Check In Time</th>" +
                "          <th>Check Out Time</th>" +
                "          <th>Study Subject</th>" +
                "          <th>MRN</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + r.studyName + "</td>" +
            "          <td>" + showValue(r.catalystId) + "</td>" +
            "          <td>" + r.localId + "</td>" +
            "          <td>" + showValue(r.irb) + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "        </tr>";

        if (iteration == 0){
            exportStr +='PI,Department,Division,Faculty Rank,Credential,Institution,';
            exportStr +='Study Name,Catalyst ID,Local ID,IRB #,Visit Name,Check In Time,Check Out Time,Study Subject,MRN'+ '\n';
        }
        exportStr +='\"'+util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) + '\",\"'+r.piDepartment+ '\",\"'
            +r.piDivision+ '\",\"'+r.piFacultyRank+ '\",\"'+r.piCredential+ '\",\"'+r.piInstitution+'\",\"'+
            removeAdditionalComma(r.studyName) + '\",\"' + showValue(r.catalystId) + '\",\"' + r.localId + '\",\"' + showValue(r.irb) +'\",\"' + r.visitName
            +'\",\"' + showDateTime(r.checkInTime) +'\",\"' + showDateTime(r.checkOutTime) +'\",\"' + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)
            +'\",\"' + r.mrn+'\"\n';
        previousPiId = currentPiId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showBillingResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_billingResult.length);
    var currentStudyId  = -1;
    var previousStudyId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_billingResult.length;i++) {
        var r = report_billingResult[i];
        currentStudyId = r.studyId;
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.visitCheckInTime), showDateTime(r.visitCheckOutTime));
        var visitLengthLabel2 = calculateAndFormatVisitTime(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));
        var visitLengthLabel3 = calculateAndFormatVisitTimeInMinutes(showDateTime(r.visitCheckInTime), showDateTime(r.visitCheckOutTime));
        var visitLengthLabel4 = calculateAndFormatVisitTimeInMinutes(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));
        var startDate = dateFormat(r.scheduledStartTime, 'd');
        var endDate = dateFormat(r.scheduledEndTime, 'd');
        var overMidnight;
        if (startDate < endDate){
            overMidnight = "YES";
        }
        else {
            overMidnight = "NO";
        }
        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.studyName + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlockBlackText reportCheckedOutSecondary'>" +
                "          <div class='label'>Catalyst ID</div>" +
                "          <div class='value'>" + r.catalystId + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>IRB #</div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>Industry Initiated</div>" +
                "          <div class='value'>" + yesNoValue(r.industryInitiated) + "</div>" +
                "          <div class='label'>PI Name</div>" +
                "          <div class='value'>" + util_buildFullName(r.investigatorFirstName, r.investigatorMiddleName, r.investigatorLastName) + "</div>" +
                "          <div class='label'>CRC Approved Study</div>" +
                "          <div class='value'>" + yesNoValue(r.crcFunded) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='7%'>Resource Start Time</th>" +
                "          <th width='7%'>Resource End Time</th>" +
                "          <th width='4%'>Resource Duration</th>" +
                "          <th width='7%'>Check In</th>" +
                "          <th width='7%'>Check Out</th>" +
                "          <th width='8%'>Visit Duration</th>" +
                "          <th width='3%'>Visit Duration total mins</th>" +
                "          <th width='4%'>Visit Over Midnight?</th>" +
                "          <th width='6%'>Sublocation</th>" +
                "          <th width='6%'>Resource Name</th>" +
                "          <th width='4%'>Billable</th>" +
                "          <th width='8%'>Visit Name</th>" +
                "          <th width='6%'>Visit Type</th>" +
                "          <th width='6%'>Study Subject</th>" +
                "          <th width='9%'>MRN</th>" +
                "          <th width='7%'>Birth Date</th>" +
                "          <th width = '12%'> Booked Visit Comment </th>" +
                "        </tr>";
            if (iteration == 0){
                exportStr +='Study Name,Catalyst ID,Local ID,IRB #,Industry Initiated,PI Name,CRC Approved Study,';
                exportStr +='Resource Start Time,Resource End Time,Resource Duration,Resource Duration In Mins,Check In,Check Out,Visit Duration,Visit Duration Total Mins,Visit Over Midnight?,Sublocation,Resource Name, Resource Activities, Resource Activities Comment, Resource Activities Quantity, Billable,Visit Name,Visit Type,Study Subject, MRN,Birth Date,Booked Visit Comment'+ '\n';
            }
        }
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td>" + visitLengthLabel2 + "</td>" +
            "          <td>" + showDateTime(r.visitCheckInTime) + "</td>" +
            "          <td>" + showDateTime(r.visitCheckOutTime) + "</td>" +
            "          <td>" + visitLengthLabel + "</td>" +
            "          <td>" + visitLengthLabel3 + "</td>" +
            "          <td>" + overMidnight + "</td>" +
            "          <td>" + r.sublocation + "</td>" +
            "          <td>" + r.resourceName + "</td>" +
            "          <td>" + yesNoValue(r.billable)  + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + r.birthdate + "</td>" +
            "          <td>" + showValue(r.bookedVisitComment)+ "</td>" +
            "        </tr>";
        exportStr +='\"'+removeAdditionalComma(r.studyName) + '\",\"'+r.catalystId+ '\",\"'+r.localId+ '\",\"'+r.irb+ '\",\"'+yesNoValue(r.industryInitiated)
            + '\",\"'+util_buildFullName(r.investigatorFirstName, r.investigatorMiddleName, r.investigatorLastName)+ '\",\"'+yesNoValue(r.crcFunded)+'\",';
        exportStr +='\"'+showDateTime(r.checkInTime) + '\",\"' + showDateTime(r.checkOutTime) + '\",\"' + visitLengthLabel2+ '\",\"' + visitLengthLabel4 +'\",\"' +showDateTime(r.visitCheckInTime)
            + '\",\"' + showDateTime(r.visitCheckOutTime) +'\",\"'+ visitLengthLabel +'\",\"' + visitLengthLabel3+ '\",\"' +
            overMidnight +'\",\"' + r.sublocation +'\",\"' + removeAdditionalComma(r.resourceName) +'\",\"' + removeAdditionalComma(r.resourceActivities)
            +'\",\"' + removeAdditionalComma(r.resourceActivitiesComment) +'\",\"' + removeAdditionalComma(r.resourceActivitiesQuantity) +'\",\"' +yesNoValue(r.billable)+'\",\"' + r.visitName+'\",\"'+ r.visitType +'\",\"' + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)+'\",\"' + r.mrn+'\",\"' + r.birthdate+'\",\"'+r.bookedVisitComment +'\"\n';
        previousStudyId = currentStudyId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showBillingByInvestigatorResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_billingByInvestigatorResult.length);
    var currentPiId  = -1;
    var previousPiId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_billingByInvestigatorResult.length;i++) {
        var r = report_billingByInvestigatorResult[i];
        currentPiId = r.piId;
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));
        var visitLengthLabel1 = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        if (iteration != 0 && currentPiId != previousPiId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentPiId != previousPiId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlockBlackText reportCheckedOutSecondary'>" +
                "          <div class='label'>Study Name</div>" +
                "          <div class='value'>" + r.studyName + "</div>" +
                "          <div class='label'>Catalyst ID</div>" +
                "          <div class='value'>" + r.catalystId + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>IRB </div>" +
                "          <div class='value'>" + r.irb + "</div>" +
                "          <div class='label'>Industry Initiated </div>" +
                "          <div class='value'>" + yesNoValue(r.industryInitiated) + "</div>" +
                "          <div class='label'>CRC Approved Study</div>" +
                "          <div class='value'>" + yesNoValue(r.crcFunded) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Visit Name</th>" +
                "          <th>Study Subject</th>" +
                "          <th>MRN</th>" +
                "          <th>Check In Time</th>" +
                "          <th>Check Out Time</th>" +
                "          <th>Visit Length</th>" +
                "          <th>Resource Start Time</th>" +
                "          <th>Resource End Time</th>" +
                "          <th>Resource Duration</th>" +
                "          <th>Resource Name</th>" +
                "          <th>Booked Visit Comment </th>" +
                "        </tr>";

            if (iteration == 0){
                exportStr +='PI Name,Study Name,Catalyst ID,Local ID,IRB #,Industry Initiated,CRC Approved Study,';
                exportStr +='Visit Name,Study Subject,MRN,Check In Time,Check Out Time,Visit Length,Resource Start Time,Resource End Time,Resource Duration,Resource Name, Resource Activities, Resource Activities Comment, Resource Activities Quantity, Booked Visit Comment'+ '\n';
            }
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td style='word-wrap: break-word;'>" + r.visitName + "</td>" +
            "          <td style='word-wrap: break-word;'>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.mrn + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + visitLengthLabel + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td style='word-wrap: break-word;'>" + visitLengthLabel1 + "</td>" +
            "          <td style='word-wrap: break-word;'>" + r.resourceName + "</td>" +
            "          <td style='word-wrap: break-word;'>" + showValue(r.bookedVisitComment)+ "</td>" +
            "        </tr>";

        exportStr +='\"'+util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName)+ '\",\"'+removeAdditionalComma(r.studyName) + '\",\"'
            + r.catalystId+ '\",\"'+r.localId+ '\",\"'+r.irb+ '\",\"'+yesNoValue(r.industryInitiated)+ '\",\"'+yesNoValue(r.crcFunded)+ '\",\"'
            + r.visitName + '\",\"' + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"' + r.mrn + '\",\"'
            + showDateTime(r.checkInTime) +'\",\"' + showDateTime(r.checkOutTime) +'\",\"' + visitLengthLabel + '\",\"'
            + showDateTime(r.scheduledStartTime) +'\",\"' + showDateTime(r.scheduledEndTime)
            +'\",\"' + visitLengthLabel1 +'\",\"' + removeAdditionalComma(r.resourceName) +'\",\"'+removeAdditionalComma(r.resourceActivities)
            +'\",\"'+removeAdditionalComma(r.resourceActivitiesComment) +'\",\"'+removeAdditionalComma(r.resourceActivitiesQuantity) +'\",\"'+showValue(r.bookedVisitComment)+'\"\n';
        previousPiId = currentPiId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showCensusResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_censusResult.length);
    var currentAsrId  = -1;
    var previousAsrId = -1;
    var currentStudyId = -1;
    var previousStudyId = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0; i < report_censusResult.length; i++) {
        var r = report_censusResult[i];
        currentAsrId = r.asrId;
        currentStudyId = r.studyId;
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        var visitLengthLabel1 = calculateAndFormatVisitTimeInMinutes(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        var overMidnightDays = calculateTimeInDays(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        var visitId = r.visitId;

        if (iteration != 0 && currentAsrId != previousAsrId || currentStudyId != previousStudyId) {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentAsrId != previousAsrId || currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.asrName + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlockBlackText reportCheckedOutSecondary'>" +
                "          <div class='label'>Study Name</div>" +
                "          <div class='value' style='width: 235px;'>" + r.studyName + "</div>" +
                "          <div class='label'>PI Name</div>" +
                "          <div class='value' style='width: 235px;'>" + util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName) + "</div>" +
                "          <div class='label'>Primary Scheduling Contact</div>" +
                "          <div class='value' style='width: 235px;'>" + util_buildFullName(r.psFirstName, r.psMiddleName, r.psLastName) + "</div>" +
                "          <div class='label'>Catalyst ID</div>" +
                "          <div class='value' style='width: 235px;'>" + r.catalystId + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value' style='width: 235px;'>" + r.localId + "</div>" +
                "          <div class='label'>IRB </div>" +
                "          <div class='value' style='width: 235px;'>" + r.irb + "</div>" +
                "          <div class='label'>Industry Initiated </div>" +
                "          <div class='value' style='width: 235px;'>" + yesNoValue(r.industryInitiated) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Check In Date</th>" +
                "          <th>Check Out Date</th>" +
                "          <th># Days Over Midnight</th>" +
                "          <th>Visit ID</th>" +
                "          <th>Visit Length</th>" +
                "          <th>Visit Length total Minutes</th>" +
                "          <th>Visit Name</th>" +
                "          <th>Sub-Location</th>" +
                "          <th>Visit Type</th>" +
                "          <th>Study Subject</th>" +
                "          <th>MRN</th>" +
                "        </tr>";
        }
        if (iteration == 0){
            exportStr +='Reason Name,Study Name,PI Name,Primary Scheduling Contact,Catalyst ID,Local ID,IRB #,Industry Initiated,';
            exportStr +='Check In Date,Check Out Date,# Days Over Midnight,Visit ID,Visit Length,Visit Length total Minutes,Visit Name, Sub-Location, Visit Type,Study Subject,MRN'+ '\n';
        }
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + overMidnightDays + "</td>" +
            "          <td>" + visitId + "</td>" +
            "          <td>" + visitLengthLabel + "</td>" +
            "          <td>" + visitLengthLabel1 + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + r.sublocation + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "        </tr>";

        exportStr +='\"'+r.asrName+ '\",\"'+removeAdditionalComma(r.studyName) + '\",\"'+util_buildFullName(r.piFirstName, r.piMiddleName, r.piLastName)+'\",\"'
            +util_buildFullName(r.psFirstName, r.psMiddleName, r.psLastName)+'\",\"'
            +r.catalystId+ '\",\"'+r.localId+ '\",\"'+r.irb+ '\",\"'
            +yesNoValue(r.industryInitiated)+'\",';
        exportStr +='\"'+showDateTime(r.scheduledStartTime) + '\",\"' + showDateTime(r.scheduledEndTime) +
            '\",\"' + overMidnightDays + '\",\"' + visitId + '\",\"' +visitLengthLabel + '\",\"'+ visitLengthLabel1 +
            '\",\"'
            + r.visitName +'\",\"'
            + r.sublocation +'\",\"'
            + r.visitType +'\",\"'
            + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"' + r.mrn+'\"\n';
        previousAsrId = currentAsrId;
        previousStudyId = currentStudyId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showLevelOfServiceResults() {
    report_handleDataResponse(report_levelOfServiceResult.length);
    var tableRow = 0;
    exportStr = '';

    var out =    "    <div class='reportRow'>" +
        "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
        "        <tr style='font-weight:bold'>" +
        "          <th>Study Name</th>" +
        "          <th>Visit Name</th>" +
        "          <th>Visit Type</th>" +
        "          <th>Nursing</th>" +
        "          <th>Nutrition</th>" +
        "          <th>Processing</th>" +
        "          <th>Setup</th>" +
        "          <th>Appointment Status</th>" +
        "          <th>Check In Date</th>" +
        "          <th>Check Out Date</th>" +
        "          <th>Check Out Reason</th>" +
        "        </tr>";
    exportStr = 'Study Name,Visit Name,Visit Type,Nursing,Nutrition,Processing,Setup,Appointment Status,Check In Date,Check Out Date,Check Out Reason\n';
    for (var i=0;i< report_levelOfServiceResult.length;i++) {
        var r = report_levelOfServiceResult[i];

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + r.studyName +  "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + showValue(r.nursing) + "</td>" +
            "          <td>" + showValue(r.nutrition) + "</td>" +
            "          <td>" + showValue(r.processing) + "</td>" +
            "          <td>" + showValue(r.setup) + "</td>" +
            "          <td>" + r.appointmentStatus +  "</td>" +
            "          <td>" + showDateTime(r.checkInDate) +  "</td>" +
            "          <td>" + showDateTime(r.checkOutDate) +  "</td>" +
            "          <td>" + r.checkOutReason.name +  "</td>" +
            "        </tr>";
        tableRow++;
        exportStr += removeAdditionalComma(r.studyName) + ',' + removeAdditionalComma(r.visitName) + ',' + r.visitType + ',' + showValue(r.nursing) + ',' + showValue(r.nutrition) + ',' +
            showValue(r.processing) + ',' + showValue(r.setup) + ',' +
            r.appointmentStatus + ',\"' + showDateTime(r.checkInDate) + '\",\"' + showDateTime(r.checkOutDate) + '\",\"' + r.checkOutReason.name+ '\"';
        if(i != report_levelOfServiceResult.length-1) exportStr +='\n';
    }
    out += " </table>" +
        "    </div>" +
        "  <hr class='report' />";
    $('#report_results').html(out);
}

function report_showSubjectPurgeResults() {
    report_handleDataResponse(report_subjectPurgeResult.length);
    var tableRow = 0;
    exportStr = '';

    var out =    "    <div class='reportRow'>" +
        "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
        "        <tr style='font-weight:bold'>" +
        "          <th>Subject Name</th>" +
        "          <th>MRN</th>" +
        "          <th>User</th>" +
        "          <th>Subject Creation Date</th>" +
        "        </tr>";
    exportStr = 'Subject Name,MRN,User,Subject Creation Date\n';
    for (var i=0;i< report_subjectPurgeResult.length;i++) {
        var r = report_subjectPurgeResult[i];

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>"  + util_buildFullName(r.firstName, r.middleName, r.lastName) +  "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + "</td>" +
            "          <td>" + showDateTime(r.createTime) + "</td>" +
            "        </tr>";
        tableRow++;
        exportStr += removeAdditionalComma(util_buildFullName(r.firstName, r.middleName, r.lastName)) + ',' + removeAdditionalComma(r.mrn) + ',' +
            util_buildFullName(r.userFirstName, r.userMiddleName, r.userLastName) + ',\"' + showDateTime(r.createTime)+ '\"';
        if(i != report_subjectPurgeResult.length-1) exportStr +='\n';
    }
    out += " </table>" +
        "    </div>" +
        "  <hr class='report' />";
    $('#report_results').html(out);
}

function report_showResourceLevelOfServiceResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_resourceLevelOfServiceResult.length);
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_resourceLevelOfServiceResult.length;i++) {
        var r = report_resourceLevelOfServiceResult[i];
        currentVisit = r.visitId;

        if (iteration != 0 && currentVisit != previousVisit)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        var resourceLengthLabel = calculateAndFormatDuration(r.duration);

        if (currentVisit != previousVisit)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.visitName + "</div>" +
                "      </div>" +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>Visit Type</div>" +
                "          <div class='value'>" + r.visitType + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.studyName + "</div>" +
                "          <div class='label'>Nursing</div>" +
                "          <div class='value'>" + showValue(r.nursing) + "</div>" +
                "          <div class='label'>Nutrition</div>" +
                "          <div class='value'>" + showValue(r.nutrition) + "</div>" +
                "          <div class='label'>Processing</div>" +
                "          <div class='value'>" + showValue(r.processing) + "</div>" +
                "          <div class='label'>Setup</div>" +
                "          <div class='value'>" + showValue(r.setup) + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Resource Name</th>" +
                "          <th>Resource Duration</th>" +
                "        </tr>";
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + r.resourceName +  "</td>" +
            "          <td>" + resourceLengthLabel + "</td>" +
            "        </tr>";

        if (iteration == 0){
            exportStr +='Visit Name,Visit Type,Local ID,Nursing,Nutrition,Processing,Setup,';
            for (var k = 0; k < 10; k++){
                exportStr +='Resource Name,Resource Duration,';
            }
            exportStr += '\n';
        }

        if(tableRow == 0){
            if (iteration != 0){
                exportStr += '\"\n';
            }
            exportStr +='\"'+r.visitName+ '\",\"'+r.visitType+ '\",\"'+removeAdditionalComma(r.studyName)+ '\",\"'+showValue(r.nursing)+ '\",\"'+showValue(r.nutrition)+ '\",\"'
                +showValue(r.processing) + '\",\"' + showValue(r.setup)+'\",\"'+removeAdditionalComma(r.resourceName) + '\",\"' + resourceLengthLabel;
        }else{
            exportStr +='\",\"'+removeAdditionalComma(r.resourceName) + '\",\"' + resourceLengthLabel;
        }

        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showVisitTemplateResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_visitTemplateResult.length);
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_visitTemplateResult.length;i++) {
        var r = report_visitTemplateResult[i];
        currentVisit = r.id;

        if (iteration != 0 && currentVisit != previousVisit)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }


        if (currentVisit != previousVisit)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.studyId + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Study Name</th>" +
                "          <th>Study Status</th>" +
                "          <th>Visit Name</th>" +
                "          <th>Visit Type</th>" +
                "          <th>Sublocation</th>" +
                "          <th>Research Pharmacy?</th>" +
                "          <th>Institution: Non CRC</th>" +
                "          <th>Non Institution: Non CRC</th>" +
                "          <th>Relative Time?</th>" +
                "          <th>Nursing</th>" +
                "          <th>Nutrition</th>" +
                "          <th>Processing</th>" +
                "          <th>Setup</th>" +
                "          <th>Comment</th>" +
                "        </tr>";
        }

        if (iteration == 0){
            exportStr +='Study Id,Study Name,Study Status,Visit Name,Visit Type,Sublocation,Research Pharmacy?,Institution: Non CRC,Non Institution: Non CRC,Relative Time?,Nursing,Nutrition,Processing,Setup,Comment'+ '\n';
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + r.studyName + "</td>" +
            "  	   <td>" + r.studyStatus + "</td>" +
            "          <td>" + r.name + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + r.sublocation + "</td>" +
            "          <td>" + yesNoValue(r.researchPharmacy) + "</td>" +
            "          <td>" + yesNoValue(r.institutionNonCRC) + "</td>" +
            "          <td>" + yesNoValue(r.nonInstitutionNonCRC) + "</td>" +
            "          <td>" + yesNoValue(r.relativeTime) + "</td>" +
            "          <td>" + showValue(r.nursing) + "</td>" +
            "          <td>" + showValue(r.nutrition) + "</td>" +
            "          <td>" + showValue(r.processing) + "</td>" +
            "          <td>" + showValue(r.setup) + "</td>" +
            "          <td>" + showValue(r.comment) + "</td>" +
            "        </tr>";
        exportStr +=removeAdditionalComma(r.studyId);
        exportStr +=',\"'+ removeAdditionalComma(r.studyName) + '\",\"'+ r.studyStatus + '\",\"'+r.name + '\",\"' + r.visitType + '\",\"' + r.sublocation + '\",\"' + yesNoValue(r.researchPharmacy) +
            '\",\"' + yesNoValue(r.institutionNonCRC) + '\",\"' + yesNoValue(r.nonInstitutionNonCRC) +
            '\",\"' + yesNoValue(r.relativeTime) + '\",\"' + showValue(r.nursing) +
            '\",\"' + showValue(r.nutrition) + '\",\"' + showValue(r.processing)
            + '\",\"' + showValue(r.setup) + '\",\"' + showValue(r.comment) + '\"\n';
        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showCRCAvailabilityResults() {
    report_handleDataResponse(report_crcAvailabilityResult.length);
    var tableRow = 0;
    exportStr = '';

    var out =    "    <div class='reportRow'>" +
        "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
        "        <tr style='font-weight:bold'>" +
        "          <th>Study Name</th>" +
        "          <th>Visit Name</th>" +
        "          <th># visits scheduled</th>" +
        "          <th># visits overbooked</th>" +
        "        </tr>";
    exportStr = 'Study Name,Visit Name,# visits booked normally,# visits overbooked\n';
    for (var i=0;i< report_crcAvailabilityResult.length;i++) {
        var r = report_crcAvailabilityResult[i];

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>"  + r.studyName +  "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + r.scheduled + "</td>" +
            "          <td>" + showValue(r.overbook) + "</td>" +
            "        </tr>";
        tableRow++;
        exportStr += removeAdditionalComma(r.studyName) + ',' + r.visitName + ',' + r.scheduled + ',' + showValue(r.overbook);
        if(i != report_crcAvailabilityResult.length-1) exportStr +='\n';
    }
    out += " </table>" +
        "    </div>" +
        "  <hr class='report' />";
    $('#report_results').html(out);
}

function report_showNutritionTasksResults(){

    // maybe a better way to handle no results?
    if (! report_nutritionTasksResult) return;

    var out = "";
    exportStr = '';
    report_handleDataResponse(report_nutritionTasksResult.length);
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;
    for (var i=0;i< report_nutritionTasksResult.length;i++) {
        var r = report_nutritionTasksResult[i];
        currentVisit = r.id;

        if (iteration != 0 && currentVisit != previousVisit)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }


        if (currentVisit != previousVisit)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.localId + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "           <th> Visit Name</th>" +
                "           <th> Visit Start Time </th>"  +
                "           <th> Visit End Time </th>" +
                "           <th> Subject Last Name</th>" +
                "           <th> Nutrition Visit Resources</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Local ID, Visit Name, Visit Start Time, Visit End Time,Subject Last Name,Nutrition Visit Resources,Anthropometry Simple,Anthropometry Complex, Meal Plan Calculation, Nutrient Analysis, Education Time, Questionnaire Time'+ '\n';
        }

        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + r.subjectLastName + "</td>" +
            "          <td>" + r.resource + "</td>" +
            "        </tr>";
        if(tableRow == 0){exportStr +=r.localId;}
        exportStr +=',\"' + r.visitName  + '\",\"' + showDateTime(r.scheduledStartTime) +
            '\",\"' + showDateTime(r.scheduledEndTime) + '\",\"' + r.subjectLastName  +
            '\",\"' +  removeAdditionalComma(r.resource) + '\"\n';
        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showVisitDurationByVisitTypeResults() {
    report_handleDataResponse(report_visitDurationByVisitTypeResult.length);
    var tableRow = 0;
    exportStr = '';

    var out =    "    <div class='reportRow'>" +
        "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
        "        <tr style='font-weight:bold'>" +
        "          <th>Local ID</th>" +
        "          <th>Booked Visit ID</th>" +
        "          <th>Scheduled Start Time</th>" +
        "          <th>Scheduled End Time</th>" +
        "          <th>Visit Type</th>" +
        "          <th>Visit Name</th>" +
        "          <th>Check In Date</th>" +
        "          <th>Check Out Date</th>" +
        "          <th>Visit Duration</th>" +
        "        </tr>";
    exportStr = 'Local ID,Booked Visit ID,Scheduled Start Time,Scheduled End Time,Visit Type,Visit Name,Check In Date,Check Out Date,Visit Duration\n';
    for (var i=0;i< report_visitDurationByVisitTypeResult.length;i++) {
        var r = report_visitDurationByVisitTypeResult[i];
        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.checkInTime), showDateTime(r.checkOutTime));
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=  "  <td>" + r.studyName +  "</td>" +
            "          <td>" + r.visitId + "</td>" +
            "          <td>" + showDateTime(r.scheduledStartTime) + "</td>" +
            "          <td>" + showDateTime(r.scheduledEndTime) + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td>" + showValue(visitLengthLabel) + "</td>" +
            "        </tr>";
        tableRow++;
        exportStr += removeAdditionalComma(r.studyName) + ',' + r.visitId + ',' + showDateTime(r.scheduledStartTime) + ',' + showDateTime(r.scheduledEndTime)
            + ',' + r.visitType + ',' + removeAdditionalComma(r.visitName) + ',' + showDateTime(r.checkInTime) + ',' + showDateTime(r.checkOutTime) + ',' + showValue(visitLengthLabel) + '\n';
    }
    out += " </table>" +
        "    </div>" +
        "  <hr class='report' />";
    $('#report_results').html(out);
}


function downloadReport() {
    document.getElementById('exportField').value = exportStr;
    document.getElementById('exportFileName').value = report_selectedReport.name;
    document.getElementById('exportForm').submit();
}


function downloadCustomReport() {
    if (report_selectedReport.name == 'daily_overview'){
        report_getExportDailyOverviewReport();
    }
    if (report_selectedReport.name == 'daily_resource'){
        report_getExportDailyResourceReport();
    }
}

function downloadFlatReport(event) {
    if (report_selectedReport.name == 'meta_kitchen'){
        event.preventDefault();
        document.getElementById('exportField').value = exportCustomStr;
        document.getElementById('exportFileName').value = report_selectedReport.name;
        document.getElementById('exportForm').submit();
    }
}

function report_getExportDailyOverviewReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=export_daily_overview", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_dailyOverviewResult = parsedData.dailyOverviewReport;
        report_showExportDailyOverviewResults();
    });
}

function report_showExportDailyOverviewResults() {
    exportBIStr = '';
    var currentVisit = -1;
    var previousVisit = -1;
    var iteration = 0;
    var tableRow = 0;
    report_handleDataResponse(report_dailyOverviewResult.length);
    exportBIStr +='Visit Start Time, Visit End Time, Subject Name, MRN, Local ID, Visit Name, Visit Type, Resource Name,Is part of the Visit Off Unit?, Clipboard, Setup, Check-In, Check-Out,Comment'+ '\n';

    for (var i=0;i< report_dailyOverviewResult.length;i++) {
        var r = report_dailyOverviewResult[i];
        currentVisit = r.bookedVisitId;

        if (currentVisit != previousVisit)  {
            tableRow = 0;
        }

        exportBIStr +='\"'+showDateTime(r.scheduledStartTime) + '\",\"' +showDateTime(r.scheduledEndTime) + '\",\"' +util_buildFullName(r.firstName, r.middleName, r.lastName) + '\",\"'
            +r.mrn + '\",\"' +r.localId + '\",\"' +r.visitName + '\",\"' +r.visitType + '\",\"' +removeAdditionalComma(r.resourceName) + '\",\"'
            + r.offInstitution  + '\",\"'+ '\",\"' + '\",\"'+ '\",\"' + '\",\"' +r.comment+ '\"\n';
        previousVisit = currentVisit;
        iteration++;
        tableRow++;
    }

    document.getElementById('exportField').value = exportBIStr;
    document.getElementById('exportFileName').value = report_selectedReport.name;
    document.getElementById('exportForm').submit();
}

function report_getExportDailyResourceReport() {
    var jsonData = JSON.stringify({
        startTime: getStartTime(),
        endTime: getEndTime()});
    $.post("rest/report/getReport?name=export_daily_resource", {data:jsonData}, function(data) {
        parsedData = $.parseJSON(data);
        report_dailyResourceResult = parsedData.dailyResourceReport;
        report_showExportDailyResourceResults();
    });
}
function report_showExportDailyResourceResults() {
    exportBIStr = '';
    report_handleDataResponse(report_dailyResourceResult.length);
    var currentResourceTypeId  = -1;
    var previousResourceTypeId  = -1;
    var iteration = 0;
    var tableRow = 0;
    exportBIStr +='Resource Name,Subject Name,MRN,Visit ID,Visit Name,Resource Start Time,Resource End Time,Resource Usage Duration,Comment 1, Comment 2, Comment 3, Comment 4'+ '\n';
    for (var i=0;i< report_dailyResourceResult.length;i++) {
        var r = report_dailyResourceResult[i];
        currentResourceTypeId = r.resourceTypeId;

        if (currentResourceTypeId  != previousResourceTypeId)  {
            tableRow = 0;
        }

        var visitLengthLabel = calculateAndFormatVisitTime(showDateTime(r.scheduledStartTime), showDateTime(r.scheduledEndTime));
        exportBIStr +='\"'+removeAdditionalComma(r.resourceName)+ '\",\"' +util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + '\",\"' + r.mrn + '\",\"'
            + r.visitId +'\",\"'
            + r.visitName +'\",\"'
            + showDateTime(r.scheduledStartTime) +'\",\"' + showDateTime(r.scheduledEndTime) +'\",\"' + visitLengthLabel+'\",\"' +r.comment+'\"\n';
        previousResourceTypeId = currentResourceTypeId;
        iteration++;
        tableRow++;
    }

    document.getElementById('exportField').value = exportBIStr;
    document.getElementById('exportFileName').value = report_selectedReport.name;
    document.getElementById('exportForm').submit();
}

function report_showBookedVisitServiceLevelByTypeResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_bookedVisitServiceLevelByTypeResult.length);
    var currentVisitTypeId = -1;
    var previousVisitTypeId = -1;
    var iteration = 0;

    for (var i=0;i< report_bookedVisitServiceLevelByTypeResult.length;i++) {
        var r = report_bookedVisitServiceLevelByTypeResult[i];
        currentVisitTypeId = r.visitId;

        if (iteration != 0 && currentVisitTypeId != previousVisitTypeId) {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentVisitTypeId != previousVisitTypeId)  {
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.visitType + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='15%'>Nursing</th>" +
                "          <th width='11%'># of Visits</th>" +
                "          <th width='11%'>Nutrition</th>" +
                "          <th width='9%'># of Visits</th>" +
                "          <th width='9%'>Processing</th>" +
                "          <th width='9%'># of Visits</th>" +
                "          <th width='11%'>Set Up</th>" +
                "          <th width='11%'># of Visits</th>" +
                "        </tr>";

            if(iteration == 0){
                exportStr += 'Visit Type,Nursing,# of Visits,Nutrition,# of Visits,Processing,# of Visits,Set Up,# of Visits \n';
            }
        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=    "<td> " + r.nursinglevel + "</td>" +
            "          <td>" + showValue(r.nursing) + "</td>" +
            "          <td> " + r.nutritionlevel + "</td>" +
            "          <td>" + showValue(r.nutrition) + "</td>" +
            "          <td> " + r.processinglevel + "</td>" +
            "          <td>" + showValue(r.processing) + "</td>" +
            "          <td> " + r.setuplevel + "</td>" +
            "          <td>" + showValue(r.setup) + "</td>" +
            "        </tr>";

        exportStr += r.visitType+',\"'+r.nursinglevel + '\",' + showValue(r.nursing) + ',' + r.nutritionlevel
            + ',' + showValue(r.nutrition) +',' + r.processinglevel + ',' + showValue(r.processing) +','+ r.setuplevel +
            ',' +showValue(r.setup)+'\n';

        previousVisitTypeId = currentVisitTypeId;
        iteration++;
    }

    $('#report_results').html(out);
}

function report_showRoomAvailabilityCheckResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_roomAvailabilityCheckResult.length);
    var currentVisitTypeId = -1;
    var previousVisitTypeId = -1;
    var iteration = 0;

    for (var i=0;i< report_roomAvailabilityCheckResult.length;i++) {
        var r = report_roomAvailabilityCheckResult[i];
        currentVisitTypeId = r.visitName;

        if (iteration != 0 && currentVisitTypeId != previousVisitTypeId)  {

            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentVisitTypeId != previousVisitTypeId)  {
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.visitName + "</div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='15%'>Resource Name</th>" +
                "          <th width='11%'>Open Time 1</th>" +
                "          <th width='11%'>Open Time 2</th>" +
                "          <th width='9%'>Open Time 3</th>" +
                "          <th width='9%'>Open Time 4</th>" +
                "          <th width='9%'>Open Time 5</th>" +
                "          <th width='11%'>Open Time 6</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';
            exportStr += 'Visit Type,Nursing,# of Visits,Nutrition,# of Visits,Processing,# of Visits,Set Up,# of Visits \n';

        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=    "<td> " + r.scheduledStartTime + "</td>" +
            "          <td>" + r.scheduledEndTime + "</td>" +
            "          <td> " + r.nutritionlevel + "</td>" +
            "          <td>" + showValue(r.nutrition) + "</td>" +
            "          <td> " + r.processinglevel + "</td>" +
            "          <td>" + showValue(r.processing) + "</td>" +
            "          <td> " + r.setuplevel + "</td>" +
            "          <td>" + showValue(r.setup) + "</td>" +
            "        </tr>";
        if(iteration == 0){exportStr +=r.visitType;}
        exportStr += ',\"'+r.nursinglevel + '\",' + showValue(r.nursing) + ',' + r.nutritionlevel
            + ',' + showValue(r.nutrition) +',' + r.processinglevel + ',' + showValue(r.processing) +','+ r.setuplevel +
            ',' +showValue(r.setup)+'\n';

        previousVisitTypeId = currentVisitTypeId;
        iteration++;
    }

    $('#report_results').html(out);
}

function report_showVisitTerminatedPriorToCompletionResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_visitTerminatedPriorToCompletionResult.length);
    var currentStudyId  = -1;
    var previousStudyId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_visitTerminatedPriorToCompletionResult.length;i++) {
        var r = report_visitTerminatedPriorToCompletionResult[i];
        currentStudyId = r.id;

        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='secondaryNameBlock'>" +
                "       <div class='mainName'>" + r.studyName + "</div>" +
                "      </div>"  +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportSecondary'>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='7%'>Visit Name</th>" +
                "          <th width='7%'>Visit Date</th>" +
                "          <th width='7%'>Subject Name</th>" +
                "          <th width='7%'>Unused Resources</th>" +
                "          <th width='7%'>Percent Used</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';

            exportStr +='Study Name,Local ID,';
            exportStr +='Visit Name,Resource End Time,Resource Duration,Scheduled Start Time,Scheduled End Time,Scheduled Visit Length,Over Midnight?,Sublocation,Resource Name,Billable,Visit Name,Visit Type,Study Subject, MRN,Birth Date'+ '\n';
        }
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "          <td>" + r.visitName + "</td>" +
            "          <td>" + showDateTime(r.startDate) + "</td>" +
            "          <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName) + "</td>" +
            "          <td>" + r.resourceName + "</td>" +
            "          <td>" + r.percentCompleted + "</td>" +
            "        </tr>";
        if(tableRow == 0){
            exportStr +='\"'+removeAdditionalComma(r.studyName) + '\",\"'+r.localId+'\",';
        }else{
            exportStr +=',,,,,,';
        }
        exportStr +='\"'+r.visitName + '\",\"' + showDateTime(r.startDate)
            +'\",\"' + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)+'\",\"' + removeAdditionalComma(r.resourceName)+'\",\"' + r.percentCompleted +'\"\n';
        previousStudyId = currentStudyId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}


function report_showVisitsFlaggedResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_visitsFlaggedResult.length);
    var currentStudyId  = -1;
    var previousStudyId  = -1;
    var iteration = 0;
    var tableRow = 0;

    for (var i=0;i< report_visitsFlaggedResult.length;i++) {
        var r = report_visitsFlaggedResult[i];
        currentStudyId = r.id;

        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentStudyId != previousStudyId)  {
            tableRow = 0;
            out +=
                "    <div class='reportRow'>" +
                "      <div class='statusBlockContainer'>" +
                "        <div class='statusBlock reportNoStatusSecondary'>" +
                "          <div class='label'>Study Name</div>" +
                "          <div class='value'>" + r.studyName + "</div>" +
                "          <div class='label'>Local ID</div>" +
                "          <div class='value'>" + r.localId + "</div>" +
                "          <div class='label'>PI Name</div>" +
                "          <div class='value'>" + r.piName + "</div>" +
                "        </div>" +
                "      </div>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th width='7%'>Subject Name</th>" +
                "          <th width='7%'>DOB</th>" +
                "          <th width='7%'>MRN</th>" +
                "          <th width='7%'>Visit Name</th>" +
                "          <th width='7%'>Visit Type</th>" +
                "          <th width='7%'>Check In</th>" +
                "          <th width='7%'>Check Out</th>" +
                "          <th width='7%'>Resource Duration Variation?</th>" +
                "          <th width='7%'>Activity Variation?</th>" +
                "        </tr>";
            if(i != 0) exportStr +='\n';

            exportStr +='Study Name,Local ID,PI Name,';
            exportStr +='Subject Name,DOB,MRN,Visit Name, Visit Type, Check In, Check Out, Resource Duration Variation?,Activity Variation?'+ '\n';
        }
        out +=  ((tableRow % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out += "   <td>" + util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName)  + "</td>" +
            "          <td>" + r.birthdate + "</td>" +
            "          <td>" + r.mrn + "</td>" +
            "          <td>" + r.visitName + "</td>" +
            "          <td>" + r.visitType + "</td>" +
            "          <td>" + showDateTime(r.checkInTime) + "</td>" +
            "          <td>" + showDateTime(r.checkOutTime) + "</td>" +
            "          <td>" + yesNoValue(r.varyDuration) + "</td>" +
            "          <td>" + yesNoValue(r.ommittedActivities) + "</td>" +
            "        </tr>";

        exportStr += removeAdditionalComma(r.studyName)+ '\",\"'+removeAdditionalComma(r.localId) + '\",\"'+removeAdditionalComma(r.piName) +'\",\"'
            + removeAdditionalComma(util_buildFullName(r.subjectFirstName, r.subjectMiddleName, r.subjectLastName))+'\",\"'+r.birthdate +'\",\"'+r.mrn
            +'\",\"' + removeAdditionalComma(r.visitName)+'\",\"' + r.visitType+'\",\"' + showDateTime(r.checkInTime)+'\",\"' + showDateTime(r.checkOutTime)
            +'\",\"' + yesNoValue(r.varyDuration)+'\",\"' + yesNoValue(r.ommittedActivities)+'\"\n';
        previousStudyId = currentStudyId;
        iteration++;
        tableRow++;
    }
    $('#report_results').html(out);
}

function report_showAncillaryOnlyByProtocolResults() {
    var out = "";
    exportStr = '';
    report_handleDataResponse(report_ancillaryOnlyByProtocolResult.length);
    var currentStudyId = -1;
    var previousStudyId = -1;
    var iteration = 0;

    for (var i=0; i < report_ancillaryOnlyByProtocolResult.length; i++) {
        var count = report_ancillaryOnlyByProtocolResult.length - 1;
        var r = report_ancillaryOnlyByProtocolResult[i];
        currentStudyId = r.studyId;

        if (iteration != 0 && currentStudyId != previousStudyId)  {
            out += " </table>" +
                "    </div>" +
                "  <hr class='report' />";
        }

        if (currentStudyId != previousStudyId)  {
            out +=
                "    <div class='reportRow'>" +
                "      <div style='clear: both;'></div>" +
                "      <table width='100%' border='0' cellspacing='0' cellpadding='5' style='font-size: 90%; table-layout: fixed;'>" +
                "        <tr style='font-weight:bold'>" +
                "          <th>Protocol</th>" +
                "          <th></th>" +
                "          <th colspan='2' align='center'>Ancillary Only Visits</th>" +
                "        </tr>"+
                "        <tr style='font-weight:bold'>" +
                "          <th></th>" +
                "          <th>A</th>" +
                "          <th>B</th>" +
                "          <th>D</th>" +
                "        </tr>";
        }

        out +=  ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr>");
        out +=    "<td style='word-wrap: break-word;'>" + r.studyName + "</td>" +
            "          <td>" + showValue(r.crcA) + "</td>" +
            "          <td>" + showValue(r.crcB) + "</td>" +
            "          <td>" + showValue(r.crcC) + "</td>" +
            "        </tr>";

        if (iteration == 0){
            exportStr += 'Protocol,,Ancillary Only Visits\n';
            exportStr += ',A, B, D\n';
        }

        exportStr += removeAdditionalComma(r.studyName) + ',' + showValue(r.crcA) + ','
            + showValue(r.crcB) +',' + showValue(r.crcC)+'\n';

        if (i == count){
            out +=  ("<tr>");
            out +=    "<td style='word-wrap: break-word;'>" + 'Total' + "</td>" +
                "          <td>" + showValue(r.totalCRCA) + "</td>" +
                "          <td>" + showValue(r.totalCRCB) + "</td>" +
                "          <td>" + showValue(r.totalCRCC) + "</td>" +
                "        </tr>";
            exportStr += 'Total' + ',' + showValue(r.totalCRCA) + ','
                + showValue(r.totalCRCB) +',' + showValue(r.totalCRCC)+'\n';
        }
        previousStudyId = currentStudyId;
        iteration++;
    }

    $('#report_results').html(out);
}

