/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
function renderBreadcrumbs(screen) {
    switch (screen) {
        case 'home_screen':
            $(".breadcrumbs").html("");
            break;
        case 'report_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Standard Reports");
            break;
        case 'mgmt_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Management");
            break;
        case 'mgmt_user_view_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:mgmtModule()'>Management</a> &gt; User Details");
            break;
        case 'mgmt_user_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:userReadData()'>Management</a> &gt; Edit User");
            break;
        case 'mgmt_user_new_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:mgmtModule()'>Management</a> &gt; Create New User");
            break;
        case 'subject_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Subjects");
            break;
        case 'subject_create_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:subjectModule()'>Subjects</a> <span class='breadcrumbSep'> &gt; </span> Create New Subject");
            break;
        case 'subject_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:subjectModule()'>Subjects</a> <span class='breadcrumbSep'> &gt; </span> Edit Subject");
            break;
        case 'subject_view_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:subjectModule()'>Subjects</a> &gt; Subject Details");
            break;
        case 'studyStaff_subject_view_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:subjectModule()'>Subject Search Form</a> &gt; " +
                "<a href='subject_search.html'>Subject Found</a> &gt; Subject Details");
            break;
        case 'subject_studyStaff_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:subjectModule()'>Subject Search Form</a> &gt; " +
                "<a href='subject_search.html'>Subject Found</a> &gt;" +
                "<a href='javascript:subjectReadData()'>Subject Details</a> &gt; Edit Subject");
            break;
        case 'subject_search_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:subjectModule()'>Subject Search Form</a> &gt; Subject Found");
            break;
        case 'resource_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Resources");
            break;
        case 'resource_new_resource_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Create New Resource");
            break;
        case 'resource_edit_resource_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#DefaultAvailability'>Resource Detail</a> &gt; Edit Resource");
            break;
        case 'resource_detail_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Resource");
            break;
        case 'resource_da_add_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#DefaultAvailability'>Resource Detail</a> &gt; Add Default Availability");
            break;
        case 'resource_da_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#DefaultAvailability'>Resource Detail</a> &gt; Edit Default Availability");
            break;
        case 'resource_alternative_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#ResourceAlternate'>Resource Detail</a> &gt; Add Alternative Resource(s)");
            break;
        case 'resource_ta_add_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#TemporaryAdjustment'>Resource Detail</a> &gt; Add Temporary Adjustment");
            break;
        case 'resource_ta_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='resource_detail.html#TemporaryAdjustment'>Resource Detail</a> &gt; Edit Temporary Adjustment");
            break;
        case 'resource_close_sub_list':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Sub-Location Closure List");
            break;
        case 'resource_close_sub_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; " +
                "<a href='sublocation_closure_screen.html'>Sub-Location Closure List</a> &gt; New Sub-Location Closure");
            break;
        case 'resource_room_gantt_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Room Resource Usage Gantt");
            break;
        case 'resource_nursing_gantt_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Nursing Resource Usage Gantt");
            break;
        case 'resource_nutrition_gantt_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:resourceModule()'>Resources</a> &gt; Nutrition Resource Usage Gantt");
            break;
        case 'study_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Studies List");
            break;
        case 'study_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; Study Details");
            break;
        case 'study_new_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; Create New Study");
            break;
        case 'study_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; Edit Study Details");
            break;
        case 'study_visit_main_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies</a> &gt; Visit</a>");
            break;
        case 'study_visit_view_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; Visit Details");
            break;
        case 'study_subject_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; Add Study Subject");
            break;
        case 'study_staff_subject_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; " +
                "<a href='subject_search.html'>Add Study Subject</a> &gt; Subject Found");
            break;
        case 'study_member_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; Add Study Member");
            break;
        case 'study_details_subjects_detail':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyModule()'>Studies List</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyReadData()'>Study Details</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyShowSubjectsTab();'> Study Subjects</a> <span class='breadcrumbSep'> &gt; </span> " + "Subject Details");
            break;
        case 'study_details_subjects_detail_edit':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyModule()'>Studies List</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyReadData()'>Study Details</a> <span class='breadcrumbSep'> &gt; </span> " +
                "<a href='javascript:studyShowSubjectsTab();'> Study Subjects</a> <span class='breadcrumbSep'> &gt; </span> " + "Edit Subject");
            break;
        case 'study_visit_edit_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; " +
                "<a href='visit_detail.html'>Visit Details</a> &gt; " +" Edit Visit Template");
            break;
        case 'study_visit_copy_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; Copy Visit Template");
            break;
        case 'study_visit_approval_form_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; " +
                "<a href='visit_detail.html'>Visit Details</a> &gt;Approve Visit Template");
            break;
        case 'study_visit_new_form':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
                "<a href='javascript:studyModule()'>Studies List</a> &gt; " +
                "<a href='javascript:studyReadData()'>Study Details</a> &gt; New Visit Template");
            break;
        case 'appointment_screen':
            $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; Appointments");
            break;
    }
}


function renderReportBreadcrumbs(reportTitle) {
    $(".breadcrumbs").html("<a href='javascript:homeModule()'>Home</a> &gt; " +
        "<a href='javascript:reportModule()'>Reports List</a> &gt; " + reportTitle);
}

