/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var updatedRoles;
var rolesExceptFinalApprover;

$(document).ready(function(){
    getMgmtStaticLists();
});

function getMgmtStaticLists() {
    $.get("rest/app/getStaticLists", {}, function(data) {

	parsedData = $.parseJSON(data);

	roles = parsedData.roles;
	institutionRoles = parsedData.institutionRoles;
	institutions = parsedData.institutions;
	credentials = parsedData.credentials;
	divisions = parsedData.divisions;
	departments = parsedData.departments;
	facultyRanks = parsedData.facultyRanks;

	roleSelectOptions = buildSelectOptions(roles, 'name', 'choose');
	institutionRoleSelectOptions = buildRoleSelectOptions(institutionRoles, 'name', 'choose');
	institutionSelectOptions = buildSelectOptions(institutions, 'longName', 'choose');
	credentialSelectOptions = buildSelectOptions(credentials, 'name', 'choose');
	departmentSelectOptions = buildSelectOptions(departments, 'name', 'choose');
	divisionSelectOptions = buildSelectOptions(divisions, 'name', 'choose');
	facultyRankSelectOptions = buildSelectOptions(facultyRanks, 'name', 'choose');

	$("#mgmt_role").html(roleSelectOptions);
	$("#mgmt_institution").html(institutionSelectOptions);
	$("#mgmt_institutionRole").html(institutionRoleSelectOptions);
	$("#mgmt_credential").html(credentialSelectOptions);
	$("#mgmt_division").html(divisionSelectOptions);
	$("#mgmt_department").html(departmentSelectOptions);
	$("#mgmt_facultyRank").html(facultyRankSelectOptions);
    });
}

function commonUserScreenData(){
    commonData();
    renderBreadcrumbs('mgmt_screen');
    initial_load = true;
    resetUI();
    currentPage = 1;
    loadUserData(currentPage);	   
}

function commonCreateUserData(){
    commonData();
    getUpdatedRolesLists();
    $("#mgmt_primaryPhone").mask("999-999-9999");
    $("#mgmt_secondaryPhone").mask("999-999-9999");
    var mode = JSON.parse(sessionStorage.getItem("mode"));
    mgmt_setFormMode(mode);
    if (mode == 'edit'){
	setTimeout(function() { mgmt_loadEditForm(); }, 500);
    }
}


function commonUserDetailData(){
    commonData();
    app_selectedUser = JSON.parse(sessionStorage.getItem("app_selectedUser"));
    mgmt_setFormMode('view');
}


function addNewUserClick() {
    sessionStorage.setItem("mode", JSON.stringify('new'));
    window.location.href = "create_user.html";
}


function editUserClick() {
    sessionStorage.setItem("mode", JSON.stringify('edit'));
    window.location.href = "create_user.html";
}

function editUser(){
    sessionStorage.setItem("mode", JSON.stringify('edit'));
    window.location.href = "create_user.html";
};

function institutionRoleChangeClick() {
    if(($.trim($("#mgmt_institutionRole").val()) == "ROLE_STUDY_STAFF") || ($.trim($("#mgmt_institutionRole").val()) == "ROLE_GENERAL_VIEW"))  { 
	$("#mgmt_role").html(rolesExceptFinalApprover);
    }
    else {
	$("#mgmt_role").html(roleSelectOptions);
    }
}

function getUpdatedRolesLists() {
    $.getJSON("rest/management/getRolesList", function(data) {
        rolesExceptFinalApprover = buildsSelectsOptions(data, 'id', 'choose');
  });
}

function buildsSelectsOptions(list, optionTextProperty, choiceLabel) { 
    var html = [];    
    html[html.length] = "<option value=''>" + choiceLabel + "</option>";
    for (var i = 0, len = list.length; i < len; i++) {
	html[html.length] = "<option value='";
	html[html.length] = list[i].id;
	html[html.length] = "'>";
	html[html.length] = list[i].name;
	html[html.length] = "</option>";
    }
    return html.join('');
}

function userEditData(){
    sessionStorage.setItem("mode", JSON.stringify('edit'));
    window.location.href = "create_user.html";
}

function userReadData(){
    sessionStorage.setItem("mode", JSON.stringify('search_view'));
    window.location.href = "mgmt_detail.html";
}

function showUserDetail(id) {
    $.getJSON("rest/management/getUserData?user="+id, function(data) {
	sessionStorage.setItem("app_selectedUser", JSON.stringify(data));
	sessionStorage.setItem("mode", JSON.stringify('view'));
	window.location.href="mgmt_detail.html";
    });      
}

function filterUserClick() {
    currentPage = 1;
    loadUserData(currentPage);
}

function resetUserClick() {
    $("#filters_string").val('');
    currentPage = 1;
    loadUserData(currentPage);   
}

function statusDialog(id) {
    $("#status-dialog-confirm").dialog({
	resizable: true,
	height:100,
	width: 600,
	modal: true,
	buttons: {
	    "Yes": function() {
		$.getJSON("rest/management/changeUserStatus?user="+id, function(data) {
		    currentPage = 1;
		    loadUserData(currentPage);
		    util_showMainMessage("User Status changed");
		});   
		$( this ).dialog( "close" );
	    },
	    "No": function() {
		$( this ).dialog( "close" );
		return;
	    }
	}
    });
}

function userChangeStatusConfirmation(id) {
    statusDialog(id);
}

function crudUserClick() {
    processUserForm();
}

function passwordResetClick(){
    user = JSON.parse(sessionStorage.getItem("userData"));
    var isValid = true;
    $('#mgmt_passwordChangeValidation').css({visibility: "hidden"});
    $('#mgmt_passwordChangeConfirmValidation').css({visibility: "hidden"});
    if($.trim($("#mgmt_passwordChange").val()).length < 1) { showError('#mgmt_passwordChangeValidation'); isValid = false; }
    if($.trim($("#mgmt_passwordChangeConfirm").val()).length < 1) { showError('#mgmt_passwordChangeConfirmValidation'); isValid = false; }
    if($.trim($("#mgmt_passwordChangeConfirm").val()).length < 1) { showError('#mgmt_passwordChangeConfirmValidation'); isValid = false; }
    if($.trim($("#mgmt_passwordChange").val()).length < 8 || $.trim($("#mgmt_passwordChangeConfirm").val()).length < 8) { showError('#mgmt_passwordChangeValidation', 'must be at least 8 chararcters long'); isValid = false; }
    if(checkPassword($.trim($("#mgmt_passwordChange").val())) == false) { showError('#mgmt_passwordChangeValidation', 'must contain a lowercase, uppercase, digit, and special character'); isValid = false; }
    if($.trim($("#mgmt_passwordChange").val()) != $.trim($("#mgmt_passwordChangeConfirm").val())) { showError('#mgmt_passwordChangeValidation', 'passwords must match'); isValid = false; }

    if (isValid == false) {
	    return;
    }

    $('#mgmt_passwordChangeLoading').css({visibility: "visible"});
    var jsonData = JSON.stringify({id: user.id, password: $.trim($("#mgmt_passwordChange").val()) });

    $.post("rest/management/updatePassword", {data:jsonData}, function(data) {
	var parsedData = $.parseJSON(data);
	$('#mgmt_responseLoading').css({visibility: "hidden"});
	var confirmationMessage = "";
	if (parsedData.result == true) {
	    confirmationMessage = "Password updated";
	    $('#mgmt_passwordChangeValidation').css({visibility: "hidden"});
	    $('#mgmt_passwordChangeConfirmValidation').css({visibility: "hidden"});
	    $('#mgmt_passwordChange').val('');
	    $('#mgmt_passwordChangeConfirm').val('');
	    if (user.previousLoginTime == ""){
		alert("Password updated and system is now going to log you out. Please login with your new password.");
		sessionStorage.removeItem("userData");
		window.location.href = "j_spring_security_logout";
	    }
	    else {
		util_showMainMessage(confirmationMessage);
	    }
	}
	else { 
	    confirmationMessage = parsedData.errorMsg;
	    util_showMainMessage(confirmationMessage);
	}
    });
}

function restoreUserClick(){
    mgmt_clearErrors();
    mgmt_loadEditForm();
}

function cancelUserClick(){
    if (mgmt_formMode == 'new'){
	window.location.href="mgmt_screen.html";
    }
    else {
	sessionStorage.setItem("mode", JSON.stringify('view'));
	window.location.href="mgmt_detail.html";
    }
}