/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var changeSubjectId;
var orderBy;


function checkinAppointmentClick() {
    var comment = $.trim($("#wizard_comment").val());
    $("#checkin-visit-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                sessionStorage.setItem("eventid", JSON.stringify(eventid));
                sessionStorage.setItem("comment", JSON.stringify(comment));
                checkinAppointment();
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function restoreSubjectClick() {
    subject_clearErrors();
    subject_loadEditForm();
}

function cancelSubjectClick() {
    //window.location.href = "subject_search_form.html";
}

function crudSubjectClick() {
    processSubjectForm('new');
}

function crudDemographicSubjectClick() {
    processSubjectDemoDataForm();
}

function subject_clearErrors() {
    $('#subject_firstNameValidation').css({visibility: "hidden"});
    $('#subject_lastNameValidation').css({visibility: "hidden"});
    $('#subject_primaryPhoneValidation').css({visibility: "hidden"});
    $('#subject_sexValidation').css({visibility: "hidden"});
    $('#subject_birthdateValidation').css({visibility: "hidden"});
    $('#subject_raceValidation').css({visibility: "hidden"});
    $('#subject_ethnicityValidation').css({visibility: "hidden"});
    $('#subject_streetAddress1Validation').css({visibility: "hidden"});
    $('#subject_streetAddress2Validation').css({visibility: "hidden"});
    $('#subject_cityValidation').css({visibility: "hidden"});
    $('#subject_zipValidation').css({visibility: "hidden"});
    $('#subject_countryValidation').css({visibility: "hidden"});
    $('#subject_generalValidation').css({visibility: "hidden"});
    $('#subject_mrnValidation').css({visibility: "hidden"});
}

function processSubjectForm(mode) {
    var isValid = true;
    subject_clearErrors();

    if($.trim($("#subject_firstName").val()).length < 1) {
        showError('#subject_firstNameValidation');
        isValid = false;
    }
    if($.trim($("#subject_lastName").val()).length < 1) {
        showError('#subject_lastNameValidation');
        isValid = false;
    }

    if($.trim($("#subject_sex").val()).length < 1) {
        showError('#subject_sexValidation');
        isValid = false;
    }
    if($.trim($("#subject_race").val()).length < 1) {
        showError('#subject_raceValidation');
        isValid = false;
    }

    if ($.trim($("#subject_primaryContactNumber").val()).length < 1) {
        showError('#subject_primaryPhoneValidation');
        isValid = false;
    }

    if($.trim($("#subject_ethnicity").val()).length < 1) {
        showError('#subject_ethnicityValidation');
        isValid = false;
    }

    if($.trim($("#subject_streetAddress1").val()).length < 1) {
        showError('#subject_streetAddress1Validation');
        isValid = false;
    }
    if($.trim($("#subject_streetAddress2").val()).length < 1) {
        showError('#subject_streetAddress2Validation');
    }

    if($.trim($("#subject_city").val()).length < 1) {
        showError('#subject_cityValidation');
        isValid = false;
    }
    if($("#subject_country").val().length < 1) {
        showError('#subject_countryValidation');
        isValid = false;
    }
    if(($.trim($("#subject_zip").val()).length < 5) || ($.trim($("#subject_zip").val()).length > 5)) {
        showError('#subject_zipValidation');
        isValid = false;
    }

    var candidateMrn = $.trim($("#subject_mrn").val());
    var mrnRegexObj = /^[0-9]+$/;
    if (candidateMrn.length < 1) {
        showError('#subject_mrnValidation');
        isValid = false;
    }
    else if ( ! mrnRegexObj.test(candidateMrn) ) {
        showError('#subject_mrnValidation', "MRN can only contain digits. Please remove all other characters and special characters before saving");
        isValid = false;
    }


    var regexObj = /^\(?([0-9]{3})\)?[-. ]?([0-9]{3})[-. ]?([0-9]{4})$/;

    if (regexObj.test($.trim($("#subject_primaryContactNumber").val()))) {
        $("#subject_primaryContactNumber").val($.trim($("#subject_primaryContactNumber").val()).replace(regexObj, "($1) $2-$3"));
    }
    else {
        $('#subject_generalValidation').text('Primary Phone not a valid phone number format');
        $('#subject_generalValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if($.trim($("#subject_secondaryContactNumber").val()).length > 0) {
        if (regexObj.test($.trim($("#subject_secondaryContactNumber").val()))) {
            $("#subject_secondaryContactNumber").val($.trim($("#subject_secondaryContactNumber").val()).replace(regexObj, "($1) $2-$3"));
        }
        else {
            $('#subject_generalValidation').text('secondary phone not a valid phone number format');
            $('#subject_generalValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
            isValid = false;
        }
    }

    var DOB = null;
    var subject_birthdateVal = $("#subject_birthdate").val();

    if (subject_birthdateVal == '') {
        $('#subject_birthdateValidation').css({display:'inline'});
        $('#subject_birthdateValidation').text('Please enter valid birth date');
        $('#subject_birthdateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }
    else {
        DOB = $("#subject_birthdate").datepicker('getDate');
        DOB.setHours(0,0,0,0);

        var today = new Date();
        today.setHours(0,0,0,0);
        if (DOB != null) {
            if (DOB >= today) {
                $('#subject_birthdateValidation').css({display:'inline'});
                $('#subject_birthdateValidation').text('Please enter valid birth date');
                $('#subject_birthdateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
                isValid = false;
            }
        }
    }

    var studyId = $('#subject_study').val();
    var stateId = $('#subject_state').val();

    if (isValid == false) {
        return;
    }
    DOB.setHours(10);
    DOB.setMinutes(0);
    $('#subject_responseLoading').css({visibility: "visible"});

    var jsonData = JSON.stringify({
        id: (app_selectedSubject != null ? app_selectedSubject.id : 0),
        firstName: $.trim($("#subject_firstName").val()),
        middleName: $.trim($("#subject_middleName").val()),
        lastName: $.trim($("#subject_lastName").val()),
        mrn: $.trim($("#subject_mrn").val()),
        gender: $.trim($("#subject_sex").val()),
        primaryContactNumber: $.trim($("#subject_primaryContactNumber").val()),
        secondaryContactNumber: $.trim($("#subject_secondaryContactNumber").val()),
        birthday: DOB.toString(),
        race: $('#subject_race').val(),
        ethnicity: $('#subject_ethnicity').val(),
        streetAddress1: $.trim($("#subject_streetAddress1").val()),
        streetAddress2: $.trim($("#subject_streetAddress2").val()),
        city: $('#subject_city').val(),
        state: (stateId != '' ? stateId : 0),
        country: $('#subject_country').val(),
        zip: $.trim($("#subject_zip").val()),
        comment : $.trim($("#subject_comment").val()),
        studyId : (studyId != '' ? studyId : 0),
        active: true,
        user: user
    });

    var url = "rest/subject/createSubject";
    if (mode == 'edit') {
        url = "rest/subject/updateSubject";
    }

    $.post(url, {data:jsonData}, function(data) {
        var parsedData = $.parseJSON(data);
        if (parsedData.result == false){
            util_showMainMessage(parsedData.errorMsg);
            $('#subject_responseLoading').css({visibility: "hidden"});
            return;
        }
        else {
            if (demoData == true) {
                checkinAppointment();
                return;
            }
            else {
                if (mode == 'new'){
                    alert("New subject was created.");
                }
                if (mode == 'edit') {
                    alert("Subject updated.");
                }
                $('#subject_responseLoading').css({visibility: "hidden"});
                subject_clearErrors();
                subjectModule();
            }
        }
    });
}

var demoData = false;
function processSubjectDemoDataForm(){
    subject_clearErrors();
    demoData = true;
    processSubjectForm('edit');
}

function checkinAppointment() {
    var checkInComment = JSON.parse(sessionStorage.getItem("comment"));
    eventid = JSON.parse(sessionStorage.getItem("eventid"));
    home_check = JSON.parse(sessionStorage.getItem("home_cal"));
    $("#appt_wizard_scheduled_visit_details").dialog("close");
    window.location.hash = '';
    $.blockUI();
    jsonData = JSON.stringify({id: eventid, comment: checkInComment});
    $.post("rest/appointment/checkinVisit",{data:jsonData}, function(data) {
        $.unblockUI();
        checkInComment = null;
        searching_appointments = false;
        util_showMainMessage("The visit has been Checked-In.");
        sessionStorage.setItem("is_navigated", false);
        sessionStorage.setItem("eventid", "");
        alert("The visit has been Checked-In.");
        if (home == true || home_check == true){
            homeModule();
        }
        else {
            appointmentModule();
            if (start != null){
                $('#appt_calendar').fullCalendar('gotoDate', start);
            }
            else {
                $('#appt_calendar').fullCalendar('gotoDate', new Date());
            }
        }
    });
}
