/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
$(document).ready(function(){
    if (feedback.handleGlobally()) {
        feedback.init();
    }
});


var feedback = (function(){
    var handleGlobally = true;

    function handleByPage(){
        handleGlobally = false;
    }

    function init(){
        $('.helpLinks').css({display: 'none'});
        $.ajax({
            url: "/scheduler-resources/zendesk-properties.txt",
            success: function (data) {
                var lines = data.split('\n');
                if (lines.length >= 5) {
                    var zenboxcss = lines[4].split('=')[1];
                    $.loadCSS(zenboxcss);
                    $('.helpLinks').css({display: 'inline'});
                    var zenboxjs = lines[3].split('=')[1];
                    $.getScript(zenboxjs, function () {
                        var dropboxId = lines[0].split('=')[1];
                        var url = lines[1].split('=')[1];
                        var helpUrl = lines[2].split('=')[1];
                        var help = document.getElementsByName('helpLink')[0];
                        help.href = helpUrl;
                        if (typeof(Zenbox) !== "undefined") {
                            Zenbox.init({
                                dropboxID: dropboxId,
                                url: url,
                                tabTooltip: "Support",
                                tabImageURL: "https://p4.zdassets.com/external/zenbox/images/tab_support.png",
                                tabColor: "#0A507D",
                                tabPosition: "Left"
                            });
                        }
                    });
                }
            },
            error: function (data) {
                console.log("error in initializing zenbox:", data);
            }
        });
    }

    return {
        init: init,
        handleByPage: handleByPage,
        handleGlobally: function(){ return handleGlobally;}
    };

}());