/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var noSublocationsSelected = true;

function resource_da_createWidgets() {
    $('#resource_da_startTime').timepicker({
        controlType: 'select',
        timeFormat: 'h:mm tt',
        minuteMax: 59,
        stepMinute: 15,
        ampm: true
    });

    $('#resource_da_endTime').timepicker({
        controlType: 'select',
        timeFormat: 'h:mm tt',
        minuteMax: 59,
        stepMinute: 15,
        ampm: true
    });
}

function resource_ta_createWidgets() {
    $('#resource_ta_startDateTime').datetimepicker({
        numberOfMonths: 3,
        showButtonPanel: true,
        buttonImage: "images/calendar.gif",
        showOn: "button",
        buttonImageOnly: true,
        controlType: 'select',
        timeFormat: 'hh:mm tt',
        stepMinute: 15,
        minuteMax: 59,
        ampm: true
    });

    $('#resource_ta_endDateTime').datetimepicker({
        numberOfMonths: 3,
        showButtonPanel: true,
        buttonImage: "images/calendar.gif",
        showOn: "button",
        buttonImageOnly: true,
        controlType: 'select',
        timeFormat: 'hh:mm tt',
        stepMinute: 15,
        minuteMax: 59,
        ampm: true
    });
}

function sublocationClosureInterval_createWidgets() {
    $('#sublocation_startDate').datetimepicker({
        numberOfMonths: 3,
        showButtonPanel: true,
        buttonImage: "images/calendar.gif",
        showOn: "button",
        buttonImageOnly: true,
        controlType: 'select',
        timeFormat: 'hh:mm tt',
        stepMinute: 15,
        minuteMax: 59,
        ampm: true
    });
    $('#sublocation_endDate').datetimepicker({
        numberOfMonths: 3,
        showButtonPanel: true,
        buttonImage: "images/calendar.gif",
        showOn: "button",
        buttonImageOnly: true,
        controlType: 'select',
        timeFormat: 'hh:mm tt',
        stepMinute: 15,
        minuteMax: 59,
        ampm: true
    });
}

function resource_setFormMode(mode) {
    resource_formMode = mode;
    $('#resource_confirmationMessage').css({visible: "hidden"});
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    if (mode == 'new') {
        renderBreadcrumbs('resource_new_resource_form');
        $('#resource_selected_resource_name').text('');
        $('#resource_resource_form_title').text('New Resource');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.formTextReadOnly').css({display: "none"});
        $('.requiredIcon').css({visibility: "visible"});
        $('.formSelectInput').css({display: "inline"});
        resource_clearForm();
    }
    else if (mode == 'edit') {
        renderBreadcrumbs('resource_edit_resource_form');
        $('#resource_selected_resource_name').text(app_selectedResource.resource);
        $('.requiredIcon').css({visibility: "visible"});
        $('.requiredFieldKey').css({visibility: "visible"});
        $('#resource_resource_form_title').text('Edit Resource');
        $('.formTextReadOnly').css({display: "inline"});
        $('.formSelectInput').css({display: "none"});
        $('#resource_resourceNameReadOnly').text(app_selectedResource.resource);
        resource_clearErrors();
    }
}

function resource_da_setFormMode(mode) {
    resource_da_formMode = mode;
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    $('#resource_default_resource_name').text(app_selectedResource.resource);
    if (mode == 'new') {
        renderBreadcrumbs('resource_da_add_form');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#resource_da_form_title').text('Add Default Availability');
        resource_da_createWidgets();
        $("#resource_da_startTime").val('12:00 am');
        $("#resource_da_endTime").val('12:00 am');
        resource_da_clearForm();
        $("#resource_da_checkboxes :checkbox").each(function(){
            $(this).removeAttr("disabled");
        });
        app_selectedResourceSchedule = null;
    }
    else if (mode == 'edit') {
        renderBreadcrumbs('resource_da_edit_form');
        $('#resource_da_form_title').text('Edit Default Availability');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        resource_da_createWidgets();
        resource_da_clearForm();
        resource_da_loadEditForm();
    }
}

function resource_ta_setFormMode(mode) {
    resource_ta_formMode = mode;
    app_selectedResource = JSON.parse(sessionStorage.getItem("resourceData"));
    $('#resource_tempAdjustment_resource_name').text(app_selectedResource.resource);
    if (mode == 'new') {
        renderBreadcrumbs('resource_ta_add_form');
        $('#resource_ta_form_title').text('Add Temporary Adjustment');
        $('.requiredIcon').css({visibility: "visible"});
        $('.requiredFieldKey').css({visibility: "visible"});
        resource_ta_createWidgets();
        resource_ta_clearForm();
        app_selectedTempAdj = null;
    }
    else if (mode == 'edit') {
        renderBreadcrumbs('resource_ta_edit_form');
        $('#resource_ta_form_title').text('Edit Temporary Adjustment');
        $('.requiredIcon').css({visibility: "visible"});
        $('.requiredFieldKey').css({visibility: "visible"});
        resource_ta_createWidgets();
        resource_ta_clearForm();
        resource_ta_loadEditForm();
    }
}

function resource_ta_loadEditForm() {
    app_selectedTempAdj = JSON.parse(sessionStorage.getItem("selectedTempAdj"));
    var resource_ta_startDateVal = app_selectedTempAdj.startTime;
    var resource_ta_endDateVal = app_selectedTempAdj.endTime;
    $("#resource_ta_startDateTime").val(resource_ta_startDateVal);
    $("#resource_ta_endDateTime").val(resource_ta_endDateVal);
    $('#resource_ta_quantity').val(app_selectedTempAdj.quantity);
}

function resource_da_loadEditForm() {
    app_selectedResourceSchedule = JSON.parse(sessionStorage.getItem("selectedResourceSchedule"));
    $("#resource_da_checkboxes :checkbox").each(function() {
        if ($(this).attr("name") == app_selectedResourceSchedule.dayOfWeek) {
            this.checked = true;
        }
        $(this).attr("disabled", true);
    });
    $('#resource_da_quantity').val(app_selectedResourceSchedule.quantity);
    $('#resource_da_startTime').val(showStandardTime(app_selectedResourceSchedule.startTime));
    $('#resource_da_endTime').val(showStandardTime(app_selectedResourceSchedule.endTime));
}

function cancelResourceClick() {
    mode = JSON.parse(sessionStorage.getItem("mode"));
    if (mode == 'new'){
        resourceModule();
    }
    else {
        window.location.href = "resource_detail.html#DefaultAvailability";
    }
}

function cancelDefaultAvailabilityClick() {
    window.location.href = "resource_detail.html#DefaultAvailability";
}

function cancelTemporaryAdjustmentClick() {
    resource_ta_clearForm();
    window.location.href = "resource_detail.html#TemporaryAdjustment";
}

function crudDefaultAvailabilityClick() {
    resource_da_clearErrors();
    var isValid = true;
    var noDaysSelected = true;
    resource_da_days = [];

    $("#resource_da_checkboxes :checkbox").each(function(){
        if (this.checked) {
            resource_da_days.push($(this).attr("name"));
            noDaysSelected = false;
        }
    });

    if (noDaysSelected == true) {
        $('#resource_da_dayValidation').text('Please select a Day');
        $('#resource_da_dayValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    var resource_da_startTimeVal = $('#resource_da_startTime').val();
    var resource_da_endTimeVal = $('#resource_da_endTime').val();
    if (resource_da_startTimeVal == null) {
        $('#resource_da_startTimeValidation').css({display:'inline'});
        $('#resource_da_startTimeValidation').text('Please enter valid start time');
        $('#resource_da_startTimeValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (resource_da_endTimeVal == null) {
        $('#resource_da_endTimeValidation').css({display:'inline'});
        $('#resource_da_endTimeValidation').text('Please enter valid end time');
        $('#sublocation_endTimeValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    var resourceStart = (new Date (new Date(2008,0,1).toDateString() + ' ' + resource_da_startTimeVal));
    var resourceEnd = (new Date (new Date(2008,0,1).toDateString() + ' ' + resource_da_endTimeVal));

    if (resourceStart >= resourceEnd) {
        $('#resource_da_startTimeValidation').css({display:'inline'});
        $('#resource_da_startTimeValidation').text('Please enter valid time range');
        $('#resource_da_startTimeValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        $('#resource_da_endTimeValidation').css({display:'inline'});
        $('#resource_da_endTimeValidation').text('Please enter valid time range');
        $('#resource_da_endTimeValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if ($('#resource_da_quantity').val() == "") {
        $('#resource_da_quantityValidation').css({display:'inline'});
        $('#resource_da_quantityValidation').text('Please enter a valid quantity.');
        $('#resource_da_quantityValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (isValid == false) {
        return;
    }

    $('#resource_da_responseLoading').css({visibility: "visible"});
    jsonData = JSON.stringify({
        id: (app_selectedResourceSchedule != null ? app_selectedResourceSchedule.id : 0),
        resourceId: app_selectedResource.resourceId,
        days: resource_da_days,
        startDate: resourceStart.valueOf(),
        endDate: resourceEnd.valueOf(),
        quantity: $('#resource_da_quantity').val(),
        override: false
    });

    var url = resource_da_formMode == 'new' ? "rest/resource/addDefaultAvailability" : "rest/resource/updateDefaultAvailability";

    $.post(url, {data:jsonData}, function(data) {
        $('#resource_da_responseLoading').css({visibility: "hidden"});
        var confirmationMessage = 'Default Availability ' + (resource_da_formMode == 'new' ? 'Added.' : 'Updated.');
        util_showMainMessage(confirmationMessage);
        alert(confirmationMessage);
        window.location.href = "resource_detail.html#DefaultAvailability";
    });
}

function crudTemporaryAdjustmentClick() {
    resource_ta_clearErrors();
    var isValid = true;
    var resource_ta_startDateVal = new Date($("#resource_ta_startDateTime").val());
    var resource_ta_endDateVal =  new Date($("#resource_ta_endDateTime").val());

    if (resource_ta_startDateVal == null) {
        $('#resource_ta_startDateValidation').css({display:'inline'});
        $('#resource_ta_startDateValidation').text('Please enter valid start date');
        $('#resource_ta_startDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (resource_ta_endDateVal == null) {
        $('#resource_ta_endDateValidation').css({display:'inline'});
        $('#resource_ta_endDateValidation').text('Please enter valid end date');
        $('#resource_ta_endDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (resource_ta_startDateVal >= resource_ta_endDateVal) {
        $('#resource_ta_startDateValidation').css({display:'inline'});
        $('#resource_ta_startDateValidation').text('Please enter valid date range');
        $('#resource_ta_startDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        $('#resource_ta_endDateValidation').css({display:'inline'});
        $('#resource_ta_endDateValidation').text('Please enter valid date range');
        $('#resource_ta_endDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if ($('#resource_ta_quantity').val() == "") {
        $('#resource_ta_quantityValidation').css({display:'inline'});
        $('#resource_ta_quantityValidation').text('Please enter a valid quantity.');
        $('#resource_ta_quantityValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (isValid == false) {
        return;
    }

    $('#resource_ta_responseLoading').css({visibility: "visible"});
    jsonData = JSON.stringify({
        id: (app_selectedTempAdj != null ? app_selectedTempAdj.id : 0),
        resourceId: app_selectedResource.resourceId,
        startDate: resource_ta_startDateVal.valueOf(),
        endDate: resource_ta_endDateVal.valueOf(),
        quantity: $('#resource_ta_quantity').val(),
        override: true
    });

    var url = "rest/resource/addTemporaryAdjustment";
    if (resource_ta_formMode == 'edit') {
        url = "rest/resource/updateTemporaryAdjustment";
    }

    $.post(url,{data:jsonData}, function(data) {
        $('#resource_ta_responseLoading').css({visibility: "hidden"});
        var confirmationMessage = 'Temporary Adjustment ' + (resource_ta_formMode == 'new' ? 'Added.' : 'Updated.');
        util_showMainMessage(confirmationMessage);
        alert(confirmationMessage);
        window.location.href = "resource_detail.html#TemporaryAdjustment";
    });
}

function crudNewResourceClick() {
    resource_clearErrors();
    var isValid = true;

    if(resource_formMode == 'new' && $("#resource_resourceName").val().length < 1) {
        $('#resource_resourceNameValidation').text('Please select a Resource Name');
        $('#resource_resourceNameValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    resource_sublocations = $("#resource_subloc_checkboxes").val();

    if (resource_sublocations.length == 0) {
        $('#resource_sublocationValidation').text('Please select a Sublocation');
        $('#resource_sublocationValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (isValid == false) {
        return;
    }

    var resourceId =  $('#resource_resourceName').val();

    if (resource_formMode == 'edit') {
        resourceId = app_selectedResource.resourceId;
    }

    $('#resourceLoading').css({visibility: "visible"});
    jsonData = JSON.stringify({
        resourceId: resourceId,
        sublocations: resource_sublocations
    });

    $.post("rest/resource/assignResource",{data:jsonData}, function(data) {
        var parsedData = $.parseJSON(data);
        var confirmationMessage = "";
        if (parsedData.result == true) {
            if (resource_formMode == 'new') {
                confirmationMessage = $("#resource_resourceName option:selected").text() + ' has been added.';
                resource_clearErrors();
                noSublocationsSelected = true;
                resource_sublocations = [];
                util_showMainMessage(confirmationMessage);
                alert(confirmationMessage);
                resourceModule();
            }
            else {
                confirmationMessage = $("#resource_resourceNameReadOnly").text() + ' has been updated.';
                resource_clearErrors();
                noSublocationsSelected = true;
                resource_sublocations = [];
                util_showMainMessage(confirmationMessage);
                alert(confirmationMessage);
                resource_handleResourceSelection(resourceId);
            }
        }
        else {
            confirmationMessage = parsedData.errorMsg;
            util_showMainMessage(confirmationMessage);
            alert(confirmationMessage);
            return;
        }
    });

}


function cancelSublocationClick() {
    resourceModule();
}

function crudSublocationClick() {
    sublocation_clearErrors();
    var isValid = true;

    var sublocation_startDateVal = new Date($("#sublocation_startDate").val());
    var sublocation_endDateVal = new Date($("#sublocation_endDate").val());

    if ($("#sublocation_startDate").val() == '') {
        $('#sublocation_startDateValidation').css({display:'inline'});
        $('#sublocation_startDateValidation').text('Please enter valid start date');
        $('#sublocation_startDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if ($("#sublocation_endDate").val() == '') {
        $('#sublocation_endDateValidation').css({display:'inline'});
        $('#sublocation_endDateValidation').text('Please enter valid end date');
        $('#sublocation_endDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (sublocation_startDateVal >= sublocation_endDateVal) {
        $('#sublocation_startDateValidation').css({display:'inline'});
        $('#sublocation_startDateValidation').text('Please enter valid start date range');
        $('#sublocation_startDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        $('#sublocation_endDateValidation').css({display:'inline'});
        $('#sublocation_endDateValidation').text('Please enter valid end date range');
        $('#sublocation_endDateValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if($("#sublocation_sublocation").val().length < 1) {
        $('#sublocation_sublocationValidation').css({display:'inline'});
        $('#sublocation_sublocationValidation').text('Required Field');
        $('#sublocation_sublocationValidation').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
        isValid = false;
    }

    if (isValid == false) {
        return;
    }


    $('#sublocationLoading').css({visibility: "visible"});

    jsonData = JSON.stringify({
        sublocationId: $('#sublocation_sublocation').val(),
        startTime: sublocation_startDateVal.valueOf(),
        endTime: sublocation_endDateVal.valueOf(),
        reason: $('#sublocation_reason').val(),
        userId: user.id
    });

    $.post("rest/resource/createSublocationClosureInterval",{data:jsonData}, function(data) {
        $('#sublocationLoading').css({visibility: "hidden"});
        var confirmationMessage = "Sublocation Closure Scheduled";
        util_showMainMessage(confirmationMessage);
        alert(confirmationMessage);
        window.location.href = "sublocation_closure_screen.html";
    });
}


function resource_loadUnassignedResources() {
    $.getJSON("rest/resource/getUnassignedResources", function(data) {
        resourceNames = data.resources;
        resourceNameSelectOptions = buildSelectOptions(resourceNames, 'name', 'choose');
        $("#resource_resourceName").html(resourceNameSelectOptions);
    });
}

function resource_clearErrors() {
    $('#resource_resourceNameValidation').css({visibility: "hidden"});
    $('#resource_sublocationValidation').css({visibility: "hidden"});
}

function resource_clearForm() {
    $('#resource_resourceName').val('');
    $('#resource_subloc_checkboxes').val('');
    resource_sublocations = [];
    resource_clearErrors();
}

function resource_da_clearErrors() {
    $('#resource_da_dayValidation').css({visibility: "hidden"});
    $('#resource_da_startTimeValidation').css({visibility: "hidden"});
    $('#resource_da_endTimeValidation').css({visibility: "hidden"});
    $('#resource_da_quantityValidation').css({visibility: "hidden"});
}

function resource_da_clearForm() {
    $("#resource_da_checkboxes :checkbox").each(function(){
        this.checked = false;
    });
    resource_da_days = [];
    $('#resource_da_quantity').val('');
    $('#resource_da_confirmationMessage').css({visibility: "hidden"});
    resource_da_clearErrors();
}

function resource_ta_clearErrors() {
    $('#resource_ta_startDateValidation').css({visibility: "hidden"});
    $('#resource_ta_endDateValidation').css({visibility: "hidden"});
    $('#resource_ta_startTimeValidation').css({visibility: "hidden"});
    $('#resource_ta_endTimeValidation').css({visibility: "hidden"});
    $('#resource_ta_quantityValidation').css({visibility: "hidden"});
}

function resource_ta_clearForm() {
    var date = new Date();
    date.setHours(0,0,0,0);
    $("#resource_ta_startDateTime").val(showClockDateTime(date));
    $("#resource_ta_endDateTime").val(showClockDateTime(date));
    $('#resource_ta_quantity').val('');
    resource_ta_clearErrors();
}

function sublocation_clearErrors() {
    $('.formElementRequired').css({visibility: "hidden"});
}

function sublocation_clearForm() {
    $('#sublocation_sublocation').val('');
    var date = new Date();
    date.setHours(0,0,0,0);
    $("#sublocation_startDate").val(showClockDateTime(date));
    $("#sublocation_endDate").val(showClockDateTime(date));
    $('#sublocation_reason').val('');
    sublocation_clearErrors();
}

function buildSubLocCheckBoxes() {
    var html = [];
    html[html.length] = "<option value=''>choose</option>";
    for (var i = 0, len = sublocations.length; i < len; i++) {
        html[html.length] = "<option value='";
        html[html.length] = sublocations[i].id;
        html[html.length] = "'>";
        html[html.length] = sublocations[i].name;
        html[html.length] = "</option>";
    }
    return html.join('');
}
