/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var apptDoSearchOuterCall;
var today = new Date();
var todaysVisits = false;
var prevStart = new Date(today.getFullYear(), today.getMonth(), today.getDate(), 0, 0, 0, 0);
var filterCalendar = false;
var className;

function updateCalendarBlocks(element, event, image, imageAlt) {
    var type = event.className;
    if (event.inpatientVisitType) {
        if ($(element).hasClass("fc-day-grid-event fc-h-event fc-event fc-start fc-not-end " + type)) {
            var width = $(element).width() - 2;
            $(element).css('width', width + 'px');
            if (moment(event.start).day() == 6) {
                var search = '<div style="float: left; padding: 2px 2px 28px 2px;"><img src="' + image + '" width="15" height="14" alt="' + imageAlt + '"/></div>';
                element.find('.fc-time').html(search + ' ' + startDate + ' - ' + endDate);
            }
        }
        else if ($(element).hasClass("fc-day-grid-event fc-h-event fc-event fc-not-start fc-not-end " + type)) {
            var width = $(element).width() - 2;
            $(element).css('left', '3px');
            $(element).css('width', width + 'px');
            $(element).css('height', '20px');
        }
        else if ($(element).hasClass("fc-day-grid-event fc-h-event fc-event fc-not-start fc-end " + type)) {
            var width = $(element).width() - 2;
            $(element).css('left', '3px');
            $(element).css('width', width + 'px');
            $(element).css('height', '20px');
        }
        else if (moment(event.start).format('MM/DD/YYYY') == moment(event.end).format('MM/DD/YYYY')) {
            var search = '<div style="float: left; padding: 2px 2px 6px 2px;"><img src="' + image + '" width="15" height="14" alt="' + imageAlt + '"/></div>';
            element.find('.fc-time').html(search + ' ' + startDate + ' - ' + endDate);
            element.find('.fc-title').html('');
        }
    }
}

function updateEventRender(event, view, element, visitType) {
    if (event.inpatientVisitType) {
        element.find('.fc-time').html(visitType + ' ' + startDate + ' - ' + endDate + ': ');
        element.find('.fc-title').html(event.title);
    }
    else {
        element.find('.fc-time').html(visitType + ' ' + startTime + ' - ' + endTime + ': ');
        element.find('.fc-title').html(event.title);
    }
}

function apptDoSearch(url, dayView) {
    todaysVisits = dayView;
    apptDoSearchOuterCall = true;
    closeApptDialog();
    request = $.ajax({
        type: "GET",
        contentType: "application/json",
        data: "{}",
        url: url,
        dataType: "json",
        success: reCreateCalendar,
        error: apptDoSearchError
    });
}

var apptDoSearchError = function (XMLHttpRequest, textStatus, errorThrown) {
    $('#loading').css({display: 'none'});
    $('#filter_loading').css({display: 'none'});
    debug('There was an error while fetching data!');
};

var reCreateCalendar = function (data) {
    home_rendered = true;
    $("#appt_calendar").fullCalendar('destroy');
    $('#loading').css({display: 'none'});
    $('#filter_loading').css({display: 'none'});
    if (inpatient_search == true) {
        var confirmationMessage = "Appointment(s) found. Scroll through the calendar to select and schedule an appointment.";
        util_showMainMessage(confirmationMessage);
        inpatient_search = false;
    }
    
    $('#initial_loading').css({display: 'none'});
    var defaultViewData = 'agendaDay';
    if (todaysVisits) {
        defaultViewData = 'agendaDay';
    }
    else {
        defaultViewData = 'month';
    }
    $("#appt_calendar").fullCalendar({
        aspectRatio: 1,
        theme: true,
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
        },
        titleFormat: {
            month: 'MMMM YYYY',                             // September 2009
            week: "MMM D YYYY", // Sep 7 - 13 2009
            day: 'dddd, MMMM D, YYYY'                  // Tuesday, Sep 8, 2009
        },
        columnFormat: {
            month: 'dddd',    // Mon
            week: 'ddd M/D', // Mon 9/7
            day: 'dddd, MMMM D'  // Monday 9/7
        },
        defaultView: defaultViewData,
        firstHour: 7,
        editable: false,
        ignoreTimezone: true,
        nextDayThreshold: "00:00:00",
        displayEventEnd: true,
        selectable: true,
        selectHelper: true,
        lazyFetching: true,
        loading: apptCalendarLoading,
        select: apptCalendarSelect,
        viewRender: apptCalendarViewRenderFactory(todaysVisits),
        eventAfterRender: apptCalendarEventAfterRender,
        eventRender: apptCalendarEventRender,
        windowResize: apptCalendarWindowResize,
        eventMouseover: apptCalendarEventMouseover,
        eventMouseout: apptCalenderEventMouseout,
        events: makeCalendarEvents(data),
        allDayDefault: todaysVisits,
        eventClick: apptCalendarEventClick
    });
    if (view != null) {
        $("#appt_calendar").fullCalendar('gotoDate', $("#apptCalendarGoToDate").datepicker("getDate"));
        view = null;
    }
};

var apptCalendarLoading = function (bool) {
    if (bool) {
        $.blockUI({fadeIn: 0});
    }
    else {
        $.unblockUI();
    }
};


var apptCalendarSelect = function (date, jsEvent, view) {
    $("#appt_calendar").fullCalendar('gotoDate', date);
    $("#appt_calendar").fullCalendar('changeView', "agendaDay");
};

/**
 * this function factory creates a callback function
 * with a closure containing a todaysVisists variable
 * (i.e. todaysVisists can be modified, and
 * it will be remembered from invocation to invocation)
 *
 * @param todaysVisits
 * @returns {Function}1
 */
function apptCalendarViewRenderFactory(todaysVisits) {
    return function (view) {
        if (view.name == "month") {
            todaysVisits = false;
        }
        else {
            todaysVisits = true;
        }

        var startDate = moment(view.intervalStart.format()).toDate();
        if (todaysVisits == true) {
            if (startDate.getTime() == prevStart.getTime()) {
                apptDoSearchOuterCall = false;
                searching_appointments = false;
                prevStart = new Date(view.start);
                return;
            }
        }
        else {
            if (apptDoSearchOuterCall) {
                apptDoSearchOuterCall = false;
                searching_appointments = false;
                return;
            }
        }

        if (searching_appointments == false) {
            if (filterCalendar == false) {
                if (startDate.getMonth() == (new Date()).getMonth() && view.name == "month") {
                    $("#apptCalendarGoToDate").datepicker("setDate", new Date());
                }
                else {
                    $("#apptCalendarGoToDate").datepicker("setDate", startDate);
                }
            }
            else {
                filterCalendar = false;
            }

            $.blockUI();
            $('#initial_loading').css({display: 'block'});
            var starts = view.start;
            var ends = view.end;
            prevStart = new Date(view.start);
            url = 'rest/appointment/getCalendarBookedVisits?starting=' + starts + '&ending=' + ends + '&todayVisits=' + todaysVisits + '&filterString=' + calendarFilterString + '&filterId=' + calendarSelectedFilterId;
            $.ajax({
                type: 'GET',
                url: url,
                data: {},
                success: function (data) {
                    $("#appt_calendar").fullCalendar('removeEvents');
                    $("#appt_calendar").fullCalendar('removeEventSource', data);
                    $("#appt_calendar").fullCalendar('addEventSource', data);
                    $('#loading').css({display: 'none'});
                    $('#filter_loading').css({display: 'none'});
                    $('#initial_loading').css({display: 'none'});
                    $.unblockUI();
                },
                error: function (xhr, status, error) {
                    // check status && error
                },
                dataType: 'json',
                async: true
            });
        }
    };
}

var apptCalendarEventAfterRender = function (event, element, view) {
    startDate = moment(event.start).format('hh:mma MM/DD');
    endDate = moment(event.end).format('hh:mma MM/DD');
    if (view.name == "month") {
        var image = "";
        var imageAlt = "";

        var classNameString = "" + event.className;
        if (classNameString == "NotFound") {
            image = "css/images/icon_unavailable.png";
            imageAlt = "(U)";
        }
        else if (classNameString == "Searching") {
            image = "css/images/icon_available.png";
            imageAlt = "(A)";
        }
        else if (classNameString === "Hold") {
            image = "css/images/icon_hold.png";
            imageAlt = "(H)";
        }
        else if (classNameString == "Scheduled") {
            image = "css/images/icon_scheduled.png";
            imageAlt = "(S)";
        }
        else if (classNameString == "Checked-In") {
            image = "css/images/icon_checkedin.png";
            imageAlt = "(I)";
        }
        else if (classNameString == "Checked-Out") {
            image = "css/images/icon_checkedout.png";
            imageAlt = "(O)";

        }
        else if (classNameString == "Cancellation") {
            image = "css/images/icon_canceled.png";
            imageAlt = "(X)";
        }
        updateCalendarBlocks(element, event, image, imageAlt);
    }
};


function apptCalendarEventRender(event, element, view) {
    startDate = moment(event.start).format('hh:mma MM/DD');
    endDate = moment(event.end).format('hh:mma MM/DD');
    startTime = moment(event.start).format('hh:mma');
    endTime = moment(event.end).format('hh:mma');
    if (event.className == "NotFound") {
        var notFound = '<div style="float: left; padding: 2px;"><img src="css/images/icon_unavailable.png" width="15" height="15" alt="(U)"/></div>';
        if (event.inpatientVisitType) {
            element.find('.fc-time').html(notFound + ' ' + startDate + ' - ' + endDate);
        }
        else {
            element.find('.fc-time').html(notFound + ' ' + startTime + ' - ' + endTime);
        }
        element.find('.fc-title').html('');
    }
    if (event.className == "Searching") {
        erroMsgFlag = false;
        var search = '<div style="float: left; padding: 2px;"><img src="css/images/icon_available.png" width="15" height="14" alt="(A)"/></div>';
        if (event.inpatientVisitType) {
            element.find('.fc-time').html(search + ' ' + startDate + ' - ' + endDate);
        }
        else {
            element.find('.fc-time').html(search + ' ' + startTime + ' - ' + endTime);
        }
        element.find('.fc-title').html('');
    }
    var classNameString = "" + event.className;

    if (classNameString.match(/^Hold/)) {
        var scheduled = '<div style="float: left; padding: 2px;"><img src="css/images/icon_hold.png" width="15" height="15" alt="(S)"/></div>';
        updateEventRender(event, view, element, scheduled);
    }
    else if (classNameString.match(/^Scheduled/)) {
        var scheduled = '<div style="float: left; padding: 2px;"><img src="css/images/icon_scheduled.png" width="15" height="15" alt="(S)"/></div>';
        updateEventRender(event, view, element, scheduled);
    }
    else if (classNameString.match(/^Checked-In/)) {
        var checkedin = '<div style="float: left; padding: 2px;"><img src="css/images/icon_checkedin.png" width="15" height="15" alt="(I)"/></div>';
        updateEventRender(event, view, element, checkedin);

    }
    else if (classNameString.match(/^Checked-Out/)) {
        var checkedout = '<div style="float: left; padding: 2px;"><img src="css/images/icon_checkedout.png" width="15" height="15" alt="(O)"/></div>';
        updateEventRender(event, view, element, checkedout);

    }
    else if (classNameString.match(/^Cancellation/)) {
        var cancelled = '<div style="float: left; padding: 2px;"><img src="css/images/icon_canceled.png" width="14" height="14" alt="(X)"/></div>';
        updateEventRender(event, view, element, cancelled);
    }
}

function apptCalendarWindowResize(view) {

}

function apptCalendarEventMouseover(calEvent, jsEvent) {
    $(this).mouseover(function (e) {
        var top = e.pageY + 10;
        var left = e.pageX + 20;
        var tooltip = "<div class='appointmentHover' style='z-index:10001; left:" + left + "px; top:" + top + "px;'> <span class='appointmentHoverLabel'>Local ID:</span>\
                                         <span class='appointmentHoverItem'>" + calEvent.localId + "</span>\
                                         <span class='appointmentHoverLabel'>PI Name:</span>\
                                         <span class='appointmentHoverItem'>" + calEvent.piName + "</span>\
                                         <span class='appointmentHoverLabel'>Visit Name:</span> \
                                         <span class='appointmentHoverItem'>" + calEvent.visitName + "</span>\
                                         <span class='appointmentHoverLabel'>Room(s):</span> \
                                         <span class='appointmentHoverItem'>" + calEvent.room + "</span> </div>";
        $("body").append(tooltip);
    }).mousemove(function (e) {
        $('.appointmentHover').css('top', e.pageY + 10);
        $('.appointmentHover').css('left', e.pageX + 20);
    });
}

function apptCalenderEventMouseout(calEvent, jsEvent) {
    $(this).css('z-index', 8);
    $('.appointmentHover').remove();
}

/**
 * This method sets the following global variables:
 *   appt_list_view
 *   initial_load
 *   appt_search_view
 *   eventid
 *   start
 *   end
 *   className
 *   s_start
 *
 * This method accesses the following global variables:
 *   sessionStorage
 *   appt_selectedSubjectName
 *   user
 *
 * @param event
 */
function apptCalendarEventClick(event) {
    $.blockUI();
    $('.formTextAreaSmaller').css({display: "block"});
    $("#wizard_comment").val('');
    $("#scheduleWizard_comment").val('');
    $("#checkoutWizard_comment").val('');
    appt_list_view = false;
    initial_load = true;
    if (window.location.href.indexOf("home.html") > -1) {
        sessionStorage.setItem("home_cal", "true");
    }
    else {
        sessionStorage.setItem("home_cal", "false");
    }

    if (appt_selectedSubjectName == null || appt_selectedSubjectName == "null") {
        appt_selectedSubjectName = "No Subject Assigned";
    }

    if (event.className == "NotFound") {
        appt_search_view = true;
        $("#notAvailableResources").prop("checked", true);
        document.getElementById("commentTable").style.display = "none";
        document.getElementById("filterSearchedResources").style.display = "inline";
        document.getElementById("appt_wizard_scheduleAppointment").style.display = "none";
        eventid = event.id;
        start = moment(event.start).format('MM/DD/YYYY hh:mm a');
        end = moment(event.end).format('MM/DD/YYYY hh:mm a');
        className = event.className;
        $('#dialog_searchstudy_name_detail').text(appt_selectedStudyName);
        $('#dialog_searchstudy_localid').text(appt_selectedStudyLocalId);
        $('#dialog_searchstudy_piname_detail').text(appt_selectedStudyInvestigatorName);
        $('#dialog_searchsubject_name_detail').text(appt_selectedSubjectName);
        $('#dialog_searchvisit_name_detail').text(appt_selectedVisitName);
        $('#dialog_searchvisit_time_detail').text(appt_selectedVisitDuration);
        $('#dialog_searchvisit_start_detail').text(moment(event.start).format('MM/DD/YYYY hh:mm a'));
        $('#dialog_searchvisit_end_detail').text(moment(event.end).format('MM/DD/YYYY hh:mm a'));
        resetUI();
        loadBookedResourcesData(currentPage, eventid);
        $("#appt_wizard_searchedDetails").dialog({modal: true, height: 800, width: 700});
    }
    else if (event.className == "Searching") {
        appt_search_view = true;
        document.getElementById("filterSearchedResources").style.display = "none";
        document.getElementById("commentTable").style.display = "inline";
        document.getElementById("appt_wizard_scheduleAppointment").style.display = "inline";
        eventid = event.id;
        start = moment(event.start).format('MM/DD/YYYY hh:mm a');
        end = moment(event.end).format('MM/DD/YYYY hh:mm a');
        className = event.className;
        $('#dialog_searchstudy_name_detail').text(appt_selectedStudyName);
        $('#dialog_searchstudy_localid').text(appt_selectedStudyLocalId);
        $('#dialog_searchstudy_piname_detail').text(appt_selectedStudyInvestigatorName);
        $('#dialog_searchsubject_name_detail').text(appt_selectedSubjectName);
        $('#dialog_searchvisit_name_detail').text(appt_selectedVisitName);
        $('#dialog_searchvisit_time_detail').text(appt_selectedVisitDuration);
        $('#dialog_searchvisit_start_detail').text(moment(event.start).format('MM/DD/YYYY hh:mm a'));
        $('#dialog_searchvisit_end_detail').text(moment(event.end).format('MM/DD/YYYY hh:mm a'));
        resetUI();
        loadBookedResourcesData(currentPage, eventid);
        $("#appt_wizard_searchedDetails").dialog({modal: true, height: 800, width: 700});
    }
    else if (event.className == "Scheduled" || event.className == "Hold") {
        $("#wizard_cancellationReasons").val('');
        eventid = event.id;
        start = event.start;
        s_start = event.start;
        end = event.end;
        className = event.className;
        setParametersCalendarEventClick(eventid, start, end);

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF || user.institutionRole.id == FRONT_DESK) {
            document.getElementById("appt_newResourceButton").style.display = "none";
        }

        document.getElementById("appt_wizard_checkin").style.display = "inline";

        if (user.institutionRole.id == STUDY_STAFF) {
            document.getElementById("appt_wizard_checkin").style.display = "none";
            document.getElementById("wizard_cancellationReasons").style.display = "inline";
            $('.statusWrap').css({display: "inline"});
        }

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF || user.institutionRole.id == FRONT_DESK
            || user.institutionRole.id == RESOURCE_MANAGER) {
            document.getElementById("appt_wizard_overbookCheckAppointment").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment1").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment2").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment3").style.display = "none";
        }

        if (user.institutionRole.id == GENERAL_VIEW) {
            document.getElementById("viewScheduledCommentLink").style.display = "none";
            document.getElementById("appt_wizard_saveComment").style.display = "none";
            document.getElementById("appt_wizard_checkin").style.display = "none";
            document.getElementById("appt_wizard_cancelAppointment").style.display = "none";
            $('.statusWrap').css({display: "none"});
        }
        getResourceLists();
        openBookedResourcesAppointmentWindow(event.className);
    }
    else if (event.className == "Checked-In") {
        eventid = event.id;
        start = event.start;
        s_start = event.start;
        end = event.end;
        className = event.className;
        setParametersCalendarEventClick(eventid, start, end);

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK) {
            document.getElementById("appt_newResourceButton").style.display = "none";
            $('.appt_checkoutnewResource').css({visibility: "hidden"});
        }

        if (user.institutionRole.id == STUDY_STAFF) {
            document.getElementById("appt_wizard_saveComment1").style.display = "none";
            document.getElementById("appt_wizard_checkout").style.display = "none";
            document.getElementById("wizard_checkoutReasons").style.display = "none";
            document.getElementById("checkOutBlock").style.display = "none";
            document.getElementById("checkOutRadio").style.display = "none";
            $('.statusWrap').css({display: "none"});
        }

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK || user.institutionRole.id == RESOURCE_MANAGER) {
            document.getElementById("appt_wizard_overbookCheckAppointment").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment1").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment2").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment3").style.display = "none";
        }

        if (user.institutionRole.id == GENERAL_VIEW) {
            document.getElementById("viewCheckedInCommentLink").style.display = "none";
            document.getElementById("checkOutRadio").style.display = "none";
            document.getElementById("checkOutBlock").style.display = "none";
            document.getElementById("appt_wizard_saveComment1").style.display = "none";
            document.getElementById("appt_wizard_checkout").style.display = "none";
            document.getElementById("wizard_checkoutReasons").style.display = "none";
        }
        getResourceLists();
        openBookedResourcesAppointmentWindow("Checked-In");
    }
    else if (event.className == "Checked-Out") {
        eventid = event.id;
        start = event.start;
        end = event.end;
        className = event.className;
        setParametersCalendarEventClick(eventid, start, end);

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK) {
            document.getElementById("appt_newResourceButton").style.display = "none";
            $('.appt_checkoutVisitnewResource').css({visibility: "hidden"});
        }

        if (user.institutionRole.id == GENERAL_VIEW) {
            document.getElementById("viewCheckedoutCommentLink").style.display = "none";
            document.getElementById("checkedOutRadioRead").style.display = "none";
        }

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK || user.institutionRole.id == RESOURCE_MANAGER) {
            document.getElementById("appt_wizard_overbookCheckAppointment").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment1").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment2").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment3").style.display = "none";
        }
        openBookedResourcesAppointmentWindow("Checked-Out");
    }
    else if (event.className == "Cancellation") {
        eventid = event.id;
        start = event.start;
        end = event.end;
        className = event.className;
        setParametersCalendarEventClick(eventid, start, end);

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK || user.institutionRole.id == RESOURCE_MANAGER) {
            document.getElementById("appt_wizard_overbookCheckAppointment").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment1").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment2").style.display = "none";
            document.getElementById("appt_wizard_overbookCheckAppointment3").style.display = "none";
        }
        if (user.institutionRole.id == GENERAL_VIEW) {
            document.getElementById("viewCancelledCommentLink").style.display = "none";
        }
        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF
            || user.institutionRole.id == FRONT_DESK) {
            document.getElementById("appt_wizard_rescheduleAppointment").style.display = "none";
        }
        openBookedResourcesAppointmentWindow(event.className);
    }
    else {
        alert(event.className + ' event className: Not implemented');
    }
}


function makeCalendarEvents(data) {
    return $.map(data, function (item, i) {
        var event = new Object();
        if (item != null) {
            event.id = item.id;
            event.className = item.className;
            event.start = item.start;
            event.end = item.end;
            event.localId = item.localId;
            event.piName = item.piName;
            event.visitName = item.visitName;
            event.room = item.room;
            event.title = item.title;
            event.allDay = item.allDay;
            event.inpatientVisitType = item.inpatientVisitType;
            if (event.className == "false") {
                var confirmationMessage = "Please Note: No new appointment(s) found for the search criteria.";
                util_showMainMessage(confirmationMessage);
            }
            if (event.className == "no_appointments_found") {
                var confirmationMessage = "Please Note: No appointment(s) found for the filter criteria.";
                util_showMainMessage(confirmationMessage);
            }
            return event;
        }
    });
}
