/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var homeCalendar;
var home_selectedVisitId;
var home_selectedStudyId;
var home_visitTemplateFormMode;
var home_rendered = false;
var home_filtered = false;
var visitId;
var studyId;
var bvId;

var sortByStudy = "study.local_id";
var sortByPI = "user.last_name";
var sortByVisit = "visit_template.name";
var sortByTemplateVisitType = "visit_template.type";
var sortByTemplateSublocation = "sublocation.name";

var sortByStart = "bv.scheduledStartTime";
var sortByEnd = "bv.scheduledEndTime";
var sortByIrb = "bv.study.irb";
var sortByBookedVisitName = "bv.visitTemplate.name";
var sortByAppointment = "bv.appointmentStatus.name";

var homePage = (function () {
    var initFn = function () {
        commonInit();
    };

    function commonInit() {
        loadMetaHeaders();
        initFooter();

        $.blockUI({ignoreIfBlocked: true});
        home = true;

        login();
        getSchedulingOptionsStaticList(function () {
            var result = buildSubLocTabs("subLocTop");
            $("#sublocationListTop").html(result.html);
            $("#sublocationListTop").tabs({
                active: result.defaultTabIndex,
                activate: function( event, ui ) {
                    var activeTab = $(this).tabs("option", "active");

                    $("#sublocationListBottom").tabs("option", "active", activeTab);

                    var sublocationLabel = $(ui.newTab).attr("data-sublocation-label");
                    getCalendarBySublocation(sublocationLabel);
                }
            });

            result = buildSubLocTabs("subLocBtm");

            $("#sublocationListBottom").html(result.html);
            $("#sublocationListBottom").tabs({
                active: result.defaultTabIndex,
                activate: function( event, ui ) {
                    var activeTab = $(this).tabs("option", "active");

                    $("#sublocationListTop").tabs("option", "active", activeTab);

                    var sublocationLabel = $(ui.newTab).attr("data-sublocation-label");
                    getCalendarBySublocation(sublocationLabel);
                }
            });
        });

        $("#homepageTabs").tabs();
        $('#templateSection').load("appts/wizard_templates.html");
        $('#appt-common-dialogs').load("appts/dialogs.html");

        getStudyStaticLists();
        createApptCalendarDatePicker();

        $("#booked_visit_radio").prop("checked", true);
        $("#booked_visit_radio").click(function () {
            $("#booked_visit_radio").prop("checked", true);
        });
        $("#visit_template_radio").click(function () {
            $("#visit_template_radio").prop("checked", true);
        });
        home_viewStack('home_calendar');
    }

    return {
        init: initFn
    };
}());

function authDataCallback(data) {
    $('#index_loginError').css({display: 'none'});
    var parsedData = $.parseJSON(data);
    user = new User();
    user.id = parsedData.id;
    user.ecommonsId = parsedData.ecommonsId;
    user.firstName = parsedData.firstName;
    user.middleName = parsedData.middleName;
    user.lastName = parsedData.lastName;
    user.streetAddress1 = parsedData.streetAddress1;
    user.streetAddress2 = parsedData.streetAddress2;
    user.city = parsedData.city;
    user.state = parsedData.state;
    user.zip = parsedData.zip;
    user.primaryPhone = parsedData.primaryPhone;
    user.secondaryPhone = parsedData.secondaryPhone;
    user.email = parsedData.email;
    user.fax = parsedData.fax;
    user.pager = parsedData.pager;
    user.division = parsedData.division;
    user.department = parsedData.department;
    user.userGroup = parsedData.userGroup;
    user.institution = parsedData.institution;
    user.institutionRole = parsedData.institutionRole;
    user.credential = parsedData.credential;
    user.facultyRank = parsedData.facultyRank;
    user.irbInstitution = parsedData.irbInstitution;
    user.active = parsedData.active;
    user.authStatus = parsedData.authStatus;
    user.previousLoginTime = parsedData.previousLoginTime;
    sessionStorage.setItem("userData", JSON.stringify(user));
    $('#index_loginLoading').css({visibility: "hidden"});

    if (user.authStatus == USER_STATUS_AUTHORIZED) {
        commonData();
        $('#loginForm').css({display: "none"});
        $('#home_previousLoginTime').css({visibility: "visible"});

        if (PREVIOUS_ACCESS_SHOWN == false && user.previousLoginTime != "") {
            $('#home_previousLoginTime').text("Last Login: " + user.previousLoginTime);
            PREVIOUS_ACCESS_SHOWN = true;
        }
        else {
            window.location.href = "password_reset.html";
        }
        $("#home_toggleCalendar").attr("checked", "checked");
        home_viewStack("home_calendar");
        calendar_rendered = false;
        homeModuleRoles();
    }
    else {
        if (user.authStatus == USER_STATUS_NOT_FOUND) {
            $('#index_loginError').text('User not found in system');
        }
        else if (user.authStatus == USER_STATUS_INVALID_PASSWORD) {
            $('#index_loginError').text('Invalid password');
        }
        else if (user.authStatus == USER_STATUS_INACTIVE) {
            $('#index_loginError').text('User is inactive');
        }
        $('#index_loginError').css({display: 'block'});
        $('#index_loginError').css({opacity: 0.0, visibility: "visible"}).animate({opacity: 1.0});
    }
}
function login() {
    $('#index_loginLoading').css({visibility: "visible"});
    $.get("rest/auth/getUserData", authDataCallback);
}

function getTemplatesToApprove() {
    parent.location.hash = "TemplateApprovalList";
    initial_load = true;
    resetUI();
    currentPage = 1;
    loadTemplatesToApproveData(currentPage);
}

function getHomeCalendar() {
    home = true;
    var checkedVal = $('input[name=home_viewToggle]:checked').val();
    if (checkedVal == 'list') {
        home_viewStack('home_calendarList');
    }
    else {
        home_viewStack('home_calendar');
    }
}

function loadTemplatesToApproveData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 5;
    }

    $.getJSON("rest/study/getTemplatesToApprove?page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 5) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByStudy), function (data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var study_header1 = 'sortable';
        var pi_header2 = 'sortable';
        var visit_header3 = 'sortable';
        var visitType_header4 = 'sortable';
        var sublocation_header5 = 'sortable';

        if (orderBy == 'ASC' || orderBy == undefined) {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByStudy) {
            study_header1 = sort_header;
        } else if (sortBy == sortByPI) {
            pi_header2 = sort_header;
        } else if (sortBy == sortByVisit) {
            visit_header3 = sort_header;
        } else if (sortBy == sortByTemplateVisitType) {
            visitType_header4 = sort_header;
        } else if (sortBy == sortByTemplateSublocation) {
            sublocation_header5 = sort_header;
        }

        var out =
            " <table id='visitTemplatesApproval'>" +
            "  <tr>" +
            "   <td class= " + study_header1 + " onclick='sortingFunction(sortByStudy)'><strong>Study ID</strong></td> " +
            "   <td class= " + pi_header2 + " onclick='sortingFunction(sortByPI)'><strong>PI Name</strong></td> " +
            "   <td class= " + visit_header3 + " onclick='sortingFunction(sortByVisit)'><strong>Visit Name</strong></td>" +
            "   <td class= " + visitType_header4 + " onclick='sortingFunction(sortByTemplateVisitType)'><strong>Visit Type</strong></td>" +
            "   <td class= " + sublocation_header5 + " onclick='sortingFunction(sortByTemplateSublocation)'><strong>Sub-location</strong></td>" +
            "   <td class='not_sortable'><strong>Last Updated</strong></td>" +
            "   <td class='not_sortable'><strong></strong></td>" +
            "   <td class='not_sortable'><strong></strong></td>" +
            "  </tr> ";

        $.each(data, function (key, val) {
            totalData = val.totalCount;
            out += "<tr>"
            out += "   <td>" + val.localId + "</td>" +
                "          <td>" + val.piName + "</td>" +
                "          <td>" + val.visitName + "</td>" +
                "          <td>" + val.visitTypeName + "</td>" +
                "          <td>" + val.sublocationName + "</td>" +
                "          <td>" + showDate(val.lastUpdateTime) + "</td>" +
                " <td> <a href='javascript:home_showVisitTab(" + val.id + "," + val.studyId + "," + 0 + ")'> View Detail </a> </td> " +
                " <td> <a href='javascript:home_showVisitTab(" + val.id + "," + val.studyId + "," + 1 + ")'> Approve </a> </td> " +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        setupTable(out, $('#homeTemplatesApprovalData'), currentPage, totalData);
    });
}

$(document).ready(function () {
    $("#home_toggleCalendar").click(function () {
        home_viewStack('home_calendar');
        $("#home_toggleCalendar").attr("checked", "checked");
    });
    $("#home_toggleList").click(function () {
        home_viewStack('home_calendarList');
        $("#home_toggleList").attr("checked", "checked");
    });
});

function home_viewStack(screen) {
    switch (screen) {
        case 'home_calendar':
            $(".calendarKey").show();
            $('.calendarTab').css({display: "block"});
            $('#appt_calendar').css({display: "block"});
            $('.apptDateRangeContainer').css({display: "inline-block"});
            $('#home_calendarList').css({display: "none"});
            $("#home_toggleCalendar").attr("checked", "checked");

            parent.location.hash = "homeCalendar";
            if (home_rendered == false) {
                var today = new Date();
                var startTime = new Date(today.getFullYear(), today.getMonth(), today.getDate(), 0, 0, 0, 0);
                var endTime = new Date(today.getFullYear(), today.getMonth(), today.getDate(), 23, 59, 59, 59);
                url = 'rest/appointment/getCalendarBookedVisits?starting=' + startTime.getTime() + '&ending=' + endTime.getTime() + '&todayVisits=true' + '&filterString=&filterId=';
                apptDoSearch(url, true);
                eventid = sessionStorage.getItem("eventid");
                if (eventid != null && eventid != "") {
                    $('.formTextAreaSmaller').css({display: "block"});
                    $("#wizard_comment").val('');
                    $("#checkoutWizard_comment").val('');
                    $('.wizardButtons input').css({width: "160px"});
                    eventid = sessionStorage.getItem("eventid");
                    start = sessionStorage.getItem("selected_start");
                    end = sessionStorage.getItem("selected_end");
                    setParametersCalendarEventClick(eventid, start, end);
                    className = sessionStorage.getItem("className");
                    openBookedResourcesAppointmentWindow(className);
                }
            }
            if (user != null) {
                closeApptDialog();
            }
            break;
        case 'home_calendarList':
            $(".calendarKey").hide();
            $('.calendarTab').css({display: "none"});
            $('#appt_calendar').css({display: "none"});
            $('.apptDateRangeContainer').css({display: "none"});
            $('#home_calendarList').css({display: "block"});
            $("#home_toggleList").attr("checked", "checked");
            parent.location.hash = "homeAppointmentList";
            resetUI();
            initial_load = true;
            loadBookedVisitsList(currentPage);
            break;
    }
}

function loadBookedVisitsList(currentPage, initial) {
    createPageDropDownList();
    if (max_results == undefined) {
        max_results = 25;
    }

    $.getJSON("rest/appointment/getOnlyTodaysBookedVisitsList?page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 25) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByStart), function (data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var start_header1 = 'sortable';
        var end_header2 = 'sortable';
        var irb_header3 = 'sortable';
        var visit_header4 = 'sortable';
        var status_header5 = 'sortable';

        if (orderBy == 'ASC' || orderBy == undefined) {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByStart) {
            start_header1 = sort_header;
        } else if (sortBy == sortByEnd) {
            end_header2 = sort_header;
        } else if (sortBy == sortByIrb) {
            irb_header3 = sort_header;
        } else if (sortBy == sortByBookedVisitName) {
            visit_header4 = sort_header;
        } else if (sortBy == sortByAppointment) {
            status_header5 = sort_header;
        }

        var out =
            " <table id='homeBookedVisit'>" +
            "  <tr>" +
            "   <td class= '" + start_header1 + " schedStartTime' onclick='sortingFunction(sortByStart)'><strong>Scheduled Start Time</strong></td> " +
            "   <td class= '" + end_header2 + " schedEndTime' onclick='sortingFunction(sortByEnd)'><strong>Scheduled End Time</strong></td> " +
            "   <td class='not_sortable'><strong>Subject Name</strong></td>" +
            "   <td class= " + irb_header3 + " onclick='sortingFunction(sortByIrb)'><strong>IRB</strong></td>" +
            "   <td class= " + visit_header4 + " onclick='sortingFunction(sortByBookedVisitName)'><strong>Visit Name</strong></td>" +
            "   <td class= " + status_header5 + " onclick='sortingFunction(sortByAppointment)'><strong>Status</strong></td>" +
            "   <td class='not_sortable actionCol'><strong>Action</strong></td>" +
            "  </tr> ";

        $.each(data, function (key, val) {
            totalData = val.totalCount;

            out += "<tr>"
            out += "   <td>" + showDateTime(val.scheduledStartTime) + "</td>" +
                "          <td>" + showDateTime(val.scheduledEndTime) + "</td>" +
                "          <td>" + val.subjectName + "</td>" +
                "          <td>" + val.irb + "</td>" +
                "          <td>" + val.visitName + "</td>" +
                "          <td>" + val.appointmentStatus + "</td>" +
                " <td> <a href='javascript:getBookedVisitDetails(" + val.id + ")'> View Detail </a> </td> " +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        setupTable(out, $('#homeBookedVisitData'), currentPage, totalData);
    });
}

function home_showVisitTab(visitId, studyId, tabId) {
    $.ajax({
        url: "rest/study/getStudyData?study=" + studyId,
        dataType: 'json',
        success: function (data) {
            sessionStorage.setItem("studyData", JSON.stringify(data));
            sessionStorage.setItem("mode", JSON.stringify('view'));
            $.getJSON("rest/study/getVisitTemplateData?visit=" + visitId, function (data) {
                sessionStorage.setItem("visitData", JSON.stringify(data));
                sessionStorage.setItem("selectedTab", tabId);
                sessionStorage.setItem("finalApproval", data.approved);
                sessionStorage.setItem("mode", JSON.stringify('view'));
                var navigatePage = "visit_approval.html";
                if (tabId == 0) {
                    navigatePage = "visit_detail.html";
                }
                window.location.href = navigatePage;
            });
        },
        error: function (xhr, status, error) {
            // check status && error
        }
    });
}

var loadHomeSuccess = function () {
    $('.homelink').addClass('active');
    app_runIdleTimer();
    commonData();
    homePage.init();
}

function onloadHomePage() {


    loadMetaHeaders();

    $.get("common/header.html", function (data) {
        $("#fullHeader").html(data);

        loadHomeSuccess();
    });

    $("#tabs").tabs();
    $("#homepageTabs").tabs();
    $('#templateSection').load("appts/wizard_templates.html");
    $('#appt-common-dialogs').load("appts/dialogs.html");

    $.get("common/dialogs.html", function (content) {
        $('#appt-common-dialogs').after(content);
    });

}

