/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * Created by ankit on 10/6/15.
 */
var totalDays = 1;
var daySelected;
var isInpatientVisitType;
var resourceTypeSelected = "Fixed";
var selectedEventResourceId;
var templateResourceOriginDate = new Date(2012, 1, 1, 0, 0, 0, 0);
var templateResourceOutpatientEndDate = new Date(2012, 1, 1, 23, 59, 59, 59);
var totalResources;
var borderColor;
var isEventClick = false;
var templateResourceId;
var actionType;
var templateResourceObj;
var approvedTemplate = "Not Approved";
var isLinkingFloat = false;
var templateResourcesSortBy;
var billableSortType;
var selectedTemplateResourcesId = [];

function loadTemplateResources() {
    commonData();
    var visit = JSON.parse(sessionStorage.getItem("visitData"));
    $.ajax({
        url: "rest/study/getVisitTemplateData?visit=" + visit.id,
        dataType: 'json',
        success: function (data) {
            sessionStorage.setItem("visitData", JSON.stringify(data));
            $('.formValidationRequired').css({visibility: "hidden"});
            $('.paginateDays').css({visibility: 'hidden'});
            $('#multi_day').css({display: 'none'});
            if (user.institutionRole.id != STUDY_STAFF) {
                $('.gantt_newResourceButton').css({display: 'inline-block'});
            }
            $('.gantt_newResourceButton').css({float: 'right'});
            $('.gantt_selectResourcesButton').css({display: 'none'});
            $('.gantt_copyDayButton').css({visibility: 'hidden'});
            $('#total_resources_count').html(0);
            $('#day_resources_count').html(0);
            app_selectedVisit = JSON.parse(sessionStorage.getItem("visitData"));
            app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
            $('#template_localId').html(app_selectedStudy.localId);
            $('#template_pi').html(app_selectedStudy.investigator.firstName + " " + app_selectedStudy.investigator.lastName);
            $('#template_studyName').html(app_selectedVisit.studyName);
            $('#template_visitName').html(app_selectedVisit.visitName);
            $('#template_visitSublocation').html(app_selectedVisit.sublocationName);
            $('#template_visitType').html(app_selectedVisit.visitTypeName);
            approvedTemplate = app_selectedVisit.approved;
            setTemplateApprovalStatus();
            isInpatientVisitType = app_selectedVisit.visitTypeName.indexOf("Inpatient") > -1;
            var isRelativeTime = app_selectedVisit.relativeTime;
            $('#template_type').html(isInpatientVisitType && !isRelativeTime ? '<img src="css/images/gantt/clock_time.png" style="vertical-align: bottom; height: 16px;"/> Clock Time' : '<img src="css/images/gantt/relative_time.png" style="vertical-align: bottom; height: 16px;"/> Relative Time ');
            createPagination();
            daySelected = 1;
            $(".pageInput").val(daySelected);
            totalResources = 0;
            var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
            getResourceStaticList();
            visitTemplateDateTimePickers();
            templateResourcesSortBy = "StartAsc";
            setSortTemplateResourceDropDownValues();
            loadTimelineEvents(daySelected, pageDate, templateResourcesSortBy);
        }
    });
}

function createPagination() {
    var pagination = "Day " + "<input type='text' style='width:20px; color: #0A507D; border: 1px solid #0A507D;' \
        class='pageInput' onkeypress='return paginateEnterKeySubmit(this, event)' onchange='updateInputVal(this)'/> of " + totalDays + "\
        <input type='button' value='Go' class='formButton' onclick='goToInputDay();' \
        style='min-width: 30px; margin: 0; height: auto;'/>";
    $("#topGanttDateHeader").html(pagination);
    $("#bottomGanttDateHeader").html(pagination);
    togglePagination();
}

function paginateEnterKeySubmit(myfield, e) {
    var keycode;
    if (window.event) keycode = window.event.keyCode;
    else if (e) keycode = e.which;
    else return true;

    if (keycode == 13) {
        if (isNaN(myfield.value) || myfield.value == 'undefined') {
            util_showMainMessage("Please enter a valid page number.");
            myfield.value = 1;
            $(".pageInput").val(1);
            return false;
        }
        if (myfield.value > totalDays || myfield.value < 1) {
            util_showMainMessage("Entered value outside the page range.. Please enter a valid page.");
            $(".pageInput").val(1);
            return false;
        }
        daySelected = myfield.value;
        $(".pageInput").val(daySelected);
        goToInputDay();
        return false;
    }
    else {
        return true;
    }
}

function togglePagination() {
    if (totalDays <= 1) {
        hidePagination();
    }
    else if (daySelected == 1) {
        hidePrevPagination();
    }
    else if (daySelected == totalDays) {
        hideNextPagination();
    }
    else {
        displayPagination();
    }
}

function displayPagination() {
    $('.firstDay').css({visibility: 'visible'});
    $('.previousDay').css({visibility: 'visible'});
    $('.nextDay').css({visibility: 'visible'});
    $('.lastDay').css({visibility: 'visible'});
}

function hidePagination() {
    $('.firstDay').css({visibility: 'hidden'});
    $('.previousDay').css({visibility: 'hidden'});
    $('.nextDay').css({visibility: 'hidden'});
    $('.lastDay').css({visibility: 'hidden'});
}

function hidePrevPagination() {
    $('.firstDay').css({visibility: 'hidden'});
    $('.previousDay').css({visibility: 'hidden'});
    $('.nextDay').css({visibility: 'visible'});
    $('.lastDay').css({visibility: 'visible'});
}

function hideNextPagination() {
    $('.firstDay').css({visibility: 'visible'});
    $('.previousDay').css({visibility: 'visible'});
    $('.nextDay').css({visibility: 'hidden'});
    $('.lastDay').css({visibility: 'hidden'});
}

function updateInputVal(obj) {
    if (isNaN(obj.value) || obj.value == 'undefined') {
        util_showMainMessage("Please enter a valid page number.");
        obj.value = 1;
        $(".pageInput").val(1);
        return false;
    }
    if (obj.value > totalDays || obj.value < 1) {
        util_showMainMessage("Entered value outside the page range.. Please enter a valid page.");
        $(".pageInput").val(1);
        return false;
    }
    $(".pageInput").val(obj.value);
    return true;
}

function goToInputDay() {
    $.blockUI();
    daySelected = $(".pageInput").val();
    $(".pageInput").val(daySelected);
    if (daySelected > totalDays) {
        util_showMainMessage("Entered value outside the page range.. Please enter a valid page.");
        return;
    }
    var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
    setSortTemplateResourceDropDownValues();
    timelinePagination(pageDate);
}

function goToFirstDay() {
    $.blockUI();
    daySelected = 1;
    $(".pageInput").val(daySelected);
    var pageDate = templateResourceOriginDate;
    setSortTemplateResourceDropDownValues();
    timelinePagination(pageDate);
}

function goToLastDay() {
    $.blockUI();
    daySelected = totalDays;
    $(".pageInput").val(daySelected);
    var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
    setSortTemplateResourceDropDownValues();
    timelinePagination(pageDate);
}

function goToPreviousDay() {
    $.blockUI();
    daySelected = $(".pageInput").val() != "" ? parseInt($(".pageInput").val()) - 1 : 1;
    if (daySelected > 0) {
        $(".pageInput").val(daySelected);
        var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
        setSortTemplateResourceDropDownValues();
        timelinePagination(pageDate);
    }
}

function goToNextDay() {
    $.blockUI();
    daySelected = $(".pageInput").val() != "" ? parseInt($(".pageInput").val()) + 1 : 1;
    if (daySelected <= totalDays) {
        $(".pageInput").val(daySelected);
        var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
        setSortTemplateResourceDropDownValues();
        timelinePagination(pageDate);
    }
}

function renderCopyDayButton() {
    if (isInpatientVisitType) {
        $('.paginateDays').css({visibility: 'visible'});
        daySelected = $(".pageInput").val();
        if (user.institutionRole.id != STUDY_STAFF) {
            $.getJSON("rest/appointment/isDayCopyable?visitId=" + app_selectedVisit.id + "&currentDay=" + daySelected, function (data) {
                if (data) {
                    $('.gantt_copyDayButton').css({visibility: 'visible'});
                }
            });
        }
    }
}

function loadTimelineEvents(daySelected, pageDate, sortType) {
    $('.gantt_copyDayButton').css({visibility: 'hidden'});
    $('.paginateDays').css({visibility: 'hidden'});
    $('.gantt_newResourceButton').css({float: 'right'});
    $('.gantt_selectResourcesButton').css({display: 'none'});

    if (actionType == "delete_template_resource" && totalResources == 1 && totalDays == daySelected) {
        $("#toCopyDaySelect option[value='" + daySelected + "']").remove();
        daySelected = 1;
        pageDate = templateResourceOriginDate;
        $(".pageInput").val(daySelected);
    }

    totalResources = 0;

    $.ajax({
        url: 'rest/appointment/getGanttInfo/combo?visit=' + app_selectedVisit.id + '&dayOffset=' + daySelected + '&sortType=' + sortType,
        dataType: 'json',
        success: function (data) {
            var totalVisitResources = data.infoDayResources.totalVisitResources;
            $('#total_resources_count').html(totalVisitResources);
            var resourcesData = data.infoDayResources.ganttResourceDetailList;
            var eventsData = data.infoDayEvents.ganttEventDetailList;
            totalResources += eventsData.length;
            var obj = $('#templateResourceSingleDayContainer').parent().find(' > div')[0];
            obj.title = "Expand";
            toggleGanttView(obj, 'templateResourceSingleDayContainer');
            loadTemplateResourcesData('templateResourceSingleDayContainer', daySelected, resourcesData, eventsData, pageDate);
            if (resourcesData.length > 0) {
                $('#no_one_resources').css({display: 'none'});
            } else {
                $('#templateResourceSingleDayContainer').parent().find(' > div > div > div > table > tbody').css({display: 'none'});
                $('#no_one_resources').css({display: 'block'});
            }
            if (totalVisitResources > 0) {
                $('.gantt_newResourceButton').css({float: ''});
                user.institutionRole.id != STUDY_STAFF ? $('.gantt_selectResourcesButton').css({display: 'inline-block'}) : $('.gantt_selectResourcesButton').css({display: 'none'});
                renderCopyDayButton();
            }

            if (isInpatientVisitType) {
                resourcesData = data.infoMultiResources.ganttResourceDetailList;
                eventsData = data.infoMultiEvents.ganttEventDetailList;
                totalDays = data.infoMultiResources.totalVisitCalendarDays;
                if (totalVisitResources > 0 && daySelected > totalDays) {
                    daySelected = 1;
                    $(".pageInput").val(daySelected);
                    timelinePagination(templateResourceOriginDate);
                    return;
                }
                $('#multi_day').css({display: 'block'});
                totalResources += eventsData.length;
                var obj = $('#templateResourceMultiDayContainer').parent().find(' > div')[0];
                obj.title = "Expand";
                toggleGanttView(obj, 'templateResourceMultiDayContainer');
                loadTemplateResourcesData('templateResourceMultiDayContainer', daySelected, resourcesData, eventsData, pageDate);
                if (resourcesData.length > 0) {
                    $('#no_multi_resources').css({display: 'none'})
                } else {
                    $('#templateResourceMultiDayContainer').parent().find(' > div > div > div > table > tbody').css({display: 'none'});
                    $('#no_multi_resources').css({display: 'block'});
                }
            }

            resourcesData = data.infoFloatResources.ganttResourceGroupList;
            eventsData = data.infoFloatEvents.ganttEventDetailList;
            totalResources += eventsData.length;
            var obj = $('#templateResourceFloatGroupContainer').parent().find(' > div')[0];
            obj.title = "Expand";
            toggleGanttView(obj, 'templateResourceFloatGroupContainer');
            loadTemplateResourcesData('templateResourceFloatGroupContainer', daySelected, resourcesData, eventsData, pageDate);
            if (resourcesData.length > 0) {
                $('#no_float_resources').css({display: 'none'})
            } else {
                $('#templateResourceFloatGroupContainer').parent().find(' > div > div > div > table > tbody').css({display: 'none'});
                $('#no_float_resources').css({display: 'block'});
            }

            resourcesData = data.infoFlexResources.ganttResourceGroupList;
            eventsData = data.infoFlexEvents.ganttEventDetailList;
            totalResources += eventsData.length;
            var obj = $('#templateResourceFlexGroupContainer').parent().find(' > div')[0];
            obj.title = "Expand";
            toggleGanttView(obj, 'templateResourceFlexGroupContainer');
            loadTemplateResourcesData('templateResourceFlexGroupContainer', daySelected, resourcesData, eventsData, pageDate);
            if (resourcesData.length > 0) {
                $('#no_flex_resources').css({display: 'none'})
            } else {
                $('#templateResourceFlexGroupContainer').parent().find(' > div > div > div > table > tbody').css({display: 'none'});
                $('#no_flex_resources').css({display: 'block'});
            }
            $('#day_resources_count').html(totalResources);
            createPagination();
            $(".pageInput").val(daySelected);
            $.unblockUI();
        }
    });
}

function destroyTimelines() {
    $('#templateResourceSingleDayContainer').fullCalendar("destroy");
    $('#templateResourceMultiDayContainer').fullCalendar("destroy");
    $('#templateResourceFloatGroupContainer').fullCalendar("destroy");
    $('#templateResourceFlexGroupContainer').fullCalendar("destroy");
}

function timelinePagination(pageDate) {
    destroyTimelines();
    loadTimelineEvents(daySelected, pageDate, templateResourcesSortBy);
}

function loadSelectResourcesData() {
    $.blockUI({fadeIn: 0});
    $("#select_template_resource").dialog({
        modal: true,
        height: 625,
        width: 900,
        resizable: false,
        open: function () {
            selectedTemplateResourcesId = [];
            $("#allResources").prop("checked", true);
            $("#nonBillableResources").prop("checked", true);
            $('.formValidationRequired').css({visibility: "hidden"});
            orderBy = "Asc";
            sortBy = sortBySelectableResourceStart;
            billableSortType = sortBy.concat(orderBy);
            createSelectableTable(billableSortType, isBillableViewSelected());
        },
        beforeClose: function (event, ui) {
            if (selectedTemplateResourcesId.length > 0) {
                confirmNavigateDialog(true);
                return false;
            }
            else {
                return true;
            }
        },
        close: function () {
            selectedTemplateResourcesId = [];
            $('#select_template_resource_save').css({display: 'none'});
            $('#select_template_resource_save_and_close').css({display: 'none'});
            $("#select_template_resource").dialog("close");
            var msg = "Applying changes to checked resources will mark them as Billable.";
            $("#bulkChangeMessage").html(msg);

        }
    });
}

function selectAllViewedResources() {
    selectedTemplateResourcesId = [];
    $('#selectTemplateResourcesData input[type=checkbox]').each(function () {
        this.checked = true;
        var row = $(this).parent().parent();
        var rowCells = row.find('td');
        var i = 0;
        rowCells.each(function () {
            if (i % 5 == 1) {
                selectedTemplateResourcesId.push($(this)[0].id);
            }
            i++;
        });
    });
    if (selectedTemplateResourcesId.length > 0) {
        $('#select_template_resource_save').css({display: 'inline-block'});
        $('#select_template_resource_save_and_close').css({display: 'inline-block'});
    }
}

function clearAllSelection() {
    selectedTemplateResourcesId = [];
    orderBy = "Asc";
    sortBy = sortBySelectableResourceStart;
    billableSortType = sortBy.concat(orderBy);
    $("#allResources").prop("checked", true);
    createSelectableTable(billableSortType, isBillableViewSelected());
    $('#select_template_resource_save').css({display: 'none'});
    $('#select_template_resource_save_and_close').css({display: 'none'});
}

function createSelectableTable(billableSortType, isBillable) {
    $.ajax({
        url: "rest/appointment/getSelectableTemplateResources?visitId=" + app_selectedVisit.id + "&sortType="
        + billableSortType + "&isBillable=" + isBillable,
        dataType: 'json',
        success: function (data) {
            var responseData = data;
            createSelectableResourcesTable(responseData);
            $.unblockUI();
        }
    });
}

function filterSelectedResources(obj) {
    $.blockUI({fadeIn: 0});
    if (obj.value == "All") {
        $('#selectTemplateResourcesData tbody tr').filter(function () {
            return $.trim($(this).find('td').eq(0).find("input")[0].checked) === "true"
                || $.trim($(this).find('td').eq(0).find("input")[0].checked) === "false"
        }).show();
    }
    else {
        $('#selectTemplateResourcesData tbody tr').filter(function () {
            if (obj.value === "Yes") {
                return $.trim($(this).find('td').eq(0).find("input")[0].checked) === "true"
            }
            else {
                return $.trim($(this).find('td').eq(0).find("input")[0].checked) === "false"
            }
        }).show();
        $('#selectTemplateResourcesData tbody tr').filter(function () {
            if (obj.value === "Yes") {
                return $.trim($(this).find('td').eq(0).find("input")[0].checked) === "false"
            }
            else {
                return $.trim($(this).find('td').eq(0).find("input")[0].checked) === "true"
            }
        }).hide();
    }
    $.unblockUI();
}

var sortBySelectableResourceName = "Name";
var sortBySelectableResourceType = "Type";
var sortBySelectableResourceStart = "Start";
var sortBySelectableResourceEnd = "End";

function createSelectableResourcesTable(responseData) {
    var iteration = 0;
    var sort_header;
    var resource_header1 = 'sortable';
    var resourceType_header2 = 'sortable';
    var start_header3 = 'sortable';
    var end_header4 = 'sortable';

    if (orderBy == 'Asc') {
        sort_header = 'sorting_asc';
    }
    else if (orderBy == 'Desc') {
        sort_header = 'sorting_desc';
    }

    if (sortBy == undefined || sortBy == sortBySelectableResourceStart) {
        start_header3 = sort_header;
    } else if (sortBy == sortBySelectableResourceName) {
        resource_header1 = sort_header;
    } else if (sortBy == sortBySelectableResourceType) {
        resourceType_header2 = sort_header;
    } else if (sortBy == sortBySelectableResourceEnd) {
        end_header4 = sort_header;
    }

    var header_table =
        " <table id='selectBillableResources' rules='cols' width='100%' border='0' cellspacing='0'>" +
        "  <thead> <tr>" +
        "   <th width='8%'  class='not_sortable' style='padding: 3px 5px 3px 5px'>Select</th> " +
        "   <th width='24%' style='border: 1px solid #CCC;' class= " + resource_header1 + " onclick='sortFunction(sortBySelectableResourceName)'><strong>Resource Name</strong></th> " +
        "   <th width='22%' style='border: 1px solid #CCC;' class= " + resourceType_header2 + " onclick='sortFunction(sortBySelectableResourceType)'><strong>Resource Type</strong></th> " +
        "   <th width='23%' style='border: 1px solid #CCC;' class= " + start_header3 + " onclick='sortFunction(sortBySelectableResourceStart)'><strong>Resource Start</strong></th> " +
        "   <th width='23%' style='border: 1px solid #CCC;' class= " + end_header4 + " onclick='sortFunction(sortBySelectableResourceEnd)'><strong>Resource End</strong></th>" +
        "  </tr> </thead> </table>";

    $('#selectTemplateResourcesHeaderData').html(header_table);

    var out = " <table id='selectBillableResources' class='selectResourcesTableClass'> <tbody>";

    $.each(responseData, function (key, val) {
        var rId = val.id;
        out += ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr> ");
        var selected = " <input type='checkbox' class='form-checkbox' onclick='renderSaveButton()' ";
        if ($.inArray(rId.toString(), selectedTemplateResourcesId) != -1) {
            selected = " <input type='checkbox' class='form-checkbox' checked='checked' onclick='renderSaveButton()' ";
        }
        var startTime = "Day " + (daysBetween(templateResourceOriginDate, val.startDate) + 1) + " " + showTime(val.startDate);
        var endTime = "Day " + (daysBetween(templateResourceOriginDate, val.endDate) + 1) + " " + showTime(val.endDate);

        out +=
            "   <td width='8%' style='text-align: center;'> " + selected + "/> </td>" +
            "   <td width='24%' align='left' valign='top' id='" + rId + "'>" + val.resource.name + "</td>" +
            "   <td width='22%' align='left' valign='top'>" + val.resource.resourceType + "</td>" +
            "   <td width='23%' align='left' valign='top'>" + startTime + "</td>" +
            "   <td width='23%' align='left' valign='top'>" + endTime + "</td>" +
            " </tr>";
        iteration++;
    });

    out += "</tbody> </table>";
    responseData.length > 0 ? $('#selectTemplateResourcesData').css({display: "inline-block"}) : $('#selectTemplateResourcesData').css({display: "none"});
    $('#selectTemplateResourcesData').html(out);
}

function renderSaveButton() {
    getSelectedTemplateResourcesForBillable();
    if (selectedTemplateResourcesId.length > 0) {
        $('#select_template_resource_save').css({display: 'inline-block'});
        $('#select_template_resource_save_and_close').css({display: 'inline-block'});
    }
    else {
        $('#select_template_resource_save').css({display: 'none'});
        $('#select_template_resource_save_and_close').css({display: 'none'});
    }
}

function confirmNavigateDialog(closeAll) {
    $("#ignore-changes-confirm").dialog({
        resizable: false,
        height: 200,
        width: 510,
        modal: true,
        buttons: {
            "Cancel": function () {
                $(this).dialog("close");
            },
            "Continue": function () {
                $("#ignore-changes-confirm").dialog("close");
                selectedTemplateResourcesId = [];
                if (closeAll) {
                    $("#select_template_resource").dialog("close");
                    $(".ui-dialog-content").dialog("close");
                }
                else {
                    isBillableViewSelected() ? $("#nonBillableResources").prop("checked", true)
                        : $("#billableResources").prop("checked", true);

                    $('#select_template_resource_save').css({display: 'none'});
                    $('#select_template_resource_save_and_close').css({display: 'none'});
                    changeBillableView();
                }
            }
        }
    })
}

function viewSelectedResources() {
    if (selectedTemplateResourcesId.length > 0) {
        isBillableViewSelected() ? $("#nonBillableResources").prop("checked", true)
            : $("#billableResources").prop("checked", true);

        confirmNavigateDialog(false);
    }
    else {
        changeBillableView();
    }
}

function changeBillableView() {
    $("#allResources").prop("checked", true);
    selectedTemplateResourcesId = [];
    orderBy = "Asc";
    sortBy = sortBySelectableResourceStart;
    billableSortType = sortBy.concat(orderBy);
    var msg = "Applying changes to checked resources will mark them as Non-Billable.";
    isBillableViewSelected() ? msg : msg = "Applying changes to checked resources will mark them as Billable.";
    $("#bulkChangeMessage").html(msg);
    createSelectableTable(billableSortType, isBillableViewSelected());
}

function isBillableViewSelected() {
    return $('input:radio[name=viewSelectedResource]:checked').val() == "billable";
}

function sortFunction(sort_by) {
    getSelectedTemplateResourcesForBillable();
    sortBy = sort_by;
    if (orderBy == "Asc") {
        orderBy = "Desc";
    }
    else {
        orderBy = "Asc";
    }
    billableSortType = sort_by.concat(orderBy);

    createSelectableTable(billableSortType, isBillableViewSelected());
}

function cancelSelectTemplateResourceClick() {
    if (selectedTemplateResourcesId.length > 0) {
        confirmNavigateDialog(true);
    }
    else {
        $("#select_template_resource").dialog("close");
    }
}

function getSelectedTemplateResourcesForBillable() {
    selectedTemplateResourcesId = [];
    $('#selectTemplateResourcesData input[type=checkbox]:checked').each(function () {

        var row = $(this).parent().parent();
        var rowCells = row.find('td');
        var i = 0;
        rowCells.each(function () {
            if (i % 5 == 1) {
                selectedTemplateResourcesId.push($(this)[0].id);
            }
            i++;
        });
    });
}

function saveSelectTemplateResource(closeDialog) {

    getSelectedTemplateResourcesForBillable();

    var templateResourcesCommaString = selectedTemplateResourcesId.join(",");

    actionType = "billable_selected";
    if (approvedTemplate == "Approved") {
        displayCrudConfirmationDialog(templateResourcesCommaString, closeDialog);
    }
    else {
        confirmChangeBillableResources(templateResourcesCommaString, isBillableViewSelected(), closeDialog);
    }
}

function confirmChangeBillableResources(templateResourcesCommaString, isBillable, closeDialog) {
    $.ajax({
        url: "rest/appointment/updateTemplateResourcesBillable?visitId=" + app_selectedVisit.id + "&templateResourcesCommaString=" + templateResourcesCommaString
        + "&isBillable=" + !isBillable,
        dataType: 'json',
        success: function (data) {
            actionType = "";
            clearAllSelection();
            if (closeDialog) {
                cancelSelectTemplateResourceClick();
            }
            var confirmationMessage = "Resources successfully updated.";
            util_showMainMessage(confirmationMessage);
            approvedTemplate = "Not Approved";
            setTimeout(function () {
                reloadTemplateResourcesData();
            }, 1000);
        }
    });
}

function updateTemplateResourceTime(event) {
    destroyTimelines();
    $.ajax({
        url: "rest/appointment/updateTemplateResourceTime?templateResourceId=" + event.id + "&startDate=" + event.start.format() + "&endDate=" + event.end.format(),
        dataType: 'json',
        success: function (data) {
            util_showMainMessage("Resource was successfully updated.");
            approvedTemplate = "Not Approved";
            setTimeout(function () {
                reloadTemplateResourcesData();
            }, 1000);
            return;
        },
        error: function () {
            util_showMainMessage("There was an error updating the resource.");
            return;
        }
    });
}

function dragResizeEventsConfirmation(event, revertFunc) {
    var eventStart = event.start.format();
    var eventEnd = event.end.format();
    var displayEventStart = moment(eventStart).toDate();
    var displayEventEnd = moment(eventEnd).toDate();
    var newDuration = ((displayEventEnd - displayEventStart) / 60000);
    if (displayEventStart < templateResourceOriginDate ||
        (!isInpatientVisitType && displayEventEnd > templateResourceOutpatientEndDate) ||
        (newDuration < 15)) {
        revertFunc();
        return;
    }

    if (event.floatable) {
        var displayEventPreferredStart = new Date(event.floatStartPreferred);
        var displayEventPreferredEnd = new Date(event.floatEndPreferred);

        if (((displayEventStart > displayEventPreferredStart)
            || (displayEventEnd < displayEventPreferredEnd))
            || (displayEventStart.getTime() == displayEventPreferredStart.getTime()
            && displayEventEnd.getTime() == displayEventPreferredEnd.getTime())) {
            revertFunc();
            return;
        }
        else {
            updateTemplateResourceTime(event);
        }
    }
    else {
        updateTemplateResourceTime(event);
    }
}

function eventDragDropResize(event, revertFunc) {
    actionType = "drag_drop_events";
    if (approvedTemplate == "Approved") {
        displayCrudConfirmationDialog(event, revertFunc);
    }
    else {
        dragResizeEventsConfirmation(event, revertFunc);
    }
}

function loadTemplateResourcesData(containerId, daySelected, resourceData, eventsData, pageDate) {
    var isIndividualResourceContainer = (containerId != "templateResourceFloatGroupContainer"
    && containerId != "templateResourceFlexGroupContainer");
    $('#' + containerId).fullCalendar({
        schedulerLicenseKey: 'GPL-My-Project-Is-Open-Source',
        now: pageDate,
        aspectRatio: 1,
        scrollTime: '00:00',
        slotDuration: '00:15',
        header: {
            left: '',
            center: '',
            right: ''
        },
        lazyFetching: false,
        slotWidth: '20',
        contentHeight: "auto",
        defaultView: 'timelineDay',
        loading: function (bool) {
            if (bool) {
                $.blockUI({fadeIn: 0});
            }
            else {
                $.unblockUI();
            }
        },
        titleFormat: {
            day: '[Day ]' + 'D'
        },
        columnFormat: {
            day: 'dddd, MMMM d'  // Monday 9/7
        },
        editable: isNotStudyStaff() && isIndividualResourceContainer,
        slotLabelFormat: 'H:mm',
        selectable: true,
        selectHelper: true,
        eventDrop: function (event, delta, revertFunc) {
            if (event.resourceId != selectedEventResourceId) {
                revertFunc();
            }

            eventDragDropResize(event, revertFunc);
        },
        eventResize: function (event, delta, revertFunc, jsEvent, ui, view) {
            eventDragDropResize(event, revertFunc);
        },
        eventDragStart: function (event) {
            selectedEventResourceId = event.resourceId;
        },
        eventMouseover: function (calEvent, jsEvent) {
            closeAllHovers();
            var topHeight = jsEvent.pageY - 50;
            var leftWidth = jsEvent.pageX - 150;
            borderColor = calEvent.color == "#D8BFD8" ? "#662E91" : calEvent.color;
            var isFloatable = calEvent.floatable;
            var hoverFloatText = isFloatable ? "<span class='appointmentHoverLabel'>Float Start Time</span>\
                                 <span class='appointmentHoverItem'>" + calEvent.displayFloatStart + "</span>\
                                 <span class='appointmentHoverLabel'>Float End Time</span>\
                                 <span class='appointmentHoverItem'>" + calEvent.displayFloatEnd + "</span>" : "";

            var tooltip = "<div id='timelineTooltip' class='appointmentHover' style='z-index:10001; left:" + leftWidth + "px; top:" + topHeight + "px; border: solid 5px " + borderColor + ";'>\
                                 <span class='appointmentHoverLabel'>Start Time</span>\
                                 <span class='appointmentHoverItem'>" + calEvent.displayStart + "</span>\
                                 <span class='appointmentHoverLabel'>End Time</span>\
                                 <span class='appointmentHoverItem'>" + calEvent.displayEnd + "</span>"
                + hoverFloatText +
                " <span class='appointmentHoverLabel'>Duration</span> \
                <span class='appointmentHoverItem'>" + convertMinutesToHrMins(calEvent.duration) + "</span>\
                                 <span class='appointmentHoverLabel'>Standard Alternate?</span> \
                                 <span class='appointmentHoverItem'>" + yesNoValue(calEvent.alternate) + "</span>\
                                 <span class='appointmentHoverLabel'>Billable?</span> \
                                 <span class='appointmentHoverItem'>" + yesNoValue(calEvent.billable) + "</span>\
                                 <span class='appointmentHoverAnnotations'></span>\
                                 <span class='appointmentHoverAnnotations'>" + showValue(calEvent.annotations).split(",").join("<br />") + "</span>\
                                 </div>";
            $("body").append(tooltip);

            var tooltipHeight = $('#timelineTooltip').height();
            $('.appointmentHover').css('top', topHeight - tooltipHeight);
            $('.addStyleRule').remove();
            $("body").append('<style class="addStyleRule">.appointmentHover:after{border-top: 10px solid ' + borderColor + ' !important;}</style>');
        },
        eventMouseout: function (calEvent, jsEvent) {
            $(this).css('z-index', 8);
            $('.appointmentHover').remove();
        },
        eventClick: function (calEvent, jsEvent, view) {
            $('.appointmentHover').remove();
            closeAllHovers();
            if (user.institutionRole.id != STUDY_STAFF) {
                isEventClick = true;
                templateResourceObj = calEvent;
                var isFloatable = calEvent.floatable;
                var isFlexible = calEvent.flexible;
                var isGroupedResource = calEvent.groupId != undefined;
                var isNotFixedResource = isFloatable || isFlexible;
                var isFlexGrouped = isGroupedResource && isFlexible;
                var isFloatGrouped = isGroupedResource && isFloatable;
                borderColor = calEvent.color == "#D8BFD8" ? "#662E91" : calEvent.color;
                templateResourceId = calEvent.id;
                var width = isNotFixedResource ? 110 : 75;
                var displayLinkAction = isNotFixedResource ? "<img src='css/images/gantt/icon_link.png' title='Link Resource' onclick='openLinkResourcesDialog(" + isFloatable + ")'/>" : "";
                var displayUnLinkAction = "<img src='css/images/gantt/icon_unlink.png' title='Unlink Resource' onclick='unlinkIndividualResource()'/>";
                var unlinkOrLinkAction = isGroupedResource ? displayUnLinkAction : displayLinkAction;
                var tooltip = "<div class='eventClickActions' style='z-index:10001; width: " + width + "px; left:" + (jsEvent.pageX - 70) + "px; top:" + (jsEvent.pageY - 70) + "px; border: solid 5px " + borderColor + ";'> " +
                    " <img src='css/images/gantt/icon_papers.jpg' title='Copy Resource' style='height: 20px;' onclick='copyTemplateResourceConfirmDialog(event)'/> &nbsp; " +
                    " <img src='css/images/gantt/icon_trash.jpg' title='Delete Resource' onclick='deleteTemplateResourceConfirmDialog(event," + isFlexGrouped + "," + isFloatGrouped + ")'/> &nbsp; " +
                    " <img src='css/images/gantt/icon_pencil.jpg' title='Edit Resource' onclick='editTemplateResourceConfirmDialog(event)'/> &nbsp; " +
                    unlinkOrLinkAction +
                    "</div>";
                $("body").append(tooltip);
                $('.addEventStyleRule').remove();
                $("body").append('<style class="addEventStyleRule">.eventClickActions:after{border-top: 10px solid ' + borderColor + ' !important;}</style>');
            }
        },
        eventAfterRender: function (event, element, view) {
            if (event.floatable) {
                var startDay = new Date(event.floatStartPreferred).getDate();
                var endDay = new Date(event.floatEndPreferred).getDate();
                var notSingleDay = (startDay != endDay);

                var isMultiDay = notSingleDay
                    || (new Date(event.floatStartDate).getDate()
                    != new Date(event.floatEndDate).getDate());

                var floatStartDate = new Date(event.floatStartDate);
                if (isMultiDay && floatStartDate.getDate() != daySelected) {
                    floatStartDate.setHours(0);
                    floatStartDate.setMinutes(0);
                    floatStartDate.setSeconds(0);
                }

                var displayFloatPreferredStart = new Date(event.floatStartPreferred);
                var displayFloatPreferredEnd = new Date(event.floatEndPreferred);
                displayFloatPreferredEnd.setSeconds(0);
                if (notSingleDay && displayFloatPreferredStart.getDate() != daySelected) {
                    displayFloatPreferredStart = displayFloatPreferredStart.addDays(daySelected - displayFloatPreferredStart.getDate());
                    displayFloatPreferredStart.setHours(0);
                    displayFloatPreferredStart.setMinutes(0);
                    displayFloatPreferredStart.setSeconds(0);
                }
                var floatStartTime = floatStartDate.addDays(daySelected - floatStartDate.getDate());
                var leftOffset = ((displayFloatPreferredStart.getTime() - floatStartTime.getTime()) / 1000) / 60;
                var floatLeft = (leftOffset / 15) * 19.85;
                var eventDuration = ((displayFloatPreferredEnd.getTime() - displayFloatPreferredStart.getTime()) / 1000) / 60;
                var floatWidth = (eventDuration / 15) * 20;
                var contentElement = $(element).find(".fc-content");

                var sameDay = daySelected == startDay || daySelected == endDay;
                var overlappingDay = daySelected > startDay && daySelected < endDay;
                var preferredTimeInView = sameDay || overlappingDay;
                !preferredTimeInView ? totalResources-- : totalResources;

                contentElement.css('left', floatLeft + "px");
                contentElement.css('width', floatWidth + 'px');
                contentElement.css('background-color', '#662E91');
                contentElement.css('position', 'relative');
            }
        },
        resourceAreaWidth: '30%',
        resourceColumns: [
            {
                labelText: 'Resource',
                field: 'resourceName',
                width: '150px',
                render: function (resource, el) {
                    var tId = resource.templateResourceId;
                    var img = ' <img src="css/images/gantt/icon_info.png" style="vertical-align: middle;" border="0" onmouseenter="onResourceMouseEnter(event, this, ' + tId + ')" onmouseout="onResourceMouseOut();">';
                    if (resource.resourceName != undefined) {
                        el.append(img);
                    }
                    else {
                        var groupId = resource.groupId;
                        var groupResourceString = resource.groupComboDisplay;
                        var img = '<span onclick="unlinkGroupResources(\'' + groupId + '\',\'' + groupResourceString + '\')"> <img src="css/images/gantt/unlink_group_resources.jpg" id="templateResourceFloatGroupContainerImg1"/> <span style="margin: 0; color: #0A507D;">Unlink Group Resources</span> </span>';
                        isNotStudyStaff() ? el.append(img) : el;
                    }
                }
            },
            {
                labelText: 'Type',
                field: 'resourceType',
                width: '50px'
            }
        ],
        resources: resourceData,
        events: eventsData
    });
}

function onResourceMouseOut() {
    $('.resourceHoverText').remove();
}

function onResourceMouseEnter(event, obj, templateResourceId) {
    preventDefaultAction(event);
    daySelected = $(".pageInput").val();
    $('.appointmentHover').remove();
    $('.eventClickActions').remove();
    $.getJSON("rest/appointment/getGanttResourceInfo?visitId=" + app_selectedVisit.id
        + "&templateResourceId=" + templateResourceId + "&dayOffset=" + daySelected, function (data) {
        var totalDayInstances = data.totalRelevantTrStintsOfThisResource;
        var totalInstances = data.totalTrStintsOfThisResourceInVisit;
        var totalVisitTime = data.totalTimeOfStintsOfThisResourceInVisit;
        var totalDayTime = data.totalTimeOfRelevantStintsOfThisResource;

        var left = cumulativeLeftOffset(obj) + 30;
        var topHeight = cumulativeTopOffset(obj) + 10;
        var totalTimeHeader = isInpatientVisitType ? "Total Day Time" : "Total Time";
        var instancesHeader = isInpatientVisitType ? "Day Instances" : "Instances";
        var addMoreColumns = "";

        if (isInpatientVisitType) {
            addMoreColumns = " \<span class='appointmentHoverLabel' style='width: 100px;'>Total Visit Time</span> \
                                 <span class='appointmentHoverItem' style='width: 50px;'>" + convertMinutesToHrMins(totalVisitTime) + "</span>\
                                 <span class='appointmentHoverLabel' style='width: 100px;'>Visit Instances</span> \
                                 <span class='appointmentHoverItem' style='width: 50px;'>" + totalInstances + "</span>";
        }
        var tooltip = "<div id='resourceTooltip' class='resourceHoverText' style='z-index:10001; width: 160px; left:" + left + "px; top:" + topHeight + "px;'>\
                                 <span class='appointmentHoverLabel' style='width: 100px;'>" + totalTimeHeader + "</span>\
                                 <span class='appointmentHoverItem' style='width: 50px;'>" + convertMinutesToHrMins(totalDayTime) + "</span>\
                                 <span class='appointmentHoverLabel' style='width: 100px;'>" + instancesHeader + "</span>\
                                 <span class='appointmentHoverItem' style='width: 50px;'>" + totalDayInstances + "</span>"
            + addMoreColumns +
            "</div>";
        $("body").append(tooltip);

        var tooltipHeight = $('#resourceTooltip').height();
        $('.resourceHoverText').css('top', topHeight - tooltipHeight + 20);
    });
}

function cumulativeTopOffset(element) {
    var top = 0;
    do {
        top += element.offsetTop || 0;
        element = element.offsetParent;
    } while (element);

    return top;
};

function cumulativeLeftOffset(element) {
    var left = 0;
    do {
        left += element.offsetLeft || 0;
        element = element.offsetParent;
    } while (element);

    return left;
};

function closeAllHovers() {
    if (!isEventClick) {
        $('.eventClickActions').remove();
    }
    $('.resourceHoverText').remove();
    $('.appointmentHover').remove();
    isEventClick = false;
}

function convertMinutesToHrMins(mins) {
    var minutes = mins % 60;
    var hours = Math.floor(mins / 60);

    minutes = (minutes < 10 ? '0' : '') + minutes;
    hours = (hours < 10 ? '0' : '') + hours;

    return hours + ':' + minutes;
}

function toggleResourceTypeSelected() {
    disableFloatInput();
    resourceTypeSelected = $('input:radio[name=category]:checked').val();
    if (resourceTypeSelected == 'Float') {
        if (isInpatientVisitType) {
            $("#template_resource_float_start_day").spinner("option", "disabled", false);
            $("#template_resource_float_end_day").spinner("option", "disabled", false);
        }
        $("#template_resource_float_start_time").timepicker("option", "disabled", false);
        $("#template_resource_float_end_time").timepicker("option", "disabled", false);
        enableOverlayCss("template_resource_float_start_time");
        enableOverlayCss("template_resource_float_end_time");
    }
}

function toggleCategoryRadioButtons(disabled) {
    var radios = document.getElementsByName('category');
    for (var i = 0; i < radios.length; i++) {
        radios[i].disabled = disabled;
    }
}

function disableTemplateWidgets() {
    toggleCategoryRadioButtons(true);
    $("#template_resource_start_day").spinner("option", "disabled", true);
    $("#template_resource_end_day").spinner("option", "disabled", true);
    $("#template_resource_start_time").timepicker("option", "disabled", true);
    $("#template_resource_end_time").timepicker("option", "disabled", true);
    $("#template_resource_float_start_day").spinner("option", "disabled", true);
    $("#template_resource_float_end_day").spinner("option", "disabled", true);
    $("#template_resource_float_start_time").timepicker("option", "disabled", true);
    $("#template_resource_float_end_time").timepicker("option", "disabled", true);

    disableOverlayCss("template_resource_start_time");
    disableOverlayCss("template_resource_end_time");
    disableOverlayCss("template_resource_float_start_time");
    disableOverlayCss("template_resource_float_end_time");
}

function enableRegularTemplateWidgets() {
    toggleCategoryRadioButtons(false);
    if (isInpatientVisitType) {
        $("#template_resource_start_day").spinner("option", "disabled", false);
        $("#template_resource_end_day").spinner("option", "disabled", false);
    }
    else {
        $("#template_resource_start_day").spinner("option", "disabled", true);
        $("#template_resource_end_day").spinner("option", "disabled", true);
    }
    $("#template_resource_start_time").timepicker("option", "disabled", false);
    $("#template_resource_end_time").timepicker("option", "disabled", false);
    enableOverlayCss("template_resource_start_time");
    enableOverlayCss("template_resource_end_time");

    disableFloatInput();

    $("#allAnnotations").prop("checked", true);
    var responseData = [];
    createAnnotationsTable(responseData);
}

function disableOverlayCss(elementId) {
    var elementObj = document.getElementById(elementId);
    elementObj.style.color = "lightgray";
}

function enableOverlayCss(elementId) {
    var elementObj = document.getElementById(elementId);
    elementObj.style.color = "";
}

function disableFloatInput() {
    $("#template_resource_float_start_day").val(daySelected);
    $("#template_resource_float_end_day").val(daySelected);
    $('#template_resource_float_start_time').timepicker('setTime', "00:00");
    $('#template_resource_float_end_time').timepicker('setTime', "00:00");

    $("#template_resource_float_start_day").spinner("option", "disabled", true);
    $("#template_resource_float_end_day").spinner("option", "disabled", true);
    $("#template_resource_float_start_time").timepicker("option", "disabled", true);
    $("#template_resource_float_end_time").timepicker("option", "disabled", true);
    disableOverlayCss("template_resource_float_start_time");
    disableOverlayCss("template_resource_float_end_time");
}

function crudResourceClick(mode) {
    actionType = mode;
    $("#crud_template_resource").dialog({
        modal: true,
        height: 750,
        width: 900,
        resizable: false,
        open: function () {
            $('.formValidationRequired').css({visibility: "hidden"});
            $("#wizard_templateResources").val('');
            $('#templateResourceButtons input').css({width: "75px"});

            var dayInput = totalDays > 1 ? $(".pageInput").val() : 1;
            $(".pageInput").val(dayInput);

            if (mode == "add_template_resource") {
                $("#crud_template_resource").dialog('option', 'title', 'Add New Resource');
                document.getElementById("template_resource_alternate").checked = true;
                document.getElementById("template_resource_billable").checked = false;
                $("#template_resource_start_day").val(dayInput);
                $("#template_resource_end_day").val(dayInput);
                $("#template_resource_float_start_day").val(dayInput);
                $("#template_resource_float_end_day").val(dayInput);
                $('#template_resource_start_time').timepicker('setTime', "00:00");
                $('#template_resource_end_time').timepicker('setTime', "00:00");
                $("#template_resource_fixed").prop("checked", true);
            }
            else {
                if (mode == "edit_template_resource") {
                    $("#crud_template_resource").dialog('option', 'title', 'Edit Resource');
                }
                else {
                    $("#crud_template_resource").dialog('option', 'title', 'Copy Resource');
                }
                $.ajax({
                    url: "rest/appointment/getTemplateResourceDataWithAnnotations?templateResourceId=" + templateResourceId,
                    dataType: 'json',
                    success: function (data) {
                        var responseData = data.llaList;
                        createAnnotationsTable(responseData);
                        app_selectedTemplateResource = data.templateResource;
                        var resourceId = app_selectedTemplateResource.resource.id;
                        $("#allAnnotations").prop("checked", true);
                        var billableVal = app_selectedTemplateResource.billable;
                        var floatableVal = app_selectedTemplateResource.floatable;

                        if (floatableVal == true) {
                            $("#template_resource_float").prop("checked", floatableVal);

                            toggleResourceTypeSelected();
                            var floatStartVal = app_selectedTemplateResource.floatStart;
                            var floatStartMinutes = floatStartVal % 60;
                            var floatStartDays = Math.floor(floatStartVal / 24 / 60);
                            var floatStartDate = templateResourceOriginDate.addDays(floatStartDays);
                            var floatStartHours = Math.floor(floatStartVal / 60 % 24);
                            floatStartDate.setHours(floatStartHours);
                            floatStartDate.setMinutes(floatStartMinutes);
                            var floatStartDay = daysBetween(templateResourceOriginDate, floatStartDate) + 1;
                            var floatEndVal = app_selectedTemplateResource.floatEnd;
                            var floatEndMinutes = floatEndVal % 60;
                            var floatEndDays = Math.floor(floatEndVal / 24 / 60);
                            var floatEndDate = templateResourceOriginDate.addDays(floatEndDays);
                            var floatEndHours = Math.floor(floatEndVal / 60 % 24);
                            floatEndDate.setHours(floatEndHours);
                            floatEndDate.setMinutes(floatEndMinutes);
                            var floatEndDay = daysBetween(templateResourceOriginDate, floatEndDate) + 1;
                            $("#template_resource_float_start_day").val(floatStartDay);
                            $('#template_resource_float_start_time').timepicker('setTime', showTime(floatStartDate));
                            $("#template_resource_float_end_day").val(floatEndDay);
                            $('#template_resource_float_end_time').timepicker('setTime', showTime(floatEndDate));
                        }

                        var flexibleVal = app_selectedTemplateResource.flexible;
                        if (!floatableVal && !flexibleVal) {
                            $("#template_resource_fixed").prop("checked", true);
                        }

                        var alternateVal = app_selectedTemplateResource.alternate;
                        document.getElementById("template_resource_billable").checked = billableVal;

                        $("#template_resource_flex").prop("checked", flexibleVal);
                        document.getElementById("template_resource_alternate").checked = alternateVal;

                        $("#wizard_templateResources").val(resourceId);
                        var startDate = new Date(app_selectedTemplateResource.startDate);
                        var startDay = daysBetween(templateResourceOriginDate, startDate) + 1;
                        $("#template_resource_start_day").val(startDay);
                        $("#template_resource_start_time").timepicker('setTime', showTime(startDate));

                        var endDate = new Date(app_selectedTemplateResource.endDate);
                        var endDay = daysBetween(templateResourceOriginDate, endDate) + 1;
                        $("#template_resource_end_day").val(endDay);
                        $("#template_resource_end_time").timepicker('setTime', showTime(endDate));

                        if (app_selectedTemplateResource.groupId != null && app_selectedTemplateResource.groupId != "") {
                            if (mode == "edit_template_resource") {
                                disableTemplateWidgets();
                            }
                            else {
                                toggleCategoryRadioButtons(false);
                            }
                        }
                        $.unblockUI();
                    }
                });
            }
        },
        close: function () {
            $.blockUI({fadeIn: 0});
            $('.formValidationRequired').css({visibility: "hidden"});
            enableRegularTemplateWidgets();
            $.unblockUI();
        }
    });
}

function daysBetween(first, second) {

    var second1 = new Date(second);
    // Copy date parts of the timestamps, discarding the time parts.
    var one = new Date(first.getFullYear(), first.getMonth(), first.getDate());
    var two = new Date(second1.getFullYear(), second1.getMonth(), second1.getDate());

    // Do the math.
    var millisecondsPerDay = 1000 * 60 * 60 * 24;
    var millisBetween = two.getTime() - one.getTime();
    var days = millisBetween / millisecondsPerDay;
    // Round down.
    return Math.round(days);
}

function setTemplateApprovalStatus() {
    var imgSrc = approvedTemplate == "Approved" ? '<img src="css/images/gantt/approved.png"/> ' : '<img src="css/images/gantt/not_approved.png"/> ';
    $('#template_status').html(imgSrc + approvedTemplate);
}

function postCrudTemplateResources(jsonData) {
    $.post("rest/appointment/crudTemplateResources?actionType=" + actionType, {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);
        if (parsedData.result) {
            var confirmationMessage = "";
            if (actionType == "edit_template_resource") {
                confirmationMessage = "Template Resource Successfully updated.";
            }
            else if (actionType == "add_template_resource") {
                confirmationMessage = "Template Resource Successfully added.";
            }
            else if (actionType == "delete_template_resource") {
                confirmationMessage = "Template Resource Successfully deleted.";
            }
            else if (actionType == "copy_template_resource") {
                confirmationMessage = "Template Resource Successfully copied.";
            }
            util_showMainMessage(confirmationMessage);
            approvedTemplate = parsedData.infoMsg;
            setTimeout(function () {
                actionType != "delete_template_resource" ? $("#crud_template_resource").dialog("close") : "";
                actionType = "";
                reloadTemplateResourcesData();
            }, 1000);
        }
        else {
            if (actionType == "delete_template_resource") {
                if (parsedData.infoMsg == "resource is booked") {
                    util_showMainMessage(parsedData.errorMsg);
                }
                else {
                    confirmBeforeDeleteUnlinkingResource(parsedData.infoMsg, "Delete");
                }
            }
            else {
                util_showMainMessage(parsedData.errorMsg);
            }
        }
    });
}

function displayCrudConfirmationDialog(jsonData, dialog) {
    var height = 300;
    var dialogName = dialog;

    if (dialog == "" || typeof dialog != "string") {
        height = 200;
        dialogName = "edit_template_resource_dialog_confirm";
    }

    $("#" + dialogName).css({display: 'inline-block'});
    $("#" + dialogName).dialog({
        resizable: false,
        height: height,
        width: 600,
        modal: true,
        close: function () {
            if (actionType == "drag_drop_events") {
                dialog();
            }
        },
        buttons: {
            "Continue": function () {
                if (actionType == "link_template_resource") {
                    linkTemplateResourcesConfirmation(jsonData);
                }
                else if (actionType == "unlink_template_resource") {
                    unlinkIndividualConfirmation();
                }
                else if (actionType == "copy_day_resources") {
                    copyDayConfirmation();
                }
                else if (actionType == "unlink_group_template_resource") {
                    unlinkGroupResourcesConfirmation(jsonData, dialogName);
                }
                else if (actionType == "billable_selected") {
                    confirmChangeBillableResources(jsonData, isBillableViewSelected(), dialog);
                }
                else if (actionType == "drag_drop_events") {
                    dragResizeEventsConfirmation(jsonData, dialog);
                }
                else {
                    postCrudTemplateResources(jsonData);
                }
                $(this).dialog("close");
            },
            "Cancel": function () {
                $(this).dialog("close");
            }
        }
    });
}

function saveTemplateResource() {
    $('.formValidationRequired').css({visibility: "hidden"});
    var confirmationMessage = "";
    var resourceId = $("#wizard_templateResources").val();
    if (resourceId == "") {
        confirmationMessage = "Please select a resource.";
        showError('#template_wizard_formValidation', confirmationMessage);
        return;
    }

    var startValidationResult = $.isNumeric($("#template_resource_start_day").val());
    var endValidationResult = $.isNumeric($("#template_resource_end_day").val());
    var startDay = parseInt($("#template_resource_start_day").val());
    var endDay = parseInt($("#template_resource_end_day").val());

    if (isNaN(startDay) || startDay < 1 || endDay < 1 || isNaN(endDay)
        || !startValidationResult || !endValidationResult) {
        confirmationMessage = "Please check resource start and end times.";
        showError('#template_wizard_formValidation', confirmationMessage);
        return;
    }

    var startTimeVal = $("#template_resource_start_time").timepicker().val();
    var endTimeVal = $("#template_resource_end_time").timepicker().val();

    if (startDay > endDay
        || (startDay == endDay && endTimeVal <= startTimeVal)) {
        confirmationMessage = "Please check resource start and end times.";
        showError('#template_wizard_formValidation', confirmationMessage);
        return;
    }
    resourceTypeSelected = ($('input:radio[name=category]:checked').val());

    if (resourceTypeSelected == "Float") {
        var floatStartDay = parseInt($("#template_resource_float_start_day").val());
        var floatEndDay = parseInt($("#template_resource_float_end_day").val());
        var floatStartTimeVal = $("#template_resource_float_start_time").timepicker().val();
        var floatEndTimeVal = $("#template_resource_float_end_time").timepicker().val();
        var startValidationResult = $.isNumeric($("#template_resource_float_start_day").val());
        var endValidationResult = $.isNumeric($("#template_resource_float_end_day").val());

        if (isNaN(floatStartDay) || floatStartDay < 1 || floatEndDay < 1
            || isNaN(floatEndDay) || !startValidationResult || !endValidationResult) {
            confirmationMessage = "Please check float start and end times.";
            showError('#template_wizard_formValidation', confirmationMessage);
            return;
        }

        if (floatStartDay == startDay && floatEndDay == endDay &&
            floatEndTimeVal == endTimeVal && startTimeVal == floatStartTimeVal) {
            confirmationMessage = "Please check resource and float start and end times.";
            showError('#template_wizard_formValidation', confirmationMessage);
            return;
        }
        else if (floatStartDay > floatEndDay ||
            (floatStartDay == floatEndDay && floatEndTimeVal <= floatStartTimeVal)) {
            confirmationMessage = "Please check float start and end times.";
            showError('#template_wizard_formValidation', confirmationMessage);
            return;
        }
        else if (startDay < floatStartDay || endDay > floatEndDay ||
            (startDay == floatStartDay && startTimeVal < floatStartTimeVal) ||
            (endDay == floatEndDay && endTimeVal > floatEndTimeVal)) {

            confirmationMessage = "Please check resource and float start and end times.";
            showError('#template_wizard_formValidation', confirmationMessage);
            return;
        }
    }

    var billable = $('#template_resource_billable').is(':checked');
    var alternate = $('#template_resource_alternate').is(':checked');

    var startDate = convertDayAndTimeToDate(startDay, startTimeVal);
    var endDate = convertDayAndTimeToDate(endDay, endTimeVal);
    var floatStart = 0;
    var floatEnd = 0;

    if (resourceTypeSelected == "Float") {
        floatStart = convertTimeStringToMinutes(floatStartDay, floatStartTimeVal);
        floatEnd = convertTimeStringToMinutes(floatEndDay, floatEndTimeVal);
    }

    var selectedAnnotationsId = [];
    var selectedAnnotationsQuantity = [];
    var selectedAnnotationsComment = [];

    $('#resourceAnnotationsData input[type=checkbox]:checked').each(function () {

        var row = $(this).parent().parent();
        var rowCells = row.find('td');
        var i = 0;
        rowCells.each(function () {
            if (i % 4 == 1) {
                selectedAnnotationsId.push($(this)[0].id);
            }
            else if (i % 4 == 2) {
                var quantity = $.trim($(this).html());
                selectedAnnotationsQuantity.push(parseInt(quantity));
            }
            else if (i % 4 == 3) {
                var comment = $.trim($(this).html());
                selectedAnnotationsComment.push(comment);
            }
            i++;
        });
    });

    var jsonData = JSON.stringify({
        id: (app_selectedTemplateResource != null ? app_selectedTemplateResource.id : 0),
        visitTemplate: app_selectedVisit.id,
        resource: resourceId,
        alternate: alternate,
        billable: billable,
        flexible: resourceTypeSelected == "Flex" ? true : false,
        floatable: resourceTypeSelected == "Float" ? true : false,
        selectedAnnotations: selectedAnnotationsId,
        selectedAnnotationsQuantity: selectedAnnotationsQuantity,
        selectedAnnotationsComment: selectedAnnotationsComment,
        floatStart: resourceTypeSelected == "Float" ? floatStart : null,
        floatEnd: resourceTypeSelected == "Float" ? floatEnd : null,
        startDate: startDate.getTime(),
        endDate: endDate.getTime()
    });

    if (approvedTemplate == "Approved") {
        if (actionType == "edit_template_resource") {
            $.post("rest/appointment/crudTemplateResources?actionType=edit_template_resource_check_diff_only", {data: jsonData}, function (data) {
                var parsedData = $.parseJSON(data);
                if (parsedData.result) {
                    displayCrudConfirmationDialog(jsonData, "");
                }
                else {
                    postCrudTemplateResources(jsonData);
                }
            });
        }
        else {
            displayCrudConfirmationDialog(jsonData, "");
        }
    }
    else {
        postCrudTemplateResources(jsonData);
    }
}

function convertTimeStringToMinutes(day, time) {
    var minutes = (day - 1) * MINS_PER_DAY;
    var index = time.split(":");

    var hours = parseInt(index[0], 10);
    var mins = parseInt(index[1], 10);

    return (minutes + (hours * MINS_PER_HOUR) + mins);
}

function convertDayAndTimeToDate(dayOffset, timeVal) {
    var date = templateResourceOriginDate.addDays(dayOffset - 1);
    var index = timeVal.split(":");

    var hours = parseInt(index[0], 10);
    var minutes = parseInt(index[1], 10);

    date.setHours(hours);
    date.setMinutes(minutes);
    date.setSeconds(0);
    return date;
}

function visitTemplateDateTimePickers() {
    $("#template_resource_start_day").spinner({min: 1});
    $("#template_resource_float_start_day").spinner({min: 1});
    $('#template_resource_start_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    $('#template_resource_float_start_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    $("#template_resource_end_day").spinner({min: 1});
    $("#template_resource_float_end_day").spinner({min: 1});
    $('#template_resource_end_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    $('#template_resource_float_end_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    $("#template_resource_start_time").mask("99:99");
    $("#template_resource_float_start_time").mask("99:99");
    $("#template_resource_end_time").mask("99:99");
    $("#template_resource_float_end_time").mask("99:99");
    $('#template_resource_float_start_time').timepicker('setTime', "00:00");
    $('#template_resource_float_end_time').timepicker('setTime', "00:00");
    enableRegularTemplateWidgets();
}

function loadResourceAnnotationsData() {
    $("#allAnnotations").prop("checked", true);
    var resourceId = $("#wizard_templateResources").val();
    $.ajax({
        url: "rest/resource/getResourceAnnotations?resourceId=" + resourceId,
        dataType: 'json',
        success: function (data) {
            var responseData = data.resourceAnnotationsValues;
            createAnnotationsTable(responseData);
        }
    });
}

function cancelTemplateResourceClick() {
    $('#wizard_templateResources').val('');
    $("#crud_template_resource").dialog("close");
}

function getResourceStaticList() {
    $.get("rest/app/getStaticLists", {}, function (data) {
        var parsedData = $.parseJSON(data);
        resources = parsedData.resources;
        resourcesSelectOptions = buildSelectOptions(resources, 'name', 'choose');
        $("#wizard_templateResources").html(resourcesSelectOptions);
    });
}

function editTemplateResourceConfirmDialog(event) {
    $.blockUI({fadeIn: 0});
    $('.eventClickActions').remove();
    crudResourceClick("edit_template_resource");
}

function deleteTemplateResourceConfirmDialog(event, isFlexGrouped, isFloatGrouped) {
    $('.eventClickActions').remove();
    $("#delete_template_resource_dialog_confirm").css({display: 'inline-block'});
    actionType = "delete_template_resource";
    var jsonData = JSON.stringify({
        id: templateResourceId,
        visitTemplate: app_selectedVisit.id
    });
    if (approvedTemplate == "Approved") {
        if (isFlexGrouped) {
            checkIfResourcesCanStillBeLinkedOnDelete();
        }
        else {
            var msg = "<p>Editing this template will change the approval status.<br></p> " +
                "<p>Are you sure you want to delete this resource?<br></p>";
            if (isFloatGrouped) {
                msg += "<p>Note: The remaining resource(s) in this group will become unlinked.</p>";
            }
            $('#delete_template_resource_approval_dialog_confirm').html(msg);
            displayCrudConfirmationDialog(jsonData, "delete_template_resource_approval_dialog_confirm");
        }
    }
    else {
        var msg = "<p>Are you sure you want to delete this resource?<br></p>";
        if (isFlexGrouped) {
            $('#delete_template_resource_dialog_confirm').html(msg);
            checkIfResourcesCanStillBeLinkedOnDelete();
        }
        else {
            if (isFloatGrouped) {
                msg += "<p>Note: The remaining resource(s) in this group will become unlinked.</p>";
            }
            $('#delete_template_resource_dialog_confirm').html(msg);
            deleteConfirmationDialog(jsonData);
        }
    }
}

function deleteConfirmationDialog(jsonData) {
    $("#delete_template_resource_dialog_confirm").dialog({
        resizable: false,
        height: 220,
        width: 600,
        modal: true,
        buttons: {
            "Delete": function () {
                $(this).dialog("close");
                postCrudTemplateResources(jsonData);
            },
            "Cancel": function () {
                $(this).dialog("close");
            }
        }
    });
}

function checkIfResourcesCanStillBeLinkedOnDelete() {
    $.ajax({
        url: "rest/appointment/checkIfResourcesLinkableOnDeleteUnlink?templateResourceId=" + templateResourceId,
        dataType: 'json',
        success: function (data) {
            if (data.result) {
                var jsonData = JSON.stringify({
                    id: templateResourceId,
                    visitTemplate: app_selectedVisit.id
                });
                if (approvedTemplate == "Approved") {
                    var msg = '<p>Editing this template will change the approval status.<br></p> ' +
                        ' <p>Are you sure you want to delete this resource?</p>';
                    var dialogName = "delete_template_resource_approval_dialog_confirm";
                    $('#delete_template_resource_approval_dialog_confirm').html(msg);
                    displayCrudConfirmationDialog(jsonData, dialogName);
                }
                else {
                    deleteConfirmationDialog(jsonData);
                }
            }
            else {
                confirmBeforeDeleteUnlinkingResource(data.infoMsg, "Delete");
            }
        }
    });
}

function checkIfResourcesCanStillBeLinkedOnUnlink() {
    $.ajax({
        url: "rest/appointment/checkIfResourcesLinkableOnDeleteUnlink?templateResourceId=" + templateResourceId,
        dataType: 'json',
        success: function (data) {
            if (data.result) {
                if (data.errorMsg == "2") {
                    confirmBeforeDeleteUnlinkingResource(data.infoMsg, "Continue")
                }
                else {
                    if (approvedTemplate == "Approved") {
                        displayCrudConfirmationDialog();
                    }
                    else {
                        unlinkIndividualConfirmation();
                    }
                }
            }
            else {
                confirmBeforeDeleteUnlinkingResource(data.infoMsg, "Continue");
            }
        }
    });
}

function copyTemplateResourceConfirmDialog(event) {
    $.blockUI({fadeIn: 0});
    $('.eventClickActions').remove();
    crudResourceClick("copy_template_resource");
}

function openLinkResourcesDialog(isFloatableResource) {
    isLinkingFloat = isFloatableResource;
    $("#link_template_resources").dialog({
        modal: true,
        height: 500,
        width: 900,
        resizable: false,
        close: function () {
            $("#link_resource_save").css({display: 'none'});
        }
    });

    var url = "rest/appointment/getGanttInfo/candidateFloatables?visit=" + app_selectedVisit.id + "&templateResource=" + templateResourceId;
    isLinkingFloat ? url : url = "rest/appointment/getGanttInfo/candidateFlexibles?visit=" + app_selectedVisit.id + "&templateResourceId=" + templateResourceId;
    $.ajax({
        url: url,
        dataType: 'json',
        success: function (data) {
            var responseData = data.acceptableGroupies;
            createLinkResourcesTable(responseData);
        }
    });
}

function createLinkResourcesTable(responseData) {
    var iteration = 0;
    var displayResourceData = templateResourceObj.resourceName
        + " (" + templateResourceObj.displayStart + " - " + templateResourceObj.displayEnd + ") ";

    var displayText = isLinkingFloat ? "(select one)" : "(select up to two)";
    var header_table =
        "<p> Link " + displayResourceData + " to the following checked resources " + displayText + " : </p> " +
        " <table id='linkResources' rules='cols' width='100%' border='0' cellspacing='0'>" +
        "  <thead> <tr>" +
        "   <th width='7%'  style='padding: 5px'>Select</th> " +
        "   <th width='34%' style='padding: 5px'><strong>Resource Name</strong></th> " +
        "   <th width='9%'  style='padding: 5px'><strong>Resource Type</strong></th>" +
        "   <th width='25%' style='padding: 5px'><strong>Resource Start Time</strong></th>" +
        "   <th width='25%' style='padding: 5px'><strong>Resource End Time</strong></th>" +
        "  </tr> </thead> <table>";

    $('#linkResourceHeaderData').html(header_table);

    var noResourcesMsg = "No valid resources available to link.";
    var out = " <table id='linkResources' class='linkResourceTableClass'> <tbody>";

    $.each(responseData, function (key, val) {
        $("#link_resource_save").css({display: 'inline-block'});
        var trId = val.id;
        out += ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr> ");
        var startTime = "Day " + (daysBetween(templateResourceOriginDate, val.resourceStartTime) + 1) + " " + showTime(val.resourceStartTime);
        var endTime = "Day " + (daysBetween(templateResourceOriginDate, val.resourceEndTime) + 1) + " " + showTime(val.resourceEndTime);
        out +=
            "   <td width='7%' style='padding-left: 2%;'> " +
            " <input type='checkbox' class='form-checkbox' checked " +
            "  value=" + trId + "/> " +
            "   </td>" +
            "   <td width='34%' align='left' valign='top' id='" + trId + "'>" + val.resourceName + "</td>" +
            "   <td width='9%'  align='left' valign='top'>" + val.resourceType + "   </td>" +
            "   <td width='25%' align='left' valign='top'>" + startTime + "   </td>" +
            "   <td width='25%' align='left' valign='top'>" + endTime + "   </td>" +
            " </tr>";
        iteration++;
    });

    out += "</tbody> </table>";

    $('#linkResourceData').html(responseData.length > 0 ? out : noResourcesMsg);
}

function cancelLinkTemplateResourceClick() {
    $("#link_template_resources").dialog("close");
}

function linkTemplateResourceConfirmDialog() {
    var linkResourcesId = [];

    $('#linkResourceData input[type=checkbox]:checked').each(function () {

        var row = $(this).parent().parent();
        var rowCells = row.find('td');
        var i = 0;
        rowCells.each(function () {
            if (i % 4 == 1) {
                linkResourcesId.push($(this)[0].id);
            }
            i++;
        });
    });

    var selectedResourcesLength = linkResourcesId.length;
    if (selectedResourcesLength == 0) {
        util_showMainMessage("Please select at least one resource to link.");
        return;
    }
    else if (isLinkingFloat && selectedResourcesLength > 1) {
        util_showMainMessage("A maximum of two resources can be linked in a float group.");
        return;
    }
    else if (!isLinkingFloat && selectedResourcesLength > 2) {
        util_showMainMessage("A maximum of three resources can be linked in a flex group.");
        return;
    }

    linkResourcesId.push(templateResourceId);

    var jsonData = JSON.stringify({
        linkResources: linkResourcesId
    });
    actionType = "link_template_resource";
    if (approvedTemplate == "Approved") {
        displayCrudConfirmationDialog(jsonData, "");
    }
    else {
        linkTemplateResourcesConfirmation(jsonData);
    }

}

function linkTemplateResourcesConfirmation(jsonData) {
    $.post("rest/appointment/linkResources", {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);
        if (parsedData.result) {
            actionType = "";
            $("#link_template_resources").dialog("close");
            util_showMainMessage("Linking Resources Successful.");
            approvedTemplate = "Not Approved";
            setTimeout(function () {
                reloadTemplateResourcesData();
            }, 1000);
        }
        else {
            util_showMainMessage(parsedData.errorMsg);
        }
    });
}

function unlinkIndividualResource() {
    actionType = "unlink_template_resource";
    checkIfResourcesCanStillBeLinkedOnUnlink();
}

function reloadTemplateResourcesData() {
    setTemplateApprovalStatus();
    daySelected = $(".pageInput").val();
    $(".pageInput").val(daySelected);
    var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
    timelinePagination(pageDate);
}

function postLoadDataOnIndividualUnlink() {
    actionType = "";
    util_showMainMessage("UnLinking Resource(s) Successful.");
    approvedTemplate = "Not Approved";
    setTimeout(function () {
        reloadTemplateResourcesData();
    }, 1000);
}

function confirmBeforeDeleteUnlinkingResource(groupId, buttonName) {
    var dialog_buttons = {};
    dialog_buttons[buttonName] = function () {
        unlinkGroupResourcesConfirmation(groupId, "unlink-individual-template-resource-dialog-confirm");
        $(".ui-dialog-content").dialog("close");
    };
    dialog_buttons['Cancel'] = function () {
        $(this).dialog('close');
    };

    $("#unlink-delete-individual-template-resource-dialog-confirm").dialog({
        resizable: false,
        height: 250,
        width: 535,
        modal: true,
        open: function () {
            var msg = "";
            if (approvedTemplate == "Approved") {
                msg += "<p>Editing this template will change the approval status.</p>";
            }
            else {
                if (actionType == "unlink_template_resource") {
                    msg += "<p>Are you sure you want to unlink this resource? </p>";
                }
            }
            if (actionType == "unlink_template_resource") {
                msg += "If you continue, all resources in this group will become unlinked.";
            }
            else {
                msg += "Are you sure you want to delete this resource? <br><br> Note: The remaining resource(s) in this group will become unlinked.";
            }
            $("#individualUnlinkDeleteMessage").html(msg);
        },
        buttons: dialog_buttons
    });
}

function unlinkIndividualConfirmation() {
    $.ajax({
        url: "rest/appointment/unlinkOneResource?templateResourceId=" + templateResourceId,
        dataType: 'json',
        success: function (data) {
            if (!data.result) {
                confirmBeforeDeleteUnlinkingResource(data.infoMsg, "Continue");
            }
            else {
                postLoadDataOnIndividualUnlink();
            }
        }
    });
}

function toggleGanttView(obj, ganttId, viewParam) {
    var toggleTitle = "";
    if (obj.title == "Collapse") {
        $('#no_' + viewParam + '_resources').css({display: 'none'});
        $('#' + ganttId).css({display: 'none'});
        toggleTitle = "Expand";
        obj.title = toggleTitle;
        document.getElementById(ganttId + "Img").src = "css/images/gantt/expand_icon.png";
    }
    else {
        toggleTitle = "Collapse";
        obj.title = toggleTitle;
        document.getElementById(ganttId + "Img").src = "css/images/gantt/collapse_icon.jpg";
        daySelected = $(".pageInput").val();
        $('#' + ganttId).css({display: 'block'});
        $('#' + ganttId).fullCalendar('clientEvents').length > 0 ?
            $('#no_' + viewParam + '_resources').css({display: 'none'}) :
            $('#no_' + viewParam + '_resources').css({display: 'block'});
    }
}

function buildFromCopyDaySelectOptions() {
    var html = [];
    for (var i = 1, len = totalDays; i <= len; i++) {
        html[html.length] = "<option value='" + i + "'>" + 'Day ' + i + "</option>";
    }
    $("#fromCopyDaySelect").html(html);
}

function copyDay() {
    buildFromCopyDaySelectOptions();
    $("#fromCopyDaySelect").val(daySelected);
    buildCopyToMultiSelectOptions();
    $('#toCopyDaySelect').multipleSelect('disable');
    fromCopyDayChangeClick();
    $("#copy-day-template-resource-dialog").css({display: 'block'});
    $("#copy-day-template-resource-dialog").dialog({
        resizable: false,
        height: 325,
        width: 510,
        modal: true,
        close: function () {
            $('.formValidationRequired').css({visibility: "hidden"});
        },
        buttons: {
            "Copy": function () {
                actionType = "copy_day_resources";
                $('.formValidationRequired').css({visibility: "hidden"});
                var currentDay = $.trim($("#fromCopyDaySelect").val());
                $.ajax({
                    url: "rest/appointment/isDayCopyable?visitId=" + app_selectedVisit.id
                    + "&currentDay=" + currentDay,
                    dataType: 'json',
                    success: function (data) {
                        if (data) {
                            var selectedCopyToValues = $("#toCopyDaySelect").multipleSelect('getSelects').join(",");
                            if (selectedCopyToValues.length == 0) {
                                var confirmationMessage = "Please select at least one destination day.";
                                showError('#copy_day_formValidation', confirmationMessage);
                                return;
                            }
                            else {
                                if (approvedTemplate == "Approved") {
                                    var jsonData = [];
                                    displayCrudConfirmationDialog(jsonData, "");
                                }
                                else {
                                    copyDayConfirmation();
                                }
                            }
                        }
                        else {
                            var confirmationMessage = "Selected copy day has no single day resources that can be copied.";
                            showError('#copy_day_formValidation', confirmationMessage);
                            return;
                        }
                    }
                });
            },
            "Cancel": function () {
                $(this).dialog("close");
            }
        }
    });
}

function copyDayConfirmation() {
    var currentDay = $.trim($("#fromCopyDaySelect").val());
    var selectedCopyToValues = $("#toCopyDaySelect").multipleSelect('getSelects').join(",");
    $.ajax({
        url: "rest/appointment/copyDayInpatientResources?visitId=" + app_selectedVisit.id
        + "&currentDay=" + currentDay + "&targetDaysCommaString=" + selectedCopyToValues,
        dataType: 'json',
        success: function (data) {
            actionType = "";
            approvedTemplate = "Not Approved";
            util_showMainMessage("Resource(s) successfully copied");
            $("#copy-day-template-resource-dialog").dialog("close");
            setTimeout(function () {
                reloadTemplateResourcesData();
            }, 1000);
        }
    });
}

function fromCopyDayChangeClick() {
    var selectedFromCopyDayVal = $("#fromCopyDaySelect").val();
    selectedFromCopyDayVal == "" ? $('#toCopyDaySelect').multipleSelect('disable') : $('#toCopyDaySelect').multipleSelect('enable');
    $(".ms-parent .ms-drop ul").remove();
    var $select = $('#toCopyDaySelect');
    $('#toCopyDaySelect option').each(function () {
        var val = $(this).attr('value');
        if (val > totalDays) {
            $("#toCopyDaySelect option[value='" + val + "']").remove();
        }
    });
    for (var i = 1, len = totalDays; i <= len; i++) {
        $("#toCopyDaySelect option[value='" + i + "']").remove();
        if (selectedFromCopyDayVal != i) {
            var value = $.trim(selectedFromCopyDayVal),
                $opt = $("<option />", {
                    value: i,
                    text: 'Day ' + i
                });

            $select.append($opt);
        }
    }
    $select.multipleSelect("refresh");
}

function buildCopyToMultiSelectOptions() {
    $('#toCopyDaySelect').multipleSelect({
        placeholder: "choose",
        width: "80%",
        allSelected: "All Selected",
        maxHeight: 150,
        minimumCountSelected: 3
    });
    $('#toCopyDaySelect').multipleSelect('setSelects', []);
}

function unlinkGroupResources(groupId, groupResourceString) {
    actionType = "unlink_group_template_resource";
    if (approvedTemplate == "Approved") {
        $("#unlink-template-resource-group-approval-dialog-confirm").css({display: 'inline-block'});
        $('.unlinkGroupedResources').html(groupResourceString.replace(/;/g, "<br>"));
        displayCrudConfirmationDialog(groupId, "unlink-template-resource-group-approval-dialog-confirm");
    } else {
        $("#unlink-template-resource-group-dialog-confirm").css({display: 'inline-block'});
        $('.unlinkGroupedResources').html(groupResourceString.replace(/;/g, "<br>"));
        $("#unlink-template-resource-group-dialog-confirm").dialog({
            resizable: false,
            height: 250,
            width: 600,
            modal: true,
            buttons: {
                "Unlink": function () {
                    unlinkGroupResourcesConfirmation(groupId, "unlink-template-resource-group-dialog-confirm");
                },
                "Cancel": function () {
                    $(this).dialog("close");
                    return;
                }
            }
        });
    }
}

function unlinkGroupResourcesConfirmation(groupId, dialogName) {
    $.ajax({
        url: "rest/appointment/unlinkGroup?groupId=" + groupId,
        dataType: 'json',
        success: function (data) {
            if (actionType != "delete_template_resource") {
                actionType = "";
                $("#" + dialogName).dialog("close");
                approvedTemplate = "Not Approved";
                reloadTemplateResourcesData();
            }
            else if (actionType == "delete_template_resource") {
                var jsonData = JSON.stringify({
                    id: templateResourceId,
                    visitTemplate: app_selectedVisit.id
                });
                postCrudTemplateResources(jsonData);
            }
        }
    });
}

function sortTemplateResources(obj) {
    destroyTimelines();
    templateResourcesSortBy = obj.value;
    setSortTemplateResourceDropDownValues();
    var pageDate = templateResourceOriginDate.addDays(daySelected - 1);
    loadTimelineEvents(daySelected, pageDate, templateResourcesSortBy);
}

function setSortTemplateResourceDropDownValues() {
    document.getElementById("topSortTemplateResourcesDropDown").value = templateResourcesSortBy;
    document.getElementById("bottomSortTemplateResourcesDropDown").value = templateResourcesSortBy;
    $("select.fix-me")
        .each(function () {
            $(this).data("origWidth", $(this).outerWidth()); // IE 8 will take padding on selects
            $(this).css("width", "auto");
        });
}