/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var WidgetUtil = function () {
};

WidgetUtil.createCombobox = function (element, options) {
    if (options === undefined) {
        options = {};
    }

    if (options.value === undefined) {
        options.value = '';
    }

    if (options.width === undefined) {
        options.width = 205;
    }

    if (options.height === undefined) {
        options.height = 30;
    }

    if (options.prompt === undefined) {
        options.prompt = "Choose or Type Ahead";
    }

    if (options.limitToList === undefined) {
        options.limitToList = true;
    }

    $(element).combobox(options);

    $(".combobox-item:empty").addClass("firstComboItem");

    return $(element);
};

WidgetUtil.createDatepicker = function(element, options, unmaskDate)
{
    if (options === undefined) {
        options = {};
    }

    if (options.buttonImage === undefined)
    {
        options.buttonImage = "css/images/calendar_icn_transparent.png";
    }

    options.changeMonth = true;
    options.changeYear = true;
    options.numberOfMonths =  3;
    options.buttonText = "Select a date";
    options.showOn = "button";
    options.buttonImageOnly = true;

    $(element).datepicker(options);

    if(!unmaskDate)
    {
        $(element).mask("99/99/9999");

        var placeholder = $(element).attr("placeholder");

        //add a placeholder only if there isn't already one
        if(placeholder === undefined)
        {
            $(element).attr("placeholder", "MM/DD/YYYY");
        }
    }

    return $(element);
};

WidgetUtil.createDatetimepicker = function(element, options) {

    // DO NOT forget ot set options.amNames and options.pmNames to [] if you want
    // to disable 'PM' and 'AM' characters in the manual entry field.
    // I did not want to do it systematically because sublocation closures might need
    // AM/PM manual input, whereas temp adjustments need AM/PM disabled

    if (options === undefined) {
        options = {};
    }

    if (options.buttonImage === undefined) {
        options.buttonImage = "css/images/calendar_icn_transparent.png";
    }

    if (options.timeFormat === undefined) {
        options.timeFormat = "hh:mm tt";
    }

    options.numberOfMonths = 3;
    options.showButtonPanel = true;
    options.showOn = "button";
    options.buttonImageOnly = true;
    options.controlType = 'select';
    options.stepMinute = 15;
    options.minuteMax = 59;

    $(element).datetimepicker(options);

};
