/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var eventVisitType;
var relativeTime;
var billableVal;
var appt_list_view;
var omitted_activities;
var vary_duration;
var currDate = '';
var selectedEndDate = showDate(new Date());
var no_appointments_found;
var initialSearchStartDate = null;
var initialSearchEndDate = null;
var initialSearchStartTime = null;
var initialSearchEndTime = null;
var appt_selectedStudyName;
var appt_selectedStudyLocalId;
var appt_selectedStudyInvestigatorName;
var searchAppointmentWorkflow;
var appt_selectedVisitName;
var appt_selectedVisitType;
var appt_selectedVisitRelative;
var appt_selectedVisitDuration;
var appt_selectedSubjectName;
var appt_selectedMrn;
var searchmrn;
var searchname;
var searchbirthdate;
var filteredString;
var erroMsgFlag = true;

var editSelectedStudy;
var editSelectedVisit;
var editSelectedSubjectMrnId;
var appt_editSelectedStudyName;
var appt_editSelectedStudyInvestigatorName;
var appt_editSelectedVisitName;
var appt_editSelectedVisitType;
var appt_editSelectedVisitDuration;
var appt_editSelectedSubjectName;

var editSearch = false;

var startDateVal;
var endDateVal;

$(document).ready(function () {
    getSchedulingOptionsStaticList(function () {

        var result = buildSubLocTabs("subLocTop");

        $("#apptSublocationListTop").html(result.html);
        $("#apptSublocationListTop").tabs({
            active: result.defaultTabIndex,
            activate: function( event, ui ) {
                var activeTab = $(this).tabs("option", "active");

                var activeBottomTab = $("#apptSublocationListBottom").tabs("option", "active");
                if( activeBottomTab !== activeTab)
                {
                    $("#apptSublocationListBottom").tabs("option", "active", activeTab);

                    var sublocationLabel = $(ui.newTab).attr("data-sublocation-label");
                    getCalendarBySublocation(sublocationLabel);
                }
            }
        });
        
        result = buildSubLocTabs("subLocBtm");

        $("#apptSublocationListBottom").html(result.html);
        $("#apptSublocationListBottom").tabs({
            active: result.defaultTabIndex,
            activate: function( event, ui ) {
                var activeTab = $(this).tabs("option", "active");

                var activeTopTab = $("#apptSublocationListTop").tabs("option", "active");

                if (activeTopTab !== activeTab) {
                    $("#apptSublocationListTop").tabs("option", "active", activeTab);
                    
                    var sublocationLabel = $(ui.newTab).attr("data-sublocation-label");
                    getCalendarBySublocation(sublocationLabel)
                }
            }
        });
    });
    commonData();
});

function adjustSubjectChoiceVisibility(subjectNaCheckbox, chooseElementHash) {

    if (subjectNaCheckbox != null && chooseElementHash != null) {
        var display = subjectNaCheckbox.checked ? "none" : "block";

        $(chooseElementHash).css({display: display});
    }
}
function searchNewAppointment() {
    if (user.institutionRole.id == STUDY_STAFF) {
        $('#appt_calendar').fullCalendar('render');
    }
    $('#appt_resetButton').css({display: "none"});
    appt_initWizardForm();
}

function closeBookedResourceClick() {
    $("#appt_bookedResource_delete_dialog").dialog("close");
}

function closeCheckOutClick() {
    eventid = null;
    studydetailname = null;
    subjectdetailname = null;
    visitdetailname = null;
    detailVisitTime = null;
    studyPIdetailname = null;
    sessionStorage.setItem("is_navigated", false);
    $("#appt_wizard_checkedin_visit_details").dialog("close");
}

function closeCheckOutDetailsClick() {
    eventid = null;
    studydetailname = null;
    subjectdetailname = null;
    visitdetailname = null;
    detailVisitTime = null;
    studyPIdetailname = null;
    sessionStorage.setItem("is_navigated", false);
    $("#appt_wizard_checkedout_visit_details").dialog("close");
}

function closeCancelDetailsClick() {
    eventid = null;
    studydetailname = null;
    subjectdetailname = null;
    visitdetailname = null;
    detailVisitTime = null;
    studyPIdetailname = null;
    sessionStorage.setItem("is_navigated", false);
    $("#appt_wizard_cancelled_visit_details").dialog("close");
}

function closeScheduleDetailsClick() {
    eventid = null;
    studydetailname = null;
    subjectdetailname = null;
    visitdetailname = null;
    detailVisitTime = null;
    studyPIdetailname = null;
    sessionStorage.setItem("is_navigated", false);
    $("#appt_wizard_scheduled_visit_details").dialog("close");
    window.location.hash = '';
}

function changeCancellationReasonsClick() {
    if ($.trim($("#wizard_cancellationReasons").val()) != "") {
        document.getElementById("appt_wizard_checkin").style.display = "none";
    }
    else {
        document.getElementById("appt_wizard_checkin").style.display = "inline";
    }
}

function saveBookedVisitCommentClick() {
    commentDialog(true);
}

function saveBookedVisitCommentClick1() {
    commentDialog(false);
}

function commentDialog(first) {
    DialogsUtil.showConfirmationDialog("#comment-dialog-confirm", {
        buttons: {
            "Yes": function () {
                if (first) {
                    saveComment();
                }
                else {
                    saveComment1();
                }
                $(this).dialog("close");
            },
            "No": function () {
                $(this).dialog("close");
            }
        }
    });
}

function cancellationDialog() {
    DialogsUtil.showConfirmationDialog("#cancellation-dialog-confirm", {
        buttons: {
            "Yes": function () {
                $(this).dialog("close");
                cancelAppointment();
            },
            "No": function () {
                $(this).dialog("close");
            }
        }
    });
}

function checkoutDialog() {
    DialogsUtil.showConfirmationDialog("#checkout-dialog-confirm", {
        buttons: {
            "Yes": function () {
                $(this).dialog("close");
                checkoutAppointment();
            },
            "No": function () {
                $(this).dialog("close");
            }
        }
    });
}

function cancelAppointmentClick() {
    if ($.trim($("#wizard_cancellationReasons").val()).length < 1) {
        util_showMainMessage("Please select a Cancellation Reason");
        return;
    }
    else {
        cancellationDialog();
    }
}

function checkOutVisitClick() {
    var activities_yes = document.getElementById("check_visit_activities_yes").checked;
    var activities_no = document.getElementById("check_visit_activities_no").checked;
    var varyVisitDuration_yes = document.getElementById("check_visit_duration_yes").checked;
    var varyVisitDuration_no = document.getElementById("check_visit_duration_no").checked;
    if (activities_yes == false && activities_no == false) {
        util_showMainMessage("Please select the required fields.");
        return;
    }

    if (varyVisitDuration_yes == false && varyVisitDuration_no == false) {
        util_showMainMessage("Please select the required fields.");
        return;
    }
    if ($.trim($("#wizard_checkoutReasons").val()).length < 1) {
        util_showMainMessage("Please select a Check-Out Reason");
        return;
    }
    else {
        checkoutDialog();
    }
}

function rescheduleAppointmentClick() {
    $("#booked_visit_radio").prop("checked", true);
    $("#appt_reschedule_dialog").dialog({modal: true, height: 300, width: 850});
    reschedule_widgets();
    $('#rescheduleWizardButtons input').css({width: "75px"});
    $("#reschedule_start_date").datepicker('setDate', new Date());
    $('#reschedule_start_time').css({display: 'inline'});
    if ((eventVisitType == 4 || eventVisitType == 5 || eventVisitType == 6)
        && (relativeTime == "false")) {
        $('#reschedule_start_time').css({display: 'none'});
    } else {
        $("#reschedule_start_time").datepicker('setTime', '07:00 AM');
    }
}

function cancelRescheduleAppointmentClick() {
    $('#wizard_rescheduleReasons').val('');
    $("#appt_reschedule_dialog").dialog("close");
}

function crudRescheduleAppointmentClick() {
    $.blockUI();
    var checkedVal = $('input[name=reschedule_appt_selected]:checked').val();
    var rescheduleFrom = true;
    if (checkedVal == 'booked_vis') {
        rescheduleFrom = false;
    }
    appt_rescheduleAppointment(rescheduleFrom);
}

function overbookCheckBatchViewClick() {
    $('#renderOverbook').css({display: "block"});
    resetUI();
    loadOverbookedResourcesData(currentPage, app_selectedBookedVisit.id);
}

//Check for overbooked Resources from appointment Screen
function overbookCheckClick() {
    resetUI();
    loadOverbookedResourcesData(currentPage, eventid);
    $("#appt_overbook_check_dialog").dialog({modal: true, height: 460, width: 1000});
}

function closeOverbookCheckClick() {
    $("#appt_overbook_check_dialog").dialog("close");
}

function cancelReasonChangeClick() {
    if ($.trim($("#cancellationReasons").val()) != "") {
        $('#checkin_date').val('');
        $("#checkin_time").timepicker().val('');
        $('#checkinRender').css({display: "none"});
    }
    else {
        if (user.institutionRole.id != STUDY_STAFF) {
            $('#checkinRender').css({display: "block"});
        }
    }
}

function checkoutReasonChangeClick() {
    $("#cancel_date").val('');
    $('#cancel_time').val('');
}

function apptBatchData() {
    appointment_viewStack('appointment_form_screen');
    appointment_setFormMode('view');
    $('#renderOverbook').css({display: "none"});
    $('#checkoutReason').val('');
    $('#cancellationReasons').val('');
}

function appt_initWizardForm() {
    editSearch = false;
    $('#apptStudyData').html("");
    sessionStorage.setItem("filteredString", '');
    selectedStudy = null;
    selectedVisit = null;
    selectedStudySubject = null;
    initial_load = true;
    resetUI();
    $("#appt_wizard_screen").dialog({modal: true, close: dialogCloseFunction, height: 750, width: 720});
    $('#appt_wizard_screen').css({display: "block"});
    appt_wizard_viewStack('appt_wizard_form1');
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    loadApptStudyData(currentPage);
}

function apptFilterStudyClick(value) {
    if (value == 'Filter') {
        if ($.trim($("#appt_studyFilterText").val()) == '') {
            util_showMainMessage("Please enter a filter value.");
            return;
        }

        filteredString = $.trim($("#appt_studyFilterText").val());
        sessionStorage.setItem("filteredString", filteredString);
        $('#appt_studyFilterButton').attr("value", "Reset");
    } else {
        filteredString = '';
        sessionStorage.setItem("filteredString", filteredString);
        $("#appt_studyFilterText").val('');
        $('#appt_studyFilterButton').attr("value", "Filter");
    }
    resetUI();
    currentPage = 1;
    initial_load = true;
    loadApptStudyData(currentPage);
}

function apptFilterVisitClick(value) {
    if (value == 'Filter') {
        if ($.trim($("#appt_visitFilterText").val()) == '') {
            util_showMainMessage("Please enter a filter value.");
            return;
        }
        filteredString = $.trim($("#appt_visitFilterText").val());
        sessionStorage.setItem("filteredString", filteredString);
        $('#appt_visitFilterButton').attr("value", "Reset");
    } else {
        filteredString = '';
        sessionStorage.setItem("filteredString", filteredString);
        $("#appt_visitFilterText").val('');
        $('#appt_visitFilterButton').attr("value", "Filter");
    }
    resetUI();
    currentPage = 1;
    initial_load = true;
    loadApptVisitData(currentPage);
}

function apptFilterSubjectClick(value) {
    if (value == 'Filter') {
        if ($.trim($("#appt_subjectFilterText").val()) == '') {
            util_showMainMessage("Please enter a filter value.");
            return;
        }
        filteredString = $.trim($("#appt_subjectFilterText").val());
        sessionStorage.setItem("filteredString", filteredString);
        $('#appt_subjectFilterButton').attr("value", "Reset");
    } else {
        filteredString = '';
        sessionStorage.setItem("filteredString", filteredString);
        $("#appt_subjectFilterText").val('');
        $('#appt_subjectFilterButton').attr("value", "Filter");
    }
    resetUI();
    currentPage = 1;
    initial_load = true;
    loadApptSubjectData(currentPage);
}

function switchSubjectFilterSubjectClick(value) {
    if (value == 'Filter') {
        if ($.trim($("#switchSubject_subjectFilterText").val()) == '') {
            util_showMainMessage("Please enter a filter value.");
            return;
        }
        filteredString = $.trim($("#switchSubject_subjectFilterText").val());
        sessionStorage.setItem("filteredString", filteredString);
        $('#switchSubject_subjectFilterButton').attr("value", "Reset");
    } else {
        filteredString = '';
        sessionStorage.setItem("filteredString", filteredString);
        $("#switchSubject_subjectFilterText").val('');
        $('#switchSubject_subjectFilterButton').attr("value", "Filter");
    }
    resetUI();
    currentPage = 1;
    initial_load = true;
    loadSwitchSubjectData(currentPage);
}

//Add study Subject from appointment Screen
function apptAddStudySubjectClick() {
    window.location.href = "../subject_search.html";
}

//////Select Study Screen///////////////////////////////
var sortByApptStudyName = "s.name";
var sortByApptLocalId = "s.localId";
function loadApptStudyData(currentPage) {
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 10;
    }

    var filterString = $.trim($("#appt_studyFilterText").val());
    if (filterString == '') {
        var str = sessionStorage.getItem("filteredString");
        filterString = str;
    }

    $.getJSON("rest/study/getOpenStudies?filterString=" + filterString +
        "&page=" + (currentPage != undefined ? currentPage : 1)
        + "&maxResults=" + (max_results != undefined ? max_results : 10)
        + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC")
        + "&sortBy=" + (sortBy != undefined ? sortBy : sortByApptLocalId), function (data) {
        var iteration = 0;
        var sort_header;
        var localID_header1 = 'sortable';
        var studyName_header2 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByApptLocalId) {
            localID_header1 = sort_header;
        } else if (sortBy == sortByApptStudyName) {
            studyName_header2 = sort_header;
        }

        $('#apptStudyHeaderData').html("<table id='apptStudyHeaderTable'> <thead> <tr>" +
            "   <th width='25%' class= " + localID_header1 + " onclick='sortingFunction(sortByApptLocalId)'>Local ID</th>" +
            "   <th width='75%' class= " + studyName_header2 + " onclick='sortingFunction(sortByApptStudyName)'>Name</th>" +
            "  </tr> </thead> </table>");

        var out = " <table id='apptStudyTable'><tbody>";
        $.each(data.studys, function (key, val) {
            totalData = data.totalCount;
            out += loadAndRenderTemplate("#studyRow_template", val);
            iteration++;
        });

        out += "</tbody> </table>";

        setupTable(out, $('#apptStudyData'), currentPage, totalData, $("#appt_studyFilterText"));
    });
}

//////Select Visit Screen///////////////////////////////////////
var sortByVisitName = "v.name";
function loadApptVisitData(currentPage) {
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 10;
    }

    var filterString = $.trim($("#appt_visitFilterText").val());

    if (filterString == '') {
        filterString = sessionStorage.getItem("filteredString");
    }

    $.getJSON("rest/appointment/getStudyVisits?study=" + appt_selectedStudy + "&approved=true&filterString=" + filterString + "&page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 10) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByVisitName),
        function (data) {
            var iteration = 0;
            var sort_header;
            var sortByVisitName_header = 'sortable';

            if (orderBy == 'ASC') {
                sort_header = 'sorting_asc';
            }
            else if (orderBy == 'DESC') {
                sort_header = 'sorting_desc';
            }

            if (sortBy == undefined || sortBy == sortByVisitName) {
                sortByVisitName_header = sort_header;
            }

            $('#apptVisitHeaderData').html("<table id='apptVisitHeaderTable' class='apptVisitHeaderTable'> <thead> <tr>" +
                "   <th class= " + sortByVisitName_header + " onclick='sortingFunction(sortByVisitName)'>Name</th>" +
                "  </tr> </thead> </table>");

            appt_selectedStudy = data.studyId;
            appt_selectedStudyName = data.studyName;
            appt_selectedStudyLocalId = data.localId;
            appt_selectedStudyInvestigatorName = data.investigatorFullName;
            $('.dialog_study_name').text(appt_selectedStudyName);
            $('.dialog_study_pi').text(appt_selectedStudyInvestigatorName);
            var out = " <table id='apptVisitTable'>";
            out += "<tbody>";
            $.each(data.visitTemplate1s, function (key, val) {
                totalData = data.totalCount;
                var tdClass = 'selectClass' + val.id;
                out += "<tr onclick='getVisitSelectedRowId(" + val.id + "," + val.visitTypeId + "," + val.visitDuration + "," + val.relativeTime + ")'> ";
                out += " <td id=" + tdClass + " class=" + tdClass + ">" + val.name + "</td>" +
                    " </tr>";
                iteration++;
            });

            out += "</tbody> </table>";

            setupTable(out, $('#apptVisitData'), currentPage, totalData, $("#appt_visitFilterText"));
        });
}

//////Select Study Subject Screen///////////////////////////////////////
var sortByApptStudySubjectMRN = "mrn";
var sortByApptStudySubjectLastName = "lastName";
var sortByApptStudySubjectFirstName = "firstName";

var studySubjectsTableElementId = "switchSubject_StudySubjectData.datagridNew";

function loadApptSubjectData(currentPage) {
    loadSubjectData(currentPage, true, appt_selectedStudy, $('#apptStudySubjectData'));
}

function loadSwitchSubjectData(currentPage) {
    loadSubjectData(currentPage, true, appt_selectedStudy, $('#switchSubject_StudySubjectData'));
}

function loadApptSubjectDataIntoSpecificElement(currentPage, element) {
    loadSubjectData(currentPage, true, appt_selectedStudy, element);
}

//////Display Template Resources on search appointment wizard///////////////////////////////
var sortByTemplateResourceName = "r.name";
var sortByTemplateResourceStartTime = "tr.startDate";
var sortByTemplateResourceEndTime = "tr.endDate";

function loadApptTemplateResourceData(currentPage) {
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 10;
    }

    $.getJSON("rest/appointment/getSearchVisitResource?visit=" + appt_selectedVisit + "&page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 10) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByTemplateResourceStartTime), function (data) {
        var iteration = 0;
        var sort_header;
        var name_header1 = 'sortable';
        var startTime_header2 = 'sortable';
        var endTime_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == sortByTemplateResourceName) {
            name_header1 = sort_header;
        } else if (sortBy == undefined || sortBy == sortByTemplateResourceStartTime) {
            startTime_header2 = sort_header;
        } else if (sortBy == sortByTemplateResourceEndTime) {
            endTime_header3 = sort_header;
        }

        $('#apptTemplateResourceHeaderData').html("<table id='apptTemplateResourceHeaderData'> <thead> <tr>" +
            "   <th width='40%' class= " + name_header1 + " onclick='sortingFunction(sortByTemplateResourceName)'>Resource Name</th>" +
            "   <th width='30%' class= " + startTime_header2 + " onclick='sortingFunction(sortByTemplateResourceStartTime)'>Start Time</th>" +
            "   <th width='30%' class= " + endTime_header3 + " onclick='sortingFunction(sortByTemplateResourceEndTime)'>End Time</th>" +
            "  </tr> </thead> </table>");


        var out = " <table id='apptTemplateResourceTable'>";
        $.each(data.templateResource1s, function (key, val) {
            totalData = data.totalCount;
            var startTime = "";
            var month = dateFormat(val.startTime, 'm');
            var day = dateFormat(val.startTime, 'd');
            var time = dateFormat(val.startTime, 'HH:MM');
            var totalDays = Math.floor(day) + 29;
            if (month > 2) {
                startTime = '(Day: ' + totalDays + ') ' + time;
            }
            else {
                startTime = '(Day: ' + day + ') ' + time;
            }
            var endTime = "";
            var month = dateFormat(val.endTime, 'm');
            var day = dateFormat(val.endTime, 'd');
            var time = dateFormat(val.endTime, 'HH:MM');
            var totalDays = Math.floor(day) + 29;
            if (month > 2) {
                endTime = '(Day: ' + totalDays + ') ' + time;
            }
            else {
                endTime = '(Day: ' + day + ') ' + time;
            }
            /* Remove the altRow here? TBD TODO */
            out += ((iteration % 2 == 1) ? "<tbody> <tr class='altRow'>" : "<tr>");
            out += " <td width='40%'>" + val.resourceName + "</td>" +
                " <td width='30%'>" + startTime + "</td>" +
                " <td width='30%'>" + endTime + "</td>" +
                " </tr>";
            iteration++;
        });

        out += " </tbody> </table>";

        setupTable(out, $('#apptTemplateResourceData'), currentPage, totalData);
    });
}

////Display Appointment List View //////////////////////////////////////////////////////////////
function createApptDatePicker() {
    $('#separator').css({display: "none"});
    $('#apptEndGoToDate').css({display: "none"});
    $(".apptDateRangeContainer").css('width', 300);
    WidgetUtil.createDatepicker("#apptStartGoToDate", {
        onSelect: function (selectedDate) {
            selectedEndDate = showDate(selectedDate);
            initial_load = true;
            loadAppointmentBookedVisitsList(currentPage, initial_load);
        }
    });
    $("#apptStartGoToDate").datepicker("setDate", new Date());
}

function createApptCalendarDatePicker() {
    $(".apptDateRangeContainer").css('width', 215);
    WidgetUtil.createDatepicker("#appt_study_subject_search_birthdate");

    WidgetUtil.createDatepicker("#apptCalendarGoToDate", {
        onSelect: function (selectedDate) {
            var gotoDate = new Date(selectedDate);
            $("#appt_calendar").fullCalendar('gotoDate', gotoDate);
            $("#apptCalendarGoToDate").datepicker("setDate", gotoDate);
        }
    });

    $("#apptCalendarGoToDate").datepicker("setDate", new Date());
}

function createApptDateRangePicker() {
    $('#separator').css({display: "inline-block"});
    $('#apptEndGoToDate').css({display: "inline-block"});
    $(".apptDateRangeContainer").css('width', 425);
    currDate = selectedEndDate;

    var apptStartChange =  function(selectedDate)
    {
        currDate = showDate(selectedDate);
        $("#apptEndGoToDate").datepicker("option", "minDate", selectedDate);
        selectedEndDate = $('#apptEndGoToDate').datepicker('getDate');
        selectedEndDate.setHours(23, 59, 59, 59);
        initial_load = false;
        currentPage = 1;
        loadAppointmentBookedVisitsList(currentPage, initial_load);
    };

    WidgetUtil.createDatepicker("#apptStartGoToDate", {
        onSelect: function (selectedDate) {
            apptStartChange(selectedDate);
        }
    });
    
    var apptEndChange = function(selectedDate)
    {
        var d = new Date(selectedDate);
        d.setHours(23, 59, 59, 59);
        selectedEndDate = showDateTime(d);
        currDate = $('#apptStartGoToDate').datepicker('getDate');
        initial_load = false;
        currentPage = 1;
        loadAppointmentBookedVisitsList(currentPage, initial_load);
    };

    WidgetUtil.createDatepicker("#apptEndGoToDate", {
        onSelect: function (selectedDate) {
            apptEndChange(selectedDate);    
        }
    });
    $("#apptStartGoToDate").datepicker("setDate", new Date());
    $("#apptEndGoToDate").datepicker("setDate", new Date());
}

var sortByListVisit = "bv.visitTemplate.name";
var sortByListLocalId = "bv.study.localId";
var sortByListCatId = "bv.study.catalystId";
var sortByListStartTime = "bv.scheduledStartTime";
var sortByListEndTime = "bv.scheduledEndTime";
var sortByListIrb = "bv.study.irb";
var sortByListAppointment = "bv.appointmentStatus.name";

function loadAppointmentBookedVisitsList(currentPage, initial) {
    $('#table_loading').css({display: 'block'});
    if (max_results == undefined) {
        max_results = 50;
    }

    totalData = 0;
    var iteration = 0;

    var sort_header;
    var start_header1 = 'sortable';
    var end_header2 = 'sortable';
    var cat_header3 = 'sortable';
    var local_header4 = 'sortable';
    var irb_header5 = 'sortable';
    var visit_header6 = 'sortable';
    var status_header7 = 'sortable';

    if (orderBy == 'ASC' || orderBy == undefined) {
        sort_header = 'sorting_asc';
    }
    else if (orderBy == 'DESC') {
        sort_header = 'sorting_desc';
    }

    if (sortBy == undefined || sortBy == sortByListStartTime) {
        start_header1 = sort_header;
    } else if (sortBy == sortByListEndTime) {
        end_header2 = sort_header;
    } else if (sortBy == sortByListCatId) {
        cat_header3 = sort_header;
    } else if (sortBy == sortByListLocalId) {
        local_header4 = sort_header;
    } else if (sortBy == sortByListIrb) {
        irb_header5 = sort_header;
    } else if (sortBy == sortByListVisit) {
        visit_header6 = sort_header;
    } else if (sortBy == sortByListAppointment) {
        status_header7 = sort_header;
    }

    var out =
        " <table id='homeBookedVisit'>" +
        "  <tr>" +
        "   <td class= " + start_header1 + " onclick='sortingFunction(sortByListStartTime)'><strong>Scheduled Start Time</strong></td> " +
        "   <td class= " + end_header2 + " onclick='sortingFunction(sortByListEndTime)'><strong>Scheduled End Time</strong></td> " +
        "   <td class='not_sortable'><strong>Subject Full Name</strong></td>" +
        "   <td class='not_sortable'><strong>MRN</strong></td>" +
        "   <td class= " + cat_header3 + " onclick='sortingFunction(sortByListCatId)'><strong>Catalyst ID</strong></td>" +
        "   <td class= " + local_header4 + " onclick='sortingFunction(sortByListLocalId)'><strong>Local ID</strong></td>" +
        "   <td class= " + irb_header5 + " onclick='sortingFunction(sortByListIrb)'><strong>IRB Number</strong></td>" +
        "   <td class= " + visit_header6 + " onclick='sortingFunction(sortByListVisit)'><strong>Visit Name</strong></td>" +
        "   <td style='width: 130px;' class= " + status_header7 + " onclick='sortingFunction(sortByListAppointment)'><strong>Appointment Status</strong></td>" +
        "   <td class='not_sortable' style='width: 90px;'><strong>Action</strong></td>" +
        "  </tr> ";
    var search_string = $.trim($("#apptlist_filters_string").val());

    $.getJSON("rest/appointment/getBookedVisitsList?fromDate=" + currDate + "&toDate=" + selectedEndDate + "&initialLoad=" + initial
            + "&page=" + (currentPage != undefined ? currentPage : 1) + "&filterString=" + search_string + "&filterId=" + (selected != undefined ? selected : 0) + "&maxResults=" + (max_results != undefined ? max_results : 50) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByListStartTime), function (data) {
        var startDate2 = null;
        $.each(data, function (key, val) {
            currentPage = val.navigatePage + 1;
            var startDate1 = showDate(val.scheduledStartTime);
            totalData = val.totalCount;
            if (startDate1 != startDate2) {
                out += "<tr id='" + showDate(val.scheduledStartTime) + "'> <td colspan='10' style='font-weight:bolder;'> " + showDate(val.scheduledStartTime) + "</td> </tr>"
            }
            out += "<tr>";
            out += "   <td>" + showDateTime(val.scheduledStartTime) + "</td>" +
                "          <td>" + showDateTime(val.scheduledEndTime) + "</td>" +
                "          <td>" + val.subjectName + "</td>" +
                "          <td>" + val.subjectMRN + "</td>" +
                "          <td>" + showValue(val.catalystId) + "</td>" +
                "          <td>" + val.localId + "</td>" +
                "          <td>" + showValue(val.irb) + "</td>" +
                "          <td>" + val.visitName + "</td>" +
                "          <td>" + val.appointmentStatus + "</td>" +
                " <td> <a href='javascript:getBookedVisitDetails(" + val.id + ")'> View Detail </a> </td> " +
                " </tr>";
            startDate2 = showDate(val.scheduledStartTime);
            iteration++;
        });
    }).always(function () {
        out += " </table>";
        createPageDropDownList();
        setupTable(out, $('#appointmentListBookedVisitData'), currentPage, totalData);

        var endDate = sessionStorage.getItem("apptListSelectedDate");
        if (endDate != "" && endDate != null && endDate != "null") {
            window.location.hash = "";
            setTimeout(function () {
                window.location.hash = "#" + endDate;
            }, 500);
            sessionStorage.setItem("apptListSelectedDate", "");
        }
        $('#table_loading').css({display: 'none'});
    });
}


/////////Next button on search dialogs///////////////////////////////////////////////////


function datePickersDisplay() {
    var durationMins = appt_selectedVisitDuration % 60;
    var min = durationMins % 60;
    var extrahr = appt_selectedVisitDuration - min;
    var hr = extrahr / 60;
    var days = Math.floor(appt_selectedVisitDuration / 24 / 60);
    var hours = Math.floor(appt_selectedVisitDuration / 60 % 24);
    var displayTime = days + ' d, ' + hours + ' hr, ' + min + ' min ';
    if (days < 1) {
        displayTime = hours + ' hr, ' + min + ' min ';
    }
    else if (days < 1 && hours < 1) {
        displayTime = min + ' min ';
    }
    $('.appt_totalTime').text(appt_selectedVisitDuration + ' minutes' + ' (' + displayTime + ')');
    dateTimeGridPlacements();
    if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER || user.institutionRole.id == SCHEDULER) {
        minDate = "+0M +0D";
        appt_createSearchDateTimeWidgets();
        var hr_value = Math.floor(7 + hr);
        var min_value = min;

        $("#appt_startDate").datepicker('setDate', new Date());
        $("#appt_endDate").datepicker('setDate', new Date());
        $("#appt_startTime").datepicker('setTime', '07:00');

        if (appt_selectedVisitDuration < 1005) {
            if (min_value == 0 && hr_value < 10) {
                search_endtimeVal = '0' + hr_value + ':0' + min_value;
            }
            else if (min_value > 0 && hr_value > 9) {
                search_endtimeVal = hr_value + ':' + min_value;
            }
            else if (min_value > 0 && hr_value < 10) {
                search_endtimeVal = '0' + hr_value + ':' + min_value;
            }
            else if (min_value == 0 && hr_value > 9) {
                search_endtimeVal = hr_value + ':0' + min_value;
            }
        }
        else {
            var totalduration = appt_selectedVisitDuration;
            var durationHours = totalduration / 60;
            var date2 = new Date();
            var enddate = date2.setHours(7 + durationHours);
            search_endtimeVal = '23:45';
            $("#appt_endDate").datepicker('setDate', new Date(enddate));
        }
        $('#appt_endTime').val(search_endtimeVal);
    }
    else {
        minDate = "+0M +1D";
        appt_createSearchDateTimeWidgets();
        var hr_value = Math.floor(7 + hr);
        var min_value = min;
        var today = new Date();
        var tomorrow = new Date();
        tomorrow.setDate(today.getDate() + 1);
        $("#appt_startDate").datepicker('setDate', tomorrow);
        $("#appt_endDate").datepicker('setDate', tomorrow);
        $('#appt_startTime').val('07:00');
        if (appt_selectedVisitDuration < 1005) {
            if (min_value == 0 && hr_value < 10) {
                search_endtimeVal = '0' + hr_value + ':0' + min_value;
            }
            else if (min_value > 0 && hr_value > 9) {
                search_endtimeVal = hr_value + ':' + min_value;
            }
            else if (min_value > 0 && hr_value < 10) {
                search_endtimeVal = '0' + hr_value + ':' + min_value;
            }
            else if (min_value == 0 && hr_value > 9) {
                search_endtimeVal = hr_value + ':0' + min_value;
            }
        }
        else {
            var totalduration = appt_selectedVisitDuration;
            var durationHours = totalduration / 60;
            var enddate = tomorrow.setHours(7 + durationHours);
            search_endtimeVal = '23:45';
            $('#appt_endDate').datepicker('setDate', new Date(enddate));
        }
        $('#appt_endTime').val(search_endtimeVal);
    }

    resetCheckBoxes();
    var startDateDatepicker = $("#appt_startDate").datepicker('getDate');
    var dateObject = $("#appt_startDate").datepicker().val();
    $("#appt_endDate").val(dateObject);
    var endDateDatepicker = $("#appt_endDate").datepicker('getDate');
    if (editSearch) {
        $("#appt_startDate").datepicker('setDate', initialSearchStartDate);
        $("#appt_endDate").datepicker('setDate', initialSearchEndDate);
        $("#appt_startTime").timepicker('setTime', initialSearchStartTime);
        $("#appt_endTime").timepicker('setTime', initialSearchEndTime);
        startDateDatepicker = $("#appt_startDate").datepicker('getDate');
        endDateDatepicker = $("#appt_endDate").datepicker('getDate');
    }
    selectedDaysOfWeek = [];
    var dateArray = getDatesInterval(startDateDatepicker, endDateDatepicker);
    if ((dateArray[0].getDay() == 1 && dateArray.length >= 5) || dateArray.length >= 7) {
        $(".week_days").prop('disabled', false);
    } else {
        $(".week_days").prop('disabled', true);
    }
    for (var i = 0; i < dateArray.length; i++) {
        if (dateArray[i].getDay() != 0 && dateArray[i].getDay() != 6) {
            var selectDay = dateArray[i].getDay().toString();
            $("input:checkbox[value=" + selectDay + "]").prop("checked", true);
            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
        }
        else if (dateArray[i].getDay() == 0 || dateArray[i].getDay() == 6) {
            var selectDay = dateArray[i].getDay().toString();
            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
        }
    }
    toggleWeekDaysCheckBoxes();
}

function apptNextWizardClick(value) {
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    switch (appt_currentWizardScreen) {
        case 'appt_wizard_form1':
            resetSelectedSubject(true /* other params moot and undefined in this call */);

            $('#apptVisitData').html("");
            if (selectedStudy == null) {
                showError('#appt_wizard_formValidation', 'Please select a study');
                return;
            }
            $('#appt_studyFilterButton').attr("value", "Filter");
            $('#appt_visitFilterButton').attr("value", "Filter");
            $('#appt_subjectFilterButton').attr("value", "Filter");
            appt_wizard_viewStack('appt_wizard_form2');
            sessionStorage.setItem("filteredString", '');
            initial_load = true;
            resetUI();
            loadApptVisitData(currentPage);
            break;
        case 'appt_wizard_form2':
            $('#apptStudySubjectData').html("");
            if (selectedVisit == null) {
                showError('#appt_wizard_formValidation', 'Please select a visit');
                return;
            }
            $('#appt_studyFilterButton').attr("value", "Filter");
            $('#appt_visitFilterButton').attr("value", "Filter");
            $('#appt_subjectFilterButton').attr("value", "Filter");
            sessionStorage.setItem("filteredString", '');
            appt_wizard_viewStack('appt_wizard_form3');
            $("#appointment_allrooms").html(roomSelectOptions);
            $.getJSON("rest/appointment/getRoomResources?id=" + appt_selectedVisit, function (data) {
                roomResources = data.roomResources;
            });
            initial_load = true;
            resetUI();
            loadApptSubjectData(currentPage);

            $('#appt_noSubject').removeAttr('checked');
            $('#app_form3_chooseSubject').css({display: 'block'});

            break;
        case 'appt_wizard_form3':
            $("#appt_startDate").datepicker("destroy");
            $("#appt_endDate").datepicker("destroy");
            $("#appt_startTime").datepicker("destroy");
            $("#appt_endTime").datepicker("destroy");
            sessionStorage.setItem("filteredString", '');

            var subjectNa = document.getElementById("appt_noSubject").checked;

            if (selectedStudySubject === null) {
                if (subjectNa) {
                    appt_selectedSubjectName = "No Subject Assigned";
                } else {
                    showError('#appt_wizard_formValidation', 'Please select a subject or click Hold appointment without a subject.');
                    return;
                }
            }

            $('#appt_studyFilterButton').attr("value", "Filter");
            $('#appt_visitFilterButton').attr("value", "Filter");
            $('#appt_subjectFilterButton').attr("value", "Filter");
            datePickersDisplay();
            appt_wizard_viewStack('appt_wizard_form4');
            break;
        case 'appt_wizard_form4':
            $('#appt_studyFilterButton').attr("value", "Filter");
            $('#appt_visitFilterButton').attr("value", "Filter");
            $('#appt_subjectFilterButton').attr("value", "Filter");
            sessionStorage.setItem("filteredString", '');
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER || user.institutionRole.id == SCHEDULER) {
                search_startdateVal = $('#appt_startDate').val();
                search_starttimeVal = $('#appt_startTime').val();
                search_enddateVal = $('#appt_endDate').val();
                search_endtimeVal = $('#appt_endTime').val();
                if (search_startdateVal == null || search_starttimeVal == null) {
                    showError('#appt_wizard_formValidation', 'Please select a Valid Start Date/Time');
                    return;
                }

                if (search_enddateVal == null || search_endtimeVal == null) {
                    showError('#appt_wizard_formValidation', 'Please select a Valid End Date/Time');
                    return;
                }
            }
            else {
                search_startdateVal = $('#appt_startDate').val();
                search_starttimeVal = $('#appt_startTime').val();
                search_enddateVal = $('#appt_endDate').val();
                search_endtimeVal = $('#appt_endTime').val();

                if (search_startdateVal == null || search_starttimeVal == null) {
                    showError('#appt_wizard_formValidation', 'Please select a Valid Start Date/Time');
                    return;
                }

                if (search_enddateVal == null || search_endtimeVal == null) {
                    showError('#appt_wizard_formValidation', 'Please select a Valid End Date/Time');
                    return;
                }

                if (search_startdateVal < minDate || search_enddateVal < minDate) {
                    showError('#appt_wizard_formValidation', 'Please select a Valid Start Date/Time');
                    return;
                }

                var search_startdateTimeVal = search_startdateVal + ' ' + search_starttimeVal;
                startDateDiff = new Date(search_startdateTimeVal);

                startDateDiff = (startDateDiff.getTime() - new Date().getTime()) / (1000 * 60 * 60);

                if (startDateDiff < 24) {
                    showError('#appt_wizard_formValidation', 'Please enter valid date range');
                    return;
                }
            }

            var search_startdateTimeVal = search_startdateVal + ' ' + search_starttimeVal;
            startDateDiff = new Date(search_startdateTimeVal);
            var search_enddateTimeVal = search_enddateVal + ' ' + search_endtimeVal;
            endDateDiff = new Date(search_enddateTimeVal);
            if (search_startdateVal == '' || search_starttimeVal == '' || search_enddateVal == '' || search_endtimeVal == '') {
                showError('#appt_wizard_formValidation', 'Please select a valid start and end date range.');
                return;
            }

            if (startDateDiff >= endDateDiff) {
                showError('#appt_wizard_formValidation', 'Please select a valid start and end date');
                return;
            }

            if ($('#appt_startDate').datepicker('getDate') > $('#appt_endDate').datepicker('getDate')) {
                showError('#appt_wizard_formValidation', 'Please enter valid date range.');
                return;
            }

            var totalStartTime = startDateDiff.getTime();
            var totalEndTime = endDateDiff.getTime();

            if (startDateDiff.getTimezoneOffset() > endDateDiff.getTimezoneOffset()) {
                totalStartTime = startDateDiff.getTime() - 3600000;
            } else if (startDateDiff.getTimezoneOffset() < endDateDiff.getTimezoneOffset()) {
                totalEndTime = endDateDiff.getTime() - 3600000;
            }
            var difference = totalEndTime - totalStartTime;
            var totalSearchDuration = difference / 60000;
            if (appt_selectedVisitDuration > totalSearchDuration) {
                showError('#appt_wizard_formValidation', 'Selected time range is smaller than the visit duration.');
                return;
            }

            $('.appt_dateRange').text(search_startdateVal + ' ' + search_starttimeVal + ' - ' + search_enddateVal + ' ' + search_endtimeVal);
            selectedDaysOfWeek = [];
            $('.appt_selectedDays').css({display: "none"});
            $('.appt_timeRange').css({display: "none"});
            $('#appt_timeRange').css({display: "none"});
            $('#selectedDaysSummary').css({display: "none"});
            if ((appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3)) {
                $('.appt_timeRange').css({display: "inline-block"});
                $('#appt_timeRange').css({display: "inline-block"});
                $('.appt_dateRange').text(search_startdateVal + ' - ' + search_enddateVal);
                $('.appt_timeRange').text(search_starttimeVal + ' - ' + search_endtimeVal);
                $('.appt_selectedDays').css({display: "inline-block"});
                $('#selectedDaysSummary').css({display: "inline-block"});
                //get days of the week selected
                var daysOfWeek = setSelectedDaysOfWeekFromCheckboxes();

                var index = daysOfWeek.lastIndexOf(",");
                daysOfWeek = daysOfWeek.substring(0, index) + daysOfWeek.substring(index + 1);
                $('.appt_selectedDays').text(daysOfWeek);

                if (selectedDaysOfWeek.length == 0) {
                    showError('#appt_wizard_formValidation', 'Please select the days for the search range.');
                    return;
                }
            }
            appt_wizard_viewStack('appt_wizard_form5');
            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Search");
            initial_load = true;
            resetUI();
            loadApptTemplateResourceData(currentPage);
            break;
        case 'appt_wizard_form5':
            sessionStorage.setItem("filteredString", '');
            $.blockUI();
            $('#loading').css({display: 'block'});
            $('#appt_calendar').fullCalendar('removeEvents',
                function (calEvent) {
                    return (calEvent.className == 'NotFound' || calEvent.className == 'Searching')
                });
            $('#appt_wizard_changeAppointmentSearch').css({display: "none"});
            setTimeout(function () {
                appt_searchAvailability();
            }, 200);
            break;
        case 'appt_wizard_overbook_room':
            sessionStorage.setItem("filteredString", '');
            if (roomResources == undefined || roomResources == null || roomResources == '') {
                $('#appt_wizard_form-next').css({width: "115px"});
                $('#appt_wizard_form-next').attr("value", "Reserve Visit");
                appt_overBookRoomAppointment();
            }
            else {
                appt_checkOverBookRoom();
            }
            break;
        case 'appt_wizard_overbookRoomSubmit':
            sessionStorage.setItem("filteredString", '');
            appt_overBookRoomAppointment();
            $('.dialog_room_selected').text(overbookRoomSelected);
            break;
    }
}

///////Previous button on search dialogs///////////////////////////////////////////////
function apptPreviousWizardClick() {
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    switch (appt_currentWizardScreen) {
        case 'appt_wizard_form2':
            var tdClass = ".selectClass" + appt_selectedStudy;
            unSelectRow(tdClass);

            selectedStudy = null;
            selectedVisit = null;
            appt_wizard_viewStack('appt_wizard_form1');
            sessionStorage.setItem("filteredString", '');
            resetUI();
            intitial_load = true;
            currentPage = 1;
            loadApptStudyData(currentPage);
            break;
        case 'appt_wizard_form3':
            var tdClass = ".selectClass" + appt_selectedVisit;
            unSelectRow(tdClass);

            selectedVisit = null;
            selectedStudySubject = null;
            appt_wizard_viewStack('appt_wizard_form2');
            sessionStorage.setItem("filteredString", '');
            resetUI();
            intitial_load = true;
            currentPage = 1;
            loadApptVisitData(currentPage);
            break;
        case 'appt_wizard_form4':
            var tdClass = ".selectClass" + appt_selectedSubjectMrnId;
            unSelectRow(tdClass);

            selectedStudySubject = null;
            appt_wizard_viewStack('appt_wizard_form3');
            sessionStorage.setItem("filteredString", '');
            resetUI();
            intitial_load = true;
            currentPage = 1;
            loadApptSubjectData(currentPage);
            $('#appt_noSubject').removeAttr('checked');
            $('#app_form3_chooseSubject').css({display: 'block'});
            break;
        case 'appt_wizard_form5':
            sessionStorage.setItem("filteredString", '');
            appt_wizard_viewStack('appt_wizard_form4');
            break;
        case 'appt_wizard_overbook_room':
            sessionStorage.setItem("filteredString", '');
            appt_wizard_viewStack('appt_wizard_form3');
            break;
        case 'appt_wizard_overbookRoomSubmit':
            sessionStorage.setItem("filteredString", '');
            appt_wizard_viewStack('appt_wizard_overbook_room');
            break;
    }
}

//Restart Search
function apptRestartWizardClick() {
    sessionStorage.setItem("filteredString", '');
    appt_initWizardForm();
}

////////////////Create datepickers//////////////////////////////////////////////////////
function reschedule_widgets() {
    WidgetUtil.createDatepicker("#reschedule_start_date", {
        minDate: "+0M +0D"
    });
    $('#reschedule_start_time').timepicker({
        timeFormat: 'hh:mm tt',
        value: '00:00'
    });
}

$("#home_toggleCalendar").click(function () {
    home_viewStack('home_calendar');
    $("#home_toggleCalendar").attr("checked", "checked");
});

$("#home_toggleList").click(function () {
    home_viewStack('home_calendarList');
    $("#home_toggleList").attr("checked", "checked");
});

function filterResources(obj) {
    $.blockUI();
    if (obj.value == "All") {
        $('#searchResourcesData tbody tr').filter(function () {
            return $.trim($(this).find('td').eq(3).attr('title')) === "Not Available"
                || $.trim($(this).find('td').eq(3).attr('title')) === "Available"
        }).show();
    }
    else {
        $('#searchResourcesData tbody tr').filter(function () {
            if (obj.value === "Yes") {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Available"
            }
            else {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Not Available"
            }
        }).show();
        $('#searchResourcesData tbody tr').filter(function () {
            if (obj.value === "Yes") {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Not Available"
            }
            else {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Available"
            }
        }).hide();
    }
    $.unblockUI();
}


function dateTimeGridPlacements() {
    $("#appt_startDate").unmask();
    $("#appt_endDate").unmask();
    if (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) {
        $('.startDate span').html("Start Date ");
        $('.endDate span').html("End Date ");
        $('.startTime span').html("Earliest Start Time ");
        $('.endTime span').html("Latest End Time ");
        var i = 0;
        $.each($("#mytable1").find("td"), function () {
            if (i == 1) {
                $(this).find("input").attr("id", "appt_startDate");
                $(this).find("input").attr("class", "apptFormDate ll-skin-latoja");
            }
            else if (i == 3) {
                $(this).find("input").attr("id", "appt_endDate");
                $(this).find("input").attr("class", "apptFormDate ll-skin-latoja");

            }
            else if (i == 5) {
                $(this).find("input").attr("id", "appt_startTime");
            }
            else if (i == 7) {
                $(this).find("input").attr("id", "appt_endTime");
            }
            i++;
        });
    }
    else if (appt_selectedVisitType == 4 || appt_selectedVisitType == 5 || appt_selectedVisitType == 6) {
        $('.startDate span').html("Earliest Start Date ");
        $('.endDate span').html("Earliest Start Time ");
        $('.startTime span').html("Latest End Date ");
        $('.endTime span').html("Latest End Time ");
        var i = 0;
        $.each($("#mytable1").find("td"), function () {
            if (i == 1) {
                $(this).find("input").attr("id", "appt_startDate");
                $(this).find("input").attr("class", "apptFormDate ll-skin-latoja");
            }
            else if (i == 3) {
                $(this).find("input").attr("id", "appt_startTime");
            }
            else if (i == 5) {
                $(this).find("input").attr("id", "appt_endDate");
                $(this).find("input").attr("class", "apptFormDate ll-skin-latoja");
            }
            else if (i == 7) {
                $(this).find("input").attr("id", "appt_endTime");
            }
            i++;
        });
    }
   
    $("#appt_startTime").mask("99:99");
    $("#appt_endTime").mask("99:99");
}

function searchAvailabilityComplete() {
    $('#loading').css({display: 'none'});
    $('#filter_loading').css({display: 'none'});

    if ($.active == 1) {
        $('#appt_wizard_changeAppointmentSearch').css({display: "inline-block"});
        editSelectedStudy = appt_selectedStudy;
        editSelectedSubjectMrnId = appt_selectedSubjectMrnId;
        editSelectedVisit = appt_selectedVisit;
        appt_editSelectedStudyName = appt_selectedStudyName;
        appt_editSelectedStudyInvestigatorName = appt_selectedStudyInvestigatorName;
        appt_editSelectedVisitName = appt_selectedVisitName;
        appt_editSelectedVisitType = appt_selectedVisitType;
        appt_editSelectedVisitDuration = appt_selectedVisitDuration;
        appt_editSelectedSubjectName = appt_selectedSubjectName;
        //edit mrn here? TBD
        $.unblockUI();
        if (erroMsgFlag == true) {
            var confirmationMessage = "No Available Appointments Found. Scroll through to view unavailable appointments.";
            util_showMainMessage(confirmationMessage);
            $("#appt_wizard_screen").dialog("close");
        }
        else if (no_appointments_found == true) {
            var confirmationMessage = "No Available Appointments were found. Please select another date range.";
            util_showMainMessage(confirmationMessage);
            updateSearchRange();
        }
        else if (erroMsgFlag == false && no_appointments_found == false) {
            var confirmationMessage = "Available Appointments Found. Scroll through to select an appointment.";
            util_showMainMessage(confirmationMessage);
            $("#appt_wizard_screen").dialog("close");
        }
    }
}

function updateSearchRange() {
    $("#appt_wizard_screen").dialog({modal: true, close: dialogCloseFunction, height: 750, width: 720});
    $('#appt_wizard_screen').css({display: "block"});
    sessionStorage.setItem("filteredString", '');
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    editSearch = true;
    appt_selectedStudyName = appt_editSelectedStudyName;
    appt_selectedStudyInvestigatorName = appt_editSelectedStudyInvestigatorName;
    $('.dialog_study_name').text(appt_editSelectedStudyName);
    $('.dialog_study_pi').text(appt_editSelectedStudyInvestigatorName);
    $('.dialog_study_visit').text(appt_editSelectedVisitName);
    $('.appt_totalTime').text(appt_editSelectedVisitDuration);
    $('.dialog_study_subject').text(appt_editSelectedSubjectName);
    appt_selectedStudy = editSelectedStudy;
    appt_selectedSubjectMrnId = editSelectedSubjectMrnId;
    appt_selectedVisit = editSelectedVisit;
    appt_selectedVisitType = appt_editSelectedVisitType;
    appt_selectedVisitDuration = appt_editSelectedVisitDuration;
    $("#appt_startDate").datepicker("destroy");
    $("#appt_endDate").datepicker("destroy");
    $("#appt_startTime").datepicker("destroy");
    $("#appt_endTime").datepicker("destroy");
    sessionStorage.setItem("filteredString", '');
    datePickersDisplay();
    appt_wizard_viewStack('appt_wizard_form4');
}

function searchAvailabilityError(xhr, status, error) {
    // check status && error
}

function searchAvailabilitySuccess(data) {
    if (data instanceof Array && data.length > 0) {
        no_appointments_found = false;

        $('#appt_calendar').fullCalendar('addEventSource', data);
        $('#appt_calendar').fullCalendar('gotoDate', startDateVal);
    }
}

function appt_searchAvailability() {
    no_appointments_found = true;
    erroMsgFlag = true;

    startDateVal = null;
    var totaldays = 0;
    searching_appointments = true;
    $('#filter_loading').css({display: 'none'});
    initialSearchStartDate = $("#appt_startDate").datepicker('getDate');
    initialSearchEndDate = $("#appt_endDate").datepicker('getDate');
    initialSearchStartTime = $("#appt_startTime").timepicker().val();
    initialSearchEndTime = $("#appt_endTime").timepicker().val();

    // outpatient
    if ((appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3)) {
        startDateVal = $("#appt_startDate").datepicker('getDate');

        search_startdateVal = $("#appt_startDate").datepicker('getDate');
        search_enddateVal = $("#appt_startDate").datepicker('getDate');
        var timeDiff = Math.abs($("#appt_endDate").datepicker('getDate').getTime() - $("#appt_startDate").datepicker('getDate').getTime());
        var totaldays = Math.ceil(timeDiff / (1000 * 3600 * 24));

        for (var i = 0; i <= totaldays; i++) {
            var sDay;
            if (i > 0) {
                var date1 = $('#appt_startDate').datepicker('getDate');
                date1.setDate(date1.getDate() + 1);
                $('#appt_startDate').datepicker('setDate', date1);
                sDay = $("#appt_startDate").datepicker('getDate');
            }
            else {
                sDay = $("#appt_startDate").datepicker('getDate');
            }
            $("#appt_startDate").datepicker('setDate', sDay);
            $("#appt_endDate").datepicker('setDate', sDay);

            search_startdateVal = $("#appt_startDate").val(); //$("#appt_startDate").datepicker('getDate');
            search_enddateVal = $("#appt_startDate").val();  //$("#appt_startDate").datepicker('getDate');

            search_starttimeVal = $("#appt_startTime").timepicker().val(); //Ext.getCmp('appt_startTime').getValue();
            search_endtimeVal = $("#appt_endTime").timepicker().val(); //Ext.getCmp('appt_endTime').getValue();

            var search_startdateTimeVal = search_startdateVal + ' ' + search_starttimeVal;
            search_startdateVal = new Date(search_startdateTimeVal);

            var search_enddateTimeVal = search_enddateVal + ' ' + search_endtimeVal;
            search_enddateVal = new Date(search_enddateTimeVal);
            if ($.inArray(sDay.getDay().toString(), selectedDaysOfWeek) != -1) {
                var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                    + '&visit=' + appt_selectedVisit
                    + '&startDate=' + search_startdateVal.valueOf()
                    + '&endDate=' + search_enddateVal.valueOf()
                    + '&isInpatient=false';

                requests.push($.ajax({
                    type: 'POST',
                    url: searchurl,
                    data: {},

                    success: searchAvailabilitySuccess,
                    error: searchAvailabilityError,
                    complete: searchAvailabilityComplete,

                    dataType: 'json',
                    async: true
                }));
            }
        }  // each day
    } // outpatient

    // inpatient
    else if ((appt_selectedVisitType == 4 || appt_selectedVisitType == 5 || appt_selectedVisitType == 6)) {

        startDateVal = $("#appt_startDate").datepicker('getDate');

        if (appt_selectedVisitRelative == true) {
            search_startdateVal = $("#appt_startDate").datepicker('getDate');
            search_enddateVal = $("#appt_endDate").datepicker('getDate');
            var timeDiffInMillis = $("#appt_endDate").datepicker('getDate') - $("#appt_startDate").datepicker('getDate');
            var timeDiffInMinutes = Math.floor(timeDiffInMillis / 60000);
            var totaldays = Math.floor(timeDiffInMinutes / MINS_PER_DAY);
            var totalVisitDuration = appt_selectedVisitDuration;

            // within one day
            if (totalVisitDuration < MINS_PER_DAY) {
                search_startdateVal = $("#appt_startDate").val(); //$("#appt_startDate").datepicker('getDate');
                search_enddateVal = $("#appt_endDate").val();  //$("#appt_startDate").datepicker('getDate');

                search_starttimeVal = $("#appt_startTime").timepicker().val(); //Ext.getCmp('appt_startTime').getValue();
                search_endtimeVal = $("#appt_endTime").timepicker().val(); //Ext.getCmp('appt_endTime').getValue();

                var search_startdateTimeVal = search_startdateVal + ' ' + search_starttimeVal;
                search_startdateVal = new Date(search_startdateTimeVal);

                var search_enddateTimeVal = search_enddateVal + ' ' + search_endtimeVal;
                search_enddateVal = new Date(search_enddateTimeVal);

                var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                    + '&visit=' + appt_selectedVisit
                    + '&startDate=' + search_startdateVal.valueOf()
                    + '&endDate=' + search_enddateVal.valueOf()
                    + '&isInpatient=true';

                requests.push($.ajax({
                    type: 'POST',
                    url: searchurl,
                    data: {},

                    success: searchAvailabilitySuccess,
                    error: searchAvailabilityError,
                    complete: searchAvailabilityComplete,

                    dataType: 'json',
                    async: true
                }));
            } // within one day

            else { // totalVisitDuration > MINS_PER_DAY, i.e., more than 1 day in duration

                var search_absoluteEndDateVal = $("#appt_endDate").val();
                var search_absoluteEndTimeVal = $("#appt_endTime").timepicker().val();
                var search_absoluteEndDateTimeVal = search_absoluteEndDateVal + ' ' + search_absoluteEndTimeVal;

                var search_absoluteEndDate = new Date(search_absoluteEndDateTimeVal);

                for (var i = 0; i <= totaldays; i++) {

                    if (i > 0) { // subsequent days increment the original value of startDate
                        var date1 = $('#appt_startDate').datepicker('getDate');
                        date1.setDate(date1.getDate() + 1);
                        $('#appt_startDate').datepicker('setDate', date1);
                    }

                    var search_startDateVal = $("#appt_startDate").val();
                    var search_startTimeVal = $("#appt_startTime").timepicker().val();
                    var search_startDateTimeVal = search_startDateVal + ' ' + search_startTimeVal;
                    var search_startDate = new Date(search_startDateTimeVal);

                    // last possible match starts one day after current start, minus epsilon,
                    //         so ends at one day + totalVisitDuration - epsilon

                    var search_endDate = new addMinutes(search_startDate, MINS_PER_DAY + totalVisitDuration - 1);

                    if (search_endDate > search_absoluteEndDate) {
                        search_endDate = search_absoluteEndDate;
                    }

                    var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId +
                        '&visit=' + appt_selectedVisit +
                        '&startDate=' + search_startDate.valueOf() +
                        '&endDate=' + search_endDate.valueOf() +
                        '&isInpatient=true';

                    requests.push($.ajax({
                        type: 'POST',
                        url: searchurl,
                        data: {},

                        success: searchAvailabilitySuccess,
                        error: searchAvailabilityError,
                        complete: searchAvailabilityComplete,

                        dataType: 'json',
                        async: true
                    }));

                }  // for each day
            }  // more than one day
        }  // relative
        else // non-relative 'clock' time visit
        {
            search_startdateVal = $("#appt_startDate").val();
            search_enddateVal = $("#appt_endDate").val();

            search_starttimeVal = $("#appt_startTime").timepicker().val();
            search_endtimeVal = $("#appt_endTime").timepicker().val();

            var search_startdateTimeVal = search_startdateVal + ' ' + search_starttimeVal;
            search_startdateVal = new Date(search_startdateTimeVal);

            var search_enddateTimeVal = search_enddateVal + ' ' + search_endtimeVal;
            search_enddateVal = new Date(search_enddateTimeVal);
            editSelectedStudy = appt_selectedStudy;
            editSelectedSubjectMrnId = appt_selectedSubjectMrnId;
            editSelectedVisit = appt_selectedVisit;
            appt_editSelectedStudyName = appt_selectedStudyName;
            appt_editSelectedStudyInvestigatorName = appt_selectedStudyInvestigatorName;
            appt_editSelectedVisitName = appt_selectedVisitName;
            appt_editSelectedVisitType = appt_selectedVisitType;
            appt_editSelectedVisitDuration = appt_selectedVisitDuration;
            appt_editSelectedSubjectName = appt_selectedSubjectName;

            //edit mrn here? TBD
            var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                + '&visit=' + appt_selectedVisit
                + '&startDate=' + search_startdateVal.valueOf()
                + '&endDate=' + search_enddateVal.valueOf()
                + '&isInpatient=true';

            request = $.post(searchurl, {}, function (data) {
                var parsedData = $.parseJSON(data);
                $.unblockUI();
                $('#appt_wizard_changeAppointmentSearch').css({display: "inline-block"});
                if (parsedData.errorMsg == "false") {
                    $('#loading').css({display: 'none'});
                    $('#filter_loading').css({display: 'none'});
                    var confirmationMessage = "No Available Appointments were found. Please select another date range.";
                    util_showMainMessage(confirmationMessage);
                    sessionStorage.setItem("filteredString", '');
                    appt_wizard_viewStack('appt_wizard_form4');
                }
                else {
                    $('#loading').css({display: 'none'});
                    $('#filter_loading').css({display: 'none'});
                    $('#appt_calendar').fullCalendar('addEventSource', parsedData);
                    $('#appt_calendar').fullCalendar('gotoDate', search_startdateVal);
                    var confirmationMessage = "Available Appointments Found. Scroll through to select an appointment.";
                    if (erroMsgFlag == true) {
                        confirmationMessage = "No Available Appointments Found. Scroll through to view unavailable appointments.";
                    }
                    util_showMainMessage(confirmationMessage);
                    $("#appt_wizard_screen").dialog("close");
                }
            });
        }  // clock time
    } // inpatient
}

function scheduleDialog() {
    DialogsUtil.showConfirmationDialog("#schedule-dialog-confirm", {
        buttons: {
            "Yes": function () {
                $(this).dialog("close");
                document.getElementById("appt_wizard_scheduleAppointment").style.display = "none";
                $('#appt_wizard_changeAppointmentSearch').css({display: "none"});
                $.blockUI();
                scheduleComment = $.trim($("#scheduleWizard_comment").val());
                double_start = start;
                document.getElementById("appt_wizard_scheduleAppointment").style.display = "none";
                jsonData = JSON.stringify({
                    events: eventid, study: appt_selectedStudy, subjectMrnId: appt_selectedSubjectMrnId,
                    visit: appt_selectedVisit, comment: scheduleComment, browserName: navigator.userAgent, user: user.id
                });
                var isInpatient = (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) ? false : true;

                var confirmUrl = 'rest/appointment/confirmAppointment?isInpatient=' + isInpatient + '&startDate=' + start + '&endDate=' + end;
                $.post(confirmUrl, {data: jsonData}, function (data) {
                    var parsedData = $.parseJSON(data);
                    handleGenderBlockForNewVisit(parsedData);
                    calendar_rendered = true;
                    view = null;
                    var starts = new Date(moment(start).year(), moment(start).month(), 1);
                    var ends = new Date(moment(start).year(), moment(start).month() + 2, 0, 23, 59, 59, 59);
                    var url = "rest/appointment/getCalendarBookedVisits?starting=" + starts.getTime() + "&ending=" + ends.getTime() + "&todayVisits=false&filterString=&filterId=";
                    $('#initial_loading').css({display: 'block'});
                    searching_appointments = false;
                    start = double_start;
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {},
                        success: function (data) {
                            $('#appt_calendar').fullCalendar('removeEvents');
                            $('#appt_calendar').fullCalendar('removeEventSource', data);
                            $('#appt_calendar').fullCalendar('addEventSource', data);
                            $('#initial_loading').css({display: 'none'});
                            $.unblockUI();
                        },
                        error: function (xhr, status, error) {
                            // check status && error
                        },
                        dataType: 'json',
                        async: false
                    });
                    if (start != null) {
                        $('#appt_calendar').fullCalendar('gotoDate', new Date(start));
                    }
                    else {
                        $('#appt_calendar').fullCalendar('gotoDate', new Date());
                    }
                });
            },
            "No": function () {
                document.getElementById("appt_wizard_scheduleAppointment").style.display = "inline";
                $(this).dialog("close");
                return;
            }
        }
    });
}

function showGenderBlockDialogForNewAppointment() {
    $("#doubleRoom-dialog-confirm").show();

    $("#doubleRoom-dialog-confirm").dialog({
        resizable: true,
        // let height be determined by the content of the div
        width: 500,
        modal: true,
        buttons: {
            "Yes": function () {
                calendar_rendered = true;
                jsonData = JSON.stringify({
                    events: eventid,
                    study: appt_selectedStudy,
                    subjectMrnId: appt_selectedSubjectMrnId,
                    visit: appt_selectedVisit,
                    comment: scheduleComment,
                    browserName: navigator.userAgent,
                    user: user.id,
                    doubleRoomMessage: doubleSharedRoom
                });
                var isInpatient = (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) ? false : true;

                var confirmUrl = 'rest/appointment/confirmAppointment?isInpatient=' + isInpatient + '&startDate=' + double_start + '&endDate=' + end;
                $.post(confirmUrl, {data: jsonData}, function (data) {
                    var parsedData = $.parseJSON(data);
                    alternateResourceUsed = parsedData.alternateResourceUsed;
                    confirmationStatus = parsedData.confirmationStatus;
                    if (confirmationStatus == "true") {
                        if (alternateResourceUsed != null) {
                            alert(alternateResourceUsed);
                        }
                        util_showMainMessage("The appointment has been Scheduled");
                        scheduleComment = null;
                        searching_appointments = false;
                        $("#appt_wizard_searchedDetails").dialog("close");
                    }
                    else {
                        alert("Sorry, one or more of the resources for this appointment became unavailable during the confirmation process. Please try your search again and look for alternate times.");
                        scheduleComment = null;
                        searching_appointments = false;
                        $("#appt_wizard_searchedDetails").dialog("close");
                    }
                    util_showMainMessage("The appointment has been Scheduled");
                    scheduleComment = null;
                    doubleSharedRoom = null;
                    var starts = null;
                    var ends = null;
                    var yourDate = new Date();
                    $("#appt_wizard_searchedDetails").dialog("close");
                    start = null;
                    view = null;
                    $('#initial_loading').css({display: 'block'});
                    calendar_rendered = true;
                    starts = new Date(yourDate.getFullYear(), yourDate.getMonth() - 1, 1);
                    ends = new Date(yourDate.getFullYear(), yourDate.getMonth() + 2, 0, 23, 59, 59, 59);
                    var url = "rest/appointment/getCalendarBookedVisits?starting=" + starts.getTime() + "&ending=" + ends.getTime() + "&todayVisits=false&filterString=&filterId=";
                    searching_appointments = false;
                    start = double_start;
                    $.ajax({
                        type: 'GET',
                        url: url,
                        data: {},
                        success: function (data) {
                            $('#appt_calendar').fullCalendar('removeEvents');
                            $('#appt_calendar').fullCalendar('removeEventSource', data);
                            $('#appt_calendar').fullCalendar('addEventSource', data);
                            $('#initial_loading').css({display: 'none'});
                        },
                        error: function (xhr, status, error) {
                            // check status && error
                        },
                        dataType: 'json',
                        async: false
                    });
                    if (start != null) {
                        $('#appt_calendar').fullCalendar('gotoDate', new Date(start));
                    }
                    else {
                        $('#appt_calendar').fullCalendar('gotoDate', new Date());
                    }
                    $('#appt_calendar').fullCalendar('rerenderEvents');
                    return;
                });
                $(this).dialog("close");
                $("#doubleRoom-dialog-confirm").hide();
            },
            "No": function () {
                $(this).dialog("close");
                $("#doubleRoom-dialog-confirm").hide();
            }
        }
    });
}


function showConfirmationDialogForSwitchedSubject(subjectMrnId, genderBlockFlag, doubleBookingFlag) {

    var genderBlockWarning = "<p>There is already a patient of a different or undetermined gender booked into the room you are trying to schedule.</p>";
    var doubleBookedWarningPrefixAlone = "<p>PLEASE NOTE: T";
    var doublebookedWarningPrefixNotAlone = "<p>PLEASE NOTE ALSO: t";
    var doubleBookedWarning = "his subject is scheduled for another visit that will conflict with your desired time. Do you wish to continue? If you choose to schedule, please follow the proper notification and operational procedures at your site.</p>";

    var messageHtml = "";

    if (genderBlockFlag) {
        messageHtml += genderBlockWarning;
    }

    if (doubleBookingFlag) {
        if (genderBlockFlag) {
            messageHtml += doublebookedWarningPrefixNotAlone + doubleBookedWarning;
        }
        else {
            messageHtml += doubleBookedWarningPrefixAlone + doubleBookedWarning;
        }
    }

    $('#switch-subject-dialog-confirm-message').html(messageHtml);

    $("#switch-subject-dialog-confirm").dialog({
        resizable: true,
        // let height be determined by the content of the div
        width: 500,
        modal: true,
        buttons: {
            "Yes": function () {
                calendar_rendered = true;
                $(this).dialog("close");
                $("#doubleRoom-dialog-confirm").hide();

                switchSubject(
                    true,
                    subjectMrnId,
                    eventid,
                    handleConfirmedSwitchedSubject,
                    handleCouldNotConfirmSwitchSubject,
                    handleAjaxError
                );
            },
            "No": function () {
                //if the user clicks 'yes', then resetToResourceTableView
                //is called in the handleConfirmedSwitchedSubject,
                //which is left there because when a confirmation dialog is NOT Needed
                // then that method is called directly.
                resetToResourceTableView();
                $(this).dialog("close");
                $("#doubleRoom-dialog-confirm").hide();
            }
        }
    });
}


function apptStopSearchClick() {
    request.abort();
    if (requests.length > 0) {
        for (var i = 0; i < requests.length; i++) {
            requests[i].abort();
        }
    }
    $('#loading').css({display: 'none'});
    $('#filter_loading').css({display: 'none'});
}

function loadTimelineTab() {
    window.location.href = "appt_timeline.html";
}

function loadListTab() {
    sessionStorage.setItem("apptListSelectedMaxResults", 50);
    sessionStorage.setItem("apptListSelectedPage", "null");
    appointmentListModule();
}

function loadCalendarTab() {
    appointmentModule();
    appointmentModuleRoles();
}


function getBookedVisitDetails(id) {
    selectedPage = $('.input_page').val();
    sessionStorage.setItem("apptListSelectedPage", selectedPage);
    sessionStorage.setItem("apptListSelectedMaxResults", max_results);
    $.getJSON("rest/appointment/getBookedVisitData?bookedVisit=" + id, function (data) {
        sessionStorage.setItem("bookedVisit", JSON.stringify(data));
        sessionStorage.setItem("apptListSelectedDate", showDate(data.scheduledStartTime));
        appointmentBatchModule();
    });
}

function setClassNameBasedOnAppointmentStatus() {
    var className;

    switch (app_selectedBookedVisit.appointmentStatus) {
        case 'Scheduled':
            className = "statusBlock statusScheduled";
            break;
        case 'Checked-In':
            className = "statusBlock statusCheckedIn";
            break;
        case 'Checked-Out':
            className = "statusBlock statusCheckedOut";
            break;
        case 'Cancellation':
            className = "statusBlock statusCancelled";
            break;
        case 'Hold':
            className = "statusBlock statusHold";
            break;
        default:
            className = "";
    }

    document.getElementById("apptStatusClass").className = className;
}
function appointment_setFormMode(mode) {
    getBrowserVersion();
    appointment_mode = mode;
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    $('#renderSave').css({display: "none"});
    $('#renderOverbook').css({display: "none"});
    $('#renderCancel').css({display: "block"});
    $('#checkinRender').css({display: "none"});
    $('#checkoutRender').css({display: "none"});
    $('#cancelRender').css({display: "none"});
    $('#holdRender').css({display: "none"});

    search_createWidgets();
    app_selectedBookedVisit = JSON.parse(sessionStorage.getItem("bookedVisit"));
    if (mode == 'view') {
        $('#bookedVisitStudy_name').text(app_selectedBookedVisit.studyName);
        $('#bookedVisitDuration').text(app_selectedBookedVisit.visitDuration);
        $('#bookedVisitStatus').text(app_selectedBookedVisit.appointmentStatus);

        setClassNameBasedOnAppointmentStatus();

        var startDate = app_selectedBookedVisit.scheduledStartTime;
        $('#bookedVisitStartTime').text(startDate);

        var endDate = app_selectedBookedVisit.scheduledEndTime;
        $('#bookedVisitEndTime').text(endDate);

        var checkinDate = app_selectedBookedVisit.checkInDate;
        $('#bookedVisitCheckInTime').text(checkinDate);

        var checkoutDate = app_selectedBookedVisit.checkOutDate;
        $('#bookedVisitCheckOutTime').text(checkoutDate);
        $('#bookedVisitCheckOutReasonName').text(app_selectedBookedVisit.checkOutReason);

        var cancelDate = app_selectedBookedVisit.cancelDate;
        $('#bookedVisitCancelTime').text(cancelDate);
        $('#bookedVisitCancelReasonName').text(app_selectedBookedVisit.cancelReason);

        $('#bookedVisitStudyLocalID').text(app_selectedBookedVisit.localId);
        $('#bookedVisitSubjectFullName').text(app_selectedBookedVisit.subjectName);
        $('#bookedVisitStudyCatID').text(app_selectedBookedVisit.catID);
        $('#bookedVisitSubjectMRN').text(app_selectedBookedVisit.subjectMRN);
        $('#bookedVisitStudyIRB').text(app_selectedBookedVisit.irb);

        $('#bookedVisitSubjectSex').text(app_selectedBookedVisit.genderName);
        $('#bookedVisitName').text(app_selectedBookedVisit.visitName);
        $('#bookedVisitSubjectDob').text(app_selectedBookedVisit.birthDate);
        $('#bookedVisitComment').text(app_selectedBookedVisit.comment);
        $('#bookedVisitType').text(app_selectedBookedVisit.visitTypeName);

        appt_list_view = true;
        eventid = app_selectedBookedVisit.id;
        initial_load = true;
        resetUI();
        loadBookedResourcesData(currentPage, eventid);

        $('#checkinTable').css({display: "inline-block"});

        if (app_selectedBookedVisit.appointmentStatusId == appointmentStatus.Scheduled) {
            if (user.institutionRole.id == GENERAL_VIEW) {
                $('#renderCancel').css({display: "block"});
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "none"});
                $('#cancelRender').css({display: "none"});
            }
            else if (user.institutionRole.id == STUDY_STAFF) {
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "none"});
                $('#checkout_date').hide();
                $('#checkout_time').hide();
                $('#cancelRender').css({display: "block"});
                $('#cancel_date_wrapper').hide();
                $('#cancel_time').hide();
                $('#renderSave').css({display: "block"});
                $('#renderCancel').css({display: "none"});
                $('#holdRender').css({display: "none"});
            }
            else {
                $('#checkinRender').css({display: "block"});
                $('#checkoutRender').css({display: "block"});
                $('#cancelRender').css({display: "block"});
                $('#renderSave').css({display: "block"});
                $('#renderCancel').css({display: "none"});
                $('#holdRender').css({display: "none"});
            }
        }
        else if (app_selectedBookedVisit.appointmentStatusId == appointmentStatus.Checked_in) {
            $('#holdRender').css({display: "none"});

            if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF) {
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "none"});
                $('#cancelRender').css({display: "none"});
                $('#renderSave').css({display: "none"});
                $('#renderCancel').css({display: "block"});
            }
            else if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == SCHEDULER || user.institutionRole.id == RESOURCE_MANAGER) {
                $('#checkinRender').css({display: "block"});
                $('#checkoutRender').css({display: "block"});
                $('#renderSave').css({display: "block"});
                $('#cancelRender').css({display: "block"});
                $('#renderCancel').css({display: "none"});
            }
            else if (user.institutionRole.id == FRONT_DESK) {
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "block"});
                $('#renderSave').css({display: "block"});
                $('#cancelRender').css({display: "none"});
                $('#renderCancel').css({display: "none"});
            }
        }
        else if (app_selectedBookedVisit.appointmentStatusId == 3) {
            $('#holdRender').css({display: "none"});
            if (user.institutionRole.id != GENERAL_VIEW && user.institutionRole.id != STUDY_STAFF && user.institutionRole.id != FRONT_DESK) {
                $('#checkinRender').css({display: "block"});
                $('#checkoutRender').css({display: "block"});
                $('#cancelRender').css({display: "block"});
                $('#renderSave').css({display: "block"});
                $('#renderCancel').css({display: "none"});
            }
            else {
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "none"});
                $('#cancelRender').css({display: "none"});
                $('#renderSave').css({display: "none"});
                $('#renderCancel').css({display: "block"});
            }
        }
        else if (app_selectedBookedVisit.appointmentStatusId == 4) {
            $('#holdRender').css({display: "none"});
            if (user.institutionRole.id != GENERAL_VIEW && user.institutionRole.id != STUDY_STAFF && user.institutionRole.id != FRONT_DESK) {
                $('#checkinRender').css({display: "block"});
                $('#checkoutRender').css({display: "block"});
                $('#cancelRender').css({display: "block"});
                $('#renderSave').css({display: "block"});
                $('#renderCancel').css({display: "none"});
            }
            else {
                $('#checkinRender').css({display: "none"});
                $('#checkoutRender').css({display: "none"});
                $('#cancelRender').css({display: "none"});
                $('#renderSave').css({display: "none"});
                $('#renderCancel').css({display: "block"});
            }
        }
        else {
            $('#checkinRender').css({display: "none"});
            $('#checkoutRender').css({display: "none"});
            $('#cancelRender').css({display: "none"});
            $('#renderSave').css({display: "none"});
            $('#checkinTable').css({display: "none"});
            $('#renderCancel').css({display: "block"});
            $('#holdRender').css({display: "block"});
        }
    }
}

function apptCancelBatchListClick() {
    $('#renderOverbook').css({display: "none"});
    appointmentListModule();
}

function apptSubmitBatchListClick() {

    var checkindateVal = $('#checkin_date').val();
    var checkoutdateVal = $('#checkout_date').val();
    var canceldateVal = $('#cancel_date').val();

    var checkintimeVal = $("#checkin_time").timepicker().val();
    if (checkindateVal != "" && checkintimeVal != "") {
        var checkindatetimeVal = checkindateVal + ' ' + checkintimeVal;
        checkindateVal = new Date(checkindatetimeVal);
    } else {
        checkindateVal = null;
    }

    var checkouttimeVal = $("#checkout_time").timepicker().val();
    if (checkoutdateVal != "" && checkouttimeVal != "") {
        var checkoutdatetimeVal = checkoutdateVal + ' ' + checkouttimeVal;
        checkoutdateVal = new Date(checkoutdatetimeVal);
    } else {
        checkoutdateVal = null;
    }

    var canceltimeVal = $("#cancel_time").timepicker().val();
    if (canceldateVal != "" && canceltimeVal != "") {
        var canceldatetimeVal = canceldateVal + ' ' + canceltimeVal;
        canceldateVal = new Date(canceldatetimeVal);
    } else {
        canceldateVal = null;
    }

    var checkoutReasons = $.trim($('#checkoutReason').val());
    var cancellationReasons = $.trim($('#cancellationReasons').val());
    if (app_selectedBookedVisit.appointmentStatusId == 1) {
        if (user.institutionRole.id != STUDY_STAFF) {

            if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in time.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() == "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in date.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (($('#checkin_date').val() == "" || $("#checkin_time").timepicker().val() == "") &&
                (checkoutReasons != "" ||
                ($('#checkout_date').val() != null && $('#checkout_date').val() != "")
                || checkouttimeVal != "")) {
                util_showMainMessage("Please Note: Appointment needs to be Checked-In first, to be able to Check-Out.");
                $('#checkoutReason').val('');
                $('#cancellationReasons').val('');
                $('#checkin_date').val('');
                $('#checkin_time').val('');
                $('#checkout_date').val('');
                $('#checkout_time').val('');
                $('#cancel_date').val('');
                $('#cancel_time').val('');
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() == "" && $('#checkout_time').timepicker().val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() == "" && $('#cancel_time').timepicker().val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "") {
                util_showMainMessage("Please enter the correct data to change the appointment status.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid check-out reason to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to cancel the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("Please enter the valid cancel reason to cancel the appointment.");
                return;
            }
            if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "") {
                util_showMainMessage("Please select valid check-in time.");
                return;
            }

        }
    }
    else if (app_selectedBookedVisit.appointmentStatusId == 2) {
        if (user.institutionRole.id == STUDY_STAFF) {
            if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal == null) {
                util_showMainMessage("The visit can either be checked-in or checked-out.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons == "" && checkoutdateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "") {
                util_showMainMessage("Please enter the correct data to change the appointment status.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null) {
                util_showMainMessage("Please enter the valid date to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal != null) {
                util_showMainMessage("Please enter the valid check-out reason to check-out the appointment.");
                return;
            }
        }
        else {
            if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in time.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() == "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in date.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() == "" && $('#checkout_time').timepicker().val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() == "" && $('#cancel_time').timepicker().val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "") {
                util_showMainMessage("Please enter the correct data to change the appointment status.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid check-out reason to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to cancel the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("Please enter the valid cancel reason to cancel the appointment.");
                return;
            }
        }
    }
    else if (app_selectedBookedVisit.appointmentStatusId == 3) {
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == SCHEDULER || user.institutionRole.id == RESOURCE_MANAGER) {
            if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in time.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter correct check-out data.");
                return;
            }
            else if ($('#checkin_date').val() == "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please select valid check-in date.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("The visit can either be checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
                util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() == "" && $('#checkout_time').timepicker().val() != "") {
                util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() == "" && $('#cancel_time').timepicker().val() != "") {
                util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "") {
                util_showMainMessage("Please enter the correct data to change the appointment status.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid check-out reason to check-out the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
                util_showMainMessage("Please enter the valid date to cancel the appointment.");
                return;
            }
            else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal != null) {
                util_showMainMessage("Please enter the valid cancel reason to cancel the appointment.");
                return;
            }
        }
    }
    else if (app_selectedBookedVisit.appointmentStatusId == 4) {
        if ((app_selectedBookedVisit.checkInDate == null || app_selectedBookedVisit.checkInDate == "") &&
            ($('#checkin_date').val() == "" || $("#checkin_time").timepicker().val() == "") &&
            (checkoutReasons != "" ||
            ($('#checkout_date').val() != null && $('#checkout_date').val() != "")
            || checkouttimeVal != "")) {
            util_showMainMessage("Please Note: Appointment needs to be Checked-In first, to be able to Check-Out.");
            $('#checkoutReason').val('');
            $('#cancellationReasons').val('');
            $('#checkin_date').val('');
            $('#checkin_time').val('');
            $('#checkout_date').val('');
            $('#checkout_time').val('');
            $('#cancel_date').val('');
            $('#cancel_time').val('');
            return;
        }

        if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please select valid check-in time.");
            return;
        }
        else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter correct check-out data.");
            return;
        }
        else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter correct check-out data.");
            return;
        }
        else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() != "" && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter correct check-out data.");
            return;
        }
        else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() != "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter correct check-out data.");
            return;
        }
        else if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons != "" && $('#checkout_date').val() == "" && $("#checkout_time").timepicker().val() == "" && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter correct check-out data.");
            return;
        }
        else if ($('#checkin_date').val() == "" && $("#checkin_time").timepicker().val() != "" && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please select valid check-in date.");
            return;
        }
        else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal != null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal != null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal != null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal != null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal == null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
            util_showMainMessage("The visit can either be checked-out or cancelled.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal != null && cancellationReasons != "" && canceldateVal != null) {
            util_showMainMessage("The visit can either be checked-in or checked-out or cancelled.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() != "") {
            util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() != "") {
            util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#checkout_date').val() == "" && $('#checkout_time').timepicker().val() != "") {
            util_showMainMessage("Please select a check out reason, valid check out date, and valid check out time.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "" && $('#cancel_date').val() == "" && $('#cancel_time').timepicker().val() != "") {
            util_showMainMessage("Please select a cancel reason, valid cancel date, and valid cancel time.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && cancellationReasons == "") {
            util_showMainMessage("Please enter the correct data to change the appointment status.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons != "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter the valid date to check-out the appointment.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal != null && cancellationReasons == "" && canceldateVal == null) {
            util_showMainMessage("Please enter the valid check-out reason to check-out the appointment.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons != "" && canceldateVal == null) {
            util_showMainMessage("Please enter the valid date to cancel the appointment.");
            return;
        }
        else if (checkindateVal == null && checkoutReasons == "" && checkoutdateVal == null && cancellationReasons == "" && canceldateVal != null) {
            util_showMainMessage("Please enter the valid cancel reason to cancel the appointment.");
            return;
        }
        if ($('#checkin_date').val() != "" && $("#checkin_time").timepicker().val() == "") {
            util_showMainMessage("Please select valid check-in time.");
            return;
        }
    }

    var jsonData = JSON.stringify({
        id: app_selectedBookedVisit.id,
        checkoutStatusReason: (checkoutReasons != "" ? checkoutReasons : 0),
        cancelStatusReason: (cancellationReasons != "" ? cancellationReasons : 0),
        checkInDate: (checkindateVal != null ? checkindateVal.valueOf() : 0),
        checkOutDate: (checkoutdateVal != null ? checkoutdateVal.valueOf() : 0),
        cancelDate: (canceldateVal != null ? canceldateVal.valueOf() : 0)
    });

    $.post("rest/appointment/batchEntry", {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);
        var confirmationMessage = "";
        if (parsedData.errorMsg != "true") {
            confirmationMessage = parsedData.errorMsg;
            util_showMainMessage(confirmationMessage);
            $('#checkoutReason').val('');
            $('#cancellationReasons').val('');
            $('#checkin_date').val('');
            $('#checkin_time').val('');
            $('#checkout_date').val('');
            $('#checkout_time').val('');
            $('#cancel_date').val('');
            $('#cancel_time').val('');
        }
        else {
            confirmationMessage = "Visit Status Updated.";
            util_showMainMessage(confirmationMessage);
            alert(confirmationMessage);
            $('#checkoutReason').val('');
            $('#cancellationReasons').val('');
            $('#checkin_date').val('');
            $('#checkin_time').val('');
            $('#checkout_date').val('');
            $('#checkout_time').val('');
            $('#cancel_date').val('');
            $('#cancel_time').val('');
            appointmentListModule();
        }
    });
}

function loadOverrideAnnotationsData() {
    $("#allAnnotations").prop("checked", true);
    var resourceId = $("#wizard_overrideResources").val();

    $.getJSON("rest/resource/getResourceAnnotations?resourceId=" + resourceId, function (data) {
        var responseData = data.resourceAnnotationsValues;
        createAnnotationsTable(responseData);
    });
}

function override_widgets() {
    WidgetUtil.createDatepicker("#override_start_date");
    $('#override_start_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    WidgetUtil.createDatepicker("#override_end_date");
    $('#override_end_time').timepicker({
        controlType: 'select',
        stepMinute: 15,
        display59: false,
        timeFormat: 'HH:mm',
        value: '00:00'
    });
    $("#override_start_time").mask("99:99");
    $("#override_end_time").mask("99:99");
}

function newOverrideResourceClick(event) {
    preventDefaultAction(event);
    mode = "override_new";
    var jsonData = JSON.stringify({id: eventid});
    $.post("rest/appointment/logAddResourceOverride", {data: jsonData}, function (data) {
    });
    openOverrideDialog(0, mode);
    getSchedulingOptionsStaticList();

    $('.annotationsTable').css({display: "none"});
    $('#overrideWizardButtons input').css({width: "75px"});
}

function openOverrideDialog(bookedResourceId, mode) {
    override_widgets();
    $("#appt_bookedResource_update_dialog").dialog({
        modal: true,
        open: function () {
            $('body').css('overflow', 'hidden');
        },
        close: function () {
            $('body').css('overflow', 'scroll');
        },
        height: 650,
        width: 900,
        resizable: false
    });
    $('#overrideWizardButtons input').css({width: "75px"});

    var eventObj = $("#appt_calendar").fullCalendar('clientEvents', eventid)[0];

    $("#override_start_date").datepicker("option", "disabled", false);
    $("#override_end_date").datepicker("option", "disabled", false);

    if (!eventObj.inpatientVisitType) {
        $("#override_start_date").datepicker("option", "disabled", true);
        $("#override_end_date").datepicker("option", "disabled", true);
    }
    $('#wizard_addOverrideReasons').val('');

    if (mode == "override_new") {
        $("#appt_bookedResource_update_dialog").dialog('option', 'title', 'Add New Resource');

        document.getElementById("override_billable").checked = false;
        $.getJSON("rest/appointment/getBookedVisitData?bookedVisit=" + eventObj.id, function (data) {

            var addResourceStart = new Date(data.scheduledStartTime);
            $("#override_start_date").datepicker('setDate', addResourceStart);
            $("#override_start_time").datepicker('setTime', showTime(addResourceStart));

            var addResourceEnd = new Date(data.scheduledEndTime);
            $("#override_end_date").datepicker('setDate', addResourceEnd);
            $("#override_end_time").datepicker('setTime', showTime(addResourceEnd));
        });

    }
    else {
        $("#appt_bookedResource_update_dialog").dialog('option', 'title', 'Edit Resource');

        $.getJSON("rest/appointment/getBookedResourceData?id=" + bookedResourceId, function (data) {
            app_selectedBookedResource = data;
            var resourceId = data.resource.id;
            $("#allAnnotations").prop("checked", true);

            if (data.billable == true) {
                billableVal = true;
            }
            else {
                billableVal = false;
            }

            document.getElementById("override_billable").checked = billableVal;

            $.getJSON("rest/resource/getBookedResourceAnnotations?resourceId=" + data.id, function (data) {
                var responseData = data.annotationsStore;
                createAnnotationsTable(responseData);
            });

            $("#wizard_overrideResources").val(resourceId);
            var minOverrideDate = new Date(data.scheduledStartTime);
            var maxOverrideDate = new Date(data.scheduledEndTime);
            $("#override_start_date").datepicker('setDate', minOverrideDate);
            $("#override_start_time").datepicker('setTime', showTime(minOverrideDate));
            $("#override_end_date").datepicker('setDate', maxOverrideDate);
            $("#override_end_time").datepicker('setTime', showTime(maxOverrideDate));
        });
    }
}

function cancelOverrideClick() {
    $('#wizard_overrideResources').val('');
    $('body').css('overflow', 'scroll');
    $("#appt_bookedResource_update_dialog").dialog("close");
}

function initiateOverride() {
    var resourceId = $("#wizard_overrideResources").val();
    if (resourceId == "") {
        var confirmationMessage = "Please select a resource.";
        util_showMainMessage(confirmationMessage);
        return;
    }

    var overrideReason = $("#wizard_addOverrideReasons").val();
    if (overrideReason == "") {
        var confirmationMessage = "Please select an override reason.";
        util_showMainMessage(confirmationMessage);
        return;
    }
    var startTimeVal = $("#override_start_time").timepicker().val();
    var endTimeVal = $("#override_end_time").timepicker().val();
    if (startTimeVal == "") {
        util_showMainMessage("Please enter valid start time.");
        return;
    }

    if (endTimeVal == "") {
        util_showMainMessage("Please enter valid end time.");
        return;
    }

    startDateVal = $("#override_start_date").datepicker('getDate');
    endDateVal = $("#override_end_date").datepicker('getDate');
    if (startDateVal == null) {
        util_showMainMessage("Please enter valid start date.");
        return;
    }

    if (endDateVal == null) {
        util_showMainMessage("Please enter valid end date.");
        return;
    }

    if (endDateVal < startDateVal) {
        util_showMainMessage("Please enter valid end date greater than start date.");
        return;
    }

    startDateVal = setDateTime(startDateVal, startTimeVal);
    endDateVal = setDateTime(endDateVal, endTimeVal);

    if (startDateVal >= endDateVal) {
        util_showMainMessage("Please enter valid time range.");
        return;
    }
    crudOverrideResource();
}

function setDateTime(date, time) {
    var index = time.split(":");

    var hours = parseInt(index[0], 10);
    var minutes = parseInt(index[1], 10);

    date.setHours(hours);
    date.setMinutes(minutes);
    date.setSeconds(0);

    return date;
}

function crudOverrideResource() {
    $.blockUI();
    var id;
    var override_url;
    var confirmationMessage = "";
    if (mode == "override_new") {
        id = eventid;
        override_url = "rest/appointment/addBookedResourceOverride";
        confirmationMessage = "Resource Added to Visit.";
    }
    else {
        id = app_selectedBookedResource.id;
        override_url = "rest/appointment/editBookedResourceOverride";
        confirmationMessage = "Visit Resource Updated.";
    }

    var resourceId = $("#wizard_overrideResources").val();
    var overrideReason = $("#wizard_addOverrideReasons").val();

    var billable = null;
    if ($('#override_billable').is(':checked')) {
        billable = true;
    }
    else {
        billable = false;
    }

    var selectedAnnotationsId = [];
    var selectedAnnotationsQuantity = [];
    var selectedAnnotationsComment = [];

    $('#resourceAnnotationsData input[type=checkbox]:checked').each(function () {

        var row = $(this).parent().parent();
        var rowCells = row.find('td');
        var i = 0;
        rowCells.each(function () {
            if (i % 4 == 1) {
                selectedAnnotationsId.push($(this)[0].id);
            }
            else if (i % 4 == 2) {
                var quantity = $.trim($(this).html());
                selectedAnnotationsQuantity.push(parseInt(quantity));
            }
            else if (i % 4 == 3) {
                var comment = $.trim($(this).html());
                selectedAnnotationsComment.push(comment);
            }
            i++;
        });
    });

    var jsonData = JSON.stringify({
        id: id,
        resource: resourceId,
        billable: billable,
        startDate: startDateVal.valueOf(),
        endDate: endDateVal.valueOf(),
        overrideReason: overrideReason,
        selectedAnnotations: selectedAnnotationsId,
        selectedAnnotationsQuantity: selectedAnnotationsQuantity,
        selectedAnnotationsComment: selectedAnnotationsComment
    });

    $.post(override_url, {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);

        if (parsedData.result = true) {
            util_showMainMessage(confirmationMessage);
        }
        else {
            confirmationMessage = "There was an error in adding a resource.";
            util_showMainMessage(confirmationMessage);
        }
        $("#appt_bookedResource_update_dialog").dialog("close");
        resetCalendarOnCrud();
    });
}

function resetCalendarOnCrud() {
    initial_load = false;
    loadBookedResourcesData(1, eventid);
    searching_appointments = false;
    var home_check = JSON.parse(sessionStorage.getItem("home_cal"));
    var dayView = false;
    var startDate = new Date($("#appt_calendar").fullCalendar('getView').start);
    var endDate = new Date($("#appt_calendar").fullCalendar('getView').end);
    if (home_check == true) {
        dayView = true;
    }
    url = "rest/appointment/getCalendarBookedVisits?starting=" + startDate.getTime() + "&ending=" + endDate.getTime() + "&todayVisits=" + dayView + "&filterString=&filterId=";
    $.ajax({
        type: 'GET',
        url: url,
        data: {},
        success: function (data) {
            $('#appt_calendar').fullCalendar('removeEvents');
            $('#appt_calendar').fullCalendar('removeEventSource', data);
            $('#appt_calendar').fullCalendar('addEventSource', data);
            $.unblockUI();
        },
        error: function (xhr, status, error) {
            // check status && error
        },
        dataType: 'json',
        async: false
    });
}

function deleteBookedResourceClick() {
    $.blockUI();
    var overrideReasons = $.trim($('#wizard_deleteOverrideReasons').val());
    if (overrideReasons == null || overrideReasons == "") {
        util_showMainMessage("Please select an override reason.");
        return;
    }
    var jsonData = JSON.stringify({
        id: app_selectedBookedResource.id,
        overrideReason: (overrideReasons != "" ? overrideReasons : 0)
    });
    $.post("rest/appointment/deleteBookedResourceOverride", {data: jsonData}, function (data) {
        resetCalendarOnCrud();
        $("#appt_bookedResource_delete_dialog").dialog("close");
        var confirmationMessage = "Resource Successfully deleted.";
        util_showMainMessage(confirmationMessage);
        $('#wizard_deleteOverrideReasons').val('');
    });
}

// ##### switch subject ###############
function switchSubjectWizard() {
    editSearch = false;
    sessionStorage.setItem("filteredString", '');
    selectedStudy = null;
    selectedStudySubject = null;
    initial_load = true;

    $('#switchSubject_subjectFilterText').val("");
    $('#switchSubject_subjectFilterButton').attr("value", "Filter");

    resetUI();

    $('#switchSubject_div').css({display: "block"});

    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    $('#scheduledResourcesBlock').hide();

    loadSubjectData(currentPage, false, $('.dialog_study_id').text(), $('#switchSubject_StudySubjectData'));
    tableKey = switchSubjectTableKey;
}

function cancelSwitchSubject() {
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    $('#scheduledResourcesBlock').show();
    $('#switchSubject_div').css({display: "none"});
    resetToResourceTableView();
}

function switchSubjectSubmit() {
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});


    var assignSubjectMode = sessionStorage.getItem("assignSubjectMode");
    if (assignSubjectMode === "assign" && selectedStudySubject === null) {
        showError('#switchSubject_formValidation', 'Please select a subject');
        return;
    }
    else {
        var subjectNa = document.getElementById("switchSubject_noSubject").checked;
        if (selectedStudySubject == null && !subjectNa) {
            showError('#switchSubject_formValidation', 'Please select a subject or click Hold appointment without a subject.');
            return;
        }
    }

    $('#scheduledResourcesBlock').show();
    $('#switchSubject_subjectFilterButton').attr("value", "Filter");

    $('#switchSubject_div').css({display: "none"});

    if (subjectNa) {
        appt_selectedSubjectName = "No Subject Assigned";
        appt_selectedMrn = "N/A";
        appt_selectedSubjectMrnId = 0; // treated as null in resource layer
    }

    switchSubject(
        false,
        appt_selectedSubjectMrnId,
        eventid,
        handleConfirmedSwitchedSubject,
        handleConfirmationNeededForSwitchedSubject,
        handleAjaxError
    );

}

function loadSubjectData(currentPage, doCommon, studyId, subjectDataElement) {
    if (doCommon) {
        commonData();
    }

    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if (max_results == undefined) {
        max_results = 10;
    }

    var filterString = $.trim($("#appt_subjectFilterText").val());

    if (filterString == '') {
        filterString = sessionStorage.getItem("filteredString");
    }

    $.getJSON("rest/study/getStudySubjects?study=" + studyId + "&filterString=" + filterString + "&page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 10) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByApptStudySubjectLastName), function (data) {
        var iteration = 0;

        var sort_header;
        var mrn_header1 = 'sortable';
        var lastName_header2 = 'sortable';
        var firstName_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header = 'sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header = 'sorting_desc';
        }

        if (sortBy == sortByApptStudySubjectMRN) {
            mrn_header1 = sort_header;
        } else if (sortBy == undefined || sortBy == sortByApptStudySubjectLastName) {
            lastName_header2 = sort_header;
        } else if (sortBy == sortByApptStudySubjectFirstName) {
            firstName_header3 = sort_header;
        }

        appt_selectedStudy = studyId;

        $('.apptStudySubjectHeaderData').html("<table id='apptStudySubjectHeaderTable'> <thead> <tr>" +
            "   <th width='34%' class= " + lastName_header2 + " onclick='sortingFunction(sortByApptStudySubjectLastName, studySubjectsTableElementId)'>Last Name</th>" +
            "   <th width='33%' class= " + firstName_header3 + " onclick='sortingFunction(sortByApptStudySubjectFirstName, studySubjectsTableElementId)'>First Name</th>" +
            "   <th width='33%' class= " + mrn_header1 + " onclick='sortingFunction(sortByApptStudySubjectMRN, studySubjectsTableElementId)'>MRN</th>" +
            "  </tr> </thead> </table>");

        var out = " <table id='apptStudySubjectTable'> <tbody>";
        $('.dialog_study_name').text(appt_selectedStudyName);
        $('.dialog_study_pi').text(appt_selectedStudyInvestigatorName);
        totalData = data.totalCount;
        $.each(data.studySubject1s, function (key, val) {

            var fullName = "\"" + escapeQuotesHTML(val.subjectFirstName + " " + val.subjectLastName) + "\"";

            out += " <tr onclick='getSubjectSelectedRowId(" + val.subjectMrnId + ", " + fullName + ");'>";
            var tdClass = 'selectClass' + val.subjectMrnId;
            out += " <td width='34%' class=" + tdClass + ">" + val.subjectLastName + "</td>" +
                " <td width='33%' class=" + tdClass + ">" + val.subjectFirstName + "</td>" +
                " <td width='33%' class=" + tdClass + ">" + val.subjectMRN + "</td>" +
                " </tr>";
            iteration++;
        });

        out += " </tbody> </table>";

        setupTable(out, subjectDataElement,
            currentPage, totalData, $("#appt_subjectFilterText"));
    });
}

function switchSubject(isConfirmation,
                       subjectMrnId,
                       eventId,
                       handleSuccessfulSwitch,
                       handleWarnings,
                       handleAjaxError) {

    var homePage = "true" == sessionStorage.getItem("home_cal");
    var url = "rest/appointment/switchVisitSubject";
    if (isConfirmation) {
        url += "?confirm=true";
    }
    else {
        url += "?confirm=false";
        ;
    }
    url +=
        "&newSubjectMrnId=" + subjectMrnId +
        "&visitId=" + eventid +
        "&className=" + "Scheduled" + // how to get value dynamically?
        "&homeScreen=" + homePage +
        "";

    $.ajax({
        type: 'GET',
        url: url,
        data: {},
        success: function (data) {
            $.unblockUI();
            if (data.result) {
                //reset dialog display values HERE; if there are no warnings
                $('.dialog_subject_name_detail').text(appt_selectedSubjectName);
                $('.dialog_subject_mrn_detail').text(appt_selectedMrn);

                dialog_subject_name_detail = data.fullName;
                var visitSummary = data.visitSummary;
                // need to override inherited (wrong-value) members
                visitSummary.end = visitSummary.endDate;
                visitSummary.start = visitSummary.startDate;
                handleSuccessfulSwitch(data);

            } else {
                handleWarnings(data);
            }
        },
        error: function (xhr, status, error) {
            // check status && error
            handleAjaxError();
        },
        dataType: 'json',
        async: false
    });
}


function handleGenderBlockForNewVisit(data) {

    doubleSharedRoom = data.doubleSharedRoom;
    alternateResourceUsed = data.alternateResourceUsed;
    confirmationStatus = data.confirmationStatus;
    if (doubleSharedRoom == null) {
        if (confirmationStatus == "true") {
            if (alternateResourceUsed != null) {
                alert(alternateResourceUsed);
            }
            util_showMainMessage("The appointment has been Scheduled");
            scheduleComment = null;
            searching_appointments = false;
            $("#appt_wizard_searchedDetails").dialog("close");
        }
        else {
            alert("Sorry, one or more of the resources for this appointment became unavailable during the confirmation process. Please try your search again and look for alternate times.");
            scheduleComment = null;
            searching_appointments = false;
            $("#appt_wizard_searchedDetails").dialog("close");
        }
    }
    else {
        if (user.institutionRole.id == STUDY_STAFF) {
            alert("There is already a patient of a different or unknown gender booked into this room. Please contact your site administrator if you want to schedule this subject into this room.");
        }
        else {
            showGenderBlockDialogForNewAppointment();
        }
    }

}


function handleConfirmationNeededForSwitchedSubject(data) {

    if (user.institutionRole.id == STUDY_STAFF) {
        alert("There is already a patient of a different or unknown gender booked into this room. Please contact your site administrator if you want to schedule this subject into this room.");
    }
    else {
        showConfirmationDialogForSwitchedSubject(data.newSubjectMrnId, data.genderBlockWarning, data.doubleBookingWarning);
    }

}


function handleConfirmedSwitchedSubject(data) {
    openBookedResourcesAppointmentWindow(className);
    reRenderEvent(data.visitSummary, "The Subject of the visit is now " + data.fullName, function () {
        scheduleComment = null;
        searching_appointments = false;

        resetToResourceTableView();
        $("#appt_wizard_searchedDetails").dialog("close");
    });
}


function resetToResourceTableView() {
    tableKey = resourceTableKey;

    resetUI();
    loadDataForRespectivePage();
}

function handleCouldNotConfirmSwitchSubject(data) {
    alert('An internal error prevented the subject to be switched. Please contact a system administrator.');
}


function handleAjaxError() {
    alert('An error prevented communication with the Server. Please try again or contact a system administrator.')
}
