/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

function onloadAppointmentDetail()
{
    renderBreadcrumbs("appt_detail");

    loadMetaHeaders();
    $("#fullHeader").load("common/header.html", function () {

        $('.appointmentslink').addClass('active');
        app_runIdleTimer();
        commonData();
        apptBatchData();

    });
}

function appointment_viewStack(screen) {
    initFooter();
    switch (screen) {
        case 'appointment_main_screen':
            $('.calenderTab').css({display: "block"});
            $("#displaySelected").val(1);
            $("#filterSelected").val(0);
            $("#appointmentfilterString").val('');
            appointmentModuleRoles();
            $('.formTextSmallerFilter').css({display: "none"});
            $('#appointment_filterButton').css({display: "none"});
            $('#appointment_main_screen').css({display: "block"});
            $('#appointment_list_view').css({display: "none"});
            $('#appointment_form_screen').css({display: "none"});

            if (start != null) {
                start = null;
            }

            if (view != null) {
                view = null;
            }

            if (calendar_rendered == false) {
                $('#initial_loading').css({display: 'block'});
                var starts = null;
                var ends = null;
                var yourDate = new Date();
                starts = new Date(yourDate.getFullYear(), yourDate.getMonth(), 1);
                ends = new Date(yourDate.getFullYear(), yourDate.getMonth() + 1, 0, 23, 59, 59, 59);
                url = 'rest/appointment/getCalendarBookedVisits?starting=' + starts.getTime() + '&ending=' + ends.getTime() + '&todayVisits=false' + '&filterString=' + calendarFilterString + '&filterId=' + calendarSelectedFilterId;
                apptDoSearch(url, false);
            }
            eventid = sessionStorage.getItem("eventid");
            if (eventid != null && eventid != "") {
                $('.formTextAreaSmaller').css({display: "block"});
                $("#wizard_comment").val('');
                $("#checkoutWizard_comment").val('');
                eventid = sessionStorage.getItem("eventid");
                start = sessionStorage.getItem("selected_start");
                end = sessionStorage.getItem("selected_end");
                setParametersCalendarEventClick(eventid, start, end);
                className = sessionStorage.getItem("className");
                openBookedResourcesAppointmentWindow(className);
                sessionStorage.setItem("eventid", "");
            }
            setTimeout(function () {
                if (/\/appt_calendar.html#SubjectSearchAvailability$/.test(window.location.href)) {
                    $("#appt_wizard_screen").dialog({modal: true, close: dialogCloseFunction, height: 750, width: 720});
                    $('#appt_wizard_screen').css({display: "block"});
                    apptNextWizardClick('appt_wizard_form2');
                }
            }, 1000);

            break;
        case 'appointment_list_view':
            $("#apptStartGoToDate").datepicker("setDate", new Date());
            $('.calendarTab').css({display: "block"});
            $("#displaySelected").val(2);
            $("#filtersSelected").val(0);
            $("#apptlist_filters_string").val('');
            $('.formTextSmallerFilters').css({display: "none"});
            $('#appointmentlist_filterButton').css({display: "none"});
            $('#appointment_main_screen').css({display: "none"});
            $('#appointment_list_view').css({display: "block"});
            $('#appointment_form_screen').css({display: "none"});
            initial_load = true;
            resetUI();
            var prevPage = sessionStorage.getItem("apptListSelectedPage");
            if (prevPage != "null" && prevPage != null) {
                initial_load = false;
                currentPage = prevPage;
                max_results = sessionStorage.getItem("apptListSelectedMaxResults");
                sessionStorage.setItem("apptListSelectedPage", currentPage);
            }
            loadAppointmentBookedVisitsList(currentPage, initial_load);
            break;
        case 'appointment_form_screen':
            $('.calendarTab').css({display: "block"});
            $("#displaySelected").val(2);
            $('#appointment_main_screen').css({display: "none"});
            $('#appointment_list_view').css({display: "none"});
            $('#appointment_form_screen').css({display: "block"});
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == SCHEDULER) {
                $('#appointmentOverbookView').css({display: "inline"});
            }
            else {
                $('#appointmentOverbookView').css({display: "none"});
            }
            search_createWidgets();
            break;
    }
}

function appt_wizard_viewStack(screen) {
    appt_currentWizardScreen = screen;
    switch (screen) {
        case 'appt_wizard_form1':
            window.location.hash = "#StudySearchAvailability";
            $('#appt_studyFilterButton').attr("value", "Filter");
            $('#appt_filter_functionality').css({visibility: "visible"});
            $("#appt_studyFilterText").val('');
            $('#appt_wizard_form1').css({display: "block"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_form-prev').css({display: "none"});
            $('#appt_wizard_form-next').css({display: "inline-block"});

            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Next");
            $('#appt_wizard_overbook_room').css({display: "none"});
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            break;
        case 'appt_wizard_form2':
            window.location.hash = "#VisitSearchAvailability";
            $('#appt_visitFilterButton').attr("value", "Filter");
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "visible"});
            $("#appt_visitFilterText").val('');
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "block"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_form-prev').css({display: "inline-block"});
            $('#appt_wizard_form-next').css({display: "inline-block"});

            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Next");
            $('#appt_wizard_overbook_room').css({display: "none"});
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            break;
        case 'appt_wizard_form3':
            window.location.hash = "#SubjectSearchAvailability";
            if (UserRoleUtil.userIsCrcStaff()) {
                $('.holdDiv').show();
            }
            else {
                $('.holdDiv').hide();
            }
            $('#appt_filterButton3').attr("value", "Filter");
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "visible"});
            $("#appt_filterSelect3").html('');
            $("#appt_filterText3").val('');
            var html = [];
            html[html.length] = "<option value='selectone3'>Select One</option>";
            html[html.length] = "<option value='subject_mrn'>MRN</option>";
            html[html.length] = "<option value='subject_name'>Subject Last Name</option>";
            var result = html.join('');
            $("#appt_filterSelect3").html(result);
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "block"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_overbook_room').css({display: "none"});
            $('#appt_wizard_form-prev').css({display: "inline-block"});
            $('#appt_wizard_form-next').css({display: "inline-block"});

            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Next");
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            break;
        case 'appt_wizard_form4':
            window.location.hash = "#SearchAppointment";
            document.getElementById("weeklyCheckboxes").style.display = "none";
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "hidden"});
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "block"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_overbook_room').css({display: "none"});
            
            if (editSearch) {
                $('#appt_wizard_form-prev').css({display: "none"});
            }
            else {
                $('#appt_wizard_form-prev').css({display: "inline-block"});
            }
            $('#appt_wizard_form-next').css({display: "inline-block"});
            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Next");
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER || user.institutionRole.id == SCHEDULER) {
                $('#appt_wizard_form-overbook').css({display: "inline-block"});
                $('#appt_wizard_form_overbook_room').css({display: "inline-block"});
            }
            else if (user.institutionRole.id == STUDY_STAFF) {
                $('#appt_wizard_form_overbook_room').css({display: "none"});
                $('#appt_wizard_form-overbook').css({display: "none"});
            }
            else {
                $('#appt_wizard_form_overbook_room').css({display: "none"});
                $('#appt_wizard_form-overbook').css({display: "none"});
            }
            if ((appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3)) {
                document.getElementById("weeklyCheckboxes").style.display = "inline-block";
            }
            break;
        case 'appt_wizard_form5':
            window.location.hash = "#ReviewTemplateResources";
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "hidden"});
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "block"});
            $('#appt_wizard_overbook_room').css({display: "none"});
            $('#appt_wizard_form-prev').css({display: "inline-block"});
            $('#appt_wizard_form-next').css({display: "inline-block"});
            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').attr("value", "Search Availability");
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            if (editSearch) {
                $('#appt_wizard_form-restart').css({display: "none"});
            }
            else {
                $('#appt_wizard_form-restart').css({display: "inline-block"});
            }
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            break;
        case 'appt_wizard_overbook_room':
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "hidden"});
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_overbook_room').css({display: "block"});
            if (editSearch) {
                $('#appt_wizard_form-prev').css({display: "none"});
            }
            else {
                $('#appt_wizard_form-prev').css({display: "inline-block"});
            }
            $('#appt_wizard_form-prev').attr("value", "Previous");
            $('#appt_wizard_form-next').css({display: "inline-block"});
            $('#appt_wizard_form-next').attr("value", "Next");
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            $('#appt_wizard_overbookRoomSubmit').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            break;
        case 'appt_wizard_overbookRoomSubmit':
            $('#appt_filter_functionality').css({visibility: "hidden"});
            $('#appt_filter_functionality2').css({visibility: "hidden"});
            $('#appt_filter_functionality3').css({visibility: "hidden"});
            $('#appt_wizard_form1').css({display: "none"});
            $('#appt_wizard_form2').css({display: "none"});
            $('#appt_wizard_form3').css({display: "none"});
            $('#appt_wizard_form4').css({display: "none"});
            $('#appt_wizard_form5').css({display: "none"});
            $('#appt_wizard_overbook_room').css({display: "none"});
            $('#appt_wizard_overbookRoomSubmit').css({display: "block"});
            $('#appt_wizard_form-prev').css({display: "inline-block"});
            $('#appt_wizard_form-next').css({display: "inline-block"});
            $('#appt_wizard_form-next').attr("value", "Reserve Visit");
            $('#appt_wizard_form_overbook_room').css({display: "none"});
            $('#appt_wizard_form-overbook').css({display: "none"});
            $('#appt_wizard_form-restart').css({display: "none"});
            break;
    }
}

function startOverbookingAppointment() {

    $('.formElementRequired').css({visibility: "hidden"});
    switch (appt_currentWizardScreen) {
        case 'appt_wizard_form4':
            $('.formTextAreaSmaller').css({display: "block"});
            appt_wizard_viewStack('appt_wizard_overbook_room');
            overbookRoom_widgets();
            $("#overbookRoom_startDate").datepicker('setDate', new Date());
            $('#overbookRoom_startTime').css({display: "inline-block"});
            $("#overbookRoom_startTime").datepicker('setTime', '07:00');
            minDate = "+0M +0D";

            if ((appt_selectedVisitType == 4 || appt_selectedVisitType == 5 || appt_selectedVisitType == 6)
                && (appt_selectedVisitRelative == false)) {
                $('#overbookRoom_startTime').css({display: "none"});
            }
            if (roomResources == undefined || roomResources == null || roomResources == '') {
                $('#allrooms_appointment').css({visibility: "hidden"});
                document.getElementById('appointment_allrooms').style.display = 'none';

                $('#appt_wizard_form-prev').attr("value", "Previous");
                $('#appt_wizard_form-next').attr("value", "Reserve Visit");
            }
            else {
                $('#allrooms_appointment').css({visibility: "visible"});
                document.getElementById('appointment_allrooms').style.display = 'block';
                $('#appt_wizard_form-prev').attr("value", "Previous");
                $('#appt_wizard_form-next').attr("value", "Next");
            }
            break;
    }
}

function calendarViewChangeClick() {
    if ($("#displaySelected").val() == 1) {
        appointmentModule();
        appointmentModuleRoles();
    }
    else {
        sessionStorage.setItem("apptListSelectedMaxResults", 50);
        sessionStorage.setItem("apptListSelectedPage", "null");
        appointmentListModule();
    }
}

function apptListDateChangeClick() {
    $("#apptStartGoToDate").datepicker("destroy");
    $("#apptEndGoToDate").datepicker("destroy");
    if ($("#displayDateSelected").val() == 1) {
        createApptDatePicker();
    }
    else {
        createApptDateRangePicker();
    }
}

var calendarFilterString = '';
var calendarSelectedFilterId = '';
function filterCalendarViewChangeClick() {
    if ($("#filterSelected").val() == 1) {
        $('#appointment_filterButton').css({display: "inline"});
        $('#appointment_filterButton').attr("value", "Filter");
        $('.formTextSmallerFilter').css({display: "inline"});
        calendarSelectedFilterId = 6;
    }
    else if ($("#filterSelected").val() == 2) {
        $('#appointment_filterButton').css({display: "inline"});
        $('.formTextSmallerFilter').css({display: "inline"});
        $('#appointment_filterButton').attr("value", "Filter");
        calendarSelectedFilterId = 7;
    }
    else if ($("#filterSelected").val() == 3) {
        $('#appointment_filterButton').css({display: "inline"});
        $('.formTextSmallerFilter').css({display: "inline"});
        $('#appointment_filterButton').attr("value", "Filter");
        calendarSelectedFilterId = 8;
    }
    else if ($("#filterSelected").val() == 4) {
        $('#appointment_filterButton').css({display: "inline"});
        $('.formTextSmallerFilter').css({display: "none"});
        $('#appointment_filterButton').attr("value", "Filter");
        calendarSelectedFilterId = 1;
    }
    else if ($("#filterSelected").val() == 5) {
        $('#appointment_filterButton').css({display: "inline"});
        $('.formTextSmallerFilter').css({display: "none"});
        $('#appointment_filterButton').attr("value", "Filter");
        calendarSelectedFilterId = 2;
    }
    else if ($("#filterSelected").val() == 6) {
        $('#appointment_filterButton').css({display: "inline"});
        $('.formTextSmallerFilter').css({display: "none"});
        $('#appointment_filterButton').attr("value", "Filter");
        calendarSelectedFilterId = 3;
    }
    else if ($("#filterSelected").val() == 7) {
        $('#appointment_filterButton').css({display: "inline"});
        $('#appointment_filterButton').attr("value", "Filter");
        $('.formTextSmallerFilter').css({display: "none"});
        calendarSelectedFilterId = 4;
    }
    else if ($("#filterSelected").val() == 8) {
        $('#appointment_filterButton').css({display: "inline"});
        $('#appointment_filterButton').attr("value", "Filter");
        $('.formTextSmallerFilter').css({display: "none"});
        calendarSelectedFilterId = 5;
    }
    else if ($("#filterSelected").val() == 0) {
        $('#appointment_filterButton').css({display: "none"});
        $('.formTextSmallerFilter').css({display: "none"});
        return;
    }
}

function filterCalendarViewClick() {
    searching_appointments = true;
    filterCalendar = true;
    view = $('#appt_calendar').fullCalendar('getView');
    var yourDate = moment(view.intervalStart.format()).toDate();
    $("#apptCalendarGoToDate").datepicker("setDate", yourDate);
    var starts = new Date(yourDate.getFullYear(), yourDate.getMonth(), 1);
    var ends = new Date(yourDate.getFullYear(), yourDate.getMonth() + 1, 0, 23, 59, 59, 59);

    if (calendarSelectedFilterId == 0) {
        $('#appointment_filterButton').css({display: "none"});
    }
    calendarFilterString = $.trim($("#appointmentfilterString").val());
    if (calendarSelectedFilterId == 6 || calendarSelectedFilterId == 7 || calendarSelectedFilterId == 8) {
        if (calendarFilterString == null || calendarFilterString == '') {
            util_showMainMessage("Please Enter the Filter Value.", "", "red");
            return;
        }
    }
    url = 'rest/appointment/getCalendarBookedVisits?starting=' + starts.getTime() + '&ending=' + ends.getTime() + '&filterString=' + calendarFilterString + '&filterId=' + calendarSelectedFilterId + '&todayVisits=false';
    $('#filter_loading').css({display: 'block'});
    apptDoSearch(url, false);
}

function calendarListViewChangeClick() {
    if ($("#filtersSelected").val() == 1) {
        $('#appointmentlist_filterButton').css({display: "inline"});
        $('#appointmentlist_filterButton').attr("value", "Filter");
        $('.formTextSmallerFilters').css({display: "inline"});
        selected = 1;
    }
    else if ($("#filtersSelected").val() == 2) {
        $('#appointmentlist_filterButton').css({display: "inline"});
        $('.formTextSmallerFilters').css({display: "inline"});
        $('#appointmentlist_filterButton').attr("value", "Filter");
        selected = 2;
    }
    else if ($("#filtersSelected").val() == 3) {
        $('#appointmentlist_filterButton').css({display: "inline"});
        $('.formTextSmallerFilters').css({display: "inline"});
        $('#appointmentlist_filterButton').attr("value", "Filter");
        selected = 3;
    }
    else if ($("#filtersSelected").val() == 0) {
        $('#appointmentlist_filterButton').css({display: "none"});
        $('.formTextSmallerFilters').css({display: "none"});
        $("#filtersSelected").val(0);
        $("#apptlist_filters_string").val('');
        return;
    }
}

function filterCalendarListViewClick() {
    var search_string = $.trim($("#apptlist_filters_string").val());

    if (selected == 1 || selected == 2 || selected == 3) {
        if (search_string == null || search_string == '') {
            util_showMainMessage("Please Enter the Filter Value.", "", "red");
            $('#appointmentlist_filterButton').css({display: "none"});
            $('.formTextSmallerFilters').css({display: "none"});
            selected = 0;
            $("#filtersSelected").val(0);
            $("#apptlist_filters_string").val('');
            return;
        }
    }

    if (selected == 0) {
        $('#appointmentlist_filterButton').css({display: "none"});
        search_string = "";
        selected = 0;
        currentPage = 1;
        loadAppointmentBookedVisitsList(currentPage, initial_load);
    }
    else {
        currentPage = 1;
        loadAppointmentBookedVisitsList(currentPage, initial_load);
    }
}

function resetCalendarListViewClick() {
    $('.formTextSmallerFilters').css({display: "none"});
    selected = 0;
    $("#filtersSelected").val(0);
    $("#apptlist_filters_string").val('');
    $('#appointmentlist_filterButton').css({display: "none"});
    search_string = "";
    selectedEndDate = showDate(new Date());
    currDate = '';
    initial_load = true;
    $("#apptStartGoToDate").datepicker("setDate", new Date());
    $("#apptEndGoToDate").datepicker("option", "minDate", new Date());
    $("#apptEndGoToDate").datepicker("setDate", new Date());
    resetUI();
    currentPage = 1;
    loadAppointmentBookedVisitsList(currentPage, initial_load);
}

function resetCalendarViewClick() {
    searching_appointments = true;
    calendarFilterString = '';
    calendarSelectedFilterId = '';
    var yourDate = new Date();
    var starts = new Date(yourDate.getFullYear(), yourDate.getMonth(), 1);
    var ends = new Date(yourDate.getFullYear(), yourDate.getMonth() + 1, 0, 23, 59, 59, 59);
    var url = "rest/appointment/getCalendarBookedVisits?starting=" + starts.getTime() + "&ending=" + ends.getTime() + "&todayVisits=false&filterString=&filterId=";
    apptDoSearch(url, false);
    $("#apptCalendarGoToDate").datepicker("setDate", yourDate);
    $('#appointment_filterButton').css({display: "none"});
    $('.formTextSmallerFilter').css({display: "none"});
    $("#filterSelected").val(0);
    $("#appointmentfilterString").val('');
    $('#appt_wizard_changeAppointmentSearch').css({display: "none"});
    searching_appointments = false;
}

function closeSearchedDetailsClick() {
    eventid = null;
    studyName = null;
    subjectName = null;
    studyVisit = null;
    studyVisitTime = null;
    studyPI = null;
    $("#appt_wizard_searchedDetails").dialog("close");
}

function overbookRoom_widgets() {
    WidgetUtil.createDatepicker("#overbookRoom_startDate", {
        onClose: function (dateText, inst) {
            try {
                $.datepicker.parseDate('mm/dd/yy', dateText);
            } catch (e) {
                alert("Incorrect Date format. It should be MM/DD/YYYY.");
                $("#overbookRoom_startDate").val('');
                return;
            }
        }
    });

    $('#overbookRoom_startTime').timepicker({
        controlType: 'select',
        timeFormat: 'h:mm tt',
        minuteMax: 59,
        stepMinute: 15,
        ampm: true
    });
}

function setInitialTime(picker) {
    if (picker == 1) {
        if ($('#checkin_time').val() == '') {
            $('#checkin_time').val('12:00 am');
            $('#checkin_time').timepicker('setTime', "12:00 am");
        }
    }
    else if (picker == 2) {
        if ($('#checkout_time').val() == '') {
            $('#checkout_time').val('12:00 am');
            $('#checkout_time').timepicker('setTime', "12:00 am");
        }
    }
    else {
        if ($('#cancel_time').val() == '') {
            $('#cancel_time').val('12:00 am');
            $('#cancel_time').timepicker('setTime', "12:00 am");
        }
    }
}

function search_createWidgets() {
    WidgetUtil.createDatepicker("#checkin_date", {
    });
    $('#checkin_time').timepicker({
        timeFormat: 'hh:mm tt',
        ampm: true,
        onClose: function (format, timeStr, options) {
            try {
                if (format != '') {
                    var time = $.datepicker.parseTime('hh:mm tt', format);
                    if (time == false) {
                        alert("Incorrect Time format. It should be hh:mm tt.");
                        $("#checkin_time").val('');
                        return;
                    }
                }
            } catch (e) {
                alert("Incorrect Time format. It should be hh:mm tt.");
                $("#checkin_time").val('');
                return;
            }
            ;
        }
    });
    WidgetUtil.createDatepicker("#checkout_date", {
    });
    $('#checkout_time').timepicker({
        timeFormat: 'hh:mm tt',
        ampm: true,
        onClose: function (format, timeStr, options) {
            try {
                if (format != '') {
                    var time = $.datepicker.parseTime('hh:mm tt', format);
                    if (time == false) {
                        alert("Incorrect Time format. It should be hh:mm tt.");
                        $("#checkout_time").val('');
                        return;
                    }
                }
            } catch (e) {
                alert("Incorrect Time format. It should be hh:mm tt.");
                $("#checkout_time").val('');
                return;
            }
            ;
        }
    });
    WidgetUtil.createDatepicker("#cancel_date");
    $('#cancel_time').timepicker({
        timeFormat: 'hh:mm tt',
        ampm: true,
        onClose: function (format, timeStr, options) {
            try {
                if (format != '') {
                    var time = $.datepicker.parseTime('hh:mm tt', format);
                    if (time == false) {
                        alert("Incorrect Time format. It should be hh:mm tt.");
                        $("#cancel_time").val('');
                        return;
                    }
                }
            } catch (e) {
                alert("Incorrect Time format. It should be hh:mm tt.");
                $("#cancel_time").val('');
                return;
            }
            ;
        }
    });
}

function appt_checkOverBookRoom() {
    $.blockUI();
    overbookRoomSelected = null;
    overbookRoomSelectedId = null;
    $('.dialog_room_selected').text('');
    searching_appointments = false;
    overbook_startdateVal = $("#overbookRoom_startDate").val();
    overbook_starttimeVal = $("#overbookRoom_startTime").timepicker().val();

    var overbook_startdateTimeVal = overbook_startdateVal + ' ' + overbook_starttimeVal;
    overbook_startdateVal = new Date(overbook_startdateTimeVal);

    overrideRoomReasons = $.trim($('#wizard_overbookReasonsRoom').val());
    overrideRoomComment = $("#overbookWizard_roomcomment").val();

    if (overrideRoomReasons == null || overrideRoomReasons == "") {
        var confirmationMessage = "Please select an override reason.";
        util_showMainMessage(confirmationMessage, "", "red");
        return;
    }

    var roomSelected = $.trim($('#appointment_allrooms').val());

    if (roomSelected == '') {
        roomSelected = 0;
    }
    $('#appt_wizard_form-next').css({display: "none"});
    $('#appt_responseLoading').css({display: "inline-block"});
    var jsonData = JSON.stringify({
        study: (appt_selectedStudy != null ? appt_selectedStudy : 0),
        subjectMrnId: (appt_selectedSubjectMrnId != null ? appt_selectedSubjectMrnId : 0),
        visit: (appt_selectedVisit != null ? appt_selectedVisit : 0),
        startDate: overbook_startdateVal.valueOf(),
        startTime: overbook_startdateVal.valueOf(),
        overrideReason: overrideRoomReasons,
        roomSelected: (roomSelected != "" ? roomSelected : 0),
        comment: $.trim($("#overbookWizard_comment").val())
    });

    $.post("rest/appointment/overbookRoomSelected", {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);
        overbookRoomSelected = parsedData.overbookRoomSelected;
        overbookRoomSelectedId = parsedData.overbookRoomSelectedId;
        $('.dialog_room_selected').text(overbookRoomSelected);
        $('#appt_responseLoading').css({display: "none"});
        appt_wizard_viewStack('appt_wizard_overbookRoomSubmit');
        $('#appt_wizard_form-prev').attr("value", "Previous");
        if (overbookRoomSelectedId == undefined) {
            $('#appt_wizard_form-next').css({display: "none"});
        }
        else {
            $('#appt_wizard_form-next').css({display: "inline-block"});
        }
        $.unblockUI();
        $('#appt_wizard_form-next').css({width: "115px"});
        $('#appt_wizard_form-next').attr("value", "Reserve Visit");
    });
}

function appt_overBookRoomAppointment() {
    $.blockUI();
    searching_appointments = true;

    overbook_startdateVal = $("#overbookRoom_startDate").val();
    overbook_starttimeVal = $("#overbookRoom_startTime").timepicker().val();

    var overbook_startdateTimeVal = overbook_startdateVal + ' ' + overbook_starttimeVal;
    overbook_startdateVal = new Date(overbook_startdateTimeVal);

    overrideRoomReasons = $.trim($('#wizard_overbookReasonsRoom').val());
    overrideRoomComment = $("#overbookWizard_roomcomment").val();

    var roomSelected = $.trim($('#appointment_allrooms').val());

    if (roomSelected == '') {
        roomSelected = 0;
    }
    if (overrideRoomReasons == null || overrideRoomReasons == '') {
        var confirmationMessage = "Please select an override reason.";
        util_showMainMessage(confirmationMessage, "", "red");
        return;
    }

    $('#appt_wizard_form-next').css({display: "none"});
    var jsonData = JSON.stringify({
        study: (appt_selectedStudy != null ? appt_selectedStudy : 0),
        subjectMrnId: (appt_selectedSubjectMrnId != null ? appt_selectedSubjectMrnId : 0),
        visit: (appt_selectedVisit != null ? appt_selectedVisit : 0),
        startDate: overbook_startdateVal.valueOf(),
        startTime: overbook_startdateVal.valueOf(),
        overrideReason: overrideRoomReasons,
        roomSelected: overbookRoomSelectedId,
        comment: overrideRoomComment
    });

    $.post("rest/appointment/overbookRoomAppointment", {data: jsonData}, function (data) {
        var parsedData = $.parseJSON(data);
        $('#appt_calendar').fullCalendar('addEventSource', parsedData);
        $('#appt_calendar').fullCalendar('gotoDate', $("#overbookRoom_startDate").datepicker('getDate'));
        $('#loading').css({display: 'none'});
        $('#filter_loading').css({display: 'none'});
        $("#appt_wizard_screen").dialog("close");
        $.unblockUI();
        $("#overbookWizard_roomcomment").val('');
        $('#wizard_overbookReasonsRoom').val('');
        util_showMainMessage("Visit Reserved.", "", "blue");
        $('#appt_wizard_form-next').css({display: ''});
    });
}

//This specifies a name for this piece of code which will appear when debugging
//This is needed because this file is loaded programatically
//# sourceURL=appointment_screen.js