/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var selectedCheckboxes =  new Map();
var SchedulerTables = function() {
};

SchedulerTables.getSelectedCheckboxes = function (tableId) {
    return selectedCheckboxes.get(tableId);
};

SchedulerTables.clearSelectedCheckboxes =  function (tableId) {
    selectedCheckboxes.set(tableId, new Array());
};

SchedulerTables.addSelectedCheckbox = function(tableId, value) {
    if (selectedCheckboxes.get(tableId)) {
        selectedCheckboxes.get(tableId).push(value);
    }
    else {
        selectedCheckboxes.set(tableId, new Array());
        selectedCheckboxes.get(tableId).push(value);
    }
};

SchedulerTables.setSelectedCheckboxes = function (tableId, arrayOfSelected) {
    selectedCheckboxes.set(tableId, arrayOfSelected);
};

function Column(sortingFunction, columnName, width, headerClass, rowElementClassName, extractDataFunction,
                onClickFunction, defaultAscOrDesc, rowElementHyperLink, isCheckBoxCol) {
    this.sortingColumnFunction = sortingFunction;
    this.columnName = columnName;
    this.columnWidth = width;
    this.headerClass = headerClass;
    this.rowElementClass = rowElementClassName;
    this.extractDataFunction = extractDataFunction;
    this.onclickFunctionString = onClickFunction;
    this.defaultAscOrDesc = defaultAscOrDesc;
    this.rowElementHyperLink = rowElementHyperLink;
    this.isCheckBoxCol = isCheckBoxCol;

    this.getSortingFunction = function() {
        if (this.sortingColumnFunction) {
            return ' onclick=' + this.sortingColumnFunction + ";";
        }
        else {
            return false;
        }
    };

    this.isSortable = function() {
        if (this.defaultAscOrDesc === 'DESC') {
            return "class= 'sorting_desc ";

        }
        else if (this.defaultAscOrDesc) {
            return "class= 'sorting_asc ";
        }
        else if (this.sortingColumnFunction) {
            return "class= 'sortable ";
        }
        else {
            return "class= 'not_sortable ";
        }
    };

    this.getColumnName = function() {
        if (this.columnName) {
            return "<strong>" + this.columnName + "</strong>";
        }
        else {
            return "";
        }
    };

    this.getHeaderClass = function() {
        if (this.headerClass) {
            return "" + this.headerClass + "";
        }
        else {
            return "";
        }
    };

    this.getRowElementClass = function(tableId) {
        var returnString = "";
        if (this.rowElementClass || this.isCheckbox()) {
            returnString = "class= " + this.rowElementClass;
            if (this.isCheckbox() && tableId !== undefined) {
                returnString += " " + tableId + "-checkbox";
            }
            return returnString;
        }
        else {
            return returnString;
        }
    };

    this.getColumnWidth = function() {
        if (this.columnWidth) {
            return " width=' " + this.columnWidth + "%' ";
        }
        else {
            return "";
        }
    };

    this.getExtractDataFunction = function(value) {
        if (this.extractDataFunction) {
            return this.extractDataFunction(value);

        }
        else {
            return value;
        }
    };

    this.getOnclickFunctionString = function() {
        if (this.onclickFunctionString) {
            return " onclick= '"+ this.onclickFunctionString + "' ";
        }
        else {
            return "";
        }
    };

    this.isRowElementHyperLink = function() {
        return this.rowElementHyperLink !== undefined;
    };

    this.getRowElementHyperLink = function (args) {
        if (this.rowElementHyperLink) {
            return "href='javascript:" + this.rowElementHyperLink(args) + "'";
        }
        else {
            return false;
        }
    };

    this.isCheckbox = function () {
        return this.isCheckBoxCol === true;
    };

    this.getCheckboxValues= function(rawValue, tableId, currentSelected) {
        var value = this.extractDataFunction(rawValue);
        var returnString = ' value=' + value;
        if ($.inArray(value, SchedulerTables.getSelectedCheckboxes(tableId)) != -1) {
            currentSelected.push(value);
            returnString += ' checked';
        }
        return returnString;
    };

}

SchedulerTables.generateTable = function(data, tableId, arrayColumns) {
    var currentSelected = new Array();
    var outputHTML = SchedulerTables.createTableHeader(arrayColumns, tableId);
    var totalData = SchedulerTables.createTableBody(outputHTML, data, tableId, arrayColumns, currentSelected);
    SchedulerTables.reselectCheckboxes(tableId, totalData, currentSelected);
    SchedulerTables.createPagination(totalData);
};

SchedulerTables.createTableHeader = function(arrayColumns, tableId) {
    var outputHTML = '<tr>';
    $.each(arrayColumns, function (indexOfThis, column) {
        // TODO: alternate the quotes not explicit escape
        if (column.isCheckbox()) {
            outputHTML += "<td><input type=\"checkbox\" id=\"" + tableId +
                "-selectAll\" onclick=\"SchedulerTables.toggleAllCheckBoxes(this, '" + tableId + "');\"></td>";
        }
        else {
            outputHTML += '<td ' + column.getColumnWidth() + column.isSortable() + column.getHeaderClass() + "'" +
                column.getSortingFunction() + '>' + column.getColumnName() + '</td>';
        }
    });
    outputHTML += '</tr>';
    return outputHTML
};

SchedulerTables.createTableBody = function(outputHTML, data, tableId, arrayColumns, currentSelected) {

    if (data.length === 0) {
      totalData = 0;
    }

    $.each(data, function (key, val) {
        totalData = val.totalCount;

        outputHTML += "<tr class= '" + tableId + "-tableRow'>";

        $.each(arrayColumns, function (indexOfThis, column) {
            if (column.isRowElementHyperLink()) {
                outputHTML += "<td" + column.getRowElementClass(val) + "><a " + column.getRowElementHyperLink(val) +
                    ">" + column.getExtractDataFunction(val) + "</a>" + "</td>";
            }
            else if (column.isCheckbox()) {
                outputHTML += "<td><input type=\"checkbox\" class=\"" + tableId + "-checkbox\" " +
                    column.getCheckboxValues(val, tableId, currentSelected) + " onclick=\"SchedulerTables.selectCheckbox(this," +
                    column.getExtractDataFunction(val) + ", " + totalData + ", '" + tableId + "');\"></td>";
            }
            else {
                outputHTML += "<td" + column.getRowElementClass(val) + ">" + column.getExtractDataFunction(val) + "</td>";
            }
        });
        outputHTML += '</tr>';
    });
    $('#' + tableId + ' tbody').html(outputHTML);
    $("#selectRecords > [value='" + max_results + "']").attr("selected", "true");
    return totalData;
};

SchedulerTables.reselectCheckboxes = function(tableId, totalData, currentSelected) {
    SchedulerTables.setSelectedCheckboxes(tableId, currentSelected);

    if (totalData === SchedulerTables.getSelectedCheckboxes(tableId).length && totalData !== 0) {
        $('#' + tableId + '-selectAll').prop('checked', true);
    }
    else {
        $('#' + tableId + '-selectAll').prop('checked', false);
    }
};

SchedulerTables.adjustCurrentAndTotalPages = function(totalData) {
  var remainder = totalData % max_results;

  totalPages = Math.floor(totalData / max_results);

  // very first page has floor of 0
  if (remainder > 0) {
    totalPages++;
  }
  // if still 0, then there were no results, but still it's page 1
  if (totalPages === 0) {
    totalPages++;
  }

  if (currentPage > totalPages) {
    currentPage = totalPages;
  }
};

SchedulerTables.createPagination = function(totalData) {
    SchedulerTables.adjustCurrentAndTotalPages(totalData);

    createPaginationLinks(currentPage, totalPages);

    return totalPages;
};


SchedulerTables.selectCheckbox = function(source, id, size, tableId) {
    if (source.checked && $.inArray(id, this.getSelectedCheckboxes(tableId)) == -1) {
        this.addSelectedCheckbox(tableId, id)
    }
    else if (!source.checked) {
        this.setSelectedCheckboxes(tableId, $.grep(this.getSelectedCheckboxes(tableId), function (value) {return value != id;}));
    }
    if (this.getSelectedCheckboxes(tableId).length === size) {
        $('#' + tableId + '-selectAll').prop('checked', true);
    }
    else {
        $('#' + tableId + '-selectAll').prop('checked', false);
    }
};

SchedulerTables.toggleAllCheckBoxes = function(source, tableId) {
    if (source.checked) {
        SchedulerTables.selectAllCheckboxes(tableId);
    }
    else {
        SchedulerTables.deselectAllCheckboxes(tableId);
    }
};

SchedulerTables.selectAllCheckboxes = function(tableId) {
    var checkboxes = $('.' + tableId +'-checkbox');
    for (var i = 0; i < checkboxes.length; i++) {
        var checkbox = $(checkboxes[i]);
        if (($.inArray(checkbox.val(), SchedulerTables.getSelectedCheckboxes(tableId)) == -1)) {
            if ($.isNumeric(checkbox.val())) {
                this.addSelectedCheckbox(tableId, parseInt(checkbox.val()));
            }
            checkbox.prop('checked', true);
        }
        else if (checkbox.checked != true) {
            checkbox.prop('checked', true);
        }
    }
    $('#' + tableId + '-selectAll').prop('checked', true);
};

SchedulerTables.deselectAllCheckboxes = function(tableId) {
    var checkboxes = $('.' + tableId +'-checkbox');
    this.clearSelectedCheckboxes(tableId);
    checkboxes.prop('checked', false);
    $('#' + tableId + '-selectAll').prop('checked', false);
};
