/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * Created by xavier on 9/26/16.
 */

function onloadAppointmentsPage() {

    var deferredHeader = $.Deferred();
    var deferredDialogLoad = $.Deferred();

    eraseLicense();
    loadMetaHeaders();

    $.get("common/dialogs.html", function (content) {
        $('#main_dialog_wrapper').after(content);
        deferredDialogLoad.resolve();
    });

    $("#fullHeader").load("common/header.html", function () {
        $('.appointmentslink').addClass('active');
        app_runIdleTimer();
        commonData();
        deferredHeader.resolve();
    });

    $.when(deferredHeader, deferredDialogLoad).done(function () {
        renderBreadcrumbs("appointment_screen");
        createApptCalendarDatePicker();
        eraseLicense();
        $('#templateSection').load("appts/wizard_templates.html");
        $('#appt-common-dialogs').load("appts/dialogs.html");

        appointment_viewStack('appointment_main_screen');
        $("#booked_visit_radio").prop("checked", true);
        $("#booked_visit_radio").click(function () {
            $("#booked_visit_radio").prop("checked", true);
        });
        $("#visit_template_radio").click(function () {
            $("#visit_template_radio").prop("checked", true);
        });

        $(".weekday").change(function () {
            toggleWeekDaysCheckBoxes();
        });

        $(".weekend").change(function () {
            toggleWeekDaysCheckBoxes();
        });

        $('#appt_startDate').datepicker().keyup(function () {
            if (isValidDate($(this).val())) {
                var selectedDate = new Date($(this).val());
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                if (selectedDate < today) {
                    alert("Incorrect Date. Entered date is outside the range.");
                    $("#appt_startDate").val('');
                    return;
                }
                if (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) {
                    resetCheckBoxes();
                    var startDateDatepicker = $("#appt_startDate").datepicker('getDate');
                    $("#appt_endDate").datepicker("option", "minDate", selectedDate);
                    $("#appt_endDate").datepicker("setDate", selectedDate);
                    var endDateDatepicker = $("#appt_endDate").datepicker('getDate');
                    $('.formElementRequired').css({visibility: "hidden"});
                    $('.formValidationRequired').css({visibility: "hidden"});
                    selectedDaysOfWeek = [];
                    var dateArray = getDatesInterval(startDateDatepicker, endDateDatepicker);
                    if ((dateArray[0].getDay() == 1 && dateArray.length >= 5) || dateArray.length >= 7) {
                        $(".week_days").prop('disabled', false);
                    }
                    else {
                        $(".week_days").prop('disabled', true);
                    }
                    for (var i = 0; i < dateArray.length; i++) {
                        if (dateArray[i].getDay() != 0 && dateArray[i].getDay() != 6) {
                            var selectDay = dateArray[i].getDay().toString();
                            $("input:checkbox[value=" + selectDay + "]").prop("checked", true);
                            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
                        }
                        else if (dateArray[i].getDay() == 0 || dateArray[i].getDay() == 6) {
                            var selectDay = dateArray[i].getDay().toString();
                            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
                        }
                    }
                    toggleWeekDaysCheckBoxes();
                }
            }
        });
        $('#appt_endDate').datepicker().keyup(function () {
            if (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) {
                if (isValidDate($(this).val())) {
                    var selectedDate = new Date($(this).val());
                    var today = new Date();
                    today.setHours(0, 0, 0, 0);
                    if (selectedDate < today) {
                        alert("Incorrect Date. Entered date is outside the range.");
                        $("#appt_endDate").val('');
                        return;
                    }

                    resetCheckBoxes();
                    var startDateDatepicker = $("#appt_startDate").datepicker('getDate');
                    var endDateDatepicker = $("#appt_endDate").datepicker('getDate');
                    var dateArray = getDatesInterval(startDateDatepicker, endDateDatepicker);
                    $('.formElementRequired').css({visibility: "hidden"});
                    $('.formValidationRequired').css({visibility: "hidden"});
                    selectedDaysOfWeek = [];
                    if ((dateArray[0].getDay() == 1 && dateArray.length >= 5) || dateArray.length >= 7) {
                        $(".week_days").prop('disabled', false);
                    }
                    else {
                        $(".week_days").prop('disabled', true);
                    }
                    for (var i = 0; i < dateArray.length; i++) {
                        if (dateArray[i].getDay() != 0 && dateArray[i].getDay() != 6) {
                            var selectDay = dateArray[i].getDay().toString();
                            $("input:checkbox[value=" + selectDay + "]").prop("checked", true);
                            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
                        }
                        else if (dateArray[i].getDay() == 0 || dateArray[i].getDay() == 6) {
                            var selectDay = dateArray[i].getDay().toString();
                            $("input:checkbox[value=" + selectDay + "]").prop("disabled", false);
                        }
                    }
                    toggleWeekDaysCheckBoxes();
                }
            }
        });
        $('#appt_startTime').datepicker().keyup(function () {
            if (isValidDate($(this).val())) {
                var selectedDate = new Date($(this).val());
                var today = new Date();
                today.setHours(0, 0, 0, 0);
                if (selectedDate < today) {
                    alert("Incorrect Date. Entered date is outside the range.");
                    $("#appt_endDate").val('');
                    return;
                }
            }
        });

    });
    $("#apptModuleTabs").tabs();

}

