/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var ApptTables = {};

ApptTables.dbColumnVisitStartTime = "bv.scheduledStartTime";
ApptTables.dbColumnVisitEndTime = "bv.scheduledEndTime";
ApptTables.dbColumnVisitMrn = "bv.subjectMrn";
ApptTables.dbColumnStudyLocalId = "bv.study.localId";
ApptTables.dbColumnStudyIrb = "bv.study.irb";
ApptTables.dbColumnVisitName = "bv.visitTemplate.name";
ApptTables.dbColumnVisitStatus = "bv.appointmentStatus.name";

ApptTables.uiColumnVisitStartTime = "Scheduled Start Time";
ApptTables.uiColumnVisitEndTime = "Scheduled End Time";
ApptTables.uiColumnVisitSubjectName = "Subject Full Name";
ApptTables.uiColumnVisitMrn = "MRN";
ApptTables.uiColumnStudyLocalId = "Local ID";
ApptTables.uiColumnStudyIrb = "IRB Number";
ApptTables.uiColumnVisitName = "Visit Name";
ApptTables.uiColumnVisitStatus = "Appointment Status";

ApptTables.tableName = "appointmentListTable";

ApptTables.pushColumns = function(columns) {
    if (UserRoleUtil.userIsSuperAdmin()) {
        columns.push(new Column({
            width: 4,
            extractDataFunction: function (val) {
                return val.id;
            },
            columnType: Column.Expandable
        }));
    }
    columns.push(new Column({
        dbColumn: ApptTables.dbColumnVisitStartTime,
        columnName: ApptTables.uiColumnVisitStartTime,
        columnType: Column.Text,
        width:17,
        defaultSortOrder: Column.ASC, // single presence of this option
                                      // among Columns indicates initial sort
        extractDataFunction: function (val) {return showDateTime(val.scheduledStartTime);}
    }));

    columns.push(new Column({
        dbColumn: ApptTables.dbColumnVisitEndTime,
        columnName: ApptTables.uiColumnVisitEndTime,
        width:17,
        extractDataFunction: function (val) {return showDateTime(val.scheduledEndTime);}
    }));

    columns.push(new Column({
        columnName: ApptTables.uiColumnVisitSubjectName,
        width:15,
        extractDataFunction: function (val) {return val.subjectName;}
    }));

    columns.push(new Column({
        dbColumn: ApptTables.dbColumnVisitMrn,
        columnName: ApptTables.uiColumnVisitMrn,
        width:15,
        extractDataFunction: function (val) {return val.subjectMRN;}
    }));

    columns.push(new Column({
        dbColumn: ApptTables.dbColumnStudyLocalId,
        columnName: ApptTables.uiColumnStudyLocalId,
        width:13,
        extractDataFunction: function (val) {return val.localId;}
    }));

    columns.push(new Column({
        dbColumn: ApptTables.dbColumnStudyIrb,
        columnName: ApptTables.uiColumnStudyIrb,
        width:13,
        extractDataFunction: function (val) {return val.irb;}
    }));
    columns.push(new Column({
        dbColumn: ApptTables.dbColumnVisitName,
        columnName: ApptTables.uiColumnVisitName,
        width:13,
        extractDataFunction: function (val) {return val.visitName;}
    }));
    columns.push(new Column({
        dbColumn: ApptTables.dbColumnVisitStatus,
        columnName: ApptTables.uiColumnVisitStatus,
        width:14,
        extractDataFunction: function (val) {return val.appointmentStatus;}
    }));

    columns.push(new Column({
        columnType: Column.Hyperlink,
        rowElementClass: 'editColumn',
        width:11,
        rowElementHyperLink: function (val) {
            return 'getBookedVisitDetails(' + val.id + ')';
        },
        extractDataFunction: function () {
            return " View Detail ";
        }
    }));
};

ApptTables.expandFn = function (container, visitId) {

    $.getJSON("rest/appointment/getScheduledVisitHistory?id=" + visitId, function (data) {

        var list = $('<div class="expandContent visitHistory"></div>').appendTo(container);

        var headingElement = $('<div class="heading"></div>').appendTo(list);
        $('<div class="column1"></div>').appendTo(headingElement);
        $('<div class="column2"><div">Appointment History:</div></div>').appendTo(headingElement);

        data.bookedVisitActivity.forEach(function (element) {
            var listElement = $('<div style=""></div>').appendTo(list);
            $('<div class="column1"></div>').appendTo(listElement);
            $('<div class="column2 highlight"><div>' + element.action + ':</div></div>').appendTo(listElement);
            $('<div class="column3"><div>' + showDateTime(element.date) + '</div></div>').appendTo(listElement);
            var userString = element.user ? "by " + element.user : "user data not available";
            $('<div class="column4"><div>' + userString + '</div></div>').appendTo(listElement);
        });
    });
};

ApptTables.loadVisitsIntoApptTablesWidget = function(currentPage, initial) {

    initial = initial === undefined ? true: initial;

    var columns = [];
    ApptTables.pushColumns(columns);

    ApptTables.currentTable = new SchedulerTables({
        tableId: ApptTables.tableName,
        columns: columns,
        reloadFn: ApptTables.populateApptListTable,
        groupBy: {
            columnName: ApptTables.uiColumnVisitStartTime,
            isNewGroup: function(oldValue, newValue)
            {
                var oldDate = showDate(oldValue);
                var newDate = showDate(newValue);
                return oldDate !== newDate;
            },
            render: function (value) {
                return showDate(value);
            }
        },
        expandFn: ApptTables.expandFn
    });

    ApptTables.currentTable.generateTable(
        [],
        50,
        ApptTables.tableName + "Pagination",
        function() {
            ApptTables.currentTable.reloadFn(false);
        },
        function() {
            ApptTables.currentTable.reloadFn(true);
        }
    );

    ApptTables.populateApptListTable(initial, currentPage);
};

ApptTables.populateApptListTable = function(initial, currentPage) {

    var whichTable = ApptTables.currentTable;

    if (currentPage) {
        whichTable.setCurrentPage(currentPage);
    }

    $('#table_loading').css({display: 'block'});

    // handling filter using 'the old way' widget, vs in the columns
    var search_string = $.trim($("#apptlist_filters_string").val());

    var restUrl = "rest/appointment/getBookedVisitsList" +
        "?fromDate=" + currDate +
        "&toDate=" + selectedEndDate +
        "&initialLoad=" + initial +
        "&page=" +          whichTable.getCurrentPage() +
        "&filterString=" + search_string +
        "&filterId=" + (selected != undefined ? selected : 0) +
        "&maxResults=" +    whichTable.getRecordsPerPage() +
        "&orderBy=" +       (whichTable.getSortOrder() || Column.ASC) +
        "&sortBy=" +        (whichTable.getSortColumn());

    $.getJSON(restUrl, function(data) {
        whichTable.refreshTableBody(data);

    }).always(function() {
        $('#table_loading').css({display: 'none'});
    });
};

//The below 'commented' sourceURL specifies a name for this piece of code which
//  will appear if debugging in the browser
//This is needed because this file is loaded programatically
//# sourceURL=appt_tables.js
