/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var orderBy;
var sortBy;
var sortOn;
var sortByResource = "r.name";
var sortByAnnotations = "lla.name";
var sortByStartTime = "br.scheduled_start_time";
var sortByEndTime = "br.scheduled_end_time";
var totalPages;
var appt_search_view;

function loadBookedResourcesData(currentPage, eventid) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (max_results == undefined) {
        max_results = 50;
    }
    var subjectAvailable = true;
    var url;
    if (appt_search_view == true) {
        if (className == 'NotFound') {
            var isInpatient = (appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3) ? false : true;

            url = 'rest/appointment/getSearchedSlotResources?subjectMrnId=' + (appt_selectedSubjectMrnId != null ? appt_selectedSubjectMrnId : 0) +
                '&visit=' + appt_selectedVisit +
                '&startDate=' + start +
                '&endDate=' + end +
                '&isInpatient=' + isInpatient;
        }
        else {
            url = "rest/appointment/getEventResources?eventId=" + eventid;
        }
    }
    else {
        url = "rest/appointment/getBookedVisitResources?eventid=" + eventid + "&page=" + (currentPage != undefined ? currentPage : 1) + "&maxResults=" + (max_results != undefined ? max_results : 50) + "&orderBy=" + (orderBy != undefined ? orderBy : "ASC") + "&sortBy=" + (sortBy != undefined ? sortBy : sortByStartTime);
    }

    $.getJSON(url, function (data) {
        var iteration = 0;
        var editColumns = "";
        var editColumns1 = "";
        var msgColumn = "";
        var availableColumn = "";
        createTableHeader();
        var resourceWidth = "16%";
        var resourceStartWidth = "15%";
        var resourceEndWidth = "15%";

        var out = " <table id='bookedResource' width='100%'> <tbody> ";

        $.each(data, function (key, val) {
            totalData = val.totalCount;
            subjectAvailable = val.subjectAvailable;
            var resourceImage = '';
            if (val.resourceGroup == "fixed") {
                resourceImage = "<img src='css/images/icon_fixed.png' style='padding-right: 2px;'/>";
            }
            else if (val.resourceGroup == "float") {
                resourceImage = "<img src='css/images/icon_float.png' style='padding-right: 2px;'/>";
            }
            else if (val.resourceGroup == "float group") {
                resourceImage = "<img src='css/images/icon_floatgroup.png' style='padding-right: 2px;'/>";
            }
            else if (val.resourceGroup == "flex") {
                resourceImage = "<img src='css/images/icon_flex.png' style='padding-right: 2px;'/>";
            }
            if (appt_search_view == true) {
                if (className == 'NotFound') {
                    var availabilityImage = 'css/images/icon_x_hexb2382d.png';
                    var availabilityText = 'Not Available';

                    if (showValue(val.available) == 'Yes') {
                        availabilityImage = 'css/images/icon_checkmark_hex4ab092.png';
                        availabilityText = 'Available';
                    }
                    resourceWidth = "38%";
                    resourceStartWidth = "25%";
                    resourceEndWidth = "25%";
                    availableColumn = "<td width='12%' style='padding-left: 30px;' valign='top' title='" + availabilityText + "'> <img src='" + availabilityImage + "' alt='" + availabilityText + "' /> </td>";
                    if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER || user.institutionRole.id == SCHEDULER) {
                        resourceWidth = "30%";
                        resourceStartWidth = "19%";
                        resourceEndWidth = "19%";
                        msgColumn = "<td width='20%' align='left' valign='top'>" + showValue(val.rejectedResourceMessage) + "</td>";
                    }
                }
                else {
                    resourceWidth = "50%";
                    resourceStartWidth = "25%";
                    resourceEndWidth = "25%";
                }
            }
            if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF || user.institutionRole.id == FRONT_DESK
                || appt_list_view == true || appt_search_view == true) {
                editColumns1 = " ";
                editColumns = " ";
            }
            else {
                editColumns1 = "<td width='20%' align='left' valign='top'>" + showValue(val.annotations) + "</td>";
                editColumns = "<td width='15%' class='editColumn'>" +
                    " <a href='javascript:editBookedResourceOverride(" + val.id + "," + eventid + ")'>Edit</a>" +
                    " | <a href='javascript:deleteBookedResourceOverride(" + val.id + ")'>Delete</a> " +
                    " </td> ";
            }
            out += ((iteration % 2 == 1) ? " <tr>" : "<tr>");
            out += "   <td width='" + resourceWidth + "' align='left' valign='top'>" + resourceImage + val.resourceName + " </td>" +
                editColumns1 +
                "          <td width='" + resourceStartWidth + "' align='left' valign='top'>" + showDateTime(val.scheduledStartTime) + "</td>" +
                "          <td width='" + resourceEndWidth + "' align='left' valign='top'>" + showDateTime(val.scheduledEndTime) + "</td>" +
                availableColumn +
                msgColumn +
                editColumns +
                " </tr>";
            iteration++;
        });

        out += " </tbody> </table>";
        var tables =   $('#searchResourcesData, #scheduledResourcesData, #checkedInResourcesData, #checkedOutResourcesData, #cancelledResourcesData, #batchResourcesData');

        setupTable(out, tables, currentPage, totalData);

        if (typeof className != 'undefined' && className == 'NotFound') {
            $('#searchResourcesData tbody tr').filter(function () {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Not Available"
            }).show();
            $('#searchResourcesData tbody tr').filter(function () {
                return $.trim($(this).find('td').eq(3).attr('title')) === "Available"
            }).hide();
        } else if (typeof className != 'undefined' && className == 'Searching') {
            if (subjectAvailable == false) {
                subjectConfirmationDialog();
            }
        }
        $.unblockUI();
    });
}

function subjectConfirmationDialog() {
    $("#subject-dialog-confirm").css({display: 'inline-block'});
    $("#subject-dialog-confirm").dialog({
        resizable: false,
        width: 510,
        modal: true,
        buttons: {
            "Yes": function () {
                $(this).dialog("close");
            },
            "No": function () {
                $(".ui-dialog-content").dialog("close");
                $(this).dialog("close");
            }
        }
    });
}

function createTableHeader() {
    var sort_header;
    var resource_header1 = 'sortable';
    var annotations_header2 = 'sortable';
    var start_header3 = 'sortable';
    var end_header4 = 'sortable';
    var resourceWidth = "16%";
    var resourceStartWidth = "15%";
    var resourceEndWidth = "15%";
    if (orderBy == 'ASC') {
        sort_header = 'sorting_asc';
    }
    else if (orderBy == 'DESC') {
        sort_header = 'sorting_desc';
    }

    if (sortBy == sortByResource) {
        resource_header1 = sort_header;
    } else if (sortBy == sortByAnnotations) {
        annotations_header2 = sort_header;
    } else if (sortBy == undefined || sortBy == sortByStartTime) {
        start_header3 = sort_header;
    } else if (sortBy == sortByEndTime) {
        end_header4 = sort_header;
    }
    var editColumns1 = "";
    var editColumns = "";
    var msgColumn = "";
    var availableColumn = "";
    if (appt_search_view == true) {
        if (className == 'NotFound') {
            resourceWidth = "38%";
            resourceStartWidth = "25%";
            resourceEndWidth = "25%";
            availableColumn = "   <th width='12%' id='annotationSort' class='not_sortable'><strong>Available</strong></th>";
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER || user.institutionRole.id == SCHEDULER) {
                resourceWidth = "30%";
                resourceStartWidth = "19%";
                resourceEndWidth = "19%";
                msgColumn = "   <th id='annotationSort' width='20%' class='not_sortable'><strong>Reason for Unavailability</strong></th>";
            }
        }
        else {
            resourceWidth = "50%";
            resourceStartWidth = "25%";
            resourceEndWidth = "25%";
        }
    }
    if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == STUDY_STAFF || user.institutionRole.id == FRONT_DESK
        || appt_list_view == true || appt_search_view == true) {
        editColumns = " ";
        editColumns1 = " ";
    }
    else {
        editColumns1 = "   <th id='annotationSort' width='20%'><strong>Resource Activities</strong></th>";
        editColumns = "   <th id='crud' class='not_sortable' width='15%'> </th>";
    }
    var header_table =
        " <table id='bookedResource' width='100%' border='0' cellspacing='0'>" +
        "  <thead> <tr>" +
        "   <th id='resourceSort' width='" + resourceWidth + "'><strong>Resource Name</strong></th> " +
        editColumns1 +
        "   <th id='startTimeSort' width='" + resourceStartWidth + "'><strong>Start Time</strong></th>" +
        "   <th id='endTimeSort' width='" + resourceEndWidth + "'><strong>End Time</strong></th>" +
        availableColumn +
        msgColumn +
        editColumns +
        "  </tr> </thead> </table>";

    $('#searchResourcesHeaderData').html(header_table);
    $('#scheduledResourcesHeaderData').html(header_table);
    $('#checkedInResourcesHeaderData').html(header_table);
    $('#checkedOutResourcesHeaderData').html(header_table);
    $('#cancelledResourcesHeaderData').html(header_table);
    $('#batchResourcesHeaderData').html(header_table);
}

////////////////////////////////////////////Check for Overbooked Data....////////////////////////////////////////////////////////////////////////////////////

function loadOverbookedResourcesData(currentPage, eventid) {
    $.blockUI();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (max_results == undefined) {
        max_results = 50;
    }

    $.getJSON("rest/appointment/getOverbookedVisitsData?id=" + eventid, function (data) {
        var iteration = 0;
        createOverbookTableHeader();

        var out = " <table id='overbookedResource'>" +
            "  <thead></thead> ";
        out += "<tbody> ";
        $.each(data, function (key, val) {
            totalData = val.totalCount;
            out += "<tr>";
            out += "       <td align='left' width='10%' valign='top'>" + val.resourceName + "</td>" +
                "          <td align='left' width='10%' valign='top'>" + val.visitName + "</td>" +
                "          <td align='left' width='11%' valign='top'>" + val.subjectName + "</td>" +
                "          <td align='left' width='10%' valign='top'>" + val.localId + "</td>" +
                "          <td align='left' width='12%' valign='top'>" + showDateTime(val.visitStartTime) + "</td>" +
                "          <td align='left' width='11%' valign='top'>" + showDateTime(val.visitEndTime) + "</td>" +
                "          <td align='left' width='12%' valign='top'>" + showDateTime(val.scheduledStartTime) + "</td>" +
                "          <td align='left' width='12%' valign='top'>" + showDateTime(val.scheduledEndTime) + "</td>" +
                "          <td align='left' width='12%' valign='top'>" + val.conflictedTime + "</td>" +
                " </tr>";
            iteration++;
        });

        setupTable(out, $('#overbookedResourcesData'), currentPage, totalData);

        $.unblockUI();
    });
}

function createOverbookTableHeader() {
    var header;
    var header1 = 'sortable';
    var header2 = 'sortable';
    var header3 = 'sortable';
    var header4 = 'sortable';
    var header5 = 'sortable';
    var header6 = 'sortable';
    var header7 = 'sortable';
    var header8 = 'sortable';
    var header9 = 'sortable';

    if (orderBy == undefined) {
        orderBy = "ASC";
    }

    if (orderBy == 'ASC') {
        header = 'sorting_asc';
    }
    else if (orderBy == 'DESC') {
        header = 'sorting_desc';
    }

    if (sortOn == undefined || sortOn == 0) {
        header1 = header;
    } else if (sortOn == 1) {
        header2 = header;
    } else if (sortOn == 2) {
        header3 = header;
    } else if (sortOn == 3) {
        header4 = header;
    } else if (sortOn == 4) {
        header5 = header;
    } else if (sortOn == 5) {
        header6 = header;
    } else if (sortOn == 6) {
        header7 = header;
    } else if (sortOn == 7) {
        header8 = header;
    } else if (sortOn == 8) {
        header9 = header;
    }

    var header_table =
        " <table id='bookedResource' rules='cols' width='100%' border='0' cellspacing='0'>" +
        "  <thead> <tr>" +
        "   <th width='10%' class= " + header1 + " width='20%' onclick='sortTable(0)'><strong>Resource Name</strong></th> " +
        "   <th width='10%' class= " + header2 + " width='20%' onclick='sortTable(1)'><strong>Visit Name</strong></th> " +
        "   <th width='11%' class= " + header3 + " width='20%' onclick='sortTable(2)'><strong>Subject Name</strong></th> " +
        "   <th width='10%' class= " + header4 + " width='20%' onclick='sortTable(3)'><strong>Local ID</strong></th> " +
        "   <th width='12%' class= " + header5 + " width='20%' onclick='sortTable(4)'><strong>Visit Start Time</strong></th> " +
        "   <th width='11%' class= " + header6 + " width='20%' onclick='sortTable(5)'><strong>Visit End Time</strong></th>" +
        "   <th width='12%' class= " + header7 + " width='20%' onclick='sortTable(6)'><strong>Resource Start Time</strong></th>" +
        "   <th width='12%' class= " + header8 + " width='20%' onclick='sortTable(7)'><strong>Resource End Time</strong></th>" +
        "   <th width='12%' class= " + header9 + " width='20%' onclick='sortTable(8)'><strong>Conflicted Time</strong></th>" +
        "  </tr> </thead> </table>";
    $('#overbookResourcesHeaderData').html(header_table);
}

function sortTable(sortedOn) {
    if (orderBy == "ASC") {
        orderBy = "DESC";
    }
    else {
        orderBy = "ASC";
    }
    sortOn = sortedOn;
    var table = document.getElementById('overbookedResource');
    var tbody = table.getElementsByTagName('tbody')[0];
    var rows = tbody.getElementsByTagName('tr');
    var rowArray = new Array();
    for (var i = 0, length = rows.length; i < length; i++) {
        rowArray[i] = new Object;
        rowArray[i].oldIndex = i;
        rowArray[i].value = rows[i].getElementsByTagName('td')[sortOn].firstChild.nodeValue;
    }

    if (sortOn == 0 || sortOn == 1 || sortOn == 2 || sortOn == 3) {
        rowArray.sort(RowCompareStrings);
    } else if (sortOn == 4 || sortOn == 5 || sortOn == 6 || sortOn == 7) {
        rowArray.sort(RowCompareDates);
    } else {
        rowArray.sort(RowCompare);
    }

    var newTbody = document.createElement('tbody');
    for (var i = 0, length = rowArray.length; i < length; i++) {
        newTbody.appendChild(rows[rowArray[i].oldIndex].cloneNode(true));
    }
    table.replaceChild(newTbody, tbody);
    createOverbookTableHeader();
}

function RowCompare(a, b) {
    var aVal = a.value;
    var bVal = b.value;
    if (orderBy == "ASC") {
        return (aVal == bVal ? 0 : (aVal > bVal ? 1 : -1));
    }
    else {
        return (aVal == bVal ? 0 : (aVal < bVal ? 1 : -1));
    }
}
//Compare Dates
function RowCompareDates(a, b) {
    var aDate = a.value;
    var bDate = b.value;
    if (orderBy == "ASC") {
        return (aDate == bDate ? 0 : (aDate > bDate ? 1 : -1));
    }
    else {
        return (aDate == bDate ? 0 : (aDate < bDate ? 1 : -1));
    }
}
//Compare Strings
function RowCompareStrings(a, b) {
    var firstString = a.value;
    var secondString = b.value;
    if (orderBy == "ASC") {
        var index = secondString.localeCompare(firstString);
        return index;
    }
    else {
        var index = firstString.localeCompare(secondString);
        return index;
    }
}
