/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Sub-location closures

var SublocationClosureTable = {};

SublocationClosureTable.id = "sublocationClosureTable";
SublocationClosureTable.dbColumnSublocation = "sci.sublocation.name";
SublocationClosureTable.dbColumnStartDate = "sci.startTime";
SublocationClosureTable.dbColumnEndDate = "sci.endTime";
SublocationClosureTable.dbColumnReason = "sci.reason";
SublocationClosureTable.defaultPerPage = 50;

SublocationClosureTable.create = function() {
    var columns = [];

    SublocationClosureTable.pushAllColumns(columns);

    var args = {
        tableId: SublocationClosureTable.id,
        columns: columns,
        reloadFn: SublocationClosureTable.populate
    };

    SublocationClosureTable.currentTable = new SchedulerTables(args);

    SublocationClosureTable.currentTable.generateTable(
        [],
        SublocationClosureTable.defaultPerPage,
        PaginationHelper.getPaginationId(SublocationClosureTable.id),
        SublocationClosureTable.populate
    );

};


SublocationClosureTable.pushAllColumns = function(columns) {

    columns.push(new Column({
        dbColumn: SublocationClosureTable.dbColumnSublocation,
        columnName: "Sub-location",
        width: 20,
        extractDataFunction: function (val) {
            return val.sublocation;
        }
    }));

    columns.push(new Column({
        dbColumn: SublocationClosureTable.dbColumnStartDate,
        columnName: "Start Date",
        width: 20,
        extractDataFunction: function (val) {
            return showDateTime(val.startDate);
        }
    }));

    columns.push(new Column({
        dbColumn: SublocationClosureTable.dbColumnEndDate,
        columnName: "End Date",
        width: 20,
        extractDataFunction: function (val) {
            return showDateTime(val.endDate);
        }
    }));

    columns.push(new Column({
        dbColumn: SublocationClosureTable.dbColumnReason,
        columnName: "Reason",
        width: 20,
        extractDataFunction: function (val) {
            return val.reason;
        }
    }));

    columns.push(new Column({
        columnType: Column.Hyperlink,
        rowElementClass: 'editColumn',
        columnName: "",
        width: 20,
        rowElementHyperLink: function (val) {
            return 'javascript:deleteSublocationDialog(' + val.id + ')';
        },
        extractDataFunction: function () {
            return "Delete";
        }
    }));

};


SublocationClosureTable.populate = function() {

    var url = "rest/resource/getSublocationClosureIntervals" +
        "?page=" + SublocationClosureTable.currentTable.getCurrentPage() +
        "&maxResults=" + SublocationClosureTable.currentTable.getRecordsPerPage() +
        "&orderBy=" + (SublocationClosureTable.currentTable.getSortOrder() || Column.ASC) +
        "&sortBy=" + (SublocationClosureTable.currentTable.getSortColumn() || SublocationClosureTable.dbColumnSublocation);

    $.getJSON(url, function (data) {
        SublocationClosureTable.currentTable.refreshTableBody(data);
        // where is the blockUI() call?
        $.unblockUI();
    });

};
