/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var AppointmentSearch = {};

AppointmentSearch.searchAvailabilityComplete = function() {
    $('#loading').css({display: 'none'});
    $('#filter_loading').css({display: 'none'});

    if ($.active == 1) {
        $('#appt_wizard_changeAppointmentSearch').css({display: "inline-block"});
        editSelectedStudy = appt_selectedStudy;
        editSelectedSubjectMrnId = appt_selectedSubjectMrnId;
        editSelectedVisit = appt_selectedVisit;
        appt_editSelectedStudyName = appt_selectedStudyName;
        appt_editSelectedStudyInvestigatorName = appt_selectedStudyInvestigatorName;
        appt_editSelectedVisitName = appt_selectedVisitName;
        appt_editSelectedVisitType = appt_selectedVisitType;
        appt_editSelectedVisitDuration = appt_selectedVisitDuration;
        appt_editSelectedSubjectName = appt_selectedSubjectName;
        //edit mrn here? TBD
        $.unblockUI();
        if (erroMsgFlag == true) {
            var confirmationMessage = "No Available Appointments Found. Scroll through to view unavailable appointments.";
            util_showMainMessage(confirmationMessage);
            $("#appt_wizard_screen").dialog("close");
        }
        else if (no_appointments_found == true) {
            var confirmationMessage = "No Available Appointments were found. Please select another date range.";
            util_showMainMessage(confirmationMessage);
            AppointmentSearch.updateSearchRange();
        }
        else if (erroMsgFlag == false && no_appointments_found == false) {
            var confirmationMessage = "Available Appointments Found. Scroll through to select an appointment.";
            util_showMainMessage(confirmationMessage);
            $("#appt_wizard_screen").dialog("close");
        }
    }
};

AppointmentSearch.updateSearchRange = function() {
    $("#appt_wizard_screen").dialog({modal: true, close: dialogCloseFunction, height: 780, width: 720});
    $('#appt_wizard_screen').css({display: "block"});
    sessionStorage.setItem("filteredString", '');
    $('.formElementRequired').css({visibility: "hidden"});
    $('.formValidationRequired').css({visibility: "hidden"});
    editSearch = true;
    appt_selectedStudyName = appt_editSelectedStudyName;
    appt_selectedStudyInvestigatorName = appt_editSelectedStudyInvestigatorName;
    $('.dialog_study_name').text(appt_editSelectedStudyName);
    $('.dialog_study_pi').text(appt_editSelectedStudyInvestigatorName);
    $('.dialog_study_visit').text(appt_editSelectedVisitName);
    $('.appt_totalTime').text(appt_editSelectedVisitDuration);
    $('.dialog_study_subject').text(appt_editSelectedSubjectName);
    $('.dialog_study_subject_mrn').text(appt_selectedSubjectMrn);
    $('.dialog_study_subject_gender').text(appt_selectedSubjectGender);
    appt_selectedStudy = editSelectedStudy;
    appt_selectedSubjectMrnId = editSelectedSubjectMrnId;
    appt_selectedVisit = editSelectedVisit;
    appt_selectedVisitType = appt_editSelectedVisitType;
    appt_selectedVisitDuration = appt_editSelectedVisitDuration;
    $("#appt_startDate").datepicker("destroy");
    $("#appt_endDate").datepicker("destroy");
    $("#appt_startTime").datepicker("destroy");
    $("#appt_endTime").datepicker("destroy");
    sessionStorage.setItem("filteredString", '');
    datePickersDisplay();
    appt_wizard_viewStack('appt_wizard_form4');
};

AppointmentSearch.searchAvailabilityError = function(xhr, status, error) {
    // check status && error
};

AppointmentSearch.searchAvailabilitySuccess = function(data) {
    if (data instanceof Array && data.length > 0) {
        no_appointments_found = false;

        $('#appt_calendar').fullCalendar('addEventSource', data);
        $('#appt_calendar').fullCalendar('gotoDate', startDateVal);
    }
};

AppointmentSearch.appt_searchAvailability = function() {
    no_appointments_found = true;
    erroMsgFlag = true;

    startDateVal = null;
    var totaldays = 0;
    searching_appointments = true;
    $('#filter_loading').css({display: 'none'});
    initialSearchStartDate = $("#appt_startDate").datepicker('getDate');
    initialSearchEndDate = $("#appt_endDate").datepicker('getDate');
    initialSearchStartTime = $("#appt_startTime").timepicker().val();
    initialSearchEndTime = $("#appt_endTime").timepicker().val();

    // outpatient
    if ((appt_selectedVisitType == 1 || appt_selectedVisitType == 2 || appt_selectedVisitType == 3)) {
        startDateVal = $("#appt_startDate").datepicker('getDate');

        search_startDateVal = $("#appt_startDate").datepicker('getDate');
        search_endDateVal = $("#appt_startDate").datepicker('getDate');
        var timeDiff = Math.abs($("#appt_endDate").datepicker('getDate').getTime() - $("#appt_startDate").datepicker('getDate').getTime());
        var totaldays = Math.ceil(timeDiff / (1000 * 3600 * 24));

        for (var i = 0; i <= totaldays; i++) {
            var sDay;
            if (i > 0) {
                var date1 = $('#appt_startDate').datepicker('getDate');
                date1.setDate(date1.getDate() + 1);
                $('#appt_startDate').datepicker('setDate', date1);
                sDay = $("#appt_startDate").datepicker('getDate');
            }
            else {
                sDay = $("#appt_startDate").datepicker('getDate');
            }
            $("#appt_startDate").datepicker('setDate', sDay);
            $("#appt_endDate").datepicker('setDate', sDay);

            search_startDateVal = $("#appt_startDate").val(); //$("#appt_startDate").datepicker('getDate');
            search_endDateVal = $("#appt_startDate").val();  //$("#appt_startDate").datepicker('getDate');

            search_startTimeVal = $("#appt_startTime").timepicker().val(); //Ext.getCmp('appt_startTime').getValue();
            search_endTimeVal = $("#appt_endTime").timepicker().val(); //Ext.getCmp('appt_endTime').getValue();

            var search_startdateTimeVal = search_startDateVal + ' ' + search_startTimeVal;
            search_startDateVal = new Date(search_startdateTimeVal);

            var search_enddateTimeVal = search_endDateVal + ' ' + search_endTimeVal;
            search_endDateVal = new Date(search_enddateTimeVal);
            if ($.inArray(sDay.getDay().toString(), selectedDaysOfWeek) != -1) {
                var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                    + '&visit=' + appt_selectedVisit
                    + '&startDate=' + search_startDateVal.valueOf()
                    + '&endDate=' + search_endDateVal.valueOf()
                    + '&isInpatient=false';

                requests.push($.ajax({
                    type: 'POST',
                    url: searchurl,
                    data: {},

                    success: AppointmentSearch.searchAvailabilitySuccess,
                    error: AppointmentSearch.searchAvailabilityError,
                    complete: AppointmentSearch.searchAvailabilityComplete,

                    dataType: 'json',
                    async: true
                }));
            }
        }  // each day
    } // outpatient

    // inpatient
    else if ((appt_selectedVisitType == 4 || appt_selectedVisitType == 5 || appt_selectedVisitType == 6)) {

        startDateVal = $("#appt_startDate").datepicker('getDate');

        if (appt_selectedVisitRelative == true) {
            search_startDateVal = $("#appt_startDate").datepicker('getDate');
            search_endDateVal = $("#appt_endDate").datepicker('getDate');
            var timeDiffInMillis = $("#appt_endDate").datepicker('getDate') - $("#appt_startDate").datepicker('getDate');
            var timeDiffInMinutes = Math.floor(timeDiffInMillis / 60000);
            var totaldays = Math.floor(timeDiffInMinutes / MINS_PER_DAY);
            var totalVisitDuration = appt_selectedVisitDuration;

            // within one day
            if (totalVisitDuration < MINS_PER_DAY) {
                search_startDateVal = $("#appt_startDate").val(); //$("#appt_startDate").datepicker('getDate');
                search_endDateVal = $("#appt_endDate").val();  //$("#appt_startDate").datepicker('getDate');

                search_startTimeVal = $("#appt_startTime").timepicker().val(); //Ext.getCmp('appt_startTime').getValue();
                search_endTimeVal = $("#appt_endTime").timepicker().val(); //Ext.getCmp('appt_endTime').getValue();

                var search_startdateTimeVal = search_startDateVal + ' ' + search_startTimeVal;
                search_startDateVal = new Date(search_startdateTimeVal);

                var search_enddateTimeVal = search_endDateVal + ' ' + search_endTimeVal;
                search_endDateVal = new Date(search_enddateTimeVal);

                var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                    + '&visit=' + appt_selectedVisit
                    + '&startDate=' + search_startDateVal.valueOf()
                    + '&endDate=' + search_endDateVal.valueOf()
                    + '&isInpatient=true';

                requests.push($.ajax({
                    type: 'POST',
                    url: searchurl,
                    data: {},

                    success: AppointmentSearch.searchAvailabilitySuccess,
                    error: AppointmentSearch.searchAvailabilityError,
                    complete: AppointmentSearch.searchAvailabilityComplete,

                    dataType: 'json',
                    async: true
                }));
            } // within one day

            else { // totalVisitDuration > MINS_PER_DAY, i.e., more than 1 day in duration

                var search_absoluteEndDateVal = $("#appt_endDate").val();
                var search_absoluteEndTimeVal = $("#appt_endTime").timepicker().val();
                var search_absoluteEndDateTimeVal = search_absoluteEndDateVal + ' ' + search_absoluteEndTimeVal;

                var search_absoluteEndDate = new Date(search_absoluteEndDateTimeVal);

                for (var i = 0; i <= totaldays; i++) {

                    if (i > 0) { // subsequent days increment the original value of startDate
                        var date1 = $('#appt_startDate').datepicker('getDate');
                        date1.setDate(date1.getDate() + 1);
                        $('#appt_startDate').datepicker('setDate', date1);
                    }

                    var search_startDateVal = $("#appt_startDate").val();
                    var search_startTimeVal = $("#appt_startTime").timepicker().val();
                    var search_startDateTimeVal = search_startDateVal + ' ' + search_startTimeVal;
                    var search_startDate = new Date(search_startDateTimeVal);

                    // last possible match starts one day after current start, minus epsilon,
                    //         so ends at one day + totalVisitDuration - epsilon

                    var search_endDate = new addMinutes(search_startDate, MINS_PER_DAY + totalVisitDuration - 1);

                    if (search_endDate > search_absoluteEndDate) {
                        search_endDate = search_absoluteEndDate;
                    }

                    var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId +
                        '&visit=' + appt_selectedVisit +
                        '&startDate=' + search_startDate.valueOf() +
                        '&endDate=' + search_endDate.valueOf() +
                        '&isInpatient=true';

                    requests.push($.ajax({
                        type: 'POST',
                        url: searchurl,
                        data: {},

                        success: AppointmentSearch.searchAvailabilitySuccess,
                        error: AppointmentSearch.searchAvailabilityError,
                        complete: AppointmentSearch.searchAvailabilityComplete,

                        dataType: 'json',
                        async: true
                    }));

                }  // for each day
            }  // more than one day
        }  // relative
        else // non-relative 'clock' time visit
        {
            search_startDateVal = $("#appt_startDate").val();
            search_endDateVal = $("#appt_endDate").val();

            search_startTimeVal = $("#appt_startTime").timepicker().val();
            search_endTimeVal = $("#appt_endTime").timepicker().val();

            var search_startDateTimeVal = search_startDateVal + ' ' + search_startTimeVal;
            search_startDateVal = new Date(search_startDateTimeVal);

            var search_endDateTimeVal = search_endDateVal + ' ' + search_endTimeVal;
            search_endDateVal = new Date(search_endDateTimeVal);
            editSelectedStudy = appt_selectedStudy;
            editSelectedSubjectMrnId = appt_selectedSubjectMrnId;
            editSelectedVisit = appt_selectedVisit;
            appt_editSelectedStudyName = appt_selectedStudyName;
            appt_editSelectedStudyInvestigatorName = appt_selectedStudyInvestigatorName;
            appt_editSelectedVisitName = appt_selectedVisitName;
            appt_editSelectedVisitType = appt_selectedVisitType;
            appt_editSelectedVisitDuration = appt_selectedVisitDuration;
            appt_editSelectedSubjectName = appt_selectedSubjectName;

            //edit mrn here? TBD
            var searchurl = 'rest/appointment/getSearchedVisit?subjectMrnId=' + appt_selectedSubjectMrnId
                + '&visit=' + appt_selectedVisit
                + '&startDate=' + search_startDateVal.valueOf()
                + '&endDate=' + search_endDateVal.valueOf()
                + '&isInpatient=true';

            request = $.post(searchurl, {}, function (data) {
                var parsedData = $.parseJSON(data);
                $.unblockUI();
                $('#appt_wizard_changeAppointmentSearch').css({display: "inline-block"});
                if (parsedData.errorMsg == "false") {
                    $('#loading').css({display: 'none'});
                    $('#filter_loading').css({display: 'none'});
                    var confirmationMessage = "No Available Appointments were found. Please select another date range.";
                    util_showMainMessage(confirmationMessage);
                    sessionStorage.setItem("filteredString", '');
                    appt_wizard_viewStack('appt_wizard_form4');
                }
                else {
                    $('#loading').css({display: 'none'});
                    $('#filter_loading').css({display: 'none'});
                    $('#appt_calendar').fullCalendar('addEventSource', parsedData);
                    $('#appt_calendar').fullCalendar('gotoDate', search_startDateVal);
                    var confirmationMessage = "Available Appointments Found. Scroll through to select an appointment.";
                    if (erroMsgFlag == true) {
                        confirmationMessage = "No Available Appointments Found. Scroll through to view unavailable appointments.";
                    }
                    util_showMainMessage(confirmationMessage);
                    $("#appt_wizard_screen").dialog("close");
                }
            });
        }  // clock time
    } // inpatient
};
