/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.cbmi.jira;

import com.dolby.jira.net.soap.jira.JiraSoapService;
import com.dolby.jira.net.soap.jira.JiraSoapServiceServiceLocator;
import com.dolby.jira.net.soap.jira.RemoteAuthenticationException;
import com.dolby.jira.net.soap.jira.RemoteComment;
import com.dolby.jira.net.soap.jira.RemoteCustomFieldValue;
import com.dolby.jira.net.soap.jira.RemoteException;
import com.dolby.jira.net.soap.jira.RemoteField;
import com.dolby.jira.net.soap.jira.RemoteFieldValue;
import com.dolby.jira.net.soap.jira.RemoteIssue;
import com.dolby.jira.net.soap.jira.RemotePermissionException;
import com.dolby.jira.net.soap.jira.RemoteValidationException;
import com.dolby.jira.net.soap.jira.RemoteWorklog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.mail.internet.MimeMessage;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class JiraService {
    protected final Logger logUtil = Logger.getLogger(JiraService.class.getName());
    private JiraSoapServiceServiceLocator fJiraSoapServiceGetter = new JiraSoapServiceServiceLocator();
    private JiraSoapService fJiraSoapService = null;
    private final String adminUsername;
    private final String adminPw;
    private final String generalUsername;
    private final String generalPw;

    public JiraService(String uri, String adminUsername, String adminPw, String generalUsername, String generalPw) throws Exception {
        try {
            this.fJiraSoapServiceGetter.setJirasoapserviceV2EndpointAddress(uri);
            this.fJiraSoapServiceGetter.setMaintainSession(true);
            this.fJiraSoapService = this.fJiraSoapServiceGetter.getJirasoapserviceV2();
            this.adminUsername = adminUsername;
            this.adminPw = adminPw;
            this.generalUsername = generalUsername;
            this.generalPw = generalPw;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: instantiating JiraService: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public RemoteField[] getCustomFields() throws Exception {
        String token = this.loginAdmin();
        RemoteField[] customFields = this.getFJiraSoapService().getCustomFields(token);
        this.logout(token);
        return customFields;
    }

    private RemoteCustomFieldValue[] generateRemoteCustomFields(Map<String, Object> customFieldMap) throws Exception {
        RemoteField[] customFields = this.getCustomFields();
        ArrayList<RemoteCustomFieldValue> list = new ArrayList<RemoteCustomFieldValue>();
        for (String key : customFieldMap.keySet()) {
            Object obj = customFieldMap.get(key);
            String customFieldId = this.getCustomFieldId(customFields, key);
            String[] val = null;
            try {
                if (obj instanceof String) {
                    val = new String[]{(String)obj};
                } else if (obj instanceof List) {
                    ArrayList tmpList = (ArrayList)obj;
                    val = new String[tmpList.size()];
                    for (int i = 0; i < tmpList.size(); ++i) {
                        val[i] = (String)tmpList.get(i);
                    }
                } else if (obj instanceof String[]) {
                    val = (String[])obj;
                }
                list.add(new RemoteCustomFieldValue(customFieldId, null, val));
            }
            catch (ClassCastException e) {
                this.logUtil.info("ERROR: casting object: key=" + key + " , customFieldId=" + customFieldId + ", object=" + obj.toString());
                this.logUtil.info("ERROR: casting object: " + e.getMessage());
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        RemoteCustomFieldValue[] customFieldValues = new RemoteCustomFieldValue[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            customFieldValues[i] = (RemoteCustomFieldValue)list.get(i);
        }
        return customFieldValues;
    }

    public String getFieldId(String fieldName) throws Exception {
        RemoteField[] customFields;
        String fieldId = null;
        for (RemoteField field : customFields = this.getCustomFields()) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            fieldId = field.getId();
            return fieldId;
        }
        return fieldId;
    }

    public void addAttachment(String issueKey, String filename, byte[] contents) throws Exception {
        try {
            String token = this.loginUser();
            this.getFJiraSoapService().addAttachmentsToIssue(token, issueKey, new String[]{filename}, (byte[][])new byte[][]{contents});
            this.logout(token);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: createIssue: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
    }

    public void addAttachmentViaEmail(String issueKey, String filename, byte[] contents, String to, String from) throws Exception {
        this.addAttachmentViaEmail(issueKey, filename, contents, to, from, "localhost");
    }

    public void addAttachmentViaEmail(String issueKey, String filename, byte[] contents, String to, String from, String host) throws Exception {
        try {
            this.sendMimeMessage(to, from, "file upload: " + filename, issueKey, filename, contents, host);
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: sending attachment via email: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void sendMimeMessage(String to, String from, String text, String subject, String attachmentName, byte[] attachment1, String host) throws Exception {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(host);
        sender.getSession().setDebug(true);
        MimeMessage message = sender.createMimeMessage();
        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(message, 2);
        mimeMessageHelper.setFrom(from);
        mimeMessageHelper.setTo(to.split(";"));
        mimeMessageHelper.setSubject(subject);
        mimeMessageHelper.setText(text);
        if (attachmentName != null && !attachmentName.equals("undefined") && attachment1 != null && attachment1.length > 0) {
            ByteArrayResource resource = new ByteArrayResource(attachment1);
            mimeMessageHelper.addAttachment(attachmentName, (InputStreamSource)resource);
        }
        try {
            sender.send(message);
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: sending mail to: " + to + ", from: " + from + ", with subject: " + subject);
            throw e;
        }
    }

    public void addComment(String issueKey, String comment) throws Exception {
        try {
            RemoteComment remoteComment = new RemoteComment();
            remoteComment.setAuthor(this.getGeneralUsername());
            remoteComment.setBody(comment);
            remoteComment.setUpdateAuthor(this.getGeneralUsername());
            String token = this.loginUser();
            this.getFJiraSoapService().addComment(token, issueKey, remoteComment);
            this.logout(token);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: addComment: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
    }

    public void addWorklog(String issueKey, String time, String username, Calendar startDate, String comment) throws Exception {
        try {
            RemoteWorklog remoteComment = new RemoteWorklog();
            remoteComment.setAuthor(username);
            remoteComment.setTimeSpent(time);
            remoteComment.setStartDate(startDate);
            remoteComment.setUpdateAuthor(username);
            remoteComment.setComment(comment);
            String token = this.loginUser();
            this.getFJiraSoapService().addWorklogAndAutoAdjustRemainingEstimate(token, issueKey, remoteComment);
            this.logout(token);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: addWorklog: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
    }

    public String createIssue(String assignee, String summary, String description, String project, Map<String, Object> customFieldMap) throws Exception {
        return this.createIssue(assignee, summary, description, project, customFieldMap, "3", "3");
    }

    public String createIssue(String assignee, String summary, String description, String project, Map<String, Object> customFieldMap, String type, String priority) throws Exception {
        String token = null;
        RemoteIssue newIssue = null;
        try {
            RemoteIssue remoteIssue = new RemoteIssue();
            remoteIssue.setProject(project);
            remoteIssue.setAssignee(assignee);
            remoteIssue.setSummary(summary);
            remoteIssue.setDescription(description);
            remoteIssue.setType(type);
            remoteIssue.setPriority(priority);
            remoteIssue.setCustomFieldValues(this.generateRemoteCustomFields(customFieldMap));
            token = this.loginUser();
            newIssue = this.getFJiraSoapService().createIssue(token, remoteIssue);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteException e) {
            this.logUtil.info("ERROR: remote exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: createIssue: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
        this.logout(token);
        return newIssue.getKey();
    }

    public void updateIssue(String issueKey, RemoteFieldValue[] fieldValueList) throws Exception {
        String token = null;
        try {
            token = this.loginUser();
            this.getFJiraSoapService().updateIssue(token, issueKey, fieldValueList);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteException e) {
            this.logUtil.info("ERROR: remote exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: updateIssue: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
        this.logout(token);
    }

    public RemoteIssue getIssue(String issueKey) throws Exception {
        String token = null;
        RemoteIssue newIssue = null;
        try {
            token = this.loginUser();
            newIssue = this.getFJiraSoapService().getIssue(token, issueKey);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteException e) {
            this.logUtil.info("ERROR: remote exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: createIssue: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
        this.logout(token);
        return newIssue;
    }

    public String createIssue(Calendar createDate, String assignee, String summary, String description, String project, Map<String, Object> customFieldMap) throws Exception {
        String token = null;
        RemoteIssue newIssue = null;
        try {
            RemoteIssue remoteIssue = new RemoteIssue();
            remoteIssue.setProject(project);
            remoteIssue.setAssignee(assignee);
            remoteIssue.setSummary(summary);
            remoteIssue.setDescription(description);
            remoteIssue.setType("3");
            remoteIssue.setPriority("3");
            remoteIssue.setCreated(createDate);
            remoteIssue.setCustomFieldValues(this.generateRemoteCustomFields(customFieldMap));
            token = this.loginUser();
            newIssue = this.getFJiraSoapService().createIssue(token, remoteIssue);
        }
        catch (RemoteAuthenticationException e) {
            this.logUtil.info("ERROR: remote authentication exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemotePermissionException e) {
            this.logUtil.info("ERROR: remote permission exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteValidationException e) {
            this.logUtil.info("ERROR: remote validation exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (RemoteException e) {
            this.logUtil.info("ERROR: remote exception: " + e.getFaultString());
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: createIssue: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
        this.logout(token);
        return newIssue.getKey();
    }

    public String getCustomFieldId(RemoteField[] customFields, String customFieldName) throws Exception {
        String customFieldId = null;
        for (RemoteField item : customFields) {
            if (!item.getName().equalsIgnoreCase(customFieldName)) continue;
            customFieldId = item.getId();
            break;
        }
        if (customFieldId == null) {
            throw new Exception("ERROR: could not find custom field ID for field name " + customFieldName);
        }
        return customFieldId;
    }

    private String loginAdmin() throws Exception {
        String token = null;
        try {
            token = this.getFJiraSoapService().login(this.getAdminUsername(), this.getAdminPw());
            this.logUtil.info("INFO: login admin successful = " + token);
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: loginAdmin: " + e.getMessage().toString());
            e.printStackTrace();
            throw e;
        }
        return token;
    }

    private String loginUser() throws Exception {
        String token = null;
        try {
            token = this.getFJiraSoapService().login(this.getGeneralUsername(), this.getGeneralPw());
            this.logUtil.info("INFO: login user successful = " + token);
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: loginUser: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return token;
    }

    public void logout(String token) throws Exception {
        boolean logoutSuccessful = false;
        try {
            logoutSuccessful = this.getFJiraSoapService().logout(token);
            this.logUtil.info("INFO: logout successful = " + logoutSuccessful);
        }
        catch (Exception e) {
            this.logUtil.info("ERROR: logout: " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public JiraSoapServiceServiceLocator getFJiraSoapServiceGetter() {
        return this.fJiraSoapServiceGetter;
    }

    public void setFJiraSoapServiceGetter(JiraSoapServiceServiceLocator jiraSoapServiceGetter) {
        this.fJiraSoapServiceGetter = jiraSoapServiceGetter;
    }

    public JiraSoapService getFJiraSoapService() {
        return this.fJiraSoapService;
    }

    public void setFJiraSoapService(JiraSoapService jiraSoapService) {
        this.fJiraSoapService = jiraSoapService;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPw() {
        return this.adminPw;
    }

    public String getGeneralUsername() {
        return this.generalUsername;
    }

    public String getGeneralPw() {
        return this.generalPw;
    }
}

