/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.dl.dao.PubmedSearchResultDAO;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.ncbi.Eutil;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

public class QuicksearchServlet
extends AbstractServlet {
    private static final long serialVersionUID = 4484470534700402765L;
    private static final Logger log = Logger.getLogger(QuicksearchServlet.class);
    private static final String jspUrl = "quicksearch.jspx";
    private static final String errorUrl = "../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            PubmedSearchResultDAO pubmedDao = new PubmedSearchResultDAO();
            ResourceDAO resourceDao = new ResourceDAO();
            String query = request.getParameter("query");
            String search = request.getParameter("search");
            if (search != null) {
                log.debug((Object)"getting pubmed results...");
                request.setAttribute("pubmedSearchResultList", (Object)pubmedDao.selectPubmedSearchResultList(query, Integer.valueOf(10)));
                log.debug((Object)"getting resource results...");
                SelectResourceListParams select = new SelectResourceListParams();
                if (query != null && !query.trim().equals("")) {
                    select.setQuery(query);
                    select.setSort(SelectResourceListParams.Sort.Score);
                } else {
                    select.setSort(SelectResourceListParams.Sort.Title);
                }
                select.setHistorical(Boolean.valueOf(false));
                select.setOffset(Integer.valueOf(0));
                select.setLimit(Integer.valueOf(10));
                request.setAttribute("resourceList", (Object)resourceDao.selectResourceList(select));
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SolrServerException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Eutil.EutilException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

