package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ClassInstructorDAO;
import edu.harvard.med.countway.dl.model.ClassInstructor;
import edu.harvard.med.countway.dl.model.ClassInstructorList;
import edu.harvard.med.countway.dl.model.SelectClassInstructorListParams;

@Path("class_instructor")
public class ClassInstructorResource
{
    private static final Logger log = Logger.getLogger(ClassInstructorResource.class);

    @Context
    UriInfo uriInfo;
    private final ClassInstructorDAO dao = new ClassInstructorDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectClassInstructorList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("name") @QueryParam("sort") final SelectClassInstructorListParams.Sort sort) throws SQLException
    {
        final SelectClassInstructorListParams select = new SelectClassInstructorListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final ClassInstructorList result = dao.selectClassInstructorList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("class instructors not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectClassInstructor(@PathParam("id") Integer id) throws SQLException
    {
        ClassInstructor classInstructor = dao.selectClassInstructor(id);
        if (classInstructor == null)
        {
            return Utils.getNotFoundResponse("class instructor "+id+" not found");
        }
        return Response.ok(classInstructor).build();
    }
}
