package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.ClassLocationDAO;
import edu.harvard.med.countway.dl.model.ClassLocation;
import edu.harvard.med.countway.dl.model.ClassLocationList;
import edu.harvard.med.countway.dl.model.SelectClassLocationListParams;

@Path("class_location")
public class ClassLocationResource
{
    private static final Logger log = Logger.getLogger(ClassLocationResource.class);

    @Context
    UriInfo uriInfo;
    private final ClassLocationDAO dao = new ClassLocationDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectClassLocationList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("concat") @QueryParam("sort") final SelectClassLocationListParams.Sort sort) throws SQLException
    {
        final SelectClassLocationListParams select = new SelectClassLocationListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final ClassLocationList result = dao.selectClassLocationList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("class locations not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectClassLocation(@PathParam("id") Integer id) throws SQLException
    {
        ClassLocation classLocation = dao.selectClassLocation(id);
        if (classLocation == null)
        {
            return Utils.getNotFoundResponse("class location "+id+" not found");
        }
        return Response.ok(classLocation).build();
    }
}
