package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.CourseBuildingDAO;
import edu.harvard.med.countway.dl.model.CourseBuilding;
import edu.harvard.med.countway.dl.model.CourseBuildingList;
import edu.harvard.med.countway.dl.model.SelectCourseBuildingListParams;

@Path("course_building")
public class CourseBuildingResource
{
    private static final Logger log = Logger.getLogger(CourseBuildingResource.class);

    @Context
    UriInfo uriInfo;
    private final CourseBuildingDAO dao = new CourseBuildingDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseBuildingList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("concat") @QueryParam("sort") final SelectCourseBuildingListParams.Sort sort) throws SQLException
    {
        final SelectCourseBuildingListParams select = new SelectCourseBuildingListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final CourseBuildingList result = dao.selectCourseBuildingList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("course buildings not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseBuilding(@PathParam("id") Integer id) throws SQLException
    {
        CourseBuilding courseBuilding = dao.selectCourseBuilding(id);
        if (courseBuilding == null)
        {
            return Utils.getNotFoundResponse("course building "+id+" not found");
        }
        return Response.ok(courseBuilding).build();
    }
}
