package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.CourseTypeDAO;
import edu.harvard.med.countway.dl.model.CourseType;
import edu.harvard.med.countway.dl.model.CourseTypeList;
import edu.harvard.med.countway.dl.model.SelectCourseTypeListParams;

@Path("course_type")
public class CourseTypeResource
{
    private static final Logger log = Logger.getLogger(CourseTypeResource.class);

    @Context
    UriInfo uriInfo;
    private final CourseTypeDAO dao = new CourseTypeDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseTypeList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @DefaultValue("name") @QueryParam("sort") final SelectCourseTypeListParams.Sort sort) throws SQLException
    {
        final SelectCourseTypeListParams select = new SelectCourseTypeListParams();
        select.setOffset(offset);
        select.setSort(sort);
        final CourseTypeList result = dao.selectCourseTypeList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("course types not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectCourseType(@PathParam("id") final Integer id) throws SQLException
    {
        final CourseType courseType = dao.selectCourseType(id);
        if (courseType == null)
        {
            return Utils.getNotFoundResponse("course type "+id+" not found");
        }
        return Response.ok(courseType).build();
    }
}
