package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import java.util.List;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.dao.TocFeedDAO;
import edu.harvard.med.countway.dl.model.Resource;
import edu.harvard.med.countway.dl.model.ResourceList;
import edu.harvard.med.countway.dl.model.ResourceTypeList;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.dl.model.TocFeed;

@Path("resource")
public class ResourceResource
{
    private static final Logger log = Logger.getLogger(ResourceResource.class);

    @Context
    UriInfo uriInfo;
    private final ResourceDAO resourceDao = new ResourceDAO();
    private final ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
    private final TocFeedDAO tocFeedDao = new TocFeedDAO();

    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectResourceList(
            @QueryParam("query") final String query,
            @QueryParam("field") final SelectResourceListParams.Field field,
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("typeId") final List<Integer> typeId,
            @QueryParam("historical") final Boolean historical,
            @DefaultValue("title") @QueryParam("sort") final SelectResourceListParams.Sort sort) throws SolrServerException, SQLException
    {
        final SelectResourceListParams select = new SelectResourceListParams();
        select.setQuery(query);
        select.setField(field);
        select.setOffset(offset);
        select.setTypeId(typeId);
        select.setHistorical(historical);
        select.setSort(sort);
        final ResourceList result = resourceDao.selectResourceList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("resources not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectResource(@PathParam("id") final Integer id) throws SQLException
    {
        final Resource resource = resourceDao.selectResource(id);
        if (resource == null)
        {
            return Utils.getNotFoundResponse("resource "+id+" not found");
        }
        return Response.ok(resource).build();
    }

    @GET
    @Path("{id}/type")
    @Produces({"application/xml", "text/plain"})
    public Response selectResourceTypeListByResourceId(@PathParam("id") final Integer resourceId) throws SQLException, SolrServerException
    {
        final ResourceTypeList result = resourceTypeDao.selectResourceTypeListByResourceId(resourceId);
        if (result == null)
        {
            return Utils.getNotFoundResponse("resource types not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}/toc_feed")
    @Produces({"application/xml", "text/plain"})
    public Response selectTocFeedByResourceId(@PathParam("id") final Integer resourceId) throws SQLException, SolrServerException
    {
        final TocFeed tocFeed = tocFeedDao.selectTocFeedByResourceId(resourceId);
        if (tocFeed == null)
        {
            return Utils.getNotFoundResponse("toc feed not found");
        }
        return Response.ok(tocFeed).build();
    }
    
    // TODO: add insert/update/delete methods
}
