package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

@Provider
public class SQLExceptionMapper implements ExceptionMapper<SQLException>
{
    private static final Logger log = Logger.getLogger(SQLExceptionMapper.class);

    public Response toResponse(SQLException e)
    {
        log.info(Utils.getStackTrace(e));
        return Utils.getServerErrorResponse(e);
    }
}
