package edu.harvard.med.countway.dl.rest;

import java.sql.SQLException;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.apache.log4j.Logger;

import edu.harvard.med.countway.dl.dao.UserResourceDAO;
import edu.harvard.med.countway.dl.model.UserResource;
import edu.harvard.med.countway.dl.model.UserResourceList;
import edu.harvard.med.countway.dl.model.SelectUserResourceListParams;

//TODO: disabled until authenticated access is configured
//@Path("user_resource")
public class UserResourceResource
{
    private static final Logger log = Logger.getLogger(UserResourceResource.class);

    @Context
    UriInfo uriInfo;
    private final UserResourceDAO dao = new UserResourceDAO();
    
    @GET
    @Produces({"application/xml", "text/plain"})
    public Response selectUserResourceList(
            @DefaultValue("0") @QueryParam("offset") final Integer offset,
            @QueryParam("userId") final Integer userId,
            @QueryParam("resourceId") final Integer resourceId,
            @DefaultValue("title") @QueryParam("sort") final SelectUserResourceListParams.Sort sort) throws SQLException
    {
        final SelectUserResourceListParams select = new SelectUserResourceListParams();
        select.setOffset(offset);
        select.setUserId(userId);
        select.setResourceId(resourceId);
        select.setSort(sort);
        final UserResourceList result = dao.selectUserResourceList(select);
        if (result == null)
        {
            return Utils.getNotFoundResponse("user resources not found");
        }
        return Response.ok(result).build();
    }
    
    @GET
    @Path("{id}")
    @Produces({"application/xml", "text/plain"})
    public Response selectUserResource(@PathParam("id") Integer id) throws SQLException
    {
        final UserResource userResource = dao.selectUserResource(id);
        if (userResource == null)
        {
            return Utils.getNotFoundResponse("user resource "+id+" not found");
        }
        return Response.ok(userResource).build();
    }
}
